/*Aztec C Compiler Error Codes, written 4/3/82 by J. M. Wierda.
  
  Aztec C compilers print error numbers instead of error strings
  on compile time errors, apparently this was done to save the
  several kbytes that these strings would add to the compiler size.

  This program will print out the strings corresponding to the error
  numbers. Typical usage would be - error 2 5 6 - which would result
  in the error strings corresponding to error numbers 2, 5, and 6
  being printed on the console.

  I expect this program will compile correctly with any Aztec C
  Compiler, however I compiled with the CII compiler with the
  -z4000 option because of the large amount of string space required.
*/



#define	ARRAYSIZE	(sizeof(errormsg) / sizeof(char *))

main(argc,argv)
int argc;
char **argv;
{
  int n;
  static char *errormsg[] = {
  "error number is undefined",
  "bad digit in octal constant",
  "string space exhausted (see COMPILER -Z option)",
  "undetermined string",
  "compiler error in effaddr",
  "illegal type for function",
  "inappropriate arguments",
  "bad declaration syntax",
  "name not allowed here",
  "must be constant",
  "size must be positive integer",
  "data type too complex",
  "illegal pointer reference",
  "unimplemented type",
  "unimplemented type",
  "storage class conflict",
  "data type conflict",
  "unsupported data type",
  "data type conflict",
  "too many structures",
  "structure redeclaration",
  "missing ) 's",
  "structue declaration syntax",
  "undefined structure name",
  "need right parenthesis",
  "expected symbol here",
  "must be structure or union member",
  "illegal type CAST",
  "incompatable structures",
  "structure not allowed here",
  "missing : on ? expression",
  "call of non-function",
  "illegal pointer calculation",
  "illegal type",
  "undefined symbol",
  "TYPEDEF not allowed here",
  "no more expression space (see COMPILER -E option)",
  "invalid expression",
  "no automatic aggregate initialization",
  "no strings in automatic",
  "this shouldn't happen",
  "invalid initializers",
  "too many initializers",
  "undefined structure initialization",
  "too many structure initializers",
  "bad declaration syntax",
  "missing closing bracket",
  "open failure on include file",
  "illegal symbol name",
  "already defined",
  "missing bracket",
  "must be lvalue",
  "symbol table overflow",
  "multiply defined label",
  "too many labels",
  "missing quote",
  "missing apostrophe",
  "line too long",
  "illegal # encountered",
  "macro table full (see COMPILER -X option)",
  "output file error",
  "reference of member of undefined structure",
  "function body must be compound statement",
  "undefined label",
  "inappropriate arguments",
  "illegal argument name",
  "expected comma",
  "invalid else",
  "syntax error",
  "missing semicolon",
  "bad goto syntax",
  "statement syntax",
  "statement syntax",
  "statement syntax",
  "case value must be integer constant",
  "missing colon on case",
  "too many cases in switch (see COMPILER -Y option)",
  "case outside of switch",
  "missing colon",
  "duplicate default",
  "default outside of switch",
  "break or continue error",
  "illegal character",
  "too many nested includes",
  "illegal character",
  "not an argument",
  "null dimension",
  "invalid character constant",
  "not a structure",
  "invalid storage class",
  "symbol redeclared",
  "illegal use of floating point type",
  "illegal type conversion",
  "illegal expression type for switch",
  "bad argument to define",
  "no argument list",
  "missing argument",
  "bad argument",
  "not enough arguments",
  "conversion not found in code table"
  };

  if(argc == 1)
    { puts("Aztec C Compiler Error Codes\nusage: error [error numbers]\n");
      exit(0);
    }
  while(--argc > 0)
    { n = atoi(*++argv);
      if((n > 0) && (n < ARRAYSIZE))
        printf("%3d: %s\n",n,errormsg[n]);
      else
        printf("%3s: %s\n",*argv,errormsg[0]);
    }
}
