program getcpm;
CONST void=229;
      cpmeof=26;
      cr=13;
      lf=10;
      tab=9;
      null=0;
      drivea=4;
      driveb=5;
      async=1;
      sectdir=2;
      indent=4;
      autolf=8;
TYPE nametype=packed array[0..10]of char;
     namestring=string[30];
     byte=0..255;
     temptype=packed array[0..512]of byte;
     dirtype=packed array[0..1535]of byte;
     maptype=packed array[0..15]of byte;
     nonotype='N'..'n';
     illetype=' '..']';
     secttype=packed array [0..255] of byte;
     legaltypes=(textfile,datafile,illegal);
VAR iscpm:boolean;
    filetype:legaltypes;
    cpmtopas:array[0..15]of integer;
    sourcename,destname:namestring;
    nono:set of nonotype;
    illechar:set of illetype;
    filename :nametype;
    textdest: text;
    datadest:file of secttype;
    tempbuf:temptype;
    isodd:integer;
    directbuf: dirtype;
    
function uppercase(inchar:char):char;
begin
  if(inchar in ['a'..'z']) then 
    uppercase:=chr(ord(inchar)-32)
  else uppercase:=inchar
end;

procedure checktype(var filename:namestring;
   var filetype:legaltype);
var i:integer;
   help:namestring;
begin
  for i:=1 to length(filename) do
    filename[i]:=uppercase(filename[i]);
  if length(filename)<>0 then
    if filename[1]<>'*' then
      filename:=concat('*',filename);
  help:=filename;
  delete(help,1,length(help)-5);
  filetype:=illegal;
  if help = '.TEXT' then filetype:=textfile;
  if help ='.DATA' then filetype:=datafile
end;


procedure cpmname(var wantname:nametype; wantfile:namestring);
var i,j:integer;
begin
  fillchar(wantname,11,' ');
  i:=1;j:=0;
  while((j<=10) and (i<=length(wantfile))) do begin
    if not (wantfile[i] in illechar) then
      wantname[j]:=uppercase(wantfile[i])
    else if (wantfile[i]='.') and (j<=8) then
      j:=7
    else j:=10;
    j:=j+1; i:=i+1
  end
end;

procedure writename(filename:nametype);
var i:integer;
begin
  i:=0;
  while(i<8) and (filename[i]<>' ') do begin
    write(filename[i]); i:=i+1
  end;
  write('.');
  for i:=8 to 10 do if filename[i]<>' ' then
  write(filename[i])
end;

function blocknum(seqsect:integer):integer;
var k:integer;
begin
  k:=cpmtopas[(seqsect mod 16)];
  k:=k+48+16*(seqsect div 16);
  isodd:=k mod 2;
  blocknum:=k div 2;
  if((k div 2) >=280)then begin
    writeln('blocksize too large');
    exit(program)
  end
end;

procedure directory(var directbuf:dirtype;
  var iscpm:boolean);
var i,k,seqsect:integer;
begin
  seqsect:=0;
  writeln('starting directory');
  iscpm:=true;
  writeln(blgpro
iriyeqsect),isodd);
  unitread(driveb,directbuf,256,blocknum(seqsect),sectdir);
  WRITELN('FIRST PASS');
  iscpm:=iscpm and (directbuf[1]>=ord(' '))
    and (directbuf[1]<128) and not
      (chr(directbuf[1] mod 128) in illechar)
         and (directbuf[12]=0);
  if iscpm then for i:=1 to 5 do begin
    unitread(driveb,tempbuf,512,blocknum(seqsect+i),sectdir);
    WRITELN('PASS NO.',i);
    for k:=0 to 255 do directbuf[k+i*256]:=tempbuf[k+isodd*256]
  end
end;

procedure printdirect(directbuf:dirtype);
var i,dirbufpoint,filecount:integer;
begin
  writeln('CP/M directory listing: (<user><name>.<type>');
  dirbufpoint:=0;
  filecount:=0;
  repeat
    if(directbuf[dirbufpoint]<>void) and
    (directbuf[dirbufpoint+12]=0) then begin
      write(directbuf[dirbufpoint]:2,'  ');
      for i:=1 to 8 do 
      write (chr(directbuf[i+dirbufpoint] mod 128));
      write('.');
      for i:=9 to 11 do
       write(chr(directbuf[dirbufpoint+i]mod 128));
      filecount:=filecount+1;
      if(filecount mod 4)=0 then writeln else write ('  /  ')
    end;
    dirbufpoint:=dirbufpoint+32
  until dirbufpoint>=1535;
  writeln; writeln(filecount, ' files in directory.')
end;

procedure scandirect(var diskmap:maptype;
  var found:boolean; var size:byte; dirbuf:dirtype;
  filename:nametype; extension:byte);
var dirbufpoint,i:integer;
    namebuf:nametype;
begin
  found:=false;
  fillchar(namebuf,11,' ');
  dirbufpoint:=0;
  repeat
    if(dirbuf[dirbufpoint]<>void) then begin
      for i:=0 to 10 do
      namebuf[i]:=chr(dirbuf[dirbufpoint+i+1] mod 128);
      found:=(namebuf=filename) and (extension=dirbuf[dirbufpoint+12])
    end;
    dirbufpoint:=dirbufpoint+32
  until found or (dirbufpoint>=1536);
  if found then begin
    dirbufpoint:=dirbufpoint-32;
    size:=dirbuf[dirbufpoint+15];
    for i:=0 to 15 do
      diskmap[i]:=dirbuf[dirbufpoint + i + 16]
  end
end;

procedure copyfile(filename:nametype;
filetype:legaltypes);
var linepos:integer;
size,extension:byte;
found:boolean;
diskmap:maptype;

procedure copysect(sectbuf:secttype);
begin
  datadest^:=sectbuf;
  put(datadest)
end;

procedure copychar(inchar:byte);
begin
  inchar:=inchar mod 128;
  if inchar >=32 then begin
    linepos:=linepos+1;
    write(textdest,chr(inchar))
  end
  else begin
    case inchar of
      tab:begin
        repeat
          write(textdest,' ');
          linepos:=linepos+1
        until(linepos mod 8)=0;
        exit(copychar)
      end;
      cr:begin
        writeln(textdest);
        linepos:=0;
        exit(copychar)
      end;
      lf,null:exit(copychar);
      cpmeof:begin
        writeln;
        writeln('End of File');
        exit(copyfile)
      end
    end;
    write(textdest,'?');
    linepos:=linepos+1
  end
end;

procedure copypage(valsects:integer;
  cpmpage:byte);
var seqsect,j,temp,k,l:integer;
  sectbuf:secttype;
begin
  if cpmpage<>0 then begin
    seqsect:=(cpmpage*8);
    temp:=seqsect+valsects;
    while seqsect<temp do begin
      unitread(driveb,tempbuf,512,blocknum(seqsect div 2),sectdir);
      l:=seqsect mod 2;
      for k:=0 to 127 do sectbuf[k]:=tempbuf[k+l*128+256*isodd];
      seqsect:=seqsect+1;
      if filetype=textfile then
      for j:=0 to 127 do copychar(sectbuf[j])
      else copysect(sectbuf)
    end
  end
end;

procedure copyextension(diskmap:maptype;size:byte);
var i:integer;
begin
  for i:=0 to (size div 8) - 1 do 
  copypage(8,diskmap[i]);
  if (size mod 8)<>0 then copypage(size mod 8,diskmap[size div 8])
end;

begin(*copyfile*)
  extension:=0;
  linepos:=0;
  repeat
    scandirect(diskmap,found,size,directbuf,filename,extension);
    if found then begin
      if (extension = 0) and (size=0) then
      writeln('File is empty')
      else copyextension(diskmap,size);
      extension:=extension+1
    end
  until not found;
  if extension=0 then begin
    writename(filename);
    writeln(' not found')
  end
  else begin
    writeln; writeln('End of file.')
  end
end;(*copyfile*)

begin
  cpmtopas[0]:=0; cpmtopas[1]:=9; cpmtopas[2]:=3;cpmtopas[3]:=12;
  cpmtopas[4]:=6;cpmtopas[5]:=15;cpmtopas[6]:=1;cpmtopas[7]:=10;
  cpmtopas[8]:=4;cpmtopas[9]:=13;cpmtopas[10]:=7;cpmtopas[11]:=8;
  cpmtopas[12]:=2;cpmtopas[13]:=11;cpmtopas[14]:=5;cpmtopas[15]:=14;
  illechar:=[' ','<','>',',','.',';',':','=','?','*','[',']'];
  nono:=['n','N'];
  page(output);
  writeln;writeln;
  writeln('CP/M  tp PASCAL file transfer 19820210');
  writeln;
  writeln('PASCAL diskette in drive A (#4:');
  writeln('CP/M   diskette in drive B (#5:');
  writeln;
  write('Press <return> when ready '); readln; writeln;
  directory(directbuf,iscpm);
  if iscpm then begin
    printdirect(directbuf);
    writeln;
    write('Source CP/M file      :   ');
    readln(sourcename);
    if length (sourcename) = 0 then exit(program);
    cpmname(filename,sourcename);
                                                                                                             =iletype:=illegal;
    repeat
      write('Destination PASCAL file:  ');
      readln(destname);
      if(length(destname)=0)then exit(program);
      checktype(destname,filetype);
      if(filetype=illegal) then
      writeln('Illegal file name . (.TEXT or .DATA)');
    until filetype<>illegal;
    if filetype=textfile then begin
      writeln; writeln('TEXTfile transfer');
      rewrite(textdest,destname);
      copyfile(filename,filetype);
      close(textdest,lock)
    end
    else begin
      writeln;
      writeln('DATA file transfer');
      rewrite(datadest,destname);
      copyfile(filename,filetype);
      close(datadest,lock)
    end
  end
  else writeln('Not CP/M floppy in drive B')
end.

    
