;
TITLE	'TLIST HIGH SPEED LIST UTILITY - VERS 1.4'
;
;THIS LISTER PROGRAM WRITTEN BY AL JEWER AND RELEASED
;IN PUBLIC DOMAIN 5/11/81. THIS PROGRAM MUST BE
;ASSEMBLED USING MAC, AND MUST HAVE Z80.LIB PRESENT
;ON THE DISK AT ASSEMBLY TIME. THIS SOFTWARE WILL
;RUN ON Z80 SYSTEMS ONLY. 
;
;THE LISTING WILL BE PRINTED WITH A TITLE PAGE 
;CONSISTING OF THE FILENAME & TYPE, CENTERED. 
;SUPPORT IS ALSO AVAILABLE FOR THE GODBOUT SYSTEM 
;SUPPORT 1 BOARD TO ALLOW TIME & DATE TO BE ADDED
;TO THE LISTINGS IF THAT BOARD IS IN THE SYSTEM.
;
;SETUP IS ALSO AVAILABLE TO SET UP TABS ON THE TI810 
;PRINTER, IF ONE IS USED AS SYSTEM LISTER.
;
;THIS PROGRAM COMPRESSES IMBEDDED SPACES IN THE INPUT
;FILE TO TABS AT 8 COLUMN INTERVALS. THIS SPEEDS THE
;TRANSFER TO THE LIST DEVICE, ESPECIALLY IF OVER 
;THE PHONE LINE.
;
;Fixes/updates: (in reverse order to minimize reading time)
;
;02/12/82 VERSION 1.4 - PRINTER INITIALIZATION ADDED FOR
;	  LEAR SIEGLER ADM-300 PRINTER. REMOVED UNNECESSARY
;	  CODE IN DTC-300 INIT ROUTINE AS SUGGESTED BY AL JEWER
;	  (SHAWN EVERSON)
;
;05/21/81 Version 1.3 - Changed JMP 0 to JMP REBOOT in several
;	  places.  Edited file to set proper tab columns.
;	  (Keith Petersen, W8SDZ)
;
;05/16/81 Version 1.2 - Clear high order bit of
;	  file name to fix bug when printing
;	  R/O file titles. (CHS)
;
;05/12/81 Printer initialization added for DTC-300
;	  & option to suppress initial formfeed.
;	  (C. Strom)
;
;01/08/80 Originally written by Al Jewer
;
	PAGE	60	;SET PAGE SIZE FOR ASSEMBLER
	MACLIB	Z80	;DEFINE MACRO LIBARY USED
	$*MACRO		;EXPAND MACROS IN PRN LISTING
;
;************************************************
;						*
;             CPM & BDOS EQUATES		*
;						*
;************************************************
;
BASE	EQU	00	;THIS IS BASE OF MEMORY SEGMENT FOR STD CP/M
			;USE 4200H FOR ALT CP/M
REBOOT	EQU	0+BASE	;REBOOT CP/M HERE
BDOS	EQU	5+BASE	;CALL HERE FOR SYSTEM
OFFSET	EQU	1+BASE	;GET SYSTEM OFFSET VECTOR HERE
DMAADR	EQU	80H+BASE ;THIS IS DMA BUFFER
DEFFCB	EQU	5CH+BASE ;DEFAULT FILE CONTROL BLOCK
FCBTWO	EQU	6CH+BASE ;SECOND FCB
MEMTOP	EQU	6+BASE	;THIS IS TOP OF TPA
IOBYTE	EQU	3+BASE	;I/O FLAG BYTE HERE
;
;
;   FILE CONTROL BLOCK EQUATES
;
FCBDRV	EQU	DEFFCB	  ;DRIVE # (0 FOR CURRENT)
FCBNAME	EQU	DEFFCB+1  ;FILE NAME(8 BYTES)
FCBTYPE	EQU	DEFFCB+9  ;FILE TYPE(3 BYTES)
FCBEXT	EQU	DEFFCB+12 ;EXTENT (CLEAR TO 0)
FCBEND	EQU	DEFFCB+33 ;CLEAR FCB TO HERE
;
;   I/O EQUATES
;
CONIN	EQU	1	;INPUT CON: CHARACTER TO A
CONOUT	EQU	2	;OUTPUT CON: CHARACTER FROM E
READER	EQU	3	;INPUT RDR: CHARACTER TO A
PUNCH	EQU	4	;OUTPUT PUN: CHARACTER FROM E
LIST	EQU	5	;OUTPUT LST: CHARACTER FROM E
PRINT	EQU	9	;OUTPUT STRING (DE) TO CON:
INLINE	EQU	10	;INPUT LINE FROM CON:
CONSTAT	EQU	11	;CHECK CONSOLE READY
;
;   DISK FUNCTION CALLS
;
OPEN	EQU	15	;OPEN FILE
DELETE	EQU	19	;DELETE FILE
MAKE	EQU	22	;CREATE FILE
SETBUF	EQU	26	;SET DMA ADDRESS TO (DE)
READ	EQU	20	;READ (NEXT) RECORD
WRITE	EQU	21	;WRITE (NEXT) RECORD
CLOSE	EQU	16	;CLOSE FILE
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
TAB	EQU	09H
CR	EQU	0DH
LF	EQU	0AH
FF	EQU	0CH
ESC	EQU	27
DC1	EQU	17
ACK	EQU	06H
NAK	EQU	15H
STXT	EQU	02H
EOT	EQU	04H
SPACE	EQU	20H
;
;
CLKBASE	EQU	50H	   ;BASE OF SYSTEM SUPPORT 1 CARD
CLKCTL	EQU	CLKBASE+10 ;CLOCK CONTROL PORT
CLKDATA	EQU	CLKBASE+11 ;CLOCK DATA PORT
CREAD	EQU	10H+40H	   ;READ COMMAND + HOLD COUNT COMMAND
;
RTC	EQU	FALSE	;SET TRUE IF REAL TIME CLOCK INSTALLED
;
CONSOLE	EQU	FALSE	;SET TRUE TO LIST TO CONSOLE,
			;FALSE TO LIST TO LIST DEVICE 
;
INITFF	EQU	TRUE 	;SET TRUE FOR INITIAL FORMFEED
;
TI810	EQU	FALSE	;SET TRUE TO INIT TI810 PRINTER
;
DTC	EQU	FALSE	;SET TRUE TO INIT DTC-300 PRINTER
;
ADM300	EQU	TRUE 	;SET TRUE TO INIT ADM 300 PRINTER
;

	ORG	BASE+100H ;BASE OF TPA
;
START:	LHLD	MEMTOP	;GET TOP OF USER AREA
	SPHL		;USE AS STACK
	XCHG		;TOP OF MEMORY POINTER TO DE
	EXX		;TO ALTS
	CALL	SIGNON	;GET MESSAGE ADDRESS
	DB	'TLIST High Speed List Utility Version 1.4',CR,LF
	DB	'Use CTL-C to Abort',CR,LF,'$'
;
SIGNON:	POP	D	;MESSAGE ADDRESS TO DE
	MVI	C,PRINT	;PRINT THE STRING
	CALL	BDOS
;
	IF	TI810
	MVI	A,ESC	;SEND ESCAPE SEQUENCE TO TI
	CALL	LPT	;TO PROGRAM THE TAB STOPS
	MVI	A,'3'
	CALL	LPT
	MVI	C,8	;START TABS AT COLUMN 8
	MVI	B,16	;THERE ARE 16 TAB STOPS
;
TILOOP:	MOV	A,C	;GET TAB STOP VALUE TO A
	CALL	LPT	;SET THE TAB STOP
	MVI	A,8	;ADD 8 TO THE COLUMN NUMBER
	ADD	C
	MOV	C,A
	DJNZ	TILOOP	;LOOP TILL ALL TABS PROGRAMMED
	MVI	A,0	;THEN TERMINATE COMMAND
	CALL	LPT
	ENDIF		;TI810
;
	IF	DTC
	MVI	B,16	;NUMBER OF TAB STOPS TO SET
;
DTCLOOP MVI	C,8	;SPACES BETWEEN TABS
;
DTCLP2	MVI	A,SPACE
	CALL	LPT
	DCR	C
	JRNZ	DTCLP2	;8 SPACES YET ?
	MVI	A,ESC	;YES, SO
	CALL	LPT	;SET TAB SEQUENCE
	MVI	A,'1'
	CALL	LPT
	DJNZ	DTCLOOP	;LOOP TILL ALL TABS PROGRAMMED
	ENDIF		;DTC
;
	IF	ADM300
	LXI	H,ADMTABS
	CALL	LINOUT	;SEND TAB COMMAND LINE
	ENDIF		;ADM300
;
	LXI	H,BUFFER ;CLEAR BUFFER TO 0'S
	MVI	B,80	;CLEAR ALL POSITIONS
	XRA	A	;GET 0
;
CLLOOP:	MOV	M,A	;CLEAR POSITION
	INX	H	;POINT TO NEXT
	DJNZ	CLLOOP	;LOOP TILL DONE
	LXI	D,DEFFCB ;TRY TO OPEN FILE
	MVI	C,OPEN	
	CALL	BDOS
	ORA	A	;SET FLAGS
	JP	OPENOK	;JUMP IF GOOD OPEN
	LXI	D,NOOPEN ;TELL USER ABOUT PROBLEM
	MVI	C,PRINT
	CALL	BDOS
	JMP	REBOOT	;THEN BACK TO DOS
;
OPENOK:
	IF	INITFF
	MVI	E,FF 	;FORM FEED TO LIST DEVICE
;
	IF	CONSOLE
	MVI	C,CONOUT
	ELSE
	MVI	C,LIST
	ENDIF
;
	CALL	BDOS
	ENDIF		;INITFF
;
	MVI	B,12	;THEN 12 BLANK LINES
;
BLANKS:	PUSH	B	;SAVE COUNTER
	CALL	CRLF	;DO BLANK LINE
	POP	B	;RESTORE COUNTER
	DJNZ	BLANKS	;LOOP TILL DONE
	LXI	H,FCBNAME ;POINT TO THE NAME
	LXI	B,11 SHL 8 ;COUNTER TO B, 0 TO C
	MVI	A,SPACE	;WE WILL COUNT THE SPACES
;
SPLOOP:	CMP	M	;SPACE?
	JRNZ	NOSP	;JUMP IF NOT
	INR	C	;COUNT THE SPACE
;
NOSP:	INX	H	;POINT TO NEXT ONE
	DJNZ	SPLOOP	;LOOP TILL ALL DONE
	MOV	A,C	;GET # OF SPACES
	ADD	A	;* 2
	ADD	C	;PLUS ORIG FOR *3
	MOV	C,A	;LO BYTE
	MVI	B,0	;CLEAR HI BYTE FOR ADD
	LXI	H,BUFFER ;BASE ADDRESS TO HL
	DAD	B	;PLUS OFFSET
	LXI	D,FCBNAME ;POINT TO NAME WITH (DE)
	MVI	B,11	;11 CHARACTERS
;
SIGNLP:	LDAX	D	;GET ASCII BYTE
	ANI	7FH	;RESET HIGH-ORDER BIT
	INX	D	;POINT TO NEXT
	CPI	SPACE	;IS IT A SPACE?
	JRZ	SGNLP	;IGNORE SPACES
	JRC	SGNLP	;AND ANYTHING LESS
	CPI	'A'+20H	;SMALL ENOUGH?
	JRC	UCASE	;JUMP IF OK
	CPI	'Z'+21H	;LOWER CASE ALPHA?
	JRNC	UCASE	;JUMP IF NOT
	ANI	5FH	;UPSHIFT LOWER CASE
;
UCASE:	PUSH	D	;SAVE INPUT POINTER
	PUSH	H	;SAVE RESULT DESTINATION
	SUI	SPACE	;KILL ASCII BIAS
	MOV	L,A	;TO HL
	MVI	H,0
	DAD	H	;* 6
	MOV	D,H
	MOV	E,L
	DAD	H
	DAD	D
	LXI	D,SPC	;BASE ADDRESS OF TABLE
	DAD	D	;PLUS OFFSET
	POP	D	;RESULT ADDRESS TO (DE)
	MOV	A,B	;REMEMBER COUNT IN A
	LXI	B,6	;THIS MANY BYTES
	LDIR		;MOVE IT
	INX	D	;EXTRA SPACE
;
SGNLOOP:MOV	B,A	;RESTORE COUNT
	XCHG		;RESULT DESTINATION IN (HL)
	POP	D	;SOURCE POINTER
;
SGNLP:	MOV	A,B	;GET PASS #
	CPI	4	;DONE WITH TITLE?
	JRNZ	SLP	;JUMP IF NO
	XCHG		;DESTINATION TO (DE)
	PUSH	H	;SAVE SOURCE POINTER
	LXI	H,PERIOD+1 ;THIS CHARACTER
	LXI	B,4	;MOVE CHARACTER
	LDIR
	MOV	B,A	;RESTORE COUNT
	POP	H	;RESTORE SOURCE POINTER
	XCHG		;TO DE - DEST TO HL
;
SLP:	DJNZ	SIGNLP	;TILL DONE
	MVI	C,8	;8 ROWS
;
PLOOP:	LXI	H,BUFFER ;POINT TO LEFT SIDE
	MVI	B,79	;THIS MANY CHARACTERS
	PUSH	B	;SAVE REGS
	PUSH	H
	CALL	CRLF	;TO BEGINNING OF LINE
	POP	H	;GET THEM BACK
	POP	B
;
CLOOP:	RRCR	M	;LO BIT OF MEMORY TO CARRY
	INX	H	;POINT TO NEXT
	MVI	E,SPACE	;BLANK POSITION
	JRNC	PUTIT	;JUMP IF NO BIT THERE
	MVI	E,'#'	;ELSE USE FILL CHARACTER
;
PUTIT:	PUSH	H	;PRINT TO LST:
	PUSH	B
	CALL	LPRINT
	POP	B
	POP	H
	DJNZ	CLOOP	;TILL END OF LINE
	DCR	C	;THEN COUNT ROW #
	JRNZ	PLOOP	;TILL LAST ROW DONE
	CALL	CRLF	;RETURN THE CARRIAGE
;
	IF	RTC
;
;THE TITLE BLOCK IS NOW PRINTED. THE FOLLOWING ROUTINE
;WILL PRINT THE TIME IN 24 HOUR FORMAT, CDT.
;
	MVI	B,4	;PRINT 4 TABS
;
TLOOP:	MVI	A,TAB	;PASS THRU ACC
	CALL	LPT	;TO ROUTINE
	DJNZ	TLOOP	;TILL DONE
;
	MVI	D,CREAD+5 ;POINT TO 10S OF HOURS
	MVI	B,3	;3 LOOPS
	JMPR	TX	;START W/ NO SEPARATOR
;
T1:	MVI	A,':'	;SEPARATOR
	CALL	LPT	;TO THE PRINTER
;
TX:	MOV	A,D	;GET THE DIGIT ADDRESS
	CALL	CLOCK	;GET THE VALUE
	MOV	C,A	;SAVE IT
	MVI	A,CREAD+5 ;TEST FOR FIRST LOOP
	CMP	D	;1ST LOOP?
	MOV	A,C	;RECOVER THE VALUE
	JRNZ	T2	;JUMP IF NOT 1ST LOOP
	ANI	3	;DROP PM INDICATOR
;
T2:	ADI	'0'	;ADD ASCII BIAS
	CALL	LPT	;AND PRINT IT
	DCR	D	;POINT TO NEXT DIGIT
	MOV	A,D	;GET THE DIGIT ADDRESS TO A
	CALL	PCLOCK	;GET & PRINT ASCII
	DCR	D	;BUMP DIGIT COUNTER
	DJNZ	T1	;LOOP TILL ALL PRINTED
;
	LXI	H,CDT	;POINT TO MESSAGE
	CALL	LINOUT	;PRINT IT
	CALL	CRLF
;
;WE WILL NOW PRINT THE DAY OF THE WEEK, FOLLOWED
;BY THE MONTH, DATE AND YEAR
;
	MVI	B,3	;FIRST SEND 3 TABS
;
TLP:	MVI	A,TAB
	CALL	LPT	;TO LISTER
	DJNZ	TLP
;
	MVI	A,CREAD+6 ;THIS IS DAY OF WEEK 
	CALL	CLOCK	;GET THE DAY NUMBER
;
DAYDONE:ADD	A	;DOUBLE DAY COUNT
	LXI	H,DAYS	;POINT TO TABLE
	MOV	E,A	;ADD OFFSET TO DE
	MVI	D,0
	DAD	D	;NEW POINTER IN HL
	MOV	A,M	;GET LO BYTE OF WORD
	INX	H	;POINT TO HI BYTE
	MOV	H,M	;TO H
	MOV	L,A	;PLUS LO BYTE POINTS TO STRING
	CALL	LINOUT	;PRINT THE DAY
;
	MVI	A,CREAD+10 ;10S OF MONTHS
	CALL	CLOCK
	ORA	A	;WE GOT 10'S OF MONTHS?
	JRZ	NOTENS	;JUMP IF NOT
;
	MVI	A,10	;ADD 10S IF WE GOT EM
;
NOTENS:	MOV	B,A	;SAVE 10S IN B
	MVI	A,CREAD+9 ;GET THE ONES
	CALL	CLOCK
	ADD	B	;ADD TO THE 10S PLACE TO GET MONTH
	DCR	A	;CORRECT FOR JAN=1
	ADD	A	;DOUBLE MONTH NUMBER
	LXI	H,MONTHS ;POINT TO DISPATCH TABLE
	MOV	E,A	;OFF SET TO DE
	MVI	D,0
	DAD	D	;POINTER TO STRING AT (HL)
	MOV	A,M	;GET LO BYTE TO A
	INX	H	;POINT TO NEXT
	MOV	H,M	;HI BYTE TO H
	MOV	L,A	;LO BYTE TO L POINTS TO STRING
	CALL	LINOUT	;PRINT THE MONTH
	MVI	A,CREAD+8 ;10S OF DAYS
	CALL	CLOCK
	ANI	3	;DROP LEAP YEAR INDICATOR
	JRZ	NTENS	;JUMP IF NO TENS PLACE
	CALL	PASC	;PRINT IT
;
NTENS:	MVI	A,CREAD+7 ;ONES OF DAYS
	CALL	PCLOCK	;PRINT THEM
	LXI	H,YEAR	;PLUS YEAR MESSAGE
	CALL	LINOUT	;TO LISTER
	MVI	A,CREAD+12 ;TENS OF YEAR
	CALL	PCLOCK	;PRINT THEM
	MVI	A,CREAD+11 ;ONES OF YEAR
	CALL	PCLOCK
	CALL	CRLF	;FINISH THE LINE
	JMPR	AROUND	;JUMP AROUND SUBROUTINES
;
PCLOCK:	CALL	CLOCK	;GET THE DIGIT
;
PASC:	ADI	'0'	;ADD ASCII BIAS
	JMP	LPT	;AND PRINT
;
CLOCK:	OUT	CLKCTL	;TELL IT ADDRESS
	IN	CLKDATA	;GET THE DATA NYBBLE
	PUSH	PSW	;SAVE THE DATA
	XRA	A	;GET 0
	OUT	CLKCTL	;RESET HOLD BIT
	POP	PSW	;RESTORE DATA
	RET
;
	ENDIF		;RTC
;
AROUND:	MVI	A,FF	;TO TOP OF FORM
	CALL	LPT
	CALL	LPT
;
;NOW WE CLEAR THE BUFFER TO ALL 0S
;
	EXX		;GET TOP OF BUFFER BACK
	DCR	D	;LESS STACK SPACE
	PUSH	D	;MOVE FROM ALTS
	EXX
	POP	D	;TO REGULARS
	LXI	H,-BUFFER ;SUBTRACT START ADDRESS
	DAD	D
	MOV	B,H
	MOV	C,L	;TO BC
	LXI	H,BUFFER ;CLEAR TO ALL 0S
	LXI	D,BUFFER+1
	MVI	M,0
	LDIR
	MOV	C,D	;C NOW CONTAINS BUFFER END
;
;WE WILL NOW READ TO THE BUFFER FROM THE DISK FILE.
;IF WE FIND AN END-OF-FILE, WE WILL MARK THE FILE
;END WITH A CONTROL-Z AND GO TO THE PRINT ROUTINE. IF
;WE REACH TOP OF RAM FIRST, THE PROGRAM WILL PRINT 
;UNTIL THE BUFFER IS EMPTY, THEN READ FROM THE DISK FILE
;AGAIN, UNTIL FINALLY AN END OF FILE IS ENCOUNTERED.
;
RDMORE:	LXI	D,BUFFER ;WE WILL START HERE
;
RDLOOP:	MOV	A,C	;CHECK FOR TOP OF BUFFER
	CMP	D
	JRNZ	READIT	;JUMP IF NOT TOP YET
	PUSH	B	;SAVE TOP OF MEMORY POINTER
	XRA	A	;GET 0
	STAX	D	;SHOW NOT DONE
	CALL	PRTBUF	;PRINT BUFFER
	POP	B	;RECOVER BUFFER TOP
	LXI	H,BUFFER ;ERASE BUFFER
;
RDELP:	MVI	M,0	;KILL BYTE
	INX	H	;POINT TO NEXT
	MOV	A,H	;GET HI BYTE
	CMP	C	;DONE YET?
	JRNZ	RDELP	;LOOP TILL DONE
	JMPR	RDMORE	;READ SOME MORE
;
READIT:	PUSH	D	;SAVE BUFFER DMA ADDRESS
	PUSH	B	;AND END OF BUFFER IN C
	MVI	C,SETBUF ;SET IT AS DMA ADDRESS
	CALL	BDOS
	LXI	D,DEFFCB ;THIS FILE
	MVI	C,READ	;READ NEXT SECTOR
	CALL	BDOS
;
MODIFY:	JMP	FIRST	;WE DO FORM FEED FIRST TIME ONLY
;
FIRST:	PUSH	H	;SAVE USER REGISTERS
	PUSH	PSW
	LXI	H,NORMAL ;RESET THE JUMP
	SHLD	MODIFY+1
	LDA	BUFFER	;GET FIRST CHARACTER
	CPI	FF	;FORM FEED?
	JRNZ	NOFFF	;JUMP IF NOT FORM FEED
	XRA	A	;KILL IT
	STA	BUFFER
;
NOFFF:	POP	PSW	;RESTORE USER REGS
	POP	H
;
NORMAL:	POP	B	;BUFFER END IN C
	ORA	A	;CHECK FOR EOF
	JRZ	NOEND	;JUMP IF NOT EOF
	POP	D	;GET DMA ADDRESS
	LXI	H,80H	;PLUS SECTOR LENGTH
	DAD	D
	MVI	M,'Z'-40H ;MARK AS END OF FILE
	JMPR	PRTBUF	;PRINT IT
;
NOEND:	POP	D	;RECOVER BUFFER ADDRESS
 	LXI	H,80H	;ONE SECTOR LENGTH
	DAD	D	;NEW ADDRESS IN HL
	XCHG		;TO DE
	JMPR	RDLOOP	;TILL DONE
;
;THIS ROUTINE WILL EITHER PRINT TILL END OF FILE IS
;FOUND, OR UNTIL BUFFER IS EXHAUSTED, AT WHICH TIME 
;IT WILL RETURN TO THE READER PROGRAM FOR MORE DATA.
;
PRTBUF:	LXI	H,BUFFER ;POINT TO BEGINNING
;
PTLOOP:	MOV	A,M	;GET BYTE
	ANI	7FH	;DROP THE PARITY BIT
	INX	H	;POINT TO NEXT
	CPI	'Z'-40H	;END OF FILE?
	JRNZ	NOTEND	;JUMP IF NOT
;
PDONE:	MVI	E,FF	;TO TOP OF FORM
	CALL	LPRINT
	JMP	REBOOT	;THEN REBOOT
;
NOTEND:	CPI	SPACE	;IS IT A SPACE?
	PUSH	H	;SAVE BUFFER POINTER
	PUSH	B	;AND TOP OF MEMORY
	JRNZ	NOTSP	;JUMP IF NOT SPACE
	LXI	H,HPOS	;POINT TO HORIZONTAL POSITION
	INR	M	;BUMP IT
	MOV	A,M	;GET COUNTER
	INX	H	;POINT TO SPACE COUNTER
	ANI	7	;COLUMN POSITION?
	JRNZ	NOCOL	;JUMP IF NOT TAB POSITION
	MOV	M,A	;CLEAR SPACE COUNTER
	MVI	E,TAB	;SEND TAB
	JMP	PRNT	;CONTINUE
;
NOCOL:	INR	M	;BUMP SPACES COUNTER
	JMPR	PCONT	;CONTINUE
;
NOTSP:	CPI	CR	;CARRIAGE RETURN?
	JRNZ	NOTCR	;JUMP IF NOT
	XRA	A	;GET 0
	STA	HPOS	;RESET HORIZONTAL POSITION
	STA	SBUF	;AND SPACES COUNTER
	MVI	E,CR	;SEND IT
;
PRNT:	CALL	LPRINT	;PRINT TO LISTER
	JMPR	PCONT	;AND CONTINUE
;
NOTCR:	CPI	LF	;LINE FEED?
	JRNZ	NOTLF	;JUMP IF NOT
	MOV	E,A	;PRINT IT
	JMPR	PRNT
;
NOTLF:	CPI	TAB	;TAB CHARACTER?
	JRNZ	NOTTAB	;JUMP IF NOT
	MOV	E,A	;SEND IT
	CALL	LPRINT
	LXI	H,HPOS	;POINT TO POSITION COUNTER
	MOV	A,M	;GET BYTE
	ANI	0F8H	;DROP LO BITS
	ADI	08H	;TO NEXT TAB STOP
	MOV	M,A	;TO MEMORY
	INX	H	;POINT TO SPACES COUNTER
	MVI	M,0	;CLEAR IT
	JMPR	PCONT	;AND CONTINUE
;
NOTTAB:	CPI	FF	;FORM FEED?
	JRNZ	NOTFF	;JUMP IF NOT
	MOV	E,A	;PRINT IT
	JMPR	PRNT
;
NOTFF:	CPI	SPACE	;LARGE ENOUGH TO PRINT?
	JRC	PCONT	;IGNORE IF TOO SMALL
	MOV	C,A	;SAVE CHARACTER
	LXI	H,SBUF	;POINT TO SPACES BUFFER
	MOV	A,M	;GET BUFFER VALUE
	ORA	A	;CHECK FOR 0
	JRZ	NOSPACE	;JUMP IF NO SPACES
	MOV	B,A	;TO B AS COUNTER
;
SPSEND:	MVI	A,SPACE	;PRINT SPACES
	CALL	LPT
	DJNZ	SPSEND	;TILL DONE
	MOV	M,B	;CLEAR SPACE BUFFER
;
NOSPACE:MOV	A,C	;GET CHARACTER
	CALL	LPT	;SEND IT
	DCX	H	;POINT TO HORIZ POSITION
	INR	M	;BUMP IT
;
PCONT:	POP	B	;RECOVER TOP OF MEMORY IN C
	POP	H	;AND BUFFER POINTER
	MOV	A,M	;GET LAST BYTE
	CPI	'Z'-40H	;DONE?
	JZ	PDONE	;JUMP IF SO
	MOV	A,C	;GET TOP OF MEMORY
	CMP	H	;ARE WE THERE?
	RZ		;READ MORE IF SO
	JMP	PTLOOP	;ELSE LOOP TILL DONE
;
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%%						%%
;%%		CALLED SUBROUTINES		%%
;%%						%%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;
;
CRLF:	MVI	E,CR	;FIRST CARRIAGE RETURN
	CALL	LPRINT
	MVI	E,LF	;THEN LINE FEED
;
LPRINT:	PUSH	D	;SAVE E REGISTER
	MVI	C,CONSTAT ;CHECK FOR CONSOLE KEYPRESS
	CALL	BDOS
	ORA	A
	JRZ	DOPRNT	;JUMP IF NOT BUSY
	MVI	C,CONIN	;GET THE CHARACTER
	CALL	BDOS
	CPI	'C'-40H	;EXIT REQUEST?
	JZ	REBOOT	;REBOOT IF SO
;
DOPR0T:	POP	D	;RECOVER THE CHARACTER
;
	IF	CONSOLE
	FVI	C,CONOUT ;PRINT TO LISTER
	ELSE
	MVI	C,LIU
	ENDIF
;
	JMP	BDOS
;
LPT:	MOV	E,A	;GET CHARACTER TO E REGISTER
	PUSH	B	;SAVE BC & HL
	PUSH	H
	CALL	LPRINT	;PRINT CHARACTER
	POP	H	;RESTORE REGISTERS
	POP	B
	RET
;
;THIS ROUTINE PRINTS A LINE TO THE LISTER 
;
LINOUT:	MOV	A,M	;GET CHARACTER
	INX	H	;POINT TO NEXT
	CPI	'$'	;END OF LINE?
	RZ		;RETURN IF SO
	CALL	LPT	;PRINT CHARACTER
	JMPR	LINOUT
;
;
;)))))))))))))))))))))))))))))))))))))))))))))))))
;))						))
;))		ASCII STRINGS			))
;))						))
;)))))))))))))))))))))))))))))))))))))))))))))))))
;
;
NOOPEN:	DB	CR,LF,'CAN''T OPEN FILE',CR,LF,'$'
;
ADMTABS:DB	ESC,'G',CR	;CLEAR ALL TABS
	DB	ESC,'G'		;SET MULTIPLE TABS COMMAND
	DB	'008'		;THE FOLLOWING ARE TAB STOPS IN DECIMAL (ASCII)
	DB	'016'
	DB	'024'
	DB	'032'
	DB	'040'
	DB	'048'
	DB	'056'
	DB	'064'
	DB	'072'
	DB	'080'
	DB	'088'
	DB	'096'
	DB	'104'
	DB	'112'
	DB	'120'
	DB	'128'
	DB	'136'
	DB	CR,'$'		;TERMINATE STRING W/ <CR>
;
CDT:	DB	' CDT',CR,LF,'$'
;
SUN:	DB	'SUNDAY, $'
MON:	DB	'MONDAY, $'
TUE:	DB	'TUESDAY, $'
WED:	DB	'WEDNESDAY, $'
THU:	DB	'THURSDAY, $'
FRI:	DB	'FRIDAY, $'
SAT:	DB	'SATURDAY, $'
;
JAN:	DB	'JANUARY $'
FEB:	DB	'FEBRUARY $'
MAR:	DB	'MARCH $'
APR:	DB	'APRIL $'
MAY:	DB	'MAY $'
JUN:	DB	'JUNE $'
JUL:	DB	'JULY $'
AUG:	DB	'AUGUST $'
SEP:	DB	'SEPTEMBER $'
OCT:	DB	'OCTOBER $'
NOV:	DB	'NOVEMBER $'
DEC:	DB	'DECEMBER $'
;
YEAR:	DB	', 19$'
;
;#################################################
;##						##
;##		DISPATCH TABLES			##
;##						##
;#################################################
;
DAYS:	DW	SUN
	DW	MON
	DW	TUE
	DW	WED
	DW	THU
	DW	FRI
	DW	SAT
	DW	SUN
;
MONTHS:	DW	JAN
	DW	FEB
	DW	MAR
	DW	APR
	DW	MAY
	DW	JUN
	DW	JUL
	DW	AUG
	DW	SEP
	DW	OCT
	DW	NOV
	DW	DEC
;
;
;?????????????????????????????????????????????????
;??						??
;??		RAM STORAGE AREA		??
;??						??
;?????????????????????????????????????????????????
;
HPOS:	DB	0	;HORIZONTAL POSITION COUNTER
;
SBUF:	DB	0	;SPACES SAVED BUFFER
;
;/////////////////////////////////////////////////
;//						//
;//   BINARY CHARACTER CODES FOR ASCII LETTERS	//
;//						//
;/////////////////////////////////////////////////
;
SPC:	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
;
EXCLAM:	DB	00000000B
	DB	00000000B
	DB	01011111B
	DB	00000000B
	DB	00000000B
	DB	00000000B
;
DQUOTE:	DB	00000000B
	DB	00000111B
	DB	00000000B
	DB	00000111B
	DB	00000000B
	DB	00000000B
;
NSIGN:	DB	00010100B
	DB	01111111B
	DB	00010100B
	DB	01111111B
	DB	00010100B
	DB	00000000B
;
DSIGN:	DB	00100110B
	DB	01001001B
	DB	01111111B
	DB	01001001B
	DB	00110010B
	DB	00000000B
;
PERCENT:DB	01100011B
	DB	00010011B
	DB	00001000B
	DB	01100100B
	DB	01100011B
	DB	00000000B
;
AMPSTND:DB	01110110B
	DB	01001001B
	DB	01010110B
	DB	00100000B
	DB	01010000B
	DB	00000000B
;
SQUOTE:	DB	00000000B
	DB	00000000B
	DB	00000100B
	DB	00000011B
	DB	00000000B
	DB	00000000B
;
LPAREN:	DB	00000000B
	DB	00111110B
	DB	01000001B
	DB	00000000B
	DB	00000000B
	DB	00000000B
;
RPAREN:	DB	00000000B
	DB	00000000B
	DB	01000001B
	DB	00111110B
	DB	00000000B
	DB	00000000B
;
ASTRSK:	DB	00100100B
	DB	00011000B
	DB	01111110B
	DB	00011000B
	DB	00100100B
	DB	00000000B
;
PLUS:	DB	00001000B
	DB	00001000B
	DB	00111110B
	DB	00001000B
	DB	00001000B
	DB	00000000B
;
COMMA:	DB	00000000B
	DB	00110000B
	DB	01110000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
;
MINUS:	DB	00001000B
	DB	00001000B
	DB	00001000B
	DB	00001000B
	DB	00001000B
	DB	00000000B
;
PERIOD:	DB	00000000B
	DB	01100000B
	DB	01100000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
;
FSLASH:	DB	01100000B
	DB	00010000B
	DB	00001000B
	DB	00000100B
	DB	00000011B
	DB	00000000B
;
CHAR0:	DB	01111110B
	DB	01110001B
	DB	01001001B
	DB	01000111B
	DB	00111111B
	DB	00000000B
;
CHAR1:	DB	00000000B
	DB	01000010B
	DB	01111111B
	DB	01000000B
	DB	00000000B
	DB	00000000B
;
CHAR2:	DB	01100010B
	DB	01010001B
	DB	01001001B
	DB	01001001B
	DB	01000110B
	DB	00000000B
;
CHAR3:	DB	00100010B
	DB	01000001B
	DB	01001001B
	DB	01001001B
	DB	00110110B
	DB	00000000B
;
CHAR4:	DB	00001000B
	DB	00001100B
	DB	00001010B
	DB	01111111B
	DB	00001000B
	DB	00000000B
;
CHAR5:	DB	01001111B
	DB	01001001B
	DB	01001001B
	DB	01001001B
	DB	00110001B
	DB	00000000B
;
CHAR6:	DB	00111110B
	DB	01001001B
	DB	01001001B
	DB	01001001B
	DB	00110010B
	DB	00000000B
;
CHAR7:	DB	01000001B
	DB	00100001B
	DB	00010001B
	DB	00001001B
	DB	00000111B
	DB	00000000B
;
CHAR8:	DB	00110110B
	DB	01001001B
	DB	01001001B
	DB	01001001B
	DB	00110110B
	DB	00000000B
;
CHAR9:	DB	00100110B
	DB	01001001B
	DB	01001001B
	DB	01001001B
	DB	00111110B
	DB	00000000B
;
COLIN:	DB	00000000B
	DB	01100110B
	DB	01100110B
	DB	00000000B
	DB	00000000B
	DB	00000000B
;
SCOLIN:	DB	00000000B
	DB	00110011B
	DB	01110011B
	DB	00000000B
	DB	00000000B
	DB	00000000B
;
LTHAN:	DB	00001000B
	DB	00010100B
	DB	00100010B
	DB	01000001B
	DB	00000000B
	DB	00000000B
;
EQUALS:	DB	00101000B
	DB	00101000B
	DB	00101000B
	DB	00101000B
	DB	00101000B
	DB	00000000B
;
GTHAN:	DB	01000001B
	DB	00100010B
	DB	00010100B
	DB	00001000B
	DB	00000000B
	DB	00000000B
;
QMARK:	DB	00000010B
	DB	00000001B
	DB	01010001B
	DB	00001001B
	DB	00000110B
	DB	00000000B
;
ATSIGN:	DB	00111110B
	DB	01000001B
	DB	01001001B
	DB	01010101B
	DB	01001110B
	DB	00000000B
;
CHARA:	DB	01111100B
	DB	00010010B
	DB	00010001B
	DB	00010010B
	DB	01111100B
	DB	00000000B
;
CHARB:	DB	01111111B
	DB	01001001B
	DB	01001001B
	DB	01001001B
	DB	00110110B
	DB	00000000B
;
CHARC:	DB	00111110B
	DB	01000001B
	DB	01000001B
	DB	01000001B
	DB	00100010B
	DB	00000000B
;
CHARD:	DB	01111111B
	DB	01000001B
	DB	01000001B
	DB	01000001B
	DB	00111110B
	DB	00000000B
;
CHARE:	DB	01111111B
	DB	01001001B
	DB	01001001B
	DB	01001001B
	DB	01000001B
	DB	00000000B
;
CHARF:	DB	01111111B
	DB	00001001B
	DB	00001001B
	DB	00001001B
	DB	00000001B
	DB	00000000B
;
CHARG:	DB	00111110B
	DB	01000001B
	DB	01001001B
	DB	01001001B
	DB	00111010B
	DB	00000000B
;
CHARH:	DB	01111111B
	DB	00001000B
	DB	00001000B
	DB	00001000B
	DB	01111111B
	DB	00000000B
;
CHARI:	DB	00000000B
	DB	01000001B
	DB	01111111B
	DB	01000001B
	DB	00000000B
	DB	00000000B
;
CHARJ:	DB	00100000B
	DB	01000000B
	DB	01000001B
	DB	00111111B
	DB	00000001B
	DB	00000000B
;
CHARK:	DB	01111111B
	DB	00001000B
	DB	00010100B
	DB	00100010B
	DB	01000001B
	DB	00000000B
;
CHARL:	DB	01111111B
	DB	01000000B
	DB	01000000B
	DB	01000000B
	DB	01000000B
	DB	00000000B
;
CHARM:	DB	01111111B
	DB	00000010B
	DB	00000100B
	DB	00000010B
	DB	01111111B
	DB	00000000B
;
CHARN:	DB	01111111B
	DB	00000100B
	DB	00001000B
	DB	00010000B
	DB	01111111B
	DB	00000000B
;
CHARO:	DB	00111110B
	DB	01000001B
	DB	01000001B
	DB	01000001B
	DB	00111110B
	DB	00000000B
;
CHARP:	DB	01111111B
	DB	00001001B
	DB	00001001B
	DB	00001001B
	DB	00000110B
	DB	00000000B
;
CHARQ:	DB	00111110B
	DB	01000001B
	DB	01010001B
	DB	01100001B
	DB	01111110B
	DB	00000000B
;
CHARR:	DB	01111111B
	DB	00001001B
	DB	00011001B
	DB	00101001B
	DB	01000110B
	DB	00000000B
;
CHARS:	DB	00100110B
	DB	01001001B
	DB	01001001B
	DB	01001001B
	DB	00110010B
	DB	00000000B
;
CHART:	DB	00000001B
	DB	00000001B
	DB	01111111B
	DB	00000001B
	DB	00000001B
	DB	00000000B
;
CHARU:	DB	00111111B
	DB	01000000B
	DB	01000000B
	DB	01000000B
	DB	00111111B
	DB	00000000B
;
CHARV:	DB	00011111B
	DB	00100000B
	DB	01000000B
	DB	00100000B
	DB	00011111B
	DB	00000000B
;
CHARW:	DB	01111111B
	DB	00100000B
	DB	00010000B
	DB	00100000B
	DB	01111111B
	DB	00000000B
;
CHARX:	DB	01100011B
	DB	00010100B
	DB	00001000B
	DB	00010100B
	DB	01100011B
	DB	00000000B
;
CHARY:	DB	00000011B
	DB	00000100B
	DB	01111000B
	DB	00000100B
	DB	00000011B
	DB	00000000B
;
CHARZ:	DB	01100001B
	DB	01010001B
	DB	01001001B
	DB	01000101B
	DB	01000011B
	DB	00000000B
;
LBRACK:	DB	00000000B
	DB	00000000B
	DB	01111111B
	DB	01000001B
	DB	00000000B
	DB	00000000B
;
BSLASH:	DB	00000011B
	DB	00000100B
	DB	00001000B
	DB	00010000B
	DB	01100000B
	DB	00000000B
;
RBRACK:	DB	00000000B
	DB	01000001B
	DB	01111111B
	DB	00000000B
	DB	00000000B
	DB	00000000B
;
UPAROW:	DB	00000100B
	DB	00000010B
	DB	01111111B
	DB	00000010B
	DB	00000100B
	DB	00000000B
;
BKAROW:	DB	00001000B
	DB	00011100B
	DB	00101010B
	DB	00001000B
	DB	00001000B
	DB	00000000B
;
BKQUOTE:DB	00000000B
	DB	00000001B
	DB	00000010B
	DB	00000100B
	DB	00000000B
	DB	00000000B
;
BUFFER	EQU	($ AND 0FF00H) + 100H
;
	END	START
