	TITLE	'VADCG Terminal node Communications Program - module TIP'
; ***************************************************************************
; **  VADCG Terminal node Communications Program - module TIP     ***********
; **          by Doug Lockhart, VE7APU                 December, 1979  ******
; ***************************************************************************
; Last changed:  23 July, 1980

; Terminal Interface Program
; This program is written to run in the VADCG Terminal Node Controller.
; It interfaces with a node communications program running at address 0
; in memory.  This version is written to use the 8250 programmable UART
; at 1200 baud to communicate with a local terminal operating at this speed.

	maclib	lib85

incrtb	macro
	mvi	a,1
	rst	2
	endm

incrlb	macro	?d
	mvi	a,?d
	rst	3
	endm

; ram constant - change for different ram location
loram	equ	1000h	; start of ram storage

; non-zero status means line buffer address is in <HL> reg.
; zero status means no buffer is ready
nextin	macro
	rst	4
	endm

; 8255 parallel i/o equates

porta	equ	8	; port a input and output
portb	equ	9	; port b
portc	equ	0ah	; port c
control	equ	0bh	; control port output only

; baud rate equates

baud384	equ	4	; divisor for 38,400 baud
baud192	equ	8	; 19,200
baud96	equ	16	; 9,600
baud48	equ	32	; 4,800
baud24	equ	64	; 2,400
baud12	equ	128	; 1,200
baud600	equ	256	; 600
baud300	equ	512	; 300
baud150	equ	1024	; 150
baud134	equ	1142	; 134.5
baud110	equ	1395	; 110
baud75	equ	2048	; 75
baud50	equ	3072	; 50

; 8250 serial i/o equates

; register equates
rbr	equ	0	; receive buffer register (r)
thr	equ	0	; transmit holding register (w)
ier	equ	1	; interrupt enable register (w)
iir	equ	2	; interrupt identification reg. (r)
lcr	equ	3	; line control reg. (r/w)
mcr	equ	4	; modem control reg. (r/w)
lsr	equ	5	; line status reg. (r/w)
msr	equ	6	; modem status reg. (r/w)
dll	equ	0	; driver latch - lsb (w)
dlm	equ	1	; driver latch - msb (w)

; interrupt enable equates
erbfi	equ	1	; enable received data available interrupt
etbei	equ	2	; enable transmitter holding reg. empty
elsi	equ	4	; enable receiver line status interrupt
edssi	equ	8	; enable modem status interrupt

; interrupt identification equates
ipend	equ	1	; '0' if interrupt pending
iid0	equ	2	; interrupt id. bit 0
iid1	equ	4	; interrupt id. bit 1

; line control equates
wls0	equ	1	; word length select bit 0
wls1	equ	2	; word length select bit 1
stb	equ	4	; stop bit select
pen	equ	8	; parity enable
eps	equ	10h	; even parity select
spty	equ	20h	; stick parity
sbrk	equ	40h	; set break
dlab	equ	80h	; driver latch access bit

; modem control equates
dtr	equ	1 	; data terminal ready
rts	equ	2	; request to send
out1	equ	4	; out1 line on 8250
out2	equ	8	; out2 line on 8250
loop	equ	10h	; modem loop control bit

; line status equates
dr	equ	1	; data ready
oe	equ	2	; overrun error
pe	equ	4	; parity error
fe	equ 	8	; framing error
bi	equ	10h	; break interrupt
thre	equ	20h	; transmitter holding reg. empty
tsre	equ	40h	; transmitter shift reg. empty

; modem status equates
dcts	equ	1	; data clear to send
ddsr	equ	2	; delta data set ready
teri	equ	4	; trailing edge ring indicator
drlsd	equ	8	; delta receive line signal detect
cts	equ	10h	; clear to send
dsr	equ	20h	; data set ready
ri	equ	40h	; ring indicate
rlsd	equ	80h	; receive line signal detect
rimd	equ	17h	; request initialization mode control byte

; character format equates for standard equipment
mod15	equ	stb		; for model 15 tty
asr33	equ	wls1+pen+stb	; for model asr33 tty
horst	equ	wls1+wls0	; for horst's system
bob	equ	wls1+pen	; for bob's terminal
richard equ	wls1+pen+eps	; for richard's terminal

mse	equ	08h	; mask set enable bit

; common communications area

; circular terminal buffer variables

cca	equ	loram	; address of beginning of ram area
ctbie	equ	cca+4	; current terminal buffer input entry
otbe	equ	cca+6	; oldest terminal buffer entry
tbip	equ	cca+8	; terminal buffer input pointer
tbop	equ	cca+0ah	; terminal buffer output pointer
ltboe	equ	cca+0ch	; last terminal buffer output entry
ctboe	equ	cca+0eh	; current terminal buffer output entry

; circular line buffer variables

lbpe	equ	cca+12h	; line buffer processing entry
clbe	equ	cca+14h	; current line buffer entry addr.
olbe	equ	cca+16h	; oldest line buffer entry
lbip	equ	cca+18h	; line buffer input pointer
lbop	equ	cca+1ah	; line buffer output pointer

; miscellaneous

stat1	equ	cca	; mainline status byte
tboflo	equ	cca+3	; terminal buffer overflow status
bufcount equ	cca+1ch	; current input buffer count
outcount equ	cca+1dh	; current buffer output bytes remaining
session	equ	cca+31h	; current session indicator:
			; ascii blank for connection or
			; non-blank for network services
cr	equ	0dh	; carriage return
lf	equ	0ah	; line feed

	page

;	********************************************************************
;	**		configuration equates                            ***
;	**	values change for every configuration                    ***
;	********************************************************************

format	equ	horst	; current character format
baudrat	equ	baud12	; current baud rate

	org	800h	; where this program's eprom starts

; entry jump table

	jmp	tipinit	; initialization entry point called by ncp
	jmp	rst55	; interrupt from 8250
	jmp	$	; unused interrupt entry point
	jmp	dispatch	; to dispatcher routine
rimbuf	db	10,rimd,6,'ve7dpm',0	; initialization buffer
	dw	1000			; turnaround delay value

tipinit:
	; set baud rate in serial port
	mvi	a,dlab
	out	lcr
	mvi	a,low baudrat
	out	dll		; baud rate divisor lsb
	mvi	a,high baudrat
	out	dlm		; baud rate divisor msb

	; define character format of serial data
 	mvi	a,format
	out	lcr	; update line control reg.

	; set up default session parameter
	mvi	a,' '
	sta 	session

	; unmask interrupts from serial interface
	rim		; get current interrupt mask in <A>
	ani	00000110b	; reset rst5.5 bit
	ori	mse	; set mask set enable bit
	sim		; enable rst5.5 interrupts

	; clear out receive buffer reg.
	in	rbr

	; enable received data available interrupts
	mvi	a,erbfi
	out	ier	; update interrupt enable reg.

	; bring up dsr, rlsd, and cts for terminal
	mvi	a,dtr+out1+rts
	out	mcr	; update modem control reg.

	; return to lip for completion of initialization
	ret

	page

rst55:
	push	psw
	push	h
	push	d
	push	b
	in	iir	; get interrupt identification information
	cpi	iid1	; is it received data available interrupt?
	jz	rxint	; yes, go to receive interrupt routine
	cpi	iid0	; is it transmit buffer empty?
	jz	txint	; yes, go to transmit interrupt routine
	jmp	exit	; unknown interrupt, return

rxint:
	in	rbr
	cpi	18h	; is it control x?
	jnz	ctlytest
	mvi	a,' '
	sta	session
	jmp	exit
ctlytest:
	cpi	19h	; is it control y?
	jnz	testoflo	; no, test for buffer overflow
	mvi	a,'*'	; indicate network services
	sta	session
	jmp	exit
testoflo:
	mov	c,a	; save data byte
	lda	tboflo
	ora	a
	jnz	exit
	lhld	otbe
	xchg
	lhld	tbip
update:
	incrtb
	jz	full
	shld	tbip
	lda	bufcount
	inr	a
	sta	bufcount
	cpi	1	; was it empty?
	jnz	loaddata
	lda	session
	mov	m,a
	jmp	update
loaddata:
	mov	m,c
txwait:
	in	lsr
	ani	thre
	jz	txwait
	mov	a,c
	out	thr
	cpi	cr
	jnz	exit
	lxi	h,bufcount
	mov	a,m	; get bufcount in a
	mvi	m,0	; bufcount = 0
	lhld	ctbie
	mov	m,a
	lhld	tbip
	incrtb
	shld	ctbie
	cz	overflow
	incrtb
	shld	tbip
	cz	overflow
exit:
	pop	b
	pop	d
	pop	h
	pop	psw
	ei
	ret

overflow:
	mvi	a,0ffh
	sta	tboflo
	ret

full:
	call	overflow
	jmp	exit

txint:
	lhld	lbop
	incrlb	1
	shld	lbop	; lbop = lbop + 1
	mov	a,m
	out	thr	; output data at lbop
	lxi	h,outcount
	dcr	m
	jnz	exit
	mvi	a,erbfi
	out	ier	; disable transmitter interrupts
	jmp	exit

	page
dispatch:
	in	ier
	ani	etbei	; are transmit interrupts enabled?
	rnz		; yes, return
	nextin		; no, try to get another buffer
	rz		; return if no buffers are ready
	mov	a,m	; get data length in buffer header
	dcr	a	; don't print the header
	sta	outcount	; and save it for interrupt routine
	incrlb	4	; point past the header
	shld	lbop	; lbop = olbe + 4
	mvi	a,etbei+erbfi
	out	ier	; enable transmitter interrupts
	ret

	end
int past the header
	shld	lbop	; lbop = ol