/*
	SHORTEN.C:  Program to shorten lines after 'nn' characters
		    per line.  This program should be useful to
		    those who have editors (like mine) which
		    truncate lines too long for the screen.

	For BDS C v1.4

	Skip Gilbrech - 1/11/82
	212-685-0551
*/

#include "bdscio.h"

char ibuf[BUFSIZ], obuf[BUFSIZ];
char fileout;			 /* output file? */
char termview;			 /* view output on terminal? */
char extlf;			 /* want extra '\n' at end of line? */
int c;

main(argc,argv)
char **argv;
{
	char *cp;
	char holdval;		 /* intermediate value holder */
	char ctr;		 /* length of line counter */
	int lngthln;		 /* length of longest line desired (made
				    'int' to check for 'line too long') */

	lngthln = 80;
	ctr = 0;
	fileout = FALSE;
	termview = FALSE;
	extlf = FALSE;

	printf("\nSHORTEN V1.0\nCtrl-S pauses; Ctrl-C aborts\n");

	while (--argc && *(cp = *++argv) == '-') {    /* process command line */
		while (*++cp) {
			if (isdigit(*cp)) {
				lngthln = atoi(&argv[0][1]);
				break;
			}
			else	switch (tolower(*cp)) {
				case 'v':
					++termview;  break;
				case 'l':
					++extlf;  break;
				 default:
					goto usage;
				}
		}
	}
	if (argc < 1 || argc > 2 || lngthln > 80 || lngthln < 10) {
usage:
       printf("\nUsage: A>shorten [-nn] [-vl] infile [outfile]<cr>\n");
       printf("(The '[ ]' means optional.)\n");
       printf("\nThis program will shorten text lines over 'nn' char's. ");
       printf("long (default\nnn = 80), so they will fit into editors ");
       printf("which truncate lines too long\nfor the screen.\n\n");
       printf("\t-nn: Optional value for line length (default and maximum\n");
       printf("\t     80, minimum 10)\n");
       printf("\t-vl: Optional switches to view output on terminal [v] and ");
       printf("to add\n\t     extra linefeeds to the end of shortened lines ");
       printf("[l] (This is\n\t     so BASIC interpreters will load the file");
       printf(" without a 'direct\n");
       printf("\t     statement in file' error message).\n");
       printf("\t     If no output file is specified, the view option is ");
       printf("automatic.\n");
       exit();
	}
	if (!strcmp(argv[0],argv[1])) {
		printf("\nThe infile and outfile have the same name. The");
		printf(" original file\nwill be lost if you continue.");
		printf("  Is that what you want? <Y/N> ");
		pause();
		if (tolower(getchar(c)) != 'y') {
			printf("\nOK\n");  exit();
		}
		printf("\nOK\n");
	}
	printf("\nInfile = %s  ", argv[0]);
	if (fopen(argv[0],ibuf) == ERROR) {
		printf("\n\007Can't open %s\n", argv[0]);  exit();
	}
	if (argc == 2) {
		++fileout;
		printf("||  Outfile = %s\n", argv[1]);
	}
	if (fileout && (fcreat(argv[1],obuf) == ERROR)) {
		printf("\007Can't create %s\n", argv[1]);  exit();
	}
	if (!fileout)  printf("\n");
	printf("Line length = %d\n", lngthln);
	if (argc == 1 || termview) {
		termview = TRUE;
		printf("Output will appear on terminal\n");
	}
	if (extlf) {
		printf("Appending extra linefeeds\n");
		--lngthln;			/* make room for the extra lf */
	}
	while ((c = getc(ibuf)) != EOF && c != CPMEOF) {
		if (c == '\r' || c == '\n') {
			ptout(c);  ctr = 0;
		}
		else if (c == '\t') {
			holdval = ctr;
			while (++holdval % 8 != 0)
				;
			if ((c = getc(ibuf)) != '\r' && c != '\n' && holdval >
							 lngthln ) {
				ungetc(c,ibuf);
				nlout();  ctr = 8;
			}
			else {
				ungetc(c,ibuf);  ctr = holdval;
			}
			ptout('\t');
		}
		else if (ctr < lngthln) {
			ptout(c);  ++ctr;
		}
		else {
			nlout();
			ptout(c);  ctr = 1;
		}
	}
	if (fileout) {
		putc(CPMEOF,obuf);
		if (fflush(obuf) == ERROR) {
			printf("\007Can't flush output buffer.\n");
			exit();
		}
		if (fclose(obuf) == ERROR) {
			printf("\007Can't close output file.\n");
			exit();
		}
	}
	fclose(ibuf);
	printf("\007\nConversion completed.\n");
}

nlout() 		/* get a newline */
{
	if (extlf)
		ptout('\n');
	ptout('\r');
	ptout('\n');
}

ptout(c)		/* put a character to the terminal and/or output file */
{
	if (termview)
		putchar(c);
	if (fileout)
		if (putc(c,obuf)==ERROR) {
			printf("\007Write error; disk probably full.\n");
			exit();
		}
}
sk probably full.\n");
			exit();
		}
}
or; disk probably full.\n");
