	TITLE	'BSTAM receive module vers 4.3.05'
;
;********************************
;*				*
;*	    BSTAM v4.3		*
;*	     RECEIVE		*
;*	   LOCAL REV 04 	*
;*				*
;********************************
;
;
;MODIFICATION HISTORY:
;=====================
; 1/6/82 ADDED THE OPTION OF PLACING THE
;	 RECEIVEING FILE ON TO A SELECTED 
;	 DRIVE AND USER AREA TO KEEP TRACK OF NEW 
;	 FILES AND (MY REASON) TO KEEP THEM OFF OF
;	 PROTECTED DRIVES.              (BTW)
;
; 8/13/8 FIXED PROBLEM WHERE INCOMING FILENAMES
;	 WHICH EXIST ON THE DISK (AND HAVE BLANK
;	 FILETYPE) WOULD END UP WITH TYPE ".  $".
;	 SUCH FILES NOW GET TYPE ".XX$"   (R)
;
; 8/6/81 ADDED QUIET MODE FOR AUTOMATIC ASSEMBLY
;	 OF RQ.COM.  ADDED NOCOMS EQUATE, WHICH
;	 IF SET "TRUE", CHANGES ANY INCOMING COM
;	 FILES TO "OBJ".  ALSO ADDED "NODEL" EQUATE,
;	 WHICH, IF SET TRUE, CAUSES AN INCOMING FILE
;	 WITH NAME SAME AS EXISTING FILE, TO HAVE
;	 ITS TYPE CHANGED TO "xx$", AND ANY EXIST-
;	 ING <FILE>.xx$ TO BE ERASED.	 (R)
;
;
	ORG	100H
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
QUIET	EQU	TRUE	;TRUE ASSEMBLES RQ.COM
NOCOMS	EQU	TRUE 	;TRUE CHANGES .COM TO .OBJ
NODEL	EQU	TRUE	;TRUE CAUSES AN INCOMING FILENAME
;			; TO BE CHANGED TO <FILENAME>.xx$ IF THAT NAME
;			; ALREADY EXISTS ON THE DISK
AREANEW	EQU	TRUE	; TRUE TO SELECT YOUR USER NUMBER AND DRIVE
DEFDRV	EQU	'B'	;SET TO THE DRIVE YOU WANT TO RECEIVE ON
DEFUSER	EQU	2	;SET TO THE USER AREA TO RECEIVE ON (NOT > 9)
;
BDOS	EQU	05H
DBUF	EQU	80H
DFCB	EQU	5CH
EX	EQU	0CH
EXTENT	EQU	0CH
CURDRV	EQU	25	; BDOS FUNC TO GET CURRENT DRIVE
SELDRV  EQU	14	; BDOS FUNC TO SELECT DEFAULT DRIVE
GSUSER	EQU	32	; BDOS FUNC TO GET/SET USER NUMBER
;
CR	EQU	13
LF	EQU	10
;
MODPRT	EQU	0C0H	;PMMI ADDRESS

	PAGE
;
; PRINT MACRO FOR MESSAGES
; TO BE SUPPRESSED IN QUIET MODE
;
;	$-MACRO 		;TURN ON SUPPRESSION
;
PRINT	MACRO	STRING
	LOCAL	OVRSTR,MARK
	JMP	OVRSTR
MARK:	DB	CR,LF,STRING
OVRSTR: LXI	D,MARK
;
	IF	QUIET
	CALL	LOCPRT	;MAYBE LOCAL PRINT ONLY
	ELSE
	MVI	C,9	;NON-QUIET, USE BDOS
	CALL	BDOS
	ENDIF
;
;
	ENDM
;
;
; PRINT MACRO FOR MESSAGES ALWAYS PRINTED
;
APRINT	MACRO	STRING
	LOCAL	OVRSTR,MARK
	JMP	OVRSTR
MARK:	DB	CR,LF,STRING
OVRSTR: LXI	D,MARK
	MVI	C,9
	CALL	BDOS
	ENDM
;
	PAGE
; USER AREA
;
USER	EQU	$
;
	JMP	ENTRY
INITV:	JMP	INITIU
INSPRV: JMP	INSPRU
ERRV:	JMP	ERRSTU
MIV:	JMP	INPRTU
MODOV:	JMP	OUTPRU
;
; NEW VECTOR FOR LOCAL CONSOLE
; OUTPUT: PRINT CHAR IN C, CAN
; MODIFY ANY REGISTERS
;
LCOV:	JMP	LCO
INITIU: CALL	SIGNON
	RET
INSPRU: PUSH	B
	PUSH	D
	MVI	B,0FH
ONESEC: LXI	D,0C350H
TLOOP:	IN	MODPRT+2
	ANI	4
	JZ	CARROK
	DCR	E
	JNZ	TLOOP
	DCR	D
	JNZ	TLOOP
	DCR	B
	JNZ	ONESEC
	POP	D
	POP	B
	XRA	A
	OUT	MODPRT
	OUT	MODPRT+3
	LXI	D,LSTMSG
	MVI	C,9
	CALL	BDOS
	IF	AREANEW
	JMP	ZEROU
	ELSE
	JMP	0
	ENDIF
LSTMSG: DB	CR,LF,'    ++CARRIER LOST++'
	DB	CR,LF,'The modem is now '
	DB	'DISCONNECTED',CR,LF,'$'
CARROK: POP	D
	POP	B
	IN	MODPRT
	ANI	7
	RET
ERRSTU: RET
INPRTU: IN	MODPRT+1
	RET
OUTPRU: OUT	MODPRT+1
	RET
SIGNON: PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,MESSGE
	MVI	C,9
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	RET
;
	IF	NOT QUIET ;VERBOSE SIGN-ON
MESSGE: DB	CR,LF,CR,LF,'PMMI Modem '
	DB	'ver 2.0 - no initialization '
	DB	'done,',CR,LF,'tests for '
	DB	'loss of carrier.',CR,LF
	DB	'$'
	ELSE
MESSGE: DB	'$'	;QUIET SIGN-ON
	ENDIF
;
; NEW HANDLER FOR LOCAL-CONSOLE
; ONLY.  PRINT REG C, CAN USE
; ANY REGISTER
;
LCO:	RET		;PLUG IN FOR YOUR SYSTEM
;
	PAGE
;
;
	ORG	USER+300
;
ENTRY:	LXI	H,0
	DAD	SP
	SHLD	STACK
	LXI	SP,STACK
	JMP	BYSTAK
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0
	LXI	H,0
	DAD	SP
	SHLD	STACK
	LXI	SP,STACK
	JMP	BYSTAK
STACK:	DW	0
;
	IF	QUIET
BYSTAK:
	IF	AREANEW
	LDA	SETEST	
	INR	A
	JNZ	BYSTAK1
	MVI	E,0FFH		;GET THE CURRENT USER AREA
	MVI	C,GSUSER
	CALL	BDOS
	STA	OLDUSER		;SAVE USER NUMBER HERE
	MVI	C,CURDRV	;GET THE CURRENT DRIVE
	CALL	BDOS
	STA	OLDDRV		;SAVE DRIVE HERE
	ENDIF

BYSTAK1	APRINT	'BSTAM rev 4.3.05 Receive$'

	IF	AREANEW
	APRINT	'File Will Be Stored on $'
	APRINT	<'Drive ',DEFDRV,' User ',DEFUSER+30H,'$'>
	ENDIF

	APRINT	'Ready$'
	APRINT	'$'
	ELSE
BYSTAK:
	IF	AREANEW
	LDA	SETEST	
	INR	A
	JNZ	BYSTAK1
	MVI	E,0FFH		;GET THE CURRENT USER AREA
	MVI	C,GSUSER
	CALL	BDOS
	STA	OLDUSER		;SAVE USER NUMBER HERE
	MVI	C,CURDRV	;GET THE CURRENT DRIVE
	CALL	BDOS
	STA	OLDDRV		;SAVE DRIVE HERE
	ENDIF
BYSTAK1	PRINT	'BYROM SOFTWARE TELECOMMUNICATIONS$'
	PRINT	'SERIAL NO. AA-000 VERSION   4.3.05$'
	PRINT	'COPYRIGHT (C) 1980  ALL RIGHTS RESERVED$'
	IF	AREANEW
	PRINT	'File Will Be Stored on $'
	PRINT	<'Drive ',DEFDRV,' User ',DEFUSER+30H,'$'>
	ENDIF
	ENDIF
;
	IF	NOT AREANEW
	LDA	DBUF
	CPI	0
	JNZ	GOTDRV
	APRINT	'**** NO DRIVE NAME - PROGRAM ABORTING ****$'
	JMP	EXTEST
	ELSE 
	MVI	A,0
	STA	DFCB
	ENDIF
GOTDRV: LDA	DFCB+1
	CPI	' '
	JZ	RCVLOP
	LDA	DBUF+4
	CPI	'*'	;2AH
	JNZ	NOTEXT
	MVI	A,1
	STA	EXTFLG
	APRINT	'---- EXTENDED MODE ACTIVE ----$'
	JMP	RCVLOP
NOTEXT: MVI	A,1
	STA	OVRMOD
	APRINT	'---- OVERRIDING TRANSMITTED FILE NAME ----$'
	APRINT	'---- USING USER SUPPLIED NAME ----$'
	APRINT	'---- ONLY ONE FILE WILL BE RECEIVED ----$'
RCVLOP: MVI	A,0
	STA	L1317
	CALL	L0575
	LDA	L1317
	CPI	1
	JZ	L0526
L0518:	LDA	L1317
	SUI	0
	JNZ	L0526
	CALL	L0DA9
	JMP	L0518
L0526:	CALL	L120C
EXTEST: LDA	OVRMOD
	SUI	0
	JNZ	EXIT
	LDA	L1317
	SUI	2
	JZ	RCVLOP
	LDA	EXTFLG
	SUI	1
	JNZ	EXIT
	PRINT	'---- EXTENDED MODE ACTIVE ----$'
	JMP	RCVLOP
EXIT:	LHLD	STACK
	SPHL
	CALL	RESTU
	RET
;
; LOCAL PRINT SUBROUTINE...EMULATES BDOS
; FUNCTION 9 ON LOCAL CONSOLE WHEN 'QUIET'
; CONDITIONAL TRUE...USES LOCAL CO VECTOR
; IN USER AREA (WHICH CAN SIMPLY DO RET
; TO BE TRULY QUIET).
;
	IF	QUIET
LOCPRT: LDAX	D	;PICK UP CHAR
	INX	D	;POINT PAST IT
	CPI	'$'	;GOT TERMINATOR?
	RZ		;WE'RE DONE IF SO
	MOV	C,A	;NOT TERM, OUTPUT IT
	PUSH	D	;SAVE STRING PTR
	CALL	LCOV	;SEND IT
	POP	D	;GET STR PTR BACK
	JMP	LOCPRT	;PRINT REST OF STRING
	ENDIF		;QUIET
;
L0575:	LXI	H,DFCB+1
	SHLD	L1333
	MVI	A,0
	STA	L1316
	STA	L1317
	STA	L1319
	STA	L131A
	MVI	A,1
	STA	L131B
	CALL	INITV
	PRINT	'**** CONNECTING TO REMOTE CPU ****$'
	JMP	L0892
L05C4:	SHLD	L088D
	XCHG
	SHLD	L0890
	STA	L088F
	LHLD	L088D
	SHLD	L088B
	MVI	A,1
	STA	L0886
	STA	L0887
	STA	L0889
	MVI	A,0
	STA	L0888
	LHLD	L0890
	MOV	M,A
	INX	H
	MOV	M,A
	INX	H
	MVI	A,0FFH
	MOV	M,A
	INX	H
	MVI	A,0
	MOV	M,A
	INX	H
	MOV	M,A
	INX	H
	MVI	A,0FFH
	MOV	M,A
L05F8:	LDA	L0889
	SUI	1
	JNZ	L0885
	LHLD	L0890
	INX	H
	INX	H
	INX	H
	LDA	L088F
	CMP	M
	JNZ	L0642
	MVI	A,0
	STA	L0889
	LHLD	L088B
	DCX	H
	DCX	H
	MOV	A,M
	CPI	10H
	JNZ	L0638
	INX	H
	MOV	A,M
	CPI	6
	JZ	L0882
	CPI	15H
	JZ	L0882
	CPI	5
	JZ	L0882
	CPI	3
	JZ	L0882
	CPI	17H
	JZ	L0882
L0638:	LHLD	L0890
	MVI	A,1
	ORA	M
	MOV	M,A
	JMP	L0882
L0642:	LHLD	L0890
	MVI	A,0
	MOV	M,A
	JMP	L0709
L064B:	SHLD	L0701
	STA	L0707
	LHLD	L0705
	SHLD	L0703
L0657:	CALL	INSPRV
	STA	L0708
	LDA	L0708
	ANI	10H
	JZ	L0670
	CALL	ERRV
	LHLD	L0701
	MVI	A,' '	;20H
	ORA	M
	MOV	M,A
	RET
L0670:	LDA	L0708
	ANI	8
	JZ	L0683
	CALL	ERRV
	LHLD	L0701
	MVI	A,'@'	;40H
	ORA	M
	MOV	M,A
	RET
L0683:	LDA	L0708
	ANI	2
	JZ	L06DF
	CALL	MIV
	STA	L0708
	LDA	L0707
	CPI	1
	JZ	L069D
	LDA	L0708
	RET
L069D:	LHLD	L0701
	INX	H
	INX	H
	MOV	D,M
	INX	H
	INX	H
	INX	H
	MOV	E,M
	LDA	L0708
	XCHG
	JMP	L06CD
CRCADD: XRA	H
	MOV	B,A
	RLC
	RLC
	RLC
	RLC
	XRA	B
	MOV	C,A
	ANI	0F0H
	MOV	D,A
	ADD	C
	MOV	E,A
	MOV	A,D
	ACI	0
	XRA	L
	MOV	H,A
	MOV	A,B
	ANI	0F0H
	MOV	B,A
	XRA	E
	MOV	L,A
	MOV	A,B
	RRC
	RRC
	RRC
	XRA	H
	MOV	H,A
	RET
L06CD:	CALL	CRCADD
	XCHG
	LHLD	L0701
	INX	H
	INX	H
	MOV	M,D
	INX	H
	INX	H
	INX	H
	MOV	M,E
	LDA	L0708
	RET
L06DF:	LHLD	L0703
	DCX	H
	MVI	A,0
	CMP	H
	JZ	L06EF
	SHLD	L0703
	JMP	L0657
L06EF:	CMP	L
	JZ	L06F9
	SHLD	L0703
	JMP	L0657
L06F9:	LHLD	L0701
	MVI	A,4
	ORA	M
	MOV	M,A
	RET
L0701:	DW	0
L0703:	DW	0
L0705:	DW	0
L0707:	DB	0
L0708:	DB	0
L0709:	LHLD	L0890
	MVI	A,1
	CALL	L064B
	STA	L088A
	LHLD	L0890
	MVI	A,0
	CMP	M
	JZ	L0725
	MVI	A,0
	STA	L0889
	JMP	L0882
L0725:	LDA	L0886
	SUI	1
	JNZ	L079D
	LDA	L0887
	SUI	1
	JNZ	L0755
	LDA	L088A
	CPI	10H
	JNZ	L0745
	MVI	A,0
	STA	L0887
	JMP	L0784
L0745:	LHLD	L0890
	MVI	A,8
	ORA	M
	XCHG
	STAX	D
	MVI	A,0
	STA	L0889
	JMP	L0784
L0755:	LDA	L088A
	CPI	2
	JNZ	L0765
	MVI	A,0
	STA	L0886
	JMP	L0784
L0765:	LDA	L088A
	CPI	6
	JZ	L077F
	CPI	15H
	JZ	L077F
	CPI	5
	JZ	L077F
	MVI	A,8
	LHLD	L0890
	ORA	M
	XCHG
	STAX	D
L077F:	MVI	A,0
	STA	L0889
L0784:	LDA	L088A
	LHLD	L088B
	XCHG
	STAX	D
	INX	D
	XCHG
	SHLD	L088B
	LHLD	L0890
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A
	JMP	L0882
L079D:	LDA	L0888
	SUI	1
	JNZ	L0861
	LDA	L088A
	CPI	10H
	JNZ	L07C9
	MVI	A,0
	STA	L0888
	LDA	L088A
	LHLD	L088B
	MOV	M,A
	INX	H
	SHLD	L088B
	LHLD	L0890
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A
	JMP	L0882
L07C9:	LDA	L088A
	CPI	17H
	JZ	L07F9
	CPI	3
	JZ	L07F9
	CPI	1BH
	JZ	L07F9
	LHLD	L0890
	MVI	A,8
	ORA	M
	MOV	M,A
	LDA	L088A
	LHLD	L088B
	MOV	M,A
	INX	H
	SHLD	L088B
	LHLD	L0890
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A
	JMP	L0859
L07F9:	MVI	A,10H
	LHLD	L088B
	MOV	M,A
	INX	H
	LDA	L088A
	MOV	M,A
	LHLD	L0890
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	INR	A
	MOV	M,A
	LHLD	L0890
	MVI	A,0
	CALL	L064B
	STA	L088A
	LHLD	L0890
	MVI	A,0
	CMP	M
	JNZ	L0859
	INX	H
	LDA	L088A
	MOV	M,A
	LHLD	L0890
	MVI	A,0
	CALL	L064B
	STA	L088A
	LHLD	L0890
	MVI	A,0
	CMP	M
	JNZ	L0859
	INX	H
	INX	H
	INX	H
	INX	H
	LDA	L088A
	MOV	M,A
	INX	H
	CMP	M
	JNZ	L0852
	LHLD	L0890
	INX	H
	MOV	A,M
	INX	H
	CMP	M
	JZ	L0859
L0852:	MVI	A,10H
	LHLD	L0890
	ORA	M
	MOV	M,A
L0859:	MVI	A,0
	STA	L0889
	JMP	L0882
L0861:	LDA	L088A
	CPI	10H
	JNZ	L0871
	MVI	A,1
	STA	L0888
	JMP	L0882
L0871:	LHLD	L088B
	MOV	M,A
	INX	H
	SHLD	L088B
	LHLD	L0890
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A
L0882:	JMP	L05F8
L0885:	RET
L0886:	DB	0
L0887:	DB	0
L0888:	DB	0
L0889:	DB	0
L088A:	DB	0
L088B:	DW	0
L088D:	DW	0
L088F:	DB	0
L0890:	DW	0
L0892:	LXI	H,L137B
	LXI	D,L131C
	MVI	A,2
	CALL	L05C4
L089D:	LDA	L131B
	SUI	1
	JNZ	PREMCN
	LDA	L131C
	CPI	0
	JZ	L0A8C
	JMP	LKEROR
ERRCHK: SHLD	STSPTR
	MVI	A,80H
	ANA	M
	JZ	CKPAR
	PRINT	'**** FRAMING ERROR ****$'
CKPAR:	LHLD	STSPTR
	MVI	A,40H
	ANA	M
	JZ	CKOVR
	PRINT	'**** PARITY ERROR ****$'
CKOVR:	LHLD	STSPTR
	MVI	A,20H
	ANA	M
	JZ	CKBCC
	PRINT	'**** OVERRUN ERROR ****$'
CKBCC:	LHLD	STSPTR
	MVI	A,10H
	ANA	M
	JZ	CKLOS
	PRINT	'**** BCC ERROR ****$'
CKLOS:	LHLD	STSPTR
	MVI	A,8
	ANA	M
	JZ	CHKTIM
	PRINT	'**** LOST DATA ERROR ****$'
CHKTIM: LHLD	STSPTR
	MVI	A,4
	ANA	M
	JZ	CKEXCP
	PRINT	'**** TIME OUT ERROR ****$'
CKEXCP: LHLD	STSPTR
	MVI	A,2
	ANA	M
	JZ	CKLEN
	PRINT	'**** EXCEPTION ERROR ****$'
CKLEN:	LHLD	STSPTR
	MVI	A,1
	ANA	M
	RZ
	PRINT	'**** LENGTH ERROR ****$'
	RET
STSPTR: DW	0
LKEROR: LXI	H,L131C
	CALL	ERRCHK
	JMP	L0A7B
STOPCK: 
	IF	NOT QUIET
	MVI	C,0BH
	CALL	BDOS
	ORA	A
	RZ
	MVI	C,1
	CALL	BDOS
	CPI	3
	RNZ
	PRINT	'**** OPERATOR ABORT, PHONE LINE IS ACTIVE ****$'
	XRA	A
	STA	EXTFLG
	JMP	L0526
	ELSE
	RET		;NO STOPCK IN QUIET MODE
	ENDIF
;
L0A7B:	CALL	STOPCK
	LXI	H,L137B
	LXI	D,L131C
	MVI	A,2
	CALL	L05C4
	JMP	L0D72
L0A8C:	LDA	L137B
	CPI	10H
	JNZ	PRINPR
	LDA	L137C
	CPI	5
	JNZ	PRINPR
	MVI	A,0
	STA	L131B
	JMP	L0D0E
L0AA4:	SHLD	L0CF5
	SHLD	L0CF9
	XCHG
	SHLD	L0CFD
	MOV	H,B
	MOV	L,C
	SHLD	L0CFB
	STA	L0CFF
	MVI	A,0
	LHLD	L0CFD
	MOV	M,A
	INX	H
	INX	H
	INX	H
	MOV	M,A
	DCX	H
	MVI	A,0FFH
	MOV	M,A
	DCX	H
	MVI	A,0
	MOV	M,A
	INX	H
	INX	H
	INX	H
	MOV	M,A
	INX	H
	MVI	A,0FFH
	MOV	M,A
	MVI	A,1
	STA	L0CF8
	STA	L0CF7
	CALL	ERRV
L0ADB:	LDA	L0CF8
	SUI	1
	JNZ	L0CF4
	LHLD	L0CFB
	MOV	A,M
	LHLD	L0CFD
	INX	H
	INX	H
	INX	H
	CMP	M
	JNZ	L0C0B
	MVI	A,0
	STA	L0CF8
	JMP	L0B4F
L0AF9:	STA	L0B4E
	SHLD	L0B49
	XCHG
	SHLD	L0B4B
L0B03:	CALL	INSPRV
	STA	L0B4D
	ANI	1
	JZ	L0B03
	LDA	L0B4D
	ANI	4
	JZ	L0B03
	LHLD	L0B4B
	MOV	A,M
	CALL	MODOV
L0B1D:	CALL	INSPRV
	ANI	4
	JZ	L0B1D
	LDA	L0B4E
	CPI	1
	RNZ
	LHLD	L0B49
	INX	H
	INX	H
	MOV	D,M
	INX	H
	INX	H
	INX	H
	MOV	E,M
	LHLD	L0B4B
	MOV	A,M
	XCHG
	CALL	CRCADD
	XCHG
	LHLD	L0B49
	INX	H
	INX	H
	MOV	M,D
	INX	H
	INX	H
	INX	H
	MOV	M,E
	RET
L0B49:	DW	0
L0B4B:	DW	0
L0B4D:	DB	0
L0B4E:	DB	0
L0B4F:	LHLD	L0CFD
	XCHG
	LHLD	L0D03
	XCHG
	MVI	A,1
	CALL	L0AF9
	CALL	INSPRV
	ANI	2
	JZ	L0B6E
	LHLD	L0CFD
	MVI	A,2
	ORA	M
	MOV	M,A
	JMP	L0CF1
L0B6E:	LDA	L0CFF
	CPI	1
	JZ	L0B86
	LHLD	L0CFD
	XCHG
	LHLD	L0D06
	XCHG
	MVI	A,1
	CALL	L0AF9
	JMP	L0BB2
L0B86:	LHLD	L1331
	INX	H
	MOV	A,M
	CPI	0
	JZ	L0BA5
	MVI	A,2
	STA	L1317
	LHLD	L0CFD
	XCHG
	LHLD	L0D00
	XCHG
	MVI	A,1
	CALL	L0AF9
	JMP	L0BB2
L0BA5:	LHLD	L0CFD
	XCHG
	LHLD	L0D09
	XCHG
	MVI	A,1
	CALL	L0AF9
L0BB2:	CALL	INSPRV
	ANI	2
	JZ	L0BC4
	LHLD	L0CFD
	MVI	A,2
	ORA	M
	MOV	M,A
	JMP	L0CF1
L0BC4:	LHLD	L0CFD
	INX	H
	INX	H
	SHLD	L0D0C
	LHLD	L0CFD
	XCHG
	LHLD	L0D0C
	XCHG
	MVI	A,0
	CALL	L0AF9
	CALL	INSPRV
	ANI	2
	JNZ	L0C01
	LHLD	L0CFD
	INX	H
	INX	H
	INX	H
	INX	H
	INX	H
	SHLD	L0D0C
	LHLD	L0CFD
	XCHG
	LHLD	L0D0C
	XCHG
	MVI	A,0
	CALL	L0AF9
	CALL	INSPRV
	ANI	2
	JZ	L0CF1
L0C01:	LHLD	L0CFD
	MVI	A,2
	ORA	M
	MOV	M,A
	JMP	L0CF1
L0C0B:	CALL	INSPRV
	ANI	2
	JZ	L0C22
	LHLD	L0CFD
	MVI	A,2
	ORA	M
	MOV	M,A
	MVI	A,0
	STA	L0CF8
	JMP	L0CF1
L0C22:	LDA	L0CF7
	SUI	1
	JNZ	L0C92
	LHLD	L0CFD
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A
	LHLD	L0CFD
	XCHG
	LHLD	L0CF9
	XCHG
	MVI	A,1
	CALL	L0AF9
	LHLD	L0CF9
	INX	H
	SHLD	L0CF9
	CALL	INSPRV
	ANI	2
	JZ	L0C5E
	LHLD	L0CFD
	MVI	A,2
	ORA	M
	MOV	M,A
	MVI	A,0
	STA	L0CF8
	JMP	L0CF1
L0C5E:	LHLD	L0CFD
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A
	LHLD	L0CFD
	XCHG
	LHLD	L0CF9
	XCHG
	MVI	A,1
	CALL	L0AF9
	LHLD	L0CF9
	INX	H
	SHLD	L0CF9
	DCX	H
	MVI	A,2
	CMP	M
	JNZ	L0C8A
	MVI	A,0
	STA	L0CF7
	JMP	L0CF1
L0C8A:	MVI	A,0
	STA	L0CF8
	JMP	L0CF1
L0C92:	LHLD	L0CFD
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INR	A
	MOV	M,A
	LHLD	L0CFD
	XCHG
	LHLD	L0CF9
	XCHG
	MVI	A,1
	CALL	L0AF9
	LHLD	L0CF9
	INX	H
	SHLD	L0CF9
	CALL	INSPRV
	ANI	2
	JZ	L0CC6
	LHLD	L0CFD
	MVI	A,2
	ORA	M
	MOV	M,A
	MVI	A,0
	STA	L0CF8
	JMP	L0CF1
L0CC6:	LHLD	L0CF9
	DCX	H
	MVI	A,10H
	CMP	M
	JNZ	L0CF1
	LHLD	L0CFD
	XCHG
	LHLD	L0D03
	XCHG
	MVI	A,1
	CALL	L0AF9
	CALL	INSPRV
	ANI	2
	JZ	L0CF1
	LHLD	L0CFD
	MVI	A,2
	ORA	M
	MOV	M,A
	MVI	A,0
	STA	L0CF8
L0CF1:	JMP	L0ADB
L0CF4:	RET
L0CF5:	DW	0
L0CF7:	DB	0
L0CF8:	DB	0
L0CF9:	DW	0
L0CFB:	DW	0
L0CFD:	DW	0
L0CFF:	DB	0
L0D00:	DW	L0D02
L0D02:	DB	1BH
L0D03:	DW	L0D05
L0D05:	DB	10H
L0D06:	DW	L0D08
L0D08:	DB	3
L0D09:	DW	L0D0B
L0D0B:	DB	17H
L0D0C:	DW	0
L0D0E:	LXI	H,L1379
	LXI	D,L1327
	LXI	B,L1326
	MVI	A,0
	CALL	L0AA4
	JMP	L0D72
PRINPR: PRINT	'**** CONNECTION IS STILL IN PROGRESS ****$'
	CALL	STOPCK
	LXI	H,L1377
	LXI	D,L1327
	LXI	B,L1326
	MVI	A,0
	CALL	L0AA4
	LXI	H,L137B
	LXI	D,L131C
	MVI	A,2
	CALL	L05C4
L0D72:	JMP	L089D
PREMCN: PRINT	'**** REMOTE CPU IS NOW CONNECTED ****$'
	RET
L0DA9:	MVI	A,0
	STA	L1322
	MVI	A,1
	STA	L1323
	MVI	A,0
	STA	L1319
	LXI	H,L137B
	LXI	D,L131C
	MVI	A,0C8H
	CALL	L05C4
L0DC3:	LDA	L1323
	SUI	1
	JNZ	L11D3
	LDA	L131C
	CPI	0
	JZ	L0ECF
L0DD3:	LXI	H,L131C
	CALL	ERRCHK
	LDA	L137C
	CPI	5
	JNZ	L0E48
	LDA	L1316
	SUI	0
	JNZ	PSYNER
	LDA	L1319
	INR	A
	STA	L1319
	LDA	L1319
	SUI	0C8H
	JC	L0DFC
	DCR	A
	JNC	PRMERR
L0DFC:	LXI	H,L1379
	LXI	D,L1327
	LXI	B,L1326
	MVI	A,0
	CALL	L0AA4
	LXI	H,L137B
	LXI	D,L131C
	MVI	A,0C8H
	CALL	L05C4
	JMP	L11D0
PSYNER: PRINT	'**** SYNCHRONIZATION ERROR ****$'
	JMP	L0EA1
L0E48:	LDA	L1319
	INR	A
	STA	L1319
	LDA	L1319
	SUI	0C8H
	JC	L0EB3
	JZ	L0EB3
PRMERR: APRINT	'**** PERMANENT TRANSMISSION ERROR - PROGRAM ABORTING ****$'
L0EA1:	MVI	A,1
	STA	L1317
	MVI	A,0
	STA	L1323
	MVI	A,1
	STA	L1322
	JMP	L11D0
L0EB3:	LXI	H,L1324
	LXI	D,L1327
	LXI	B,L1326
	MVI	A,0
	CALL	L0AA4
	LXI	H,L137B
	LXI	D,L131C
	MVI	A,0C8H
	CALL	L05C4
	JMP	L11D0
L0ECF:	LDA	L137B
	CPI	10H
	JNZ	L0DD3
	LDA	L137C
	CPI	2
	JNZ	L0DD3
	LDA	L131A
	LXI	H,L137D
	SUB	M
	JNZ	L10E6
	LDA	L131A
	INR	A
	STA	L131A
	LXI	H,L137B
	LXI	B,0
	LDA	L131F
	MOV	C,A
	DAD	B
	DCX	H
	MVI	A,3
	CMP	M
	JZ	L0F15
	MVI	A,1BH
	CMP	M
	JNZ	L0F10
	MVI	A,2
	STA	L1317
	JMP	L0F15
L0F10:	MVI	A,1
	STA	L1317
L0F15:	DCX	H
	SHLD	L132D
	XCHG
	LXI	H,L137E
	SHLD	L132F
L0F20:	LHLD	L132D
	XCHG
	LHLD	L132F
	MOV	A,D
	CMP	H
	JNZ	L0F34
	MOV	A,E
	CMP	L
	JNZ	L0F34
	JMP	L0F6B
L0F34:	LDA	L1316
	SUI	0
	JZ	L0F4D
	LHLD	L132F
	MOV	A,M
	CALL	PBYTE
	LHLD	L132F
	INX	H
	SHLD	L132F
	JMP	L0F20
L0F4D:	LHLD	L132F
	XCHG
	LHLD	L1333
	XCHG
	LDA	OVRMOD
	CPI	0
	JNZ	L0F5F
	MOV	A,M
	STAX	D
L0F5F:	INX	H
	INX	D
	SHLD	L132F
	XCHG
	SHLD	L1333
	JMP	L0F20
L0F6B:	LDA	L1316
	SUI	0
	JNZ	L10D0
	MVI	B,8
	LXI	H,L137E
	LXI	D,FILNAM
MOV1:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MOV1
	INX	D
	MVI	B,3
MOV2:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MOV2
FILNAM	EQU	$+20+3+2
;
	PRINT	'---- RECEIVING FILE --------.--- ----$'
	JMP	L0FCD
MOV3:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	MOV3
	RET
L0FCD:	LXI	H,DFCB
	LXI	D,MYFCB
	MVI	C,9
	CALL	MOV3
	JMP	MAKEV
MYFCB:	DB	2,0C2H,0D3H,0DH,':',1AH,13H
	DB	'!}$$$'
	DB	0,10H,':',1AH,13H,'<2',1AH
	DB	13H,'!{',13H,1,0,0,':',1FH
	DB	13H,'O',9
RECNUM: DB	'+'
FILBAS: DW	L1443
BUFSIZ: DW	1380H
BUFLEN: DW	L0F15
MAKEV:	JMP	MAKFIL
PBYTE:	PUSH	PSW
	LHLD	BUFSIZ
	XCHG
	LHLD	BUFLEN
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	L1074
	LXI	H,0
	SHLD	BUFLEN
WRLOOP: XCHG
	LHLD	BUFSIZ
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	JNC	L1066
	LHLD	FILBAS
	DAD	D
	XCHG
	MVI	C,1AH
	CALL	BDOS
	LXI	D,MYFCB
	MVI	C,15H
	CALL	BDOS
	ORA	A
	JNZ	DSKFUL
	LXI	D,DBUF
	LHLD	BUFLEN
	DAD	D
	SHLD	BUFLEN
	JMP	WRLOOP
DSKFUL: MVI	C,9
	LXI	D,FULEMS
	CALL	BDOS
	POP	PSW
	IF	AREANEW
	JMP	ZEROU
	ELSE
	JMP	0
	ENDIF
FULEMS: DB	CR,LF,'DISK FULL: DEST$'
L1066:	LXI	D,DBUF
	MVI	C,1AH
	CALL	BDOS
	LXI	H,0
	SHLD	BUFLEN
L1074:	XCHG
	LHLD	FILBAS
	DAD	D
	XCHG
	POP	PSW
	STAX	D
	LHLD	BUFLEN
	INX	H
	SHLD	BUFLEN
	RET
MAKFIL: XRA	A
	STA	MYFCB+EX
	STA	RECNUM
	LXI	H,1380H ;SIZE OF BUFFER
	SHLD	BUFSIZ
	LXI	H,0
	SHLD	BUFLEN
	CALL	RECAREA		;NEW 	@
	MVI	C,13H
	LXI	D,MYFCB
	CALL	BDOS
	MVI	C,16H
	LXI	D,MYFCB
	CALL	BDOS
	INR	A
	JNZ	L10CB
	MVI	C,9
	LXI	D,DIRFEM
	CALL	BDOS
	IF	AREANEW
	JMP	ZEROU
	ELSE
	JMP	0
	ENDIF
DIRFEM: DB	CR,LF,'NO DIR SPACE: DEST$'
L10CB:	MVI	A,1
	STA	L1316
L10D0:	LXI	H,L1379
	LXI	D,L1327
	LXI	B,L1326
	MVI	A,0
	CALL	L0AA4
	MVI	A,0
	STA	L1323
	JMP	L11D0
L10E6:	LDA	L131A
	SUI	0
	JNZ	L11BF
	LDA	L137D
	CPI	0FCH
	JNC	L113A
BCBERR: APRINT	'**** BCB ERROR - PROGRAM ABORTING ****$'
	MVI	A,1
	STA	L1322
	STA	L1317
	MVI	A,0
	STA	L1323
	JMP	L11D0
L113A:	LDA	L1319
	INR	A
	STA	L1319
	LDA	L1319
	SUI	0C8H
	JC	L11A3
	JZ	L11A3
	APRINT	'**** PERMANENT TRANSMISSION ERROR - PROGRAM ABORTING ****$'
	MVI	A,0
	STA	L1323
	MVI	A,1
	STA	L1322
	STA	L1317
	JMP	L11D0
L11A3:	LXI	H,L1379
	LXI	D,L1327
	LXI	B,L1326
	MVI	A,0
	CALL	L0AA4
	LXI	H,L137B
	LXI	D,L131C
	MVI	A,0C8H
	CALL	L05C4
	JMP	L11D0
L11BF:	LDA	L131A
	LXI	H,L137D
	SUB	M
	JC	L11CD
	DCR	A
	JNC	L113A
L11CD:	JMP	BCBERR
L11D0:	JMP	L0DC3
L11D3:	LDA	L1322
	SUI	1
	JZ	L120B
GOTBLK: PRINT	'**** BLOCK RECEIVED CORRECTLY ****$'
L120B:	RET
L120C:	LDA	L1316
	SUI	0
	JZ	L12DC
L1214:	LHLD	BUFLEN
	MOV	A,L
	ANI	7FH
	JNZ	L1220
	SHLD	BUFSIZ
L1220:	MVI	A,1AH
	PUSH	PSW
	CALL	PBYTE
	POP	PSW
	JNZ	L1214
	MVI	C,10H
	LXI	D,MYFCB
	CALL	BDOS
	INR	A
	JNZ	PR27
	MVI	C,9
	LXI	D,MS27
	CALL	BDOS
	JMP	PR27
MS27:	DB	CR,LF,'CANNOT CLOSE DEST$'
PR27:	LDA	L1322
	SUI	1
	JZ	L12DC
	LXI	D,L1335
	LXI	H,DFCB
	MVI	B,0CH
MOV4:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MOV4
	XRA	A	;CLEAR EX BYTE
	STAX	D	;(ADDED IN LOC REV 01)
;
	IF	NOCOMS	;RENAME COM TO OBJ?
	CALL	COMFIX
	ENDIF
;
	IF	NODEL	;DON'T ERASE FILES?
	CALL	DUPFIX
	ENDIF
;
	MVI	C,13H	;NOW WE CAN ERASE
	LXI	D,L1335
	CALL	BDOS
	LXI	H,DFCB
	LXI	D,L1356
	MVI	B,9
MOV5:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MOV5
	LXI	H,TMPTYP
	MVI	B,3
MOV6:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MOV6
	LXI	D,L1366
	LXI	H,L1335
	MVI	B,0CH
MOV7:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MOV7
	MVI	C,17H
	LXI	D,L1356
	CALL	BDOS
	PRINT	'---- FILE IS NOW STORED ON DISK ----$'
L12DC:	PRINT	'**** DISCONNECTING FROM REMOTE CPU ****$'
	RET
;
; CONDITIONAL NOCOM ROUTINE...RENAMES ANY .COM TYPE
; FILES TO .OBJ
;
	IF	NOCOMS
COMFIX: LXI	H,L1335+9	;LOOK AT FILE TYPE
	MOV	A,M		;GET FIRST BYTE
	ANI	7FH		;KILL ATTRIBUTES
	CPI	'C'		;'C' OF 'COM'
	RNZ
	INX	H		;MIDDLE CHAR OF TYPE
	MOV	A,M		;FETCH IT
	ANI	7FH		;KILL ATTR
	CPI	'O'		;'O' OF 'COM'
	RNZ
	INX	H		;LAST CHAR
	MOV	A,M		;FETCH
	ANI	7FH		;NO ATR
	CPI	'M'		;'M' OF 'COM'
	RNZ
	LXI	H,OBJTYP	;GOT COM FILE...SO
	LXI	D,L1335+9	;  CHANGE THE TYPE
	MVI	C,3		;  TO .OBJ
	CALL	MOV3
	RET
OBJTYP: DB	'OBJ'
	ENDIF
;
; FIX FOR INCOMING FILES THAT MATCH AN EXISTING
; NAME...IF A FILE EXISTS, THE INCOMING NAME IS
; CHANGED TO "DUP", WHICH IS SUBSEQUENTLY DELETED
; IN THE CALLING CODE
;
	IF	NODEL
DUPFIX: LXI	D,L1335 	;OUR FCB
	MVI	C,17		;SEARCH FOR 1ST
	CALL	BDOS
	INR	A		;GOT 0FFH?
	RZ			;THEN NO FILE, DONE
	LXI	H,L1335+11	;CHANGE TO .xx$
	MVI	M,'$'		;FLAG IT
	CALL	FIX1		;FIX BLANK FILETYPES
	CALL	FIX1		;(1ST CHAR OF TYPE)
	RET
FIX1:	DCX	H
	MOV	A,M
	CPI	' '		;BLANK TYPE?
	RNZ
	MVI	M,'X'		;THEN "X" IT OUT
	RET
;
DUPTYP: DB	'DUP'
	ENDIF
	
	IF	AREANEW
ZEROU:	CALL	RESTU
	JMP	0

;------> RESTORE THE USER AREA AND DRIVE FROM A RECEIVED FILE
;
RESTU	LDA	SETEST
	CPI	0FFH
	RZ
	LDA	OLDUSER		;RESTORE THE OLD DRIVE
	MOV	E,A
	CALL	RECARE
	LDA	OLDDRV		;RESTORE THE OLD USER NUMBER
	MOV	E,A
	JMP	RECDRX
;
;--------> SET USER AREA AND DRIVE TO RECEIVE FILE
RECAREA	LDA	SETEST
	INR	A
	RNZ
	MVI	A,0
	STA	SETEST
	CALL	RECDRV
	MVI	E,DEFUSER
RECARE	MVI	C,GSUSER
	CALL	BDOS
	RET

RECDRV	MVI	E,DEFDRV-41H
RECDRX	MVI	C,SELDRV
	CALL	BDOS
	RET
	ENDIF
;
;
;
SETEST:	DB	0FFH
OLDDRV:	DB	0
OLDUSER DB	0
TMPTYP: DB	'$$$'
OVRMOD: DB	0
L1316:	DB	0
L1317:	DB	0
EXTFLG: DB	0
L1319:	DB	0
L131A:	DB	0
L131B:	DB	0
L131C:	DB	0,0,0
L131F:	DB	0,0,0
L1322:	DB	0
L1323:	DB	0
L1324:	DB	10H,15H
L1326:	DB	2
L1327:	DB	0,0,0,0,0,0
L132D:	DB	0,0
L132F:	DB	0,0
L1331:	DB	0,0
L1333:	DB	0,0
L1335:	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
L1356:	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0
L1366:	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0
L1377:	DB	10H,5
L1379:	DB	10H,6
L137B:	DB	0
L137C:	DB	0
L137D:	DB	0
L137E:	DB	0,0
BUFFER: DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
L1443:	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
;
	END
