#
/*
 *      Generalized Menu Program.
 *
 *      Contributed to USENIX, February, 1980.
 *      Please refer questions and any bugs to:
 *              Neil Groundwater
 *              c/o Analytic Disciplines, Inc.
 *              8320 Old Courthouse Road  #300
 *              Vienna,  Virginia  22180
 *              (703) 893-6140
 *
 *      Compiled by:  cc -O menu.c -lp
        May use "-n" to share text if heavily used.
 *
 *      Expects to be called with a filename as argument.
 *      File form:
 *              Header question.
 *              :                               (delimiter)
 *              Choice::Prog_to_execute:Arg_to_prog
 *              Choice::Prog_to_execute:Arg[1]_to_prog:Arg[2]_to_prog...
 *              Choice:Directory:Prog_to_execute
 *              Choice                          (simply exits)
 *
 *      Menu will be presented listing choices and selection #'s.
 *      Valid selection number will execute desired program.
 *      Optional 2nd arg is directory to change to before exec.
 *
 *      nl will exit,
 *      'q' will exit.
 */

/*
 * This buffer must be at least as large as the file
 * containing the menu selections.
 */
char    bufr[2048];

/* used for user response */
char    buf_in[80];

/* flag for first pass to allow reset/setexit to setup */
int first {0};
#define NSEL    24                      /* max # of selections */
#define N_ARG   4                       /* Allows 4 prog args */

struct  sel {
        char    *a[4+N_ARG];            /* Choice, directory, progname, a[1], */
                                        /*  a[2], a[3], .., null.  */
} sel[NSEL];

struct  sel     *selp;


/* Version 2.1 */


main(argc, argv)
char *argv[];
{
        int num;
        int fd;
        int nchs, ii;
        register char *bufp;
        int siz;
        int status;                     /* child status */
        extern int onintr(), reset();

        signal(2, 1);                   /* shut off until ready to catch */
        signal(3, 1);                   /* this one stays off */

        if ((argc < 2) || ((fd = copen(argv[1], 'r')) < 0)) {
                printf("Can't find Menu Data file: %s\n", argv[1]);
                cexit();
        }

        /* load whole header into bufr */
        bufp = bufr;
        while (((siz = getstr(fd, bufp)) > 0) && (*bufp != ':')) {
                bufp =+ siz;            /* move pointer */
                *(bufp-1) = '\n';       /* put back the nl */
        }
        *bufp++ = '\0';                 /* null terminate header */

        selp = sel;

        /* load the choice lines and set up pointers */
        for (nchs=0; nchs<NSEL; nchs++) {
                if ((siz = getstr(fd, bufp)) == 0)
                        break;
                selp->a[0] = bufp;      /* start of rec */
                bufp =+ siz;            /* move ptr to end of line */

                *(bufp-1) = '\0';       /* null the nl */

                /* Null colons and add zero-last-ptr */
                for (ii=0; selp->a[ii+1]=colon(selp->a[ii]); ii++);

                selp++;
        }
        cclose(fd);


        /* read selection from user... after selection completes
           repeat menu, ad infinitum */
        for (;;) {                      /* find a good number */
                setexit();              /* returns here on intr */
                signal(2, onintr);

                if (first++) {
                        for (;;) {              /* get a response */
                                printf("\nSelection?  ");
                                if (getstr(0, buf_in) == 0)
                                        cexit();
                                if ((buf_in[0] == 'q') || (buf_in[0] == '\0'))
                                        cexit();
                                if (buf_in[0] == '?')
                                        goto reprint;

                                num = atoi(buf_in) - 1;

                                if ((num >= 0) && (num < nchs))
                                        break;

                                printf("* Invalid Choice - Try Again *\n");

                        }
                        selp = &sel[num];

                        if (argc > 2) {                 /* Print Trace */
                                printf("Choice= %s\n", selp->a[0]);
                                if (selp->a[1] != 0)
                                        printf("Dir= %s\n", selp->a[1]);
                                if (selp->a[2] != 0)
                                        printf("Prog= %s\n", selp->a[2]);
                                for (ii=3; selp->a[ii] != 0; ii++)
                                        printf("Arg[%d]= %s\t",
                                                 ii-2, selp->a[ii]);
                                printf("\n");
                        }

                        if (selp->a[2] == 0)    /* exit - no prog to run */
                                cexit();

                        signal(2, 1);           /* don't interrupt here */
                        if (fork() == 0) {
                                /* child */
                                signal(2, 0);
                                if ((selp->a[1] != 0) &&
                                    (chdir(selp->a[1]) != 0)) {
                                        printf("Invalid Directory Name: %s\n",
                                                 selp->a[1]);
                                        cexit();
                                }

                                execv(selp->a[2], &selp->a[2]);

                                printf("* Execute Error in Menu Selection *\n");
                                cexit();
                        }

                        /* parent */
                        wait(status);
                        signal(2, onintr);      /* re-enable */
                }

        reprint: ;
                printf("%s", bufr);             /* print header */

                /* print choices */
                for (ii=0; ii<nchs; ii++) {
                        if (ii < 9)
                                printf("\t (%d)  %s\n", ii+1, sel[ii].a[0]);
                        else
                                printf("\t(%d)  %s\n", ii+1, sel[ii].a[0]);
                }
        }
}

/*
 *      COLON(PTR)
 *      Given a pointer to a string, search until the next ":" is found.
 *      Null out that next colon and return to the caller a pointer
 *      to the character following.
 *      If no colon was found, return zero. The string is assumed
 *      to be null terminated.
 *      Note that a line terminated by a colon & null will return
 *      pointed at the null.
 */
colon(p)
char *p;
{
        register char *rp;

        if ((rp = p) == 0)              /* if ptr was zero */
                return(0);
        while (*rp != ':')
                if (*rp++ == '\0')
                        return(0);
        *rp++ = '\0';
        return(rp);
}


/*
 *      GETSTR
 *      Get a string from the provided file descriptor.
 */

getstr(fd, buf)
int fd;
char *buf;
{
        extern int cin;
        register int ii;

        cin = fd;
        if (gets(buf) == 0)             /* EOF */
                return(0);

        /* measure length of string */
        for (ii=0; buf[ii] != '\0'; ii++);

        return(ii+1);                   /* include null in count */
}

/*
 *      Interrupt catcher.
 */
onintr()
{
        signal(2, onintr);
        reset();
}
