
After I installed ZCPR in my system, I decided that with all
these new bells and whistles, why not add one more.  I saw
that there were about twenty bytes available at the end of
the CCP so how about a clear screen routine?  Actually, a rou-
tine to do just that was included in an earlier version of
CCP, but was discarded, probably due to space limitations.

First of all, the amount of space you have remaining at the
end of your CCP depends on how you set the customization fea-
tures.  You need at least fourteen bytes to clear the screen
of a Hazeltine 1500 series terminal 'cause it takes a two 
byte routine.

The following deals with ZCPR.ASM Version 1.0:

At line 77 add a new command; call it CLS (or whatever)
So beneath 5L we add:

;     5M		CLS
;

At about line 480 insert a new command into the table, thus:

	DB	'CLS '
	DW	CLS

And finally at the very end of the file, just before END, we
add the routine:

;
;SECTION 5M
;COMMAND: CLS
;FUNCTION: TO CLEAR THE SCREEN ON THE VIDEO TERMINAL
;
CLS:
	CALL	PRINT
	DB	7EH,1CH,80H
	RET
;
	END

The 7EH and 1CH are the two characters needed to clear the
Hazeltine screen; if you have a different terminal, your rou-
tine will naturally be different.  The 80H is needed to term-
inate the string.

There you are; now when you install the new CCP, you can clear
your screen by merely typing CLS (C/R).

GPS
