1c 0
;	TITLE	'BYE V7.8 AS OF 02/20/82'
.
4c 9850
;		BYE V7.8 (revised 02/20/82)
.
15c 20918
;The UARTS supported are the Intel 8251 and the Western Digital 8250.
;Be sure to set the equates for the modem you are using. 
;
;*************************************************************************
;DANGER: Pay close attention to the polarity of the jump instructions    *
;after any in from a uart when running under 8250/8251's,  I have tried  *
;to fix them for the most common logical setup, but your system may      *
;differ.								 *
;*************************************************************************
.
30a 2193
;02/03/82 Fixed the buggy conditional jumps in/after RINGWT.
;	  Now there is conditional assembly depending on if you are
;	  a WD8250/IN8251 or a "standard" system.
;	  Fixed a few bugs in conditional assembly.
;	  Improved LF code.
;	  					-- Paul S Traina
;
;01/20/82 Add equates and routines for HEATH or IMS systems and any
;	  other systems using External modems and the WD8250 UART.
;	  Included assembly option for compatability with RBBS,
;	  MINICBBS, and OXGATE implimentations. by Thom Quick
;
.
47,48c 1306
;	  to allow bye to run below the CCP with programs such as
;	  TYPESQ. Separated Superb conditional assembly into Externl
.
50a 41717
;		
;12/03/81 Implemented OxGate protocol,  fixed some bugs in conditional
;		equates.  Variables for UCLSW and NULLS moved up so that
;		programs can poke them too.	(Paul Traina)
.
282,285c 51113
DEST0	EQU	0F900H	;RUNNING LOCATION OF CODE
;
;Change the following to specify either DCHAYES, PMMI or systems
;with EXTERNAL  modems. Be sure to change either TPORT for PMMI or
.
288,290c 63695
DCHAYES	EQU	TRUE 	;TRUE FOR DC HAYES MODEM
PMMI	EQU	FALSE 	;TRUE FOR PMMI MODEM
IN8251	EQU	FALSE	;TRUE FOR EXTERNAL AND INTEL 8251
WD8250  EQU	FALSE	;TRUE FOR EXTERNAL AND WESTERN DIGITAL 8250 
.
306a 43093
	IF	WD8250 
BASE$PORT  EQU  20H
	ENDIF
;
.
315c 4725
;are at lables 'WELFIN' and 'COMFCB' respectively. 
.
323,324c 33450
OXGATE	EQU	TRUE 	;WANT TO RUN AN OXGATE NODE?
PRINTER EQU	TRUE 	;WANT TO RETAIN LIST DEVICE?
.
327d 5821
329,336c 39114
FKEYS	EQU	TRUE	;WANT SPECIAL FUNCTION KEYS
USRLOG	EQU	FALSE	;WANT TO COUNT NUMBER OF USERS?
HARDLOG EQU	TRUE 	;WANT TO ECHO REMOTE KBD TO PRINTER?
TIMEOUT EQU	TRUE	;WANT AUTO LOG-OFF FOR SLEEPY CALLERS?
TOVALUE EQU	5	;MINUTES TO AUTO LOGOFF
COMFILE EQU	TRUE	;WANT TO AUTOBOOT A COM FILE?
DECIMAL EQU	TRUE	;WANT DECIMAL VALUES FOR LOGS?
TRAPLC	EQU	FALSE	;WANT TO TRAP LOWER CASE?
ALLDEV	EQU	FALSE	;RETAIN PUNCH, READER, LISTER
MINICK	EQU	FALSE	;TRUE IF MINICBBS
RBBSCK	EQU	FALSE	;TRUE IF RBBS SETS/RESETS FLAG AT 'WRTLOC'
.
342,363c 22523
; 
;----------System and hardware dependent options--------------
;
ZCPRT	EQU	TRUE 	;TRUE IF RUNNING NewZCPR (IN SECURE MODE)
WHEEL	EQU	0FFFFH	;LOCATION OF NZCPR'S WHEEL FLAG
BYELOW	EQU	FALSE	;TRUE IF BYE BELOW CCP
LOSER	EQU	FALSE	;TRUE IF WARM BOOT OVERWRITE PART OF THE BIOS
NORING	EQU	FALSE	;UART RING INDICATOR NOT AVAILABLE
CPM2	EQU	TRUE	;USING CP/M 2.X?
MAXUSR	EQU	15	;SET TO 0 FOR CP/M 1.4
WELUSR	EQU	14	;USER # OF WELCOME FILE, CPM2 TRUE
COMUSR	EQU 	14	;USER # OF COM FILE, CPM2 TRUE
FASTCLK	EQU 	TRUE	;SET TRUE FOR 4MHZ CLOCK
MAXDRV	EQU	3	;HIGHEST DRIVE SUPPORTED
IMSAI	EQU	FALSE	;ADDS VARIOUS OPTIONS W/SENSE SW'S
.
360,365c 57976
SENSE	EQU	0FFH	;SENSE SWITCH PORT NUMBER IMSAI TRUE
BLKOUT	EQU	FALSE	;SWITCH TO TURN OFF REMOTE SEND IMSAI TRUE
SELPASS EQU	FALSE 	;SWITCH TO REQUIRE A PASSWORD IMSAI TRUE
CCSDISK	EQU	FALSE 	;SET TRUE IF CCS DISK CONTROLLER   
RTC	EQU	FALSE 	;SET TRUE IF GODBOUT SS1 BOARD
;
	IF CCSDISK
;
DISKON	EQU	071H	;MOTORS ON, SELECT DISK A
DISK	EQU	34H	;DISK CONTROL PORT
DISKOFF	EQU	051H	;MOTORS OFF, SELECT DISK A;
	ENDIF		;CCSDISK
.
380,393c 46967
	IF BYELOW
DEST	EQU	DEST0+3	;KEEP ON TARGET
;
;****WARNING *** WMLOC AND OLDBD ARE SYSTEM DEPENDENT****
.
386,387c 51189
;	LXI	H,OLDBD
;	SHLD	0006
.
393c 14376
	ENDIF		;BYELOW 
.
396,398c 26925
DEST	EQU	DEST0
.
398a 57932
;There are some cases where warm boot overwrites the
;initial bios jump table. This problem was solved for
;the Superbrain 3.0 bios by finding a warmboot call
;to high in the bios. This call is then patched by
;BYE.  The form of the call is:
;	WBCALL  CALL    WMSTRT
;
.
408,421c 11734
WBCALL	EQU	0DE48H	;CHECK THIS IN YOUR BIOS 	
;
;The following location is called
;
WMSTRT	EQU	0EE48H	;CHECK THIS IN YOUR BIOS
;
	ENDIF		;LOSER
;            
;****************************************************
;*	 End of option configuration section	    *
;****************************************************
;
;All modem I/O and control are here
.
423,429d 11990
528,532c 25575
;************ EXTERNAL MODEM I/O AREA ************
;
	IF	IN8251
;
;True if uart is Intel 8251 or equivalent
.
572,573c 7277
	ENDIF		;IN8251
;
;****************WD8250  I/O AREAS*************************
;True if usar is Western Digital 8250 or equivilent.
;
	IF	WD8250
; 
DPORT	EQU	BASE$PORT	;DATA PORT
LPORT	EQU	BASE$PORT+3	;LINE CONTROL
CPORT	EQU	BASE$PORT+4	;MODEM CONTROL
SPORT	EQU	BASE$PORT+5	;LINE STATUS PORT
MSPORT	EQU	BASE$PORT+6	;MODEM STATUS PORT
RPORT	EQU	BASE$PORT+6	;RING INDICATOR PORT
;
*****************LINE STATUS MASKS************************
;
P0TBMT	EQU	20H	;XMIT BUFFER EMPTY
P0DAV	EQU	01H	;DATA AVAILABLE
P0RPE	EQU	04H	;PARITY ERROR
P0ORUN	EQU	02H	;OVERRUN ERROR
P0FERR	EQU	08H	;FRAMING ERROR
P0BRK	EQU	10H	;BREAK DETECT
;
;****************MODEM STATUS MASKS***********************
;
P2DSR	EQU	20H	;DATA SET READY
P2CTS	EQU	080H	;CARRIER DETECT
P2RDET	EQU	040H	;RING DETECT
;
;******************BAUD RATE DIVISORS*********************
;
BR300LS	EQU	000H	;300 BAUD
BR300MS	EQU	001H	
BR450LS	EQU	0ABH	;450 BAUD
BR450MS	EQU	000H	
BR600LS	EQU	080H	;600 BAUD
BR600MS	EQU	000H	
BR120LS	EQU	040H	;1200 BAUD
BR120MS	EQU	000H
;
;*******************MODEM CONTROL****************************
;
MCDTR	EQU	01H	;
MCRTS	EQU	02H
MCOUT1	EQU	04H
MCOUT2	EQU	08H
;
;*********************LINE CONTROL****************************
;
LCWLS0	EQU	01H
LCWLS1	EQU	02H
LCSTB	EQU	04H
LCPEN	EQU	08H
LCPES	EQU	10H
LCSPS	EQU	20H
LCBRK	EQU	40H
LCDLAB	EQU	80H
	ENDIF		;WD8250
.
635,651c 14490
	IF 	BYELOW	
;This code allow running below ccp and using programs such as
;Mbasic or Typesq ect....
;
	LXI	H,OLDBD	;OLD LOCATION STORED IN 6 AND 7 FOR
			;JUMP FROM BDOS CALL
	SHLD	DEST-2	;STORE IT JUST ABOVE BYE
	LXI	H,DEST-3 ;POINT TO THREE BYTE ABOVE 
			 ;NORMAL BYE
	MVI	M,0C3H	;PUT A JUMP THERE
	SHLD	0006H	;STORE DEST-3 FOR BDOS JUMP
	SHLD	WMLOC	;STORE DEST-3 IN YOUR BIOS
;
	ENDIF		;BYELOW
.
672c 61936
       	CALL    BDOS	                                 
.
746,747c 64188
;The following will test whether bye is active and then set
;the flag at WRTLOC.
.
750,756c 1467
;  20 A=PEEK(A+1)*256+PEEK(A)+9 'Get Address of WRTLOC
;  30 IF CHR$(PEEK(A+1))+SHR$(PEEK(A+2))+CHR$(PEEK(A+3))<>"BYE" THEN
;  40 POKE A,&HFF 'SET FLAG FOR WRITE IN PROGRESS
;
;The routine on line 30 should be used in RBBS so that when RBBS is 
;running locally nothing will be poked into the bios.
;   
.
775,779c 3823
NULLS	EQU	$+OFFSET
	DB	5	;INITIAL NUMBER OF NULLS
;
ULCSW	EQU	$+OFFSET
	DB	0	;UPPER CASE ONLY SWITCH
;
LFEEDS	EQU	$+OFFSET
	DB	0	;LINE FEED SWITCH
;	
WRTLOC	EQU	$+OFFSET
	DB	0	;LOCATION OF FLAG FOR RBBS TO 
			;SET WHILE DOING DISK WRITES

.
791c 51040
	DB	'BYE version 7.8 as of 02/20/82',CR,LF,'$'
.
805,807c 52181
	IF	MINICK
;
;Set MINICK to true if you use MINICBBS and want to take
.
810c 56420
;nect during a file update. MINICBBS sets the high-order 
.
814,816c 45026
	MVI	A,IOVAL
	STA	IOBYTE
.
833c 13964
	IF	IN8251
.
837c 26539
	ENDIF		;IN8251
;
	IF	WD8250 
	IN	MSPORT
	ANI	P2CTS
	JNZ	GOODBY
	ENDIF		;WD8250
.
885d 42341
905c 45941
	ENDIF	;CCSDISK
.
939c 64550
	IF	IN8251
.
952c 44792
	ENDIF		;IN8251
;
	IF	WD8250 
	XRA	A	;SHUT OFF DTR & RTS
	OUT	CPORT	;SHUT OFF MODEM
	ENDIF		;WD8250
;
	IF	WD8250 AND NORING
;
	PUSH	B	;PRESERVE IT IF WE NEED IT
	MVI	B,150	;15 SEC DELAY

OFFTI	EQU	$+OFFSET
	CALL	DELAY	;0.1 SEC DELAY
	DCR	B	
	JNZ	OFFTI	;KEEP LOOPING UNTIL DONE
	POP	B	;RESTORE B
	MVI	A,MCDTR+MCRTS	;TURN ON DTR/RTS 
	OUT	CPORT
	ENDIF		;WD8250 
.
988a 34148
	IF	NORING
	IN	MSPORT
	ANI	P2CTS	;GOT CARRIER
	JNZ	ANSWER
	JMP	RINGWT	;KEEP CHECKING
	ENDIF		;NORING
;
.
999c 4767
;
	IF	WD8250 OR IN8251
	JZ	RINGWT	;NO, WAIT
	ENDIF	;WD8250 OR IN8251
;
	IF	NOT (WD8250 OR IN8251)
	JNZ	RINGWT	;NO, WAIT
	ENDIF	;NOT (WD8250 OR IN8251)
.
1013c 12756
;
	IF	WD8250 OR IN8251
	JZ	RINGWT	;NO, IT WAS RELAY BOUNCE
	ENDIF	;WD8250 OR IN8251
;
	IF	NOT (WD8250 OR IN8251)
	JNZ	RINGWT	;NO, IT WAS A RELAY BOUNCE
	ENDIF	;NOT (WD8250 OR IN8251)
.
1028,1030c 2334
;
	IF	WD8250 OR IN8251
	JNZ	ENDRING ;WAIT UNTIL RING FINISHED
	ENDIF	;WD8250 OR IN8251
;
	IF	NOT (WD8250 OR IN8251)
	JZ	ENDRING	;WAIT UNTIL RING FINISHED
	ENDIF	;NOT (WD8250 OR IN8251)
;
	IF	CALLBAK ;NEXT ROUTINES IMPLEMENT CALLBAK
.
1054c 23541
	ENDIF	;CALLBAK
;
	IF	CALLBAK AND (WD8250 OR IN8251)
	JZ	EXPECT	;NO?...ITS FOR ME!
	ENDIF
;
	IF	CALLBAK AND NOT (WD8250 OR IN8251)
	JNZ	EXPECT	;NO?...ITS FOR ME!
	ENDIF
;
	IF	CALLBAK
.
1072c 21465
	ENDIF	;CALLBAK
;
	IF	CALLBAK AND (WD8250 OR IN8251)
	JZ	ENDRNG2 ;WAIT UNTIL RING FINISHED
	ENDIF
;
	IF	CALLBAK AND NOT (WD8250 OR IN8251)
	JNZ	ENDRNG2	;WAIT UNTIL RING FINISHED
	ENDIF
;
	IF	CALLBAK
.
1091c 57899
	ENDIF	;CALLBAK
;
	IF	CALLBAK AND (WD8250 OR IN8251)
	JZ	EXPECT	;NO?...ITS FOR ME!
	ENDIF
;
	IF	CALLBAK AND NOT (WD8250 OR IN8251)
	JNZ	EXPECT	;NO?...ITS FOR ME!
	ENDIF
;
	IF	CALLBAK
.
1112,1114c 42631
	ENDIF	;CALLBAK
;
	IF	CALLBAK AND (WD8250 OR IN8251)
	JNZ	WAITNR	;YES, WAIT 10 MORE SECONDS
.
1117a 45729
	IF	CALLBAK AND NOT (WD8250 OR IN8251)
	JZ	WAITNR	;YES, WAIT 10 MORE SECONDS
	ENDIF
;
	IF	CALLBAK
	DCR	L	;NO RING, MAYBE WE'RE DONE
	JNZ	WAITNRL ;NO, LOOP SOME MORE
	ENDIF
;
.
1141c 42638
	ENDIF	;CALLBAK
;
	IF	CALLBAK AND (WD8250 OR IN8251)
	JNZ	ANSWER	;YES, GO ANSWER IT
	ENDIF
;
	IF	CALLBAK AND NOT (WD8250 OR IN8251)
	JZ	ANSWER	;YES, GO ANSWER IT
	ENDIF
;
	IF	CALLBAK
.
1159c 51761
	ENDIF		;END OF CALLBAK ROUTINES
.
1165,1168c 53854
	IF	ZCPRT		;RESET WHEEL STATUS
	XRA	A		;WHEN RUNNING ZCPR-T## FOR YOUR CCP.
	STA	WHEEL
	ENDIF	;ZCPRT
;
	IF	USRLOG AND PWRQD ;COUNT # OF LOGON ATTEMPTS
	LXI	H,OLDUSR	;GET # OF ATTEMPTS
	CALL	BOPLOG		CALL ROUTINE TO ADD ONE
	ENDIF	;USRLOG AND PWRQD
.
1245c 24390
	IF	IN8251
.
1282,1283c 50366
	ENDIF		 ;IN8251
;
	IF	WD8250 AND NOT NORING
;
	MVI	A,MCDTR+MCRTS	;TURN ON DATA SET, ANSWER PHONE; 
	OUT	CPORT
	ENDIF 		 ;WD8250 AND NOT NORING
;
	IF	WD8250 
	MVI	A,(LCWLS0+LCWLS1) AND 0FFH ;8 BIT DATA 1 STOP BIT NO PAR
	OUT	LPORT
	CALL	PATCH	;PATCH DRIVERS
;
;	BAUD RATE SELECTOR
;
TST300:	EQU	$+OFFSET
	PUSH	D	;SAVE D/E
	MVI	D,BR300MS
	MVI	E,BR300LS
	CALL	SETBAUD
	POP	D
	CALL	TSTBAUD
	JNZ	TST450
	CALL	TSTBAUD
	JZ	WELCOME
TST450:	EQU	$+OFFSET
	PUSH	D
	MVI	D,BR450MS
	MVI	E,BR450LS
	CALL	SETBAUD
	POP	D
	CALL	TSTBAUD
	JNZ	TST600
	CALL	TSTBAUD
	JZ	WELCOME
TST600:	EQU	$+OFFSET
	PUSH	D
	MVI	D,BR600MS
	MVI	E,BR600LS
	CALL	SETBAUD
	POP	D
	CALL	TSTBAUD
	JNZ	TST120
	CALL	TSTBAUD
	JZ	WELCOME
TST120:	EQU	$+OFFSET
	PUSH	D
	MVI	D,BR120MS
	MVI	E,BR120LS
	CALL	SETBAUD
	POP 	D
	CALL	TSTBAUD
	JNZ	BADDO
	CALL	TSTBAUD
	JZ	WELCOME
	ENDIF		;WD8250 
;
BADDO	EQU 	$+OFFSET
.
1343c 610
	IF	IN8251
.
1347c 12781
	ENDIF		;IN8251
.
1470,1472c 10255
	ENDIF	;CCSDISK
;
	IF BYELOW
.
1478c 16238
;	
.
1568c 1995
	ENDIF	;CCSDISK
.
1585a 64470
	IF 	NOT OXGATE
;
.
1604c 54275
	ENDIF		;NOT OXGATE
;
	IF	TRAPLC AND (NOT OXGATE)
.
1625c 25726
	ENDIF		;TRAPLC AND (NOT OXGATE)
.
1729c 60882
	DB	'Incorrect',CR,LF,0
.
1769a 57337
;
.
1773,1775c 15340
	DB	'Please Wait... ' ;BOOT MSG HERE
	DB	0
	ENDIF		;BOOTMSG
.
1809a 10484
	RZ
	CPI	'C'-40H	;IF A CONTROL C
.
1813a 61551
;**************SET WD8250  BAUD RATE************************
;
	IF	WD8250
;
SETBAUD: EQU	$+OFFSET
	MVI	A,83H	;SET DLAB
	OUT	LPORT
	MOV	A,E	;GET LSB
	OUT	DPORT
	MOV	A,D	;GET MSB
	OUT	DPORT+1
	CPI	04H	;110?
	JNZ	ONESTOP	
	MVI	A,LCWLS0+LCWLS1+LCSTB	;8 DATA 2 STOP BITS
	OUT 	LPORT
	JMP	DLOOP
ONESTOP: EQU	$+OFFSET
	MVI	A,LCWLS0+LCWLS1
	OUT 	LPORT
DLOOP:	EQU	$+OFFSET
	XCHG		;PUT DIVISOR IN HL
	DAD H!DAD H!DAD H!DAD H	;MULTIPLY BY 16
				;SO WE DELAY APPROX 2 CHARS TIMES
DLOOP1:	EQU	$+OFFSET
	DCX	H
	MOV	A,L
	ORA	H
	JNZ	DLOOP1
	XCHG
	IN	DPORT
	IN	DPORT
	RET
;
	ENDIF		;WD8250
;
.
1908c 33889
	IF	IN8251
.
1918,1919c 663
	ENDIF		;IN8251
;
	IF 	WD8250
;THE WD8250 HAS HARDWARE HANGUP. BUT WE WILL USE CARRIER DETECT
;ROUTINE TO DETERMINE CARRIER LOSS AFTER 15 SECONDS.......
; 
	IN	MSPORT	;GET MODEM STATUS
	ANI	P2CTS	;GOT A CARRIER
	JNZ	CARCK2	;YES, GO ON WITH TESTS
	PUSH	B	;PRESERVE SO WE CAN USE IT
	MVI	B,150	;SET FOR 15 SECONDS
;
CARLP	EQU	$+OFFSET
;
	CALL	DELAY	;WAIT .1 SECOND
	IN	MSPORT	;GET MODEM STATUS
	ANI	P2CTS	;HAS CARRIER RETURNED ?
	MOV	A,B	;PRESERVE COUNT DOWN VALUE
	POP	B	;FIX STACK IF ALL IS OK
	JNZ	CARCK2	;HAVE CARRIER - CONTINUE
	DCR	A	;COUNT DOWN TIME
	STC		;IN CASE THIS IS THE END OF TIME
	RZ		;RETURN IF TIMED OUT
	PUSH	B	;PRESERVE B
	MOV	B,A	;GET COUNTER VALUE IN B
	JMP	CARLP	;CONTINUE - KEEP CHECKING
	ENDIF		;WD8250

.
1960c 4792
	DB	'A>',0
.
1980c 50447
	DB	'> [Invalid user number, returning to 0]',0
.
2038c 40386
	IF	IN8251
.
2041c 37388
	ENDIF			;IN8251
.
2105,2106c 23264
	ANI	80H	;TEST FOR DISK UPDATE
	RTN		;BUSY WAIT UNTIL DONE
.
2112,2114c 26096
	LDA	WRTLOC	;GET WRITE IN PROGRESS FLAG
	ORA	A
	RNZ		;BUSY WAIT UNTIL DONE
.
2129c 26374
	DB	'[Carrier Lost]'
.
2192c 29309
	IF	IN8251
.
2203,2204c 11172
	ENDIF		;IN8251
;
	IF	WD8250 
	IN	SPORT	;GET STATUS
	ANI	P0DAV	;DATA AVAILABLE
	RZ		;RTN IF NOT RDY
	IN	SPORT	;GET STATUS
	ANI	0EH	;CHECK PAR, FRAM ERR AND OVRN BITS
	JZ	MSTAT1
	IN	DPORT
	XRA	A	;RTN FALSE
	RET
	ENDIF		;WD8250 
.
2262c 7135
	DB	'[Input timed out]',7,7,0
.
2338c 65149
	IF	IN8251
.
2341c 64913
	ENDIF		;IN8251
;
	IF	WD8250 
	IN	SPORT
	ANI	P0TBMT
	ENDIF		;WD8250 
.
2483c 20331
	DB	'[Program area too small]','$'
.
2507c 60444
	DB	'COM file loaded',CR,LF,'$'
.
2521c 33379
	DB	'[Cannot find COM file]','$'
.
2570a 32068
	IF	OXGATE
	CPI	LF	;WE HAVE A TOGGLE FOR LINE FEEDS
	JNZ	MOUTP3	;NOPE, NOT A LF
	LDA	LFEEDS	;YES, SEE IF WE CAN SEND IT...
	ORA	A
	MVI	A,0
	RNZ		;NOPE, DON'T!
	MVI	A,LF
MOUTP3	EQU	$+OFFSET
	ENDIF		;OXGATE
;
.
2590c 4363
	DB	'Message from Sysop:',0
.
2596,2597c 35462
	DB	'System going down in'
	DB	' 5 minutes...',0
.
2634,2636c 53845
	IF	NOT ALLDEV
.
2638d 61547
2641d 2910
2644d 16859
2674c 46389
IF 	RTC
.
2880,2885c 11974
COMFCB	EQU	$+OFFSET
;
	IF	NOT OXGATE
	DB	0,'RBBS    COM'
;COM file name	   ^^^^^^^^^^^ (must be 11 characters)
	ENDIF		;NOT OXGATE
;
	IF 	OXGATE
	DB	0,'OXENTR  COM'
;COM file name     ^^^^^^^^^^^ (must be 11 characters)
	ENDIF		;OXGATE
.
2898c 51183
OPTION	EQU	$+OFFSET
.
2901c 52471
TOCNTM	EQU	$+OFFSET
.
2904,2906d 53759
2908c 24669
;typing "[Carrier Lost]" so we don't loop
.
2976a 53758


.
$a 53758
.
a too small]','$'
.
2507c 60444
	DB