/*	>>>>>> start of cc8 <<<<<<<	*/

/* Begin a comment line for the assembler */
comment()
{	outbyte(';');
}

/* Put out assembler info before any code is generated */
header()
{
	comment();nl();
	if(mainflg){		/* do stuff needed for first */
	 	ol("M EQU Byte Ptr 0[BX]"); /* assembler file. */              
		ol(" DSEG");   /* set up data segment. */
		ol(" ORG 0100H");   /* set up stack */
		ol("CSEG");   /* set up code segment. */
		ol("ORG 0000H");   /* set up stack */
		callrts("ccbgn");	/* Do program initialization. */
		callrts("ccgo");	/* set default drive for CP/M */
		zcall("main");  /* call the code generated by small-c */
		zcall("exit");	/* do an exit		gtf 7/16/80 */
		}
}

/* Print any assembler stuff needed after all code */
trailer()
{	/* ol("END"); */	/*...note: commented out! */

	nl();			/* 6 May 80 rj errorsummary() now goes to console */
	ol(" Include C86lib.a86"); /* Get basic subs. */              
	comment();
	outstr(" --- End of Compilation ---");
	nl();
	ol(" END");
}

/* Continue code segment stuff. */
ccseg()
{
	nl();
	ol(" Cseg $"); /* Start Code Segment from last point. */              
}

/* Continue data segment stuff. */
cdseg()
{
	nl();
	ol(" Dseg $"); /* Start Data Segment from last point. */              
}

/* Function initialization. */
funcbgn()
{
	ol("PUSH BP");		/*Save old frame ptr.*/
	ot("SUB SP,");		/*Adjust stack beyond new frame.*/
	ostklbl();
	nl();
	ol("MOV BP,SP");	/*Get new frame ptr.*/
	nl();
}

/* Function termination. */
funcend()
{
	ostklbl();		/*Generate frame size.*/
	ot("EQU ");
	outudec(Msp);
	nl();
}

/* Print out a name such that it won't annoy the assembler */
/*	(by matching anything reserved, like opcodes.) */
/*	gtf 4/7/80 */
outname(sname)
char *sname;
{	int len, i,j;

	outasm("cz");
	len = strlen(sname);
	if(len>(asmpref+asmsuff)){
		i = asmpref;
		len = len-asmpref-asmsuff;
		while(i-- > 0)
			outbyte(raise(*sname++));
		while(len-- > 0)
			sname++;
		while(*sname)
			outbyte(raise(*sname++));
		}
	else	outasm(sname);
/* end outname */}

/* Fetch a static memory cell into the primary register */
getmem(sym)
	char *sym;
{	if((sym[ident]!=pointer)&
	   (sym[type]==cchar))
		{ot("MOV AL,Byte Ptr ");
		outname(sym+name);
		nl();
		ol("CBW");
		ol("MOV BX,AX");
		nl();
		}
	else
		{ot("MOV BX,Word Ptr ");
		outname(sym+name);
		nl();
		}
	}

/* Fetch the address of the specified symbol */
/*	into the primary register */
getloc(sym)
	char *sym;
{	ot("LEA BX,");
	ostklbl();
	outdec((sym[offset]&255)+((sym[offset+1]&255)<<8));
	outasm("[BP]");
	nl();
	}

/* Store the primary register into the specified */
/* static memory cell. */
putmem(sym)
	char *sym;
{	if((sym[ident]!=pointer)&
	   (sym[type]==cchar))
	   {ot("MOV Byte Ptr ");
	    outname(sym+name);
	    ot(",BL");
	    nl();
	   }
	else
	   {ot("MOV Word Ptr ");
	    outname(sym+name);
	    ot(",BX");
	    nl();
	   }
	}

/* Store the specified object type in the primary register */
/* at the address on the top of the stack. */
putstk(typeobj)
	char typeobj;
{	ol("POP DI");
	Zsp=Zsp+2;
	if (typeobj==cchar)
	   ol("MOV Byte Ptr 0[DI],BL");
	else
	   ol("MOV Word Ptr 0[DI],BX");
	}

/* Fetch the specified object type indirect through the */
/*	primary register into the primary register */
indirect(typeobj)
	char typeobj;
{	if (typeobj==cchar)
	   {
	      ol("MOV AL,0[BX]");
	      ol("CBW");
	      ol("MOV BX,AX");
	   }
	else
	   ol("MOV BX,0[BX]");
}

/* Swap the primary and secondary registers */
swap()
{	ol("XCHG BX,DX");
}

/* Print partial instruction to get an immediate value */
/*	into the primary register */
immed()
{	ot("MOV BX,");
}

/* Print partial instruction to get an immediate value */
/*	into the primary register */
immedo()
{	ot("MOV BX,Offset ");
}

/* Push the primary register onto the stack */
zpush()
{	ol("PUSH BX");
	Zsp=Zsp-2;
}

/* Pop the top of the stack into the secondary register */
zpop()
{	ol("POP DX");
	Zsp=Zsp+2;
}

/* Swap the primary register and the top of the stack */
swapstk()
{	ol("MOV DI,SP");
	ol("XCHG BX,[DI]");
}

