/*	clock.h	4.2	83/03/26	*/

#ifdef SUN1
/*
 * SUN-1 clock registers
 */
#ifdef LOCORE
#define CLKADDR	0x800000
#else
struct clk {
	short	clk_data;	/* data register */
	short	clk_cmd;	/* command register */
};
#define CLKADDR	((struct clk *)(0x800000))
#endif

#define	SECDAY		((unsigned)(24*60*60))		/* seconds per day */

/*
 * Carefully define the basic CPU clock rate so
 * that time-of-day calculations don't float
 */
#define CLK_BASIC	19660800

#define	CLK_RATE	1000		/* rate we use, 1 ms., for mouse */

#define CLK_F1		0xB00 	/* F1 = pulse/1 */
#define CLK_F2		0xC00	/* F2 = pulse/16 */
#define CLK_F3		0xD00	/* F3 = pulse/256 */
#define CLK_F4		0xE00	/* F4 = pulse/4096 */
#define CLK_F5		0xF00	/* F5 = pulse/65536 */
#define CLK_F1DIV	1
#define CLK_F2DIV	16
#define CLK_F3DIV	256
#define CLK_F4DIV	4096
#define CLK_F5DIV	65536
#define CLK_LMODE	0xFF00	/* Command to load the mode register */
#define CLK_LLOAD	0xFF08	/* Command to load the load register */
#define CLK_LHOLD	0xFF10	/* Command to load the hold register */
#define CLK_TICK_MODE	(CLK_F2+0x22) /* F2 + Operating mode D */
#define CLK_UART_MODE	(CLK_F1+0x22) /* F1 + Operating mode D */
#define CLK_HZ(hz)	((CLK_BASIC/(4*CLK_F2DIV))/hz) /* hz to clk conv */	
#define CLK_GO		0xFF20	/* Command to arm counter 2 */
#define CLK_REFR	0xFFE2	/* Command to re-enable clock */
#define CLKTIMER	2	/* Timer 2 */

#define	UARTTIMER	4	/* first timer for UARTS */
#endif
