/*	@(#)mushmuck.h	4.1	(Melbourne)	82/03/01	*/

/*
 * Describes the mushmuck file, which contains per user varying
 * information, usage, login time limits, ...
 */

typedef	u_short		period_t;	/* measured in minutes */
typedef	long		tlimit_t;	/* measured in seconds */

struct	mushmuck	{

	time_t		mm_updated;	/* time this record last updated */
	struct	quinfo	mm_qu;		/* dynamic system info */

	time_t		mm_logbase;	/* time login info last updated */
	tlimit_t	mm_maxuse;	/* maximum overall login time */
	tlimit_t	mm_used;	/* login time used */

	period_t	mm_wrem;	/* weeks login time left */
	period_t	mm_winc;	/* weekly login allowance */
	period_t	mm_wmax;	/* maximum weekly login time */

	period_t	mm_drem;	/* login time left today */
	period_t	mm_dinc;	/* daily login allowance */
	period_t	mm_dmax;	/* maximum daily login time */

	period_t	mm_smax;	/* maximum login session length */
	period_t	mm_lgap;	/* gap required between logins */
	period_t	mm_left;	/* time left in current session */

	short		mm_sess;	/* counter of login sessions */

	union		{		/* make sizeof(struct mushmuck)==64 */
		long		mm_lpad[3];
		short		mm_spad[6];
		char		mm_cpad[12];
	}		mm_pad;

};

/*
 * MUSH messages - to mush from user level code (and the corresp replies)
 *	(messages from the system are defined in sys/mush.h)
 */
#define	MM_SHARE	10	/* return in fdat current % share for uid */
#define	MM_USAGE	11	/* return in fdat current usage for uid */
#define	MM_LTIME	12	/* return expected length of login avail */
#define	MM_ALTER	13	/* alter mushmuck data */
#define	MM_REQUEST	14	/* return data from mushmuck */
#define	MM_SYNCR	15	/* set sync rate to ldat */
#define	MM_FREEU	16	/* set minfree (cache size) from ldat */
#define MM_SLTIME	17	/* set max login time (& reason) */
#define	MM_SYNC		18	/* synchronization message */

/*
 * MM_LTIME - values returned in d_info
 *		(associated data in minutes returned in d_ldat)
 */
#define	MM_L_OK		0	/* user may log in for as long as he likes */
#define	MM_L_DAY	1	/* data is time left today */
#define	MM_L_WEEK	2	/* data is time left this week */
#define	MM_L_EVER	3	/* data is absolute time left */
#define	MM_L_SESS	4	/* data is time left in session */
#define	MM_L_EXP	5	/* data is time until account expires */
#define	MM_L_TIME	6	/* data is time until illegal time of day */

/*
 * MM_ALTER, MM_REQUEST - commands passed in d_info
 *				(comments apply in reverse for MM_REQUEST)
 */
#define	MM_A_SHARE	1	/* set shares to sdat */
#define	MM_A_CLASS	2	/* set class to ldat */
#define	MM_A_FLAGS	3	/* set flags to ldat */
#define	MM_A_PLIM	4	/* set plim to sdat */
#define	MM_A_MAXUSE	5	/* set maxuse to ldat */
#define	MM_A_USED	6	/* set used to ldat */
#define	MM_A_WREM	7	/* set wrem to sdat */
#define	MM_A_WINC	8	/* set winc to sdat */
#define	MM_A_WMAX	9	/* set wmax to sdat */
#define	MM_A_DREM	10	/* set drem to sdat */
#define	MM_A_DINC	11	/* set dinc to sdat */
#define	MM_A_DMAX	12	/* set dmax to sdat */
#define	MM_A_SMAX	13	/* set smax to sdat */
#define	MM_A_LGAP	14	/* set lgap to sdat */
#define	MM_A_LEFT	15	/* set left to sdat */
#define	MM_A_SESS	16	/* set sess to sdat */
