#ifndef lint
static	char sccsid[] = "@(#)toolplaces.c 1.8 84/01/25 SMI";
#endif

/*
 * Sun Microsystems, Inc.
 */

/*
 * toolplace.c: Printout positions of all tools on the desktop.
 */

#include <sys/types.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sunwindow/rect.h>
#include <sunwindow/rectlist.h>
#include <sunwindow/cms.h>
#include <sunwindow/win_struct.h>
#include <sunwindow/win_input.h>
#include <sunwindow/win_screen.h>
#include <sunwindow/win_ioctl.h>
#include <suntool/wmgr.h>


main(argc, argv)
	int argc;
	char **argv;
{
	char	name[WIN_NAMESIZE];
	int	toolfd, parentfd, link, iconic;
	struct	rect rect, rectsaved, recttemp;

	/*
	 * Determine parent
	 */
	if (we_getparentwindow(name)) {
		printf("%s not passed parent window in environment\n", name);
		return(0);
	}
	/*
	 * Determine root
	 */
	for (;;) {
		/*
		 * Open parent window
		 */
		if ((parentfd = open(name, O_RDONLY, 0)) < 0) {
			printf("%s (parent) would not open\n", name);
			perror("toolplace");
			return(0);
		}
		/*
		 * Get link
		 */
		link = win_getlink(parentfd, WL_PARENT);
		if (link == WIN_NULLLINK)
			break;
		win_numbertoname(link, name);
		close(parentfd);
	}
	/*
	 * Printout rects of root children.
	 */
	for (link = win_getlink(parentfd, WL_OLDESTCHILD);
	    link != WIN_NULLLINK;) {
		/*
		 * Open tool window
		 */
		win_numbertoname(link, name);
		if ((toolfd = open(name, O_RDONLY, 0)) < 0) {
			printf("%s (tool) would not open\n", name);
			perror("toolplace");
			return(0);
		}
		/*
		 * Get rect data
		 */
		win_getrect(toolfd, &rect);
		win_getsavedrect(toolfd, &rectsaved);
		iconic = (win_getuserflags(toolfd)&WMGR_ICONIC)? 1: 0;
		if (iconic) {
			recttemp = rect;
			rect = rectsaved;
			rectsaved = recttemp;
		}
		printf("toolname	%d %d %d %d	%d %d %d %d	%D\n",
		    rect.r_left, rect.r_top, rect.r_width, rect.r_height,
		    rectsaved.r_left, rectsaved.r_top,
		    rectsaved.r_width, rectsaved.r_height,
		    iconic);
		link = win_getlink(toolfd, WL_YOUNGERSIB);
		close(toolfd);
	}
	close(parentfd);
}
