#ifndef lint
static	char sccsid[] = "@(#)framedemo.c 1.13 84/04/05 SMI";
#endif

/*
 * Sun Microsystems, Inc.
 */

/*
 * 	Overview:	Frame displayer in windows.  Reads in all the
 *			files of form "frame.xxx" in working directory &
 *			displays them like a movie.
 *			See constants below for limits.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/time.h>
#include <pixrect/pixrect.h>
#include <pixrect/pr_util.h>
#include <pixrect/bw1var.h>
#include <pixrect/memvar.h>
#include <sunwindow/rect.h>
#include <sunwindow/rectlist.h>
#include <sunwindow/pixwin.h>
#include <sunwindow/win_input.h>
#include <sunwindow/win_struct.h>
#include <suntool/gfxsw.h>

#define	MAXFRAMES	1000
#define	FRAMEWIDTH	256
#define	FRAMEHEIGHT	256
#define	USEC_INC	50000
#define	SEC_INC		1

static	struct pixrect *mpr[MAXFRAMES];
static	struct timeval timeout = {SEC_INC,USEC_INC}, timeleft;
static	char s[] = "frame.xxx";
static	struct gfxsubwindow *gfx;
static	int frames, framenum, ximage, yimage;
static	struct rect rect;

main(argc, argv)
	int argc;
	char **argv;
{
	int	fd, framedemo_selected();
	struct	inputmask im;

	for (frames = 0; frames < MAXFRAMES; frames++) {
		sprintf(&s[6], "%d", frames + 1);
		fd = open(s, O_RDONLY, 0);
		if (fd == -1) {
			break;
		}
		mpr[frames] = mem_create(FRAMEWIDTH, FRAMEHEIGHT, 1);
		read(fd, mpr_d(mpr[frames])->md_image,
		    FRAMEWIDTH*FRAMEHEIGHT/8);
		close(fd);
		}
	if (frames == 0) {
	    printf("Couldn't find any 'frame.xx' files in working directory\n");
	    return;
	}
	/*
	 * Initialize gfxsw
	 */
	gfx = gfxsw_init(0, argv);
	if (gfx == (struct gfxsubwindow *)0)
		exit(1);
	/*
	 * Set up input mask
	 */
	input_imnull(&im);
	im.im_flags |= IM_ASCII;
	gfxsw_setinputmask(gfx, &im, &im, WIN_NULLLINK, 0, 1);
	/*
	 * Main loop
	 */
	framedemo_nextframe(1);
	timeleft = timeout;
	gfxsw_select(gfx, framedemo_selected, 0, 0, 0, &timeleft);
	/*
	 * Cleanup
	 */
	gfxsw_done(gfx);
}

framedemo_selected(gfx, ibits, obits, ebits, timer)
	struct	gfxsubwindow *gfx;
	int	*ibits, *obits, *ebits;
	struct	timeval **timer;
{
	if ((*timer && ((*timer)->tv_sec == 0) && ((*timer)->tv_usec == 0)) ||
	    (gfx->gfx_flags & GFX_RESTART)) {
		/*
		 * Our timer expired or restart is true so show next frame
		 */
		if (gfx->gfx_reps)
			framedemo_nextframe(0);
		else
			gfxsw_selectdone(gfx);
	}
	if (*ibits & (1 << gfx->gfx_windowfd)) {
		struct	inputevent event;

		/*
		 * Read input from window
		 */
		if (input_readevent(gfx->gfx_windowfd, &event)) {
			perror("framedemo");
			return;
		}
		switch (event.ie_code) {
		case 'f': /* faster usec timeout */
			if (timeout.tv_usec >= USEC_INC)
				timeout.tv_usec -= USEC_INC;
			else {
				if (timeout.tv_sec >= SEC_INC) {
					timeout.tv_sec -= SEC_INC;
					timeout.tv_usec = 1000000-USEC_INC;
				}
			}
			break;
		case 's': /* slower usec timeout */
			if (timeout.tv_usec < 1000000-USEC_INC)
				timeout.tv_usec += USEC_INC;
			else {
				timeout.tv_usec = 0;
				timeout.tv_sec += 1;
			}
			break;
		case 'F': /* faster sec timeout */
			if (timeout.tv_sec >= SEC_INC)
				timeout.tv_sec -= SEC_INC;
			break;
		case 'S': /* slower sec timeout */
			timeout.tv_sec += SEC_INC;
			break;
		case '?': /* Help */
			printf("'s' slower usec timeout\n'f' faster usec timeout\n'S' slower sec timeout\n'F' faster sec timeout\n");
			/*
			 * Don't reset timeout
			 */
			return;
		default:
			gfxsw_inputinterrupts(gfx, &event);
		}
	}
	*ibits = *obits = *ebits = 0;
	timeleft = timeout;
	*timer = &timeleft;
}

framedemo_nextframe(firsttime)
	int	firsttime;
{
	int	restarting = gfx->gfx_flags&GFX_RESTART;

	if (firsttime || restarting) {
		gfx->gfx_flags &= ~GFX_RESTART;
		win_getsize(gfx->gfx_windowfd, &rect);
		ximage = rect.r_width/2-FRAMEWIDTH/2;
		yimage = rect.r_height/2-FRAMEHEIGHT/2;
		pw_writebackground(gfx->gfx_pixwin, 0, 0,
		    rect.r_width, rect.r_height, PIX_CLR);
	}
	if (framenum >= frames) {
		framenum = 0;
		gfx->gfx_reps--;
	}
	pw_write(gfx->gfx_pixwin, ximage, yimage, FRAMEWIDTH, FRAMEHEIGHT,
	    PIX_SRC, mpr[framenum], 0, 0);
	if (!restarting)
		framenum++;
}
