/*	@(#)cpu.h 4.15 83/08/16 SMI	*/

/*
 * Copyright (c) 1983 by Sun Microsystems, Inc.
 */

#ifndef LOCORE
#include "../mon/sunromvec.h"
#endif

#define	SUN_1		1
#define	SUN_2		2

#define	SUN_MAX		2

#ifndef LOCORE
#ifdef KERNEL
int	cpu;
#endif
#endif

#ifndef LOCORE
/*
 * The context structure is used to allocate
 * contexts and maintains the pmeg allocation
 * information for the context.
 */

struct	context {
	int	ctx_time;		/* pseudo-time for ctx lru */
	u_short	ctx_context;		/* bits to load into context register */
	short	ctx_tdmax;		/* max text or data seg used */
	short	ctx_smin;		/* min stack segment used */
	struct	proc *ctx_procp;	/* back pointer to proc structure */
	u_char	ctx_pmeg[NSEGMAP];	/* pmeg allocation for this context */
};

#ifdef KERNEL
extern	struct context context[];
#endif

#define	CSEG	(NSEGMAP-1)	/* segment for manipulation of contexts */

/*
 * The pmeg structure allocates the
 * hardware page map entry groups.
 */
struct	pmeg {
	struct	pmeg *pm_forw;		/* forward link */
	struct	pmeg *pm_back;		/* backward link */
	struct	proc *pm_procp; 	/* back pointer to proc using */
	struct	pte *pm_pte;		/* pointer to pte's mapping */
	short	pm_seg;			/* seg within process address space */
	short	pm_count;		/* number of valid pte's in group */
};

#ifdef KERNEL
extern	struct pmeg pmeg[];
extern	struct pmeg pmeghead;
extern	int kernpmeg;
#endif
#endif !LOCORE
