#ifndef lint
static	char sccsid[] = "@(#)shelltool.c 1.14 84/03/06 SMI";
#endif

/*
 * Sun Microsystems, Inc.
 */

/*
 * 	Overview:	Shell Tool: A shell subwindow (graphics
 *			programs are set up to run in same window).
 */

#include <suntool/tool_hs.h>
#include <suntool/ttysw.h>
#include <stdio.h>

#include "shelltool.icon"
mpr_static(shellic_mpr, 64, 64, 1, icon_data);

static	struct icon icon = {64, 64, (struct pixrect *)NULL, 0, 0, 64, 64,
	    &shellic_mpr, 0, 0, 0, 0, (char *)NULL, (struct pixfont *)NULL,
	    ICON_BKGRDGRY};

static	sigwinchcatcher(), sigchldcatcher();

static	struct tool *tool;

static	char *normalname = "Shell Tool 1.1";
static	char *consolename = "Shell Tool (CONSOLE) 1.1";

shelltool_main(argc, argv)
	int argc;
	char **argv;
{
	char	*toolname = normalname;
	struct	toolsw *ttysw;
	int	becomeconsole = 0;

	if ((*(argv+1)) && (strcmp(*(argv+1), "CONSOLE") == 0)) {
		extern	struct pixfont *pf_sys;
		extern	struct pixfont *pw_pfsysopen();

		becomeconsole = 1;
		/*
		 * Set tool strings to say "CONSOLE"
		 */
		(void) pw_pfsysopen();
		icon.ic_text = "CONSOLE";
		icon.ic_font = pf_sys;
		rect_construct(&icon.ic_textrect,
		    0, icon.ic_height-pf_sys->pf_defaultsize.y,
		    icon.ic_width, pf_sys->pf_defaultsize.y);
		toolname = consolename;
	}
	/*
	 * Create tool window
	 */
	tool = tool_create(toolname, TOOL_NAMESTRIPE, (struct rect *)0, &icon);
	if (tool == (struct tool *)NULL)
		exit(1);
	/*
	 * Create tty subwindow
	 */
	ttysw = ttysw_createtoolsubwindow(tool, "ttysw", TOOL_SWEXTENDTOEDGE,
	    TOOL_SWEXTENDTOEDGE);
	if (ttysw == (struct toolsw *)NULL)
		exit(1);
	/*
	 * Install tool in tree of windows
	 */
	signal(SIGWINCH, sigwinchcatcher);
	tool_install(tool);
	/*
	 * Start tty process
	 */
	signal(SIGCHLD, sigchldcatcher);
	if (becomeconsole) {
		ttysw_becomeconsole((struct ttyswubwindow *)ttysw->ts_data);
		/*
		 * Don't pass "CONSOLE" argument to ttysw_fork
		 */
		++argv;
	}
	if (ttysw_fork((struct ttyswubwindow *)ttysw->ts_data, ++argv,
	    &ttysw->ts_io.tio_inputmask,
	    &ttysw->ts_io.tio_outputmask,
	    &ttysw->ts_io.tio_exceptmask) == -1) {
		perror("shelltool");
		exit(1);
	}
	/*
	 * Handle input
	 */
	tool_select(tool, 1 /* means wait for child process to die*/);
	/*
	 * Cleanup
	 */
	tool_destroy(tool);
	exit(0);
}

static
sigchldcatcher()
{
	tool_sigchld(tool);
}

static
sigwinchcatcher()
{
	tool_sigwinch(tool);
}

