#ifndef lint 
static	char sccsid[] = "@(#)gfxtool.c 1.13 84/04/04 SMI";
#endif

#include <suntool/tool_hs.h>	
#include <suntool/emptysw.h>	
#include <suntool/ttysw.h>
#include <stdio.h>    /* Source of NULL */


/* define global data */
#include "gfxtool.icon"
mpr_static(gfxic_mpr, 64, 64, 1, icon_data);	
static	struct icon icon = {64, 64, (struct pixrect *)NULL, 0, 0, 64, 64,
	    &gfxic_mpr, 0, 0, 0, 0, (char *)NULL, (struct pixfont *)NULL,
	    ICON_BKGRDGRY};	

static	sigwinchcatcher(), sigchldcatcher();	
static	struct tool *tool;	

gfxtool_main(argc, argv)		
	int argc;	
	char **argv;		
{
 
/* declare local variables */
	char	*toolname = "Graphics Tool 1.1";	
	struct	toolsw *ttysw, *emptysw;	
	char	name[WIN_NAMESIZE];	

	/* create tool */	
	tool = tool_create(toolname, TOOL_NAMESTRIPE|TOOL_BOUNDARYMGR,
	    (struct rect *)NULL, &icon);	
	if (tool == (struct tool *)NULL)	
		exit(1);	

	/* create subwindows */
	ttysw = ttysw_createtoolsubwindow(tool, "ttysw",	
	    TOOL_SWEXTENDTOEDGE, 200);	

	emptysw = esw_createtoolsubwindow(tool, "emptysw",	
	    TOOL_SWEXTENDTOEDGE, TOOL_SWEXTENDTOEDGE);	
	if (ttysw == (struct toolsw *)NULL ||	
	    emptysw == (struct toolsw *)NULL)	
		exit(1);	

	/* install the tool */
	signal(SIGWINCH, sigwinchcatcher);	
	tool_install(tool);	

	/* start child process */
	win_fdtoname(emptysw->ts_windowfd, name);	
	we_setgfxwindow(name);	
	signal(SIGCHLD, sigchldcatcher);	
	if (ttysw_fork(ttysw->ts_data, ++argv,	
	    &ttysw->ts_io.tio_inputmask,	
	    &ttysw->ts_io.tio_outputmask,	
	    &ttysw->ts_io.tio_exceptmask) == -1) {	
		perror("gfxtool");	
		exit(1);	
	}

	/* notification loop */
	tool_select(tool, 1 /* means wait for child process to die*/);	
 
	/* clean up */
	tool_destroy(tool);	
	exit(0);		
}

static sigchldcatcher() { tool_sigchld(tool); }	

static sigwinchcatcher() { tool_sigwinch(tool); }	

