/*	@(#)win_cursor.h 1.2 83/08/25 SMI	*/

/*
 * Copyright (c) 1983 by Sun Microsystems, Inc.
 */

/*
 * Mouse cursor shape interface.
 *
 * The kernel tracks the mouse cursor and displays a different shape
 * depending on which window the cursor is directly over.
 *
 * The hot spot on the cursor is the offset of the mouse position from
 * the upper left hand corner of the cur_shape.
 *
 * The function is the operation used to put the cursor on the screen.
 * It is the value of a boolean expression of PIX_SRC and PIX_DEST
 * (see pixrect.h).
 *
 * The image is always a memory pixrect in order to facilitate exchange
 * of image data between the kernel and user processes.  It is a struct
 * pixrect (not a pointer to a pixrect) because cursor images are
 * typically static.
 */

/*
 * In practice, for now, the kernel only supports a limited size
 * cur_shape.pr_data->md_image.  The following constants are the maximun number
 * of bytes and words that cur_shape.pr_data->md_image can have.
 */
#define CUR_MAXIMAGEBYTES	32
#define CUR_MAXIMAGEWORDS	16

struct cursor {
	short	cur_xhot, cur_yhot;	/* offset of mouse position from shape*/
	int	cur_function;		/* relationship of shape to screen */
	struct	pixrect *cur_shape;	/* memory image to use */
};

