/*	@(#)tool.h 1.6 83/09/28 SMI	*/

/*
 * Copyright (c) 1983 by Sun Microsystems, Inc.
 */

/*
 * A tool is a stylized window that is used as the conceptual entity
 * that glues subwindows together into a functional package.
 * It is usually a child of the root window, has a name stripe at its top,
 * is responsible for providing borders around its subwindows
 * and displays as an icon when a bit is set in the tool windows user flags.
 *
 * A tool will arrange its subwindows in a tiled configuration whenever
 * its own size changes.  It can also provide a subwindow boundary adjustment
 * interface.
 *
 * The default tool window manager positions iconic tools on byte and n%4 line
 * boundaries so that if you include desktop gray in your icon image
 * the patterns will match.  A default icon is used if none is specified.
 *
 * A typical programs sequence:
 * 1) tool_create returns tool struct after creating a window and
 *  fills in tl_name, tl_flags, tl_windowfd, and tl_pixwin. 
 * 2) foo_createtoolsubwindow is called to create each "foo" type of subwindow.
 *  The subwindows are created in a left to right and top to bottom sequence
 *  which gives the tool's layout mechanism a chance to do reasonable default
 *  positioning given the passed in width and height.
 * 3) tool_select is called to do select system calls for all the windows.
 *  The ts_io.tio_selected routine is called when a subwindow is "selected".
 * 6) tool_sigwinch is called when a SIGWINCH is received.
 *  tool_select calls * tl_io.tio_handlesigwinch later.
 *  The default implementation of tl_io.tio_handlesigwinch will resize
 *  the subwindows on a tool size change,
 *  calls each ts_io.tio_handlesigwinch and fixes its own damage.
 * 7) tool_destroy called before exiting process.
 */

/*
 * Definitions of "standard" tool icon graphics/text size/proportions
 */
struct	toolio {
	int	tio_inputmask,	/* Additional fd to select on in tool_select */
		tio_outputmask,	/* (See select system call documentation) */
		tio_exceptmask;
	struct	timeval	*tio_timer; /* Timeout used in tool_select */
	int	(*tio_handlesigwinch)();/* call when win should repair image */
	int	(*tio_selected)();      /* call from tool_select */
};

struct	tool {
	short	tl_flags;	/* tool booleans */
#define	TOOL_NAMESTRIPE		(0x01)	/* include a name stripe */
#define	TOOL_BOUNDARYMGR	(0x02)	/* movable borders between subwindows */
#define	TOOL_ICONIC		(0x04)	/* current state is iconic */
#define	TOOL_SIGCHLD		(0x08)	/* info passed to tool_select */
#define	TOOL_SIGWINCHPENDING	(0x10)	/* need to call tool_handlesigwinch*/
#define	TOOL_DONE		(0x20)	/* need to return from tool_select */
	int	tl_windowfd;	/* file descriptor of tool window */
	char	*tl_name;	/* string in name stripe & default icon */
	struct	icon *tl_icon;	/* icon */
	struct	toolio tl_io;	/* Tool_select and signal handling */
	struct	toolsw *tl_sw;	/* list of subwindows that tool is managing */
	struct	pixwin *tl_pixwin; /* display mechanism structure */
	struct	rect tl_rectcache; /* rect of tool (tool relative) */
};

struct	toolsw {
	struct	toolsw *ts_next;/* next subwindow */
	int	ts_windowfd;	/* file descriptor of subwindow */
	char	*ts_name;	/* identifies subwindow (for future use) */
	short	ts_width;	/* width at which sw wants to be maintained */
	short	ts_height;	/* height at which sw wants to be maintained */
#define	TOOL_SWEXTENDTOEDGE	-1 /* extend width|height to edge of tool */
	struct	toolio ts_io;	/* Tool_select and signal handling */
	int	(*ts_destroy)();/* call when removing subwindow */
	caddr_t	ts_data; 	/* uninterpreted data passed to functions */
};

/*
 * Standard (but not enforced) constant values
 */
#define	TOOL_BORDERWIDTH	(5)
#define	TOOL_SUBWINDOWSPACING	(TOOL_BORDERWIDTH)
#define	TOOL_NAMESTRIPEXTR	(0)
#define	TOOL_ICONHEIGHT		(64)
#define	TOOL_ICONWIDTH		(64)
#define	TOOL_ICONHEIGHT		(64)
#define	TOOL_ICONMARGIN		(2)

#define	TOOL_ICONIMAGEWIDTH	((TOOL_ICONWIDTH)-2*(TOOL_ICONMARGIN))
#define	TOOL_ICONIMAGEHEIGHT	((TOOL_ICONHEIGHT)-2*(TOOL_ICONMARGIN))
#define	TOOL_ICONIMAGELEFT	(TOOL_ICONMARGIN)
#define	TOOL_ICONIMAGETOP	(TOOL_ICONMARGIN)

#define	TOOL_ICONTEXTWIDTH	(TOOL_ICONIMAGEWIDTH)
#define	TOOL_ICONTEXTHEIGHT	((TOOL_ICONHEIGHT)-(TOOL_ICONHEIGHT)/4)
#define	TOOL_ICONTEXTLEFT	(TOOL_ICONIMAGELEFT)
#define	TOOL_ICONTEXTTOP \
	((TOOL_ICONHEIGHT)-((TOOL_ICONTEXTHEIGHT)+(TOOL_ICONMARGIN)))

#define	tool_install(tool)	win_insert((tool)->tl_windowfd)

extern	struct tool *tool_create();
extern	struct toolsw *tool_createsubwindow();
extern	short tool_stripeheight(), tool_borderwidth(), tool_subwindowspacing();	
extern	struct pixrect *tool_bkgrd;

#ifdef	cplus
/*
 * C Library routines specifically related to tool functions.
 */

/*
 * Simple/common tool operations.
 */
struct	tool *tool_create(char *name, short flags, struct rect *rect,
	    struct icon *icon);
struct	toolsw *tool_createsubwindow(struct tool *tool, char *name,
	    short width, height);

/*
 * Cleanup routines
 */
void	tool_destroysubwindow(struct tool *tool, struct toolsw *toolsw);
void	tool_destroy(struct tool *tool);

/*
 * Subwindow layout utilities.
 */
short	tool_stripeheight(struct tool *tool);
short	tool_borderwidth(struct tool *tool);
short	tool_subwindowspacing(struct tool *tool);

/*
 * Input & display functions.
 */
void	tool_select(struct tool *tool, int waitprocessesdie);
void	tool_sigchld(struct tool *tool);
void	tool_done(struct tool *tool);
void	tool_sigwinch(struct tool *tool);
void	tool_display(struct tool *tool);
void	tool_handlesigwinchstd(struct tool *tool);
void	tool_selectedstd(struct tool *tool,
	    int *inputbits, *outputbits, *exceptbits, struct timeval *timer);

/*
 * Replacable operations calling sequence.
 */
void	tio_selected(caddr_t ts_data, int *inputbits, *outputbits, *exceptbits,
	    struct timeval *timer);
void	tio_handlesigwinch(caddr_t ts_data);
void	ts_destroy(caddr_t ts_data);
#endif

