/* @(#) callout.h 1.2@(#) Solbourne id 1/11/94 19:13:27 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*	@(#)callout.h 2.6 88/08/19 SMI; from UCB 4.6 81/04/18	*/

/*
 * The callout structure is for a routine arranging to be called
 * by the clock interrupt (clock.c) with a specified argument,
 * in a specified amount of time.
 * Used, for example, to time tab delays on typewriters.
 */

#ifndef _sys_callout_h
#define _sys_callout_h

struct	callout {
	int	c_time;		/* incremental time */
	caddr_t	c_arg;		/* argument to routine */
	int	(*c_func)();	/* routine */
	struct	callout *c_next;
#ifdef	solbourne
	caddr_t	c_lock;		/* pointer to lock needed (slock_t) */
#endif	solbourne
};
#ifdef KERNEL
struct	callout *callfree, *callout, calltodo;
#ifdef	solbourne
/*
 * timeouts being serviced are chained here while waiting for lock to avoid 
 * a race (we don't want to run the routine after it has been untimeout'd).
 */
struct	callout callwaiting;
#endif	solbourne
int	ncallout;
#endif

#endif /*!_sys_callout_h*/
