/* @(#) psl.h 1.1@(#) Solbourne id 9/22/93 00:18:54 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*	@(#)psl.h 1.2 91/11/22 SMI	*/

/*
 * Copyright (c) 1986 by Sun Microsystems, Inc.
 */

#ifndef _sparc_psl_h
#define _sparc_psl_h

/*
 * Definition of bits in the Sun-4 PSR (Processor Status Register)
 *  ________________________________________________________________________
 * | IMPL | VER |      ICC      | resvd | EC | EF | PIL | S | PS | ET | CWP |
 * |      |     | N | Z | V | C |       |    |    |     |   |    |    |     |
 * |------|-----|---|---|---|---|-------|----|----|-----|---|----|----|-----|
 *  31  28 27 24  23  22  21  20 19   14  13   12  11  8   7   6    5  4   0
 *
 * Reserved bits are defined to be initialized to zero and must
 * be preserved if written, for compatibility with future revisions.
 */

#define PSR_CWP		0x0000001F	/* current window pointer */
#define PSR_ET		0x00000020	/* enable traps */
#define PSR_PS		0x00000040	/* previous supervisor mode */
#define PSR_S		0x00000080	/* supervisor mode */
#define PSR_PIL		0x00000F00	/* processor interrupt level */
#define PSR_EF		0x00001000	/* enable floating point unit */
#define PSR_EC		0x00002000	/* enable coprocessor */
#define PSR_RSV		0x000FC000	/* reserved */
#define PSR_ICC		0x00F00000	/* integer condition codes */
#define PSR_C		0x00100000	/* carry bit */
#define PSR_V		0x00200000	/* overflow bit */
#define PSR_Z		0x00400000	/* zero bit */
#define PSR_N		0x00800000	/* negative bit */
#define PSR_VER		0x0F000000	/* mask version */
#define PSR_IMPL	0xF0000000	/* implementation */

#define PSL_ALLCC	PSR_ICC		/* for portability */
#define SR_SMODE	PSR_PS

/*
 * Handy psr values.
 */
#define PSL_USER	(PSR_S)		/* initial user psr */
#define PSL_USERMASK	(PSR_ICC)	/* user variable psr bits */
#define PSR_PIL1	0x100		/* for rounding up interrupt pri */

/*
 * Macros to decode psr.
 */
#define USERMODE(ps)	(((ps) & PSR_PS) == 0)
#ifdef	solbourne
# ifdef kbus
#  include <machine/sic.h>
#  define BASEPRI(ipr)	(((ipr) & IPR_MASK) == 0)
# endif	/* kbus */
# if defined(S4000)
#  define BASEPRI(ps)	(((ps) & PSR_PIL) == 0)
# endif	/* defined(S4000) */
#else	solbourne
# define BASEPRI(ps)	(((ps) & PSR_PIL) == 0)
#endif	solbourne

/*
 * Convert system interrupt priorities (0-7) into a psr for splx.
 * pritospl() should be a table lookup for systems with a serial
 * interrupt controller that maps PIL levels 0-7 into SIC levels 0-255
 */

#ifdef	solbourne
# ifdef kbus
/* On solbourne kbus machines pri==ipl and spl==sic level */
#  ifndef LOCORE
extern unsigned char spl_xlate[];
#  endif !LOCORE
#  define pritospl(n)	(int)(spl_xlate[(n)] & 0xff)
# endif	/* kbus */
# if defined(S4000)
#   define pritospl(n)	((n) << 9)
# endif	/* S4000 */
#else	solbourne
# define pritospl(n)	((n) << 9)
#endif	solbourne

/*
 * Convert a hardware interrupt priority level (0-15) into a psr for splx.
 * Also are macros to convert back.
 */
#ifdef	solbourne
#ifdef kbus
#ifndef LOCORE
extern unsigned char ipl_xlate[];
#endif !LOCORE
#define ipltospl(n)	pritospl(n)
#define spltoipl(n)	(((n) == 0) ? 0 : (int)ipl_xlate[((n)-INTBASE)])
#define spltopri(n)	spltoipl(n)
#endif	/* kbus */
#if defined(S4000)
#define ipltospl(n)	(((n) & 0xf) << 8)
#define spltoipl(n)	(((n) >> 8) & 0xf)
#define spltopri(n)	((((n) + (1 << 8)) >> 9) & 0xf)
#define intrtospl(n)	((n + 1) << 8)
#endif	/* defined(S4000) */
#else	solbourne
#define ipltospl(n)	(((n) & 0xf) << 8)
#define spltoipl(n)	(((n) >> 8) & 0xf)
#define spltopri(n)	((((n) + (1 << 8)) >> 9) & 0xf)
#endif	solbourne

#endif /*!_sparc_psl_h*/
