#ifndef lint
static char *Solbourne_id =
"@(#) init_sysent.c 1.1@(#) Solbourne id 9/21/93 23:32:50\n";
#endif
/*
 * Copyright 1990 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*	@(#)init_sysent.c 2.64 89/10/04 SMI; from UCB 6.1 83/08/17	*/

/*
 * System call switch table.
 */

#include <sys/param.h>
#include <sys/systm.h>
#ifdef SYSAUDIT
/*
 * This header file includes many defines which change function names
 * that are used in this file. For example, "open" becomes "au_open",
 * thus initializing the table value to "au_open", while what appears
 * here is "open". This will not happen if the SYSAUDIT option is not
 * used.
 */
#include <sys/init_audit.h>
#endif SYSAUDIT

#include <smpdefs.h>

int	nosys();
int	nullsys();
int	errsys();

/* 1.1 processes and protection */
int	gethostid(),sethostname(),gethostname(),getpid();
int	setdomainname(),getdomainname();
int	fork(),rexit(),execv(),execve(),wait4();
int	getuid(),setreuid(),getgid(),getgroups(),setregid(),setgroups();
int	getpgrp(),setpgrp();
int	sys_setsid(), setpgid();
int	uname();

/* 1.2 memory management */
int	brk(),sbrk(),sstk();
int	getpagesize(),smmap(),mctl(),munmap(),mprotect(),mincore();
int	omsync(),omadvise();

/* 1.3 signals */
int	sigvec(),sigblock(),sigsetmask(),sigpause(),sigstack(),sigcleanup();
int	kill(), killpg(), sigpending();

/* 1.4 timing and statistics */
int	gettimeofday(),settimeofday();
int	adjtime();
int	getitimer(),setitimer();

/* 1.5 descriptors */
int	getdtablesize(),dup(),dup2(),close();
int	select(),getdopt(),setdopt(),fcntl(),flock();

/* 1.6 resource controls */
int	getpriority(),setpriority(),getrusage(),getrlimit(),setrlimit();
#ifdef QUOTA
int	oldquota(), quotactl();
#else
#define	oldquota nullsys	/* for backward compatability with old login */
#endif QUOTA
#ifdef RT_SCHEDULE
int	rtschedule();
#endif RT_SCHEDULE

/* 1.7 system operation support */
int	mount(),unmount(),swapon();
int	sync(),reboot();
#ifdef SYSACCT
int	sysacct();
#endif SYSACCT
#ifdef SYSAUDIT
int	auditsys();
#endif SYSAUDIT

/* 2.1 generic operations */
int	read(),write(),readv(),writev(),ioctl();

/* 2.1.1 asynch operations */
#ifdef ASYNCHIO
int	aioread(), aiowrite(), aiowait(), aiocancel();
#endif ASYNCHIO

/* 2.2 file system */
int	chdir(),chroot();
int	fchdir(),fchroot();
int	mkdir(),rmdir(),getdirentries(), getdents();
int	creat(),open(),mknod(),unlink(),stat(),fstat(),lstat();
int	chown(),fchown(),chmod(),fchmod(),utimes();
int	link(),symlink(),readlink(),rename();
int	lseek(),truncate(),ftruncate(),access(),fsync();
int	statfs(),fstatfs();

/* 2.3 communications */
int	socket(),bind(),listen(),accept(),connect();
int	socketpair(),sendto(),send(),recvfrom(),recv();
int	sendmsg(),recvmsg(),shutdown(),setsockopt(),getsockopt();
int	getsockname(),getpeername(),pipe();

int	umask();		/* XXX */

/* 2.3.1 SystemV-compatible IPC */
#ifdef IPCSEMAPHORE
int	semsys();
#endif
#ifdef IPCMESSAGE
int	msgsys();
#endif
#ifdef IPCSHMEM
int	shmsys();
#endif

/* 2.4 processes */
int	ptrace();

/* 2.5 terminals */

#ifdef COMPAT
/* emulations for backwards compatibility */
#define	compat(n, name)	n, SYSC_SERIAL, o/**/name

int	otime();		/* now use gettimeofday */
int	ostime();		/* now use settimeofday */
int	oalarm();		/* now use setitimer */
int	outime();		/* now use utimes */
int	opause();		/* now use sigpause */
int	onice();		/* now use setpriority,getpriority */
int	oftime();		/* now use gettimeofday */
int	osetpgrp();		/* ??? */
int	otimes();		/* now use getrusage */
int	ossig();		/* now use sigvec, etc */
int	ovlimit();		/* now use setrlimit,getrlimit */
int	ovtimes();		/* now use getrusage */
int	osetuid();		/* now use setreuid */
int	osetgid();		/* now use setregid */
int	ostat();		/* now use stat */
int	ofstat();		/* now use fstat */
#else
#define	compat(n, name)	0, SYSC_PARALLEL, nosys
#endif

/* BEGIN JUNK */
#ifdef vax
int	resuba();
#endif vax
int	profil();		/* 'cuz sys calls are interruptible */
int	vhangup();		/* should just do in exit() */
int	vfork();		/* XXX - was awaiting fork w/ copy on write */
int	ovadvise();		/* awaiting new madvise */
int	indir();		/* indirect system call */
int	ustat();		/* System V compatibility */
int	owait();		/* should use wait4 interface */
#ifdef sparc
int	owait3();		/* should use wait4 interface */
#endif sparc
#ifdef	UFS
int	umount();		/* still more Sys V (and 4.2?) compatibility */
#endif
int	pathconf();		/* posix */
int	fpathconf();		/* posix */
int	sysconf();		/* posix */

#ifdef DEBUG
int debug();
#endif
/* END JUNK */

#ifdef	TRACE
int	vtrace();		/* kernel event tracing */
#endif	TRACE

#ifdef	TESTECC
int	testecc();		/* Test ecc error handling */
#endif

#ifdef NFSCLIENT
/* nfs */
int	async_daemon();		/* client async daemon */
#endif
#ifdef NFSSERVER

#ifdef ENFS
int	enfs_svc();		/* run nfs server */
#else ENFS
int	nfs_svc();		/* run nfs server */
#endif ENFS

int	nfs_getfh();		/* get file handle */
int	exportfs();		/* export file systems */
#endif

#ifdef RFS
int  	rfssys();		/* RFS-related calls */
#endif

int	getmsg();
int	putmsg();
int	poll();

#ifdef VPIX
int	vpixsys();		/* VP/ix system calls */
#endif

/* Start of Solbourne specific system call switch definitions ... */
#ifdef	solbourne
int	getcpustatus();		/* get enabled/disabled status for cpus */
int	setcpustatus();		/* set enabled/disabled status for cpus */

int	user_sleep_and_unlock();/* parallel programming constructs */
int	user_wakeup();
#ifdef	SMP_TEST
int	user_sync_info();
int	user_sync_reset();
int	user_sync_sleep();
int	user_sync_wakeup();
int	user_sync();
int	bind_mode();
int	bind_process();
#endif	SMP_TEST
#endif	solbourne

struct sysent sysent[] = {
	1, SYSC_SERIAL, indir,		/*   0 = indir */
	1, SYSC_PARALLEL, rexit,	/*   1 = exit */
#if NCPUS > 1
	0, SYSC_PARALLEL, fork,		/*   2 = fork */
#else
	0, SYSC_SERIAL, fork,		/*   2 = fork */
#endif
	3, SYSC_PARALLEL, read,		/*   3 = read */
	3, SYSC_PARALLEL, write,	/*   4 = write */
	3, SYSC_SERIAL, open,		/*   5 = open */
	1, SYSC_PARALLEL, close,	/*   6 = close */
	4, SYSC_PARALLEL, wait4,	/*   7 = wait4 */
	2, SYSC_SERIAL, creat,		/*   8 = creat */
	2, SYSC_SERIAL, link,		/*   9 = link */
	1, SYSC_SERIAL, unlink,		/*  10 = unlink */
	2, SYSC_SERIAL, execv,		/*  11 = execv */
	1, SYSC_SERIAL, chdir,		/*  12 = chdir */
	compat(0,time),			/*  13 = old time */
	3, SYSC_SERIAL, mknod,		/*  14 = mknod */
	2, SYSC_SERIAL, chmod,		/*  15 = chmod */
	3, SYSC_SERIAL, chown,		/*  16 = chown; now 3 args */
	1, SYSC_SERIAL, brk,		/*  17 = brk */
	compat(2,stat),			/*  18 = old stat */
#if NCPUS > 1
	3, SYSC_PARALLEL, lseek,	/*  19 = lseek */
#else
	3, SYSC_SERIAL, lseek,		/*  19 = lseek */
#endif
	0, SYSC_PARALLEL, getpid,	/*  20 = getpid */
	0, SYSC_PARALLEL, nosys,	/*  21 = old mount */
#ifdef	UFS
	1, SYSC_SERIAL, umount,		/*  22 = old umount */
#else
	0, SYSC_PARALLEL, nosys,	/*  22 = old umount */
#endif
	compat(1,setuid),		/*  23 = old setuid */
	0, SYSC_PARALLEL, getuid,	/*  24 = getuid */
	compat(1,stime),		/*  25 = old stime */
	5, SYSC_SERIAL, ptrace,		/*  26 = ptrace */
	compat(1,alarm),		/*  27 = old alarm */
	compat(2,fstat),		/*  28 = old fstat */
	compat(0,pause),		/*  29 = opause */
	compat(2,utime),		/*  30 = old utime */
	0, SYSC_PARALLEL, nosys,	/*  31 = was stty */
	0, SYSC_PARALLEL, nosys,	/*  32 = was gtty */
	2, SYSC_SERIAL, access,		/*  33 = access */
	compat(1,nice),			/*  34 = old nice */
	compat(1,ftime),		/*  35 = old ftime */
	0, SYSC_SERIAL, sync,		/*  36 = sync */
	2, SYSC_SERIAL, kill,		/*  37 = kill */
	2, SYSC_SERIAL, stat,		/*  38 = stat */
	compat(2,setpgrp),		/*  39 = old setpgrp */
	2, SYSC_SERIAL, lstat,		/*  40 = lstat */
	2, SYSC_PARALLEL, dup,		/*  41 = dup */
	0, SYSC_PARALLEL, pipe,		/*  42 = pipe */
	compat(1,times),		/*  43 = old times */
	4, SYSC_PARALLEL, profil,	/*  44 = profil */
	0, SYSC_PARALLEL, nosys,	/*  45 = nosys */
	compat(1,setgid),		/*  46 = old setgid */
	0, SYSC_PARALLEL, getgid,	/*  47 = getgid */
	compat(2,ssig),			/*  48 = old sig */
	0, SYSC_PARALLEL, nosys,	/*  49 = reserved for USG */
	0, SYSC_PARALLEL, nosys,	/*  50 = reserved for USG */
#ifdef SYSACCT
	1, SYSC_SERIAL, sysacct,	/*  51 = turn acct off/on */
#else
	0, SYSC_PARALLEL, errsys,	/*  51 = not configured */
#endif SYSACCT
	0, SYSC_PARALLEL, nosys,	/*  52 = old set phys addr */
	4, SYSC_SERIAL, mctl,		/*  53 = memory control */
	3, SYSC_PARALLEL, ioctl,	/*  54 = ioctl */
	2, SYSC_SERIAL, reboot,		/*  55 = reboot */
#ifdef sparc
	3, SYSC_PARALLEL, owait3,	/*  56 = wait3 */
#else
	0, SYSC_PARALLEL, nosys,	/*  56 = old mpxchan */
#endif sparc
	2, SYSC_SERIAL, symlink,	/*  57 = symlink */
	3, SYSC_SERIAL, readlink,	/*  58 = readlink */
	3, SYSC_SERIAL, execve,		/*  59 = execve */
	1, SYSC_PARALLEL, umask,	/*  60 = umask */
	1, SYSC_SERIAL, chroot,		/*  61 = chroot */
	2, SYSC_PARALLEL, fstat,	/*  62 = fstat */
	0, SYSC_PARALLEL, nosys,	/*  63 = used internally */
	1, SYSC_PARALLEL, getpagesize,	/*  64 = getpagesize */
	3, SYSC_SERIAL, omsync,		/*  65 = old msync */
#if NCPUS > 1
	0, SYSC_PARALLEL, vfork,	/*  66 = vfork */
#else
	0, SYSC_SERIAL, vfork,		/*  66 = vfork */
#endif
	0, SYSC_SERIAL, read,		/*  67 = old vread */
	0, SYSC_SERIAL, write,		/*  68 = old vwrite */
	1, SYSC_SERIAL, sbrk,		/*  69 = sbrk */
	1, SYSC_SERIAL, sstk,		/*  70 = sstk */
	6, SYSC_SERIAL, smmap,		/*  71 = mmap */
	1, SYSC_SERIAL, ovadvise,	/*  72 = old vadvise */
	2, SYSC_SERIAL, munmap,		/*  73 = munmap */
	3, SYSC_SERIAL, mprotect,	/*  74 = mprotect */
	3, SYSC_SERIAL, omadvise,	/*  75 = old madvise */
	1, SYSC_SERIAL, vhangup,	/*  76 = vhangup */
	compat(2,vlimit),		/*  77 = old vlimit */
	3, SYSC_SERIAL, mincore,	/*  78 = mincore */
	2, SYSC_PARALLEL, getgroups,	/*  79 = getgroups */
	2, SYSC_SERIAL, setgroups,	/*  80 = setgroups */
	1, SYSC_SERIAL, getpgrp,	/*  81 = getpgrp */
	2, SYSC_SERIAL, setpgrp,	/*  82 = setpgrp */
	3, SYSC_PARALLEL, setitimer,	/*  83 = setitimer */
	0, SYSC_PARALLEL, owait,	/*  84 = old wait & wait3 */
	1, SYSC_SERIAL, swapon,		/*  85 = swapon */
	2, SYSC_PARALLEL, getitimer,	/*  86 = getitimer */
	2, SYSC_PARALLEL, gethostname,	/*  87 = gethostname */
	2, SYSC_SERIAL, sethostname,	/*  88 = sethostname */
	0, SYSC_PARALLEL, getdtablesize,/*  89 = getdtablesize */
	2, SYSC_PARALLEL, dup2,		/*  90 = dup2 */
	2, SYSC_PARALLEL, getdopt,	/*  91 = getdopt */
	3, SYSC_PARALLEL, fcntl,	/*  92 = fcntl */
	5, SYSC_PARALLEL, select,	/*  93 = select */
	2, SYSC_SERIAL, setdopt,	/*  94 = setdopt */
	1, SYSC_SERIAL, fsync,		/*  95 = fsync */
	3, SYSC_PARALLEL, setpriority,	/*  96 = setpriority */
	3, SYSC_PARALLEL, socket,	/*  97 = socket */
	3, SYSC_PARALLEL, connect,	/*  98 = connect */
	3, SYSC_PARALLEL, accept,	/*  99 = accept */
	2, SYSC_PARALLEL, getpriority,	/* 100 = getpriority */
	4, SYSC_PARALLEL, send,		/* 101 = send */
	4, SYSC_PARALLEL, recv,		/* 102 = recv */
	0, SYSC_PARALLEL, nosys,	/* 103 = old socketaddr */
	3, SYSC_PARALLEL, bind,		/* 104 = bind */
	5, SYSC_PARALLEL, setsockopt,	/* 105 = setsockopt */
	2, SYSC_PARALLEL, listen,	/* 106 = listen */
	compat(2,vtimes),		/* 107 = old vtimes */
	3, SYSC_PARALLEL, sigvec,	/* 108 = sigvec */
	1, SYSC_PARALLEL, sigblock,	/* 109 = sigblock */
	1, SYSC_PARALLEL, sigsetmask,	/* 110 = sigsetmask */
	1, SYSC_PARALLEL, sigpause,	/* 111 = sigpause */
	2, SYSC_PARALLEL, sigstack,	/* 112 = sigstack */
	3, SYSC_PARALLEL, recvmsg,	/* 113 = recvmsg */
	3, SYSC_PARALLEL, sendmsg,	/* 114 = sendmsg */
#ifdef	TRACE
	3, SYSC_SERIAL, vtrace,		/* 115 = vtrace */
#else	TRACE
#ifdef	TESTECC
	0, SYSC_SERIAL, testecc,	/* 115 = testecc */
#else	TESTECC
	0, SYSC_PARALLEL, nosys,	/* 115 = nosys */
#endif	TESTECC
#endif	TRACE
	2, SYSC_PARALLEL, gettimeofday,	/* 116 = gettimeofday */
	2, SYSC_PARALLEL, getrusage,	/* 117 = getrusage */
	5, SYSC_PARALLEL, getsockopt,	/* 118 = getsockopt */
#ifdef vax
	1, SYSC_SERIAL, resuba,		/* 119 = resuba */
#else
	0, SYSC_PARALLEL, nosys,	/* 119 = nosys */
#endif
	3, SYSC_PARALLEL, readv,	/* 120 = readv */
	3, SYSC_PARALLEL, writev,	/* 121 = writev */
	2, SYSC_SERIAL, settimeofday,	/* 122 = settimeofday */
	3, SYSC_SERIAL, fchown,		/* 123 = fchown */
	2, SYSC_SERIAL, fchmod,		/* 124 = fchmod */
	6, SYSC_PARALLEL, recvfrom,	/* 125 = recvfrom */
	2, SYSC_SERIAL, setreuid,	/* 126 = setreuid */
	2, SYSC_SERIAL, setregid,	/* 127 = setregid */
	2, SYSC_SERIAL, rename,		/* 128 = rename */
	2, SYSC_SERIAL, truncate,	/* 129 = truncate */
	2, SYSC_SERIAL, ftruncate,	/* 130 = ftruncate */
	2, SYSC_SERIAL, flock,		/* 131 = flock */
	0, SYSC_PARALLEL, nosys,	/* 132 = nosys */
	6, SYSC_PARALLEL, sendto,	/* 133 = sendto */
	2, SYSC_PARALLEL, shutdown,	/* 134 = shutdown */
	5, SYSC_PARALLEL, socketpair,	/* 135 = socketpair */
	2, SYSC_SERIAL, mkdir,		/* 136 = mkdir */
	1, SYSC_SERIAL, rmdir,		/* 137 = rmdir */
	2, SYSC_SERIAL, utimes,		/* 138 = utimes */
	0, SYSC_PARALLEL, sigcleanup,	/* 139 = signalcleanup */
	2, SYSC_SERIAL, adjtime,	/* 140 = adjtime */
	3, SYSC_PARALLEL, getpeername,	/* 141 = getpeername */
	2, SYSC_PARALLEL, gethostid,	/* 142 = gethostid */
	0, SYSC_PARALLEL, nosys,	/* 143 = old sethostid */
	2, SYSC_PARALLEL, getrlimit,	/* 144 = getrlimit */
	2, SYSC_PARALLEL, setrlimit,	/* 145 = setrlimit */
	2, SYSC_SERIAL, killpg,		/* 146 = killpg */
	0, SYSC_PARALLEL, nosys,	/* 147 = nosys */
	0, SYSC_SERIAL, oldquota,	/* 148 = old quota */
	0, SYSC_SERIAL, oldquota,	/* 149 = old qquota */
	3, SYSC_PARALLEL, getsockname,	/* 150 = getsockname */
	4, SYSC_SERIAL, getmsg,		/* 151 = getmsg */
	4, SYSC_SERIAL, putmsg,		/* 152 = putmsg */
	3, SYSC_PARALLEL, poll,		/* 153 = poll */
#ifdef NFSSERVER
	0, SYSC_PARALLEL, nosys,	/* 154 = old nfs_mount */
#ifdef ENFS
	1, SYSC_SERIAL, enfs_svc,	/* 155 = nfs_svc */
#else ENFS
	1, SYSC_SERIAL, nfs_svc,	/* 155 = nfs_svc */
#endif ENFS
#else NFSSERVER
	0, SYSC_PARALLEL, nosys,	/* 154 = nosys */
	0, SYSC_PARALLEL, errsys,	/* 155 = errsys */
#endif NFSSERVER
	4, SYSC_SERIAL, getdirentries,	/* 156 = getdirentries */
	2, SYSC_SERIAL, statfs,		/* 157 = statfs */
	2, SYSC_SERIAL, fstatfs,	/* 158 = fstatfs */
	1, SYSC_SERIAL, unmount,	/* 159 = unmount */
#ifdef NFSCLIENT
	0, SYSC_SERIAL, async_daemon,	/* 160 = async_daemon */
#else
	0, SYSC_PARALLEL, errsys,	/* 160 = errsys */
#endif
#ifdef NFSSERVER
	2, SYSC_SERIAL, nfs_getfh,	/* 161 = get file handle */
#else
	0, SYSC_PARALLEL, nosys,	/* 161 = nosys */
#endif
	2, SYSC_PARALLEL, getdomainname,/* 162 = getdomainname */
	2, SYSC_SERIAL, setdomainname,	/* 163 = setdomainname */
#ifdef RT_SCHEDULE
	5, SYSC_SERIAL, rtschedule,	/* 164 = rtschedule */
#else
	0, SYSC_PARALLEL, errsys,	/* 164 = not configured */
#endif RT_SCHEDULE
#ifdef QUOTA
	4, SYSC_SERIAL, quotactl,	/* 165 = quotactl */
#else
	0, SYSC_PARALLEL, errsys,	/* 165 = not configured */
#endif QUOTA
#ifdef NFSSERVER
	2, SYSC_SERIAL, exportfs,	/* 166 = exportfs */
#else
	0, SYSC_PARALLEL, errsys,	/* 166 = not configured */
#endif
	4, SYSC_SERIAL, mount,		/* 167 = mount */
	2, SYSC_SERIAL, ustat,		/* 168 = ustat */
#ifdef IPCSEMAPHORE
	5, SYSC_PARALLEL, semsys,	/* 169 = semsys */
#else
	0, SYSC_PARALLEL, errsys,	/* 169 = not configured */
#endif
#ifdef IPCMESSAGE
	6, SYSC_SERIAL, msgsys,		/* 170 = msgsys */
#else
	0, SYSC_PARALLEL, errsys,	/* 170 = not configured */
#endif
#ifdef IPCSHMEM
	4, SYSC_SERIAL, shmsys,		/* 171 = shmsys */
#else
	0, SYSC_PARALLEL, errsys,	/* 171 = not configured */
#endif
#ifdef SYSAUDIT
	4, SYSC_SERIAL, auditsys,	/* 172 = auditsys (audit control) */
#else
	0, SYSC_PARALLEL, nullsys,	/* 172 = not configured */
#endif SYSAUDIT
#ifdef RFS
	5, SYSC_SERIAL, rfssys,		/* 173 = RFS calls */
#else
	0, SYSC_PARALLEL, errsys,	/* 173 = not configured */
#endif
	3, SYSC_SERIAL, getdents,	/* 174 = getdents */
	1, SYSC_SERIAL, sys_setsid,	/* 175 = setsid & s5 setpgrp() */
	1, SYSC_SERIAL, fchdir,		/* 176 = fchdir */
	1, SYSC_SERIAL, fchroot,	/* 177 = fchroot */
#ifdef VPIX
	2, SYSC_SERIAL, vpixsys,	/* 178 = VP/ix system calls */
#else
	0, SYSC_PARALLEL, errsys,	/* 178 = not configured */
#endif
#ifdef ASYNCHIO
	6, SYSC_PARALLEL, aioread,	/* 179 = aioread */
        6, SYSC_PARALLEL, aiowrite,	/* 180 = aiowrite */
	1, SYSC_PARALLEL, aiowait,	/* 181 = aiowait */
        1, SYSC_SERIAL, aiocancel,      /* 182 = aiocancel */
#else

	0, SYSC_PARALLEL, errsys,	/* 179 not configured */
	0, SYSC_PARALLEL, errsys,	/* 180 not configured */
	0, SYSC_PARALLEL, errsys,	/* 181 not configured */
	0, SYSC_PARALLEL, errsys,	/* 182 not configured */
#endif ASYNCHIO
	1, SYSC_PARALLEL, sigpending,	/* 183 = sigpending */
	0, SYSC_PARALLEL, errsys,	/* 184 = AVAILABLE */
	2, SYSC_SERIAL, setpgid,	/* 185 = setpgid */
	2, SYSC_SERIAL, pathconf,	/* 186 = pathconf */
	2, SYSC_SERIAL, fpathconf,	/* 187 = fpathconf */
	1, SYSC_SERIAL, sysconf,	/* 188 = sysconf */
	1, SYSC_SERIAL, uname,		/* 189 = uname */

	0, SYSC_PARALLEL, nosys,	/* 190 = reservd - Loadable syscalls */
	0, SYSC_PARALLEL, nosys,	/* 191 = reservd - Loadable syscalls */
	0, SYSC_PARALLEL, nosys,	/* 192 = reservd - Loadable syscalls */
	0, SYSC_PARALLEL, nosys,	/* 193 = reservd - Loadable syscalls */
	0, SYSC_PARALLEL, nosys,	/* 194 = reservd - Loadable syscalls */
	0, SYSC_PARALLEL, nosys,	/* 195 = reservd - Loadable syscalls */
	0, SYSC_PARALLEL, nosys,	/* 196 = reservd - Loadable syscalls */
	0, SYSC_PARALLEL, nosys,	/* 197 = reservd - Loadable syscalls */
	0, SYSC_PARALLEL, errsys,	/* 198 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 199 = not configured, future sun */

#ifdef	solbourne
    /* Start of sun expansion area... */
#ifndef	FUTURE
	/* DELETE THESE IN FUTURE... */
	2, SYSC_SERIAL, setcpustatus,	/* 200 = setcpustatus */
	3, SYSC_PARALLEL, getcpustatus,	/* 201 = getcpustatus */
#else	FUTURE
	0, SYSC_PARALLEL, errsys,	/* 200 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 201 = not configured, future sun */
#endif	FUTURE
	0, SYSC_PARALLEL, errsys,	/* 202 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 203 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 204 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 205 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 206 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 207 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 208 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 209 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 210 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 211 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 212 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 213 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 214 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 215 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 216 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 217 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 218 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 219 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 220 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 221 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 222 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 223 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 224 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 225 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 226 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 227 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 228 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 229 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 230 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 231 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 232 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 233 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 234 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 235 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 236 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 237 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 238 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 239 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 240 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 241 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 242 = not configured, future sun */
    /* Start of Solbourne specific system call switch entries ... */
	
#ifdef	SMP_TEST
	1, SYSC_PARALLEL, user_sync_info,	/* 243 = user_sync_info */
	1, SYSC_PARALLEL, user_sync_reset,	/* 244 = user_sync_reset */
	1, SYSC_PARALLEL, user_sync_sleep,	/* 245 = user_sync_sleep */
	2, SYSC_PARALLEL, user_sync_wakeup,	/* 246 = user_sync_wakeup */
	2, SYSC_PARALLEL, user_sync,		/* 247 = user_sync */
	1, SYSC_PARALLEL, bind_mode,	/* 248 = bind_mode */
	1, SYSC_PARALLEL, bind_process,	/* 249 = bind_cpu */
#else	SMP_TEST
	0, SYSC_PARALLEL, errsys,	/* 243 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 244 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 245 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 246 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 247 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 248 = not configured, future sun */
	0, SYSC_PARALLEL, errsys,	/* 249 = not configured, future sun */
#endif	SMP_TEST
	2, SYSC_SERIAL, setcpustatus,	/* 250 = setcpustatus */
	3, SYSC_PARALLEL, getcpustatus,	/* 251 = getcpustatus */
	0, SYSC_PARALLEL, errsys,       /* 252 = not configured */
	0, SYSC_PARALLEL, errsys,       /* 253 = not configured */
	0, SYSC_PARALLEL, errsys,       /* 254 = not configured */
	2, SYSC_SERIAL, user_sleep_and_unlock,/* 255 = usu */
	1, SYSC_SERIAL, user_wakeup,	/* 256 = user_wakeup */
#endif	solbourne
};
int	nsysent = sizeof (sysent) / sizeof (sysent[0]);

unsigned	do_syscall_counts = 1;
unsigned 	*syscall_counts;
char 		*syscall_count_reset;
char 		*syscall_count_enable;


#ifdef VDDRV
int	firstvdsys = 190;		/* first loadable syscall number */
int	lastvdsys  = 197;		/* last loadable syscall number */
#endif
