/* @(#) smpdefs.h 1.3@(#) Solbourne id 3/18/94 09:37:41 */
/*
 * Copyright 1990 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*
 * smpdefs.h - a series of handy macros which make SMP support appear
 * or disappear on command. Source files with SMP changes should #include
 * this file.
 */

#ifndef _machine_smpdefs_h
#define _machine_smpdefs_h

typedef struct {
	void	(*ls_su)();	/* simple_unlock:must be 1st (multisubr.s) */
	void	(*ls_sl)();	/* simple_lock (forever/locktimeout panic) */
	int	(*ls_sls)();	/* simple_lock_spin (until max count) */
	int	(*ls_sln)();	/* simple_lock_nospin (no order check!) */
	int	(*ls_bl)();	/* block_n_lock */
	void	(*ls_uu)();	/* unblock_n_unlock */
	void	(*ls_sli)();	/* simple_lock_init */
	void    (*ls_rww)();    /* rw_write lock */
	void    (*ls_rwr)();    /* rw_read_lock */
	void    (*ls_rwu)();    /* rw_unlock */
	int     (*ls_rwwu)();   /* rw_read_to_write_upgrade */
	void    (*ls_rwru)();   /* rw_write_to_read_upgrade */
	int     (*ls_rwtr)();   /* rw_try_read */
	int     (*ls_rwtw)();   /* try_try_write */
	int     (*ls_rwtrw)();  /* try_read_to_write_upgrade */
} locksw_t;

#ifdef	SMP_TEST
#define	PAM_BIND	0x01	/* pam is available */
#define	PAM_INHERIT	0x02	/* child inherits parent's pam */
#define	PAM_DEFAULT	0x04	/* process which has default pam (~0)
					can be executed on CPU 0 only	*/
#define	PAM_ALL		(PAM_BIND|PAM_INHERIT|PAM_DEFAULT)
#define	PAM_GET_MODE	0x80
#define PROC_EXEC_ALLOWED(p)				\
	((!(pam_mode & PAM_BIND))		||	\
	 (((p)->p_pam & (1 << cpu_number()))	&&	\
	  (!((pam_mode & PAM_DEFAULT)	&&		\
	     (cpu_number() != 0)	&&		\
	     ((p)->p_pam == ~0)))))
#endif	SMP_TEST

#define LS_NO_DEBUG	0
#define LS_DEBUG 	1
#define LS_ONE_CPU	2

#ifndef KADB
#include <sys/proc.h>
#include <sys/user.h>
#include <kap/multicpu.h>
#include <sys/debug.h>

#if	NCPUS > 1
extern	slock	if_lock;
extern	slock	mbuf_lock;
extern	slock	vm_context_lock;
extern	slock	mbuf_lock;
extern	slock	allproc_lock;
extern	slock	vfork_lock;
extern	slock	arp_lock;
extern	int	lock_style;
extern	int	check_lockorder;
extern	locksw_t locksw;

#ifdef	DOMAIN_LOCK
extern	slock	domain_lock;
extern	slock	ifchain_lock;
#else	DOMAIN_LOCK
#define	domain_lock	vm_context_lock
#endif	DOMAIN_LOCK

#ifdef	Q_VM_CONTEXT
extern	slock	vm_context_queue_lock;
extern	int	vmctx_qspin;
#endif	Q_VM_CONTEXT

#define	holding_lock(lp) ((lp)->owner_cpu == cpu_number())

#define	highest_lock(lp) ((lp) == cpu_specific[cpu_number()].locklist)

#define	highest_lock_order() (cpu_specific[cpu_number()].locklist ? \
			cpu_specific[cpu_number()].locklist->order_no : 0)

#ifdef ASS
#    define check_lock(lp)		ASSERT_LOCK(lp);
#    define check_vm_context(a)		ASSERT_LOCK(&vm_context_lock);
#    define check_stream(a)		ASSERT_LOCK(&vm_context_lock);
#    define check_if_lock(a)		ASSERT_LOCK(&if_lock);
#    define check_mbuf_context(a)	ASSERT_LOCK(&mbuf_lock);
#    define check_domain_lock(a)	ASSERT_LOCK(&domain_lock);
#else	ASS
#    define check_lock(lp)
#    define check_vm_context(a)
#    define check_stream(a)
#    define check_if_lock(a)
#    define check_mbuf_context(a)
#    define check_domain_lock(a)
#endif	ASS

#ifdef	TRACE
#include	<sys/trace.h>
#define	lock_trace(tag, lp) trace_string((tag), 0, (u_long)((lp)->name))
#else	TRACE
#define	lock_trace(tag, lp)
#endif	TRACE

/* notrace locks */
#define notrace_simple_lock(lp)		((*locksw.ls_sl) (lp))
#define notrace_simple_unlock(lp)	((*locksw.ls_su) (lp)) 
#define notrace_block_n_lock(lp)	((*locksw.ls_bl) (lp))
#define notrace_unblock_n_unlock(lp)	((*locksw.ls_uu) (lp))
#define notrace_simple_lock_spin(lp, n)	((*locksw.ls_sls) (lp, n))
#define notrace_simple_lock_nospin(lp)	((*locksw.ls_sln) (lp))

/* trace locks */
#define trace_simple_lock(lp)		(lock_trace(TR_REGEN_GETLOCK, lp),\
					((*locksw.ls_sl) (lp)),		\
					lock_trace(TR_REGEN_GOTLOCK, lp))
#define trace_simple_unlock(lp)		(lock_trace(TR_REGEN_DROPLOCK, lp),\
					((*locksw.ls_su) (lp)))
#define trace_block_n_lock(lp)		(lock_trace(TR_REGEN_GETLOCK, lp),\
					((*locksw.ls_bl) (lp)),		\
					lock_trace(TR_REGEN_GOTLOCK, lp))
#define trace_unblock_n_unlock(lp)	(lock_trace(TR_REGEN_DROPLOCK, lp),\
					((*locksw.ls_uu) (lp)))
#define trace_simple_lock_spin(lp, n)	(lock_trace(TR_REGEN_GETLOCK, lp),\
					(((*locksw.ls_sls) (lp, n)) ?	\
					(lock_trace(TR_REGEN_FAILLOCK, lp),1):\
					(lock_trace(TR_REGEN_GOTLOCK, lp),0)))
#define trace_simple_lock_nospin(lp)	(lock_trace(TR_REGEN_GETLOCK, lp),\
					(((*locksw.ls_sln) (lp)) ?	\
					(lock_trace(TR_REGEN_FAILLOCK, lp),1):\
					(lock_trace(TR_REGEN_GOTLOCK, lp),0)))
/* notrace vm locks */
#define notrace_vm_simple_lock(lp)		((*locksw.ls_sl) (lp))
#define notrace_vm_simple_unlock(lp)	((*locksw.ls_su) (lp)) 
#define notrace_vm_block_n_lock(lp)	((*locksw.ls_bl) (lp))
#define notrace_vm_unblock_n_unlock(lp)	((*locksw.ls_uu) (lp))
#define notrace_vm_simple_lock_spin(lp, n)	((*locksw.ls_sls) (lp, n))
#define notrace_vm_simple_lock_nospin(lp)	((*locksw.ls_sln) (lp))

/* trace vm locks */
#define trace_vm_simple_lock(lp)	(lock_trace(TR_REGEN_VMGETLOCK, lp),\
					((*locksw.ls_sl) (lp)),		\
					lock_trace(TR_REGEN_VMGOTLOCK, lp))
#define trace_vm_simple_unlock(lp)	(lock_trace(TR_REGEN_VMDROPLOCK, lp),\
					((*locksw.ls_su) (lp)))
#define trace_vm_block_n_lock(lp)	(lock_trace(TR_REGEN_VMGETLOCK, lp),\
					((*locksw.ls_bl) (lp)),		\
					lock_trace(TR_REGEN_VMGOTLOCK, lp))
#define trace_vm_unblock_n_unlock(lp)	(lock_trace(TR_REGEN_VMDROPLOCK, lp),\
					((*locksw.ls_uu) (lp)))
#define trace_vm_simple_lock_spin(lp, n) (lock_trace(TR_REGEN_VMGETLOCK, lp),\
					(((*locksw.ls_sls) (lp, n)) ?	\
					(lock_trace(TR_REGEN_VMFAILLOCK, lp),1):\
					(lock_trace(TR_REGEN_VMGOTLOCK, lp),0)))
#define trace_vm_simple_lock_nospin(lp)	(lock_trace(TR_REGEN_VMGETLOCK, lp),\
					(((*locksw.ls_sln) (lp)) ?	\
					(lock_trace(TR_REGEN_VMFAILLOCK, lp),1):\
					(lock_trace(TR_REGEN_VMGOTLOCK, lp),0)))

#ifdef	TRACE_LOCK_ALL
#define simple_lock(lp)			trace_simple_lock(lp)
#define simple_unlock(lp)		trace_simple_unlock(lp)
#define block_n_lock(lp)		trace_block_n_lock(lp)
#define unblock_n_unlock(lp)		trace_unblock_n_unlock(lp)
#define simple_lock_spin(lp, n)		trace_simple_lock_spin(lp, n)
#define simple_lock_nospin(lp)		trace_simple_lock_nospin(lp)
#else	TRACE_LOCK_ALL
#define simple_lock(lp)			notrace_simple_lock(lp)
#define simple_unlock(lp)		notrace_simple_unlock(lp)
#define block_n_lock(lp)		notrace_block_n_lock(lp)
#define unblock_n_unlock(lp)		notrace_unblock_n_unlock(lp)
#define simple_lock_spin(lp, n)		notrace_simple_lock_spin(lp, n)
#define simple_lock_nospin(lp)		notrace_simple_lock_nospin(lp)
#endif	TRACE_LOCK_ALL

#if	defined(TRACE_LOCK_VMCONTEXT) || defined(TRACE_LOCK_ALL)
#define vm_simple_lock(lp)		trace_vm_simple_lock(lp)
#define vm_simple_unlock(lp)		trace_vm_simple_unlock(lp)
#define vm_block_n_lock(lp)		trace_vm_block_n_lock(lp)
#define vm_unblock_n_unlock(lp)		trace_vm_unblock_n_unlock(lp)
#define vm_simple_lock_spin(lp, n)	trace_vm_simple_lock_spin(lp, n)
#define vm_simple_lock_nospin(lp)	trace_vm_simple_lock_nospin(lp)
#else	defined(TRACE_LOCK_VMCONTEXT) || defined(TRACE_LOCK_ALL)
#define vm_simple_lock(lp)		notrace_vm_simple_lock(lp)
#define vm_simple_unlock(lp)		notrace_vm_simple_unlock(lp)
#define vm_block_n_lock(lp)		notrace_vm_block_n_lock(lp)
#define vm_unblock_n_unlock(lp)		notrace_vm_unblock_n_unlock(lp)
#define vm_simple_lock_spin(lp, n)	notrace_vm_simple_lock_spin(lp, n)
#define vm_simple_lock_nospin(lp)	notrace_vm_simple_lock_nospin(lp)
#endif	defined(TRACE_LOCK_VMCONTEXT) || defined(TRACE_LOCK_ALL)

#define simple_lock_init(lp, o, n)	((*locksw.ls_sli) (lp, o, n))

/*
 * Reader_writer lock functions defined
 */
#define rw_write_lock(lp)	            ((*locksw.ls_rww) (lp))
#define rw_read_lock(lp)	            ((*locksw.ls_rwr) (lp))
#define rw_unlock(lp)	                    ((*locksw.ls_rwu) (lp))
#define rw_read_to_write_upgrade(lp)	    ((*locksw.ls_rwwu) (lp))
#define rw_write_to_read_upgrade(lp)        ((*locksw.ls_rwru) (lp))
#define rw_try_read(lp)                     ((*locksw.ls_rwtr) (lp))
#define rw_try_write(lp)                    ((*locksw.ls_rwtw) (lp))
#define rw_try_read_to_write_upgrade(lp)    ((*locksw.ls_rwtrw) (lp))

#define atomic(lp, op) {						\
	block_n_lock((lp)); 						\
	op; 								\
	unblock_n_unlock((lp)); 						\
}

#define process_monitor(p, op) {					\
	if (holding_lock(&(p)->p_lock)) {				\
		/*							\
		 * We can assume that we are at sufficient		\
		 * spl (or have interrupts blocked), as if 		\
		 * we were not we would get lock order 			\
		 * violations.						\
		 */							\
		op;							\
	} else {							\
		atomic(&(p)->p_lock, op);				\
	}								\
}

#define proc_mon_enter(p, s) {						\
	if (holding_lock(&(p)->p_lock)) {				\
		(s) = -1;						\
	} else {							\
		(s) = spl6();						\
		simple_lock((slock_t) &(p)->p_lock); 			\
	}								\
}

#define	proc_sync(p) {							\
	check_lock(&(p)->p_lock);					\
	while ((p)->p_mpflgs & STRANS) {				\
		simple_unlock((slock_t) &(p)->p_lock);			\
		while ((p)->p_mpflgs & STRANS)				\
			;						\
		simple_lock((slock_t) &(p)->p_lock);			\
	}								\
}

/* proc_mon_enter with sync if process is in transition */
#define proc_mon_enter_sync(p, s)					\
	if (holding_lock(&(p)->p_lock)) {				\
		(s) = -1;						\
	} else {							\
		(s) = spl6();						\
		simple_lock((slock_t) &(p)->p_lock); 			\
		while ((p)->p_mpflgs & STRANS) {			\
			simple_unlock((slock_t) &(p)->p_lock);		\
			(void) splx(s);					\
			while ((p)->p_mpflgs & STRANS)			\
				;					\
			(s) = spl6();					\
			simple_lock((slock_t) &(p)->p_lock);		\
		}							\
	}

#define proc_mon_exit(p, s) {						\
	if ((s) >= 0) {							\
		simple_unlock((slock_t) &(p)->p_lock);			\
		(void)splx(s);						\
	}								\
}

#define grab_vm_context(a)	{ 					\
	if (holding_lock(&vm_context_lock))				\
		(a) = -1;						\
	else {								\
		vm_simple_lock(&vm_context_lock);			\
		(a) = 1;						\
	}								\
}

#ifdef	Q_VM_CONTEXT
#define	grab_vm_context_q(a)	{					\
	if (holding_lock(&vm_context_lock))				\
		(a) = -1;						\
	else if (vm_simple_lock_spin(&vm_context_lock, vmctx_qspin) == 0)\
		(a) = 1;						\
	else								\
		(a) = grab_vm_context_queue();				\
}

#define drop_vm_context(a)	{					\
	if ((a) >= 0) {							\
		vm_simple_unlock(&vm_context_lock); 			\
		if (vm_context_lock.wakeup_chan) {			\
			int _s = splvme();				\
			simple_lock(&vm_context_queue_lock);		\
			if (vm_context_lock.wakeup_chan) {		\
			    wakeup((caddr_t)vm_context_lock.wakeup_chan);\
			    vm_context_lock.wakeup_chan = 0;		\
			} 						\
			simple_unlock(&vm_context_queue_lock);		\
			splx(_s);					\
		}							\
		ASSERT((a) == 1);					\
	}								\
}
#else	Q_VM_CONTEXT
#define	grab_vm_context_q(a)	grab_vm_context(a)

#define drop_vm_context(a)	{					\
	if ((a) >= 0) {							\
		vm_simple_unlock(&vm_context_lock); 			\
		ASSERT((a) == 1);					\
	}								\
}
#endif	Q_VM_CONTEXT

	/*
	 * Depending on the number of cpus (ncpus), this pointer is
	 * set to either splvme (ncpus > 1) or to splimp (ncpus == 1).
	 */
#define SET_SPLIMP_VMCONTEXT_FUNC(ncpus) { \
	extern int splvme(), splimp(); \
	splimp_vmcontext_func = ((ncpus) > 1) ? splvme : splimp; \
}
extern int (*splimp_vmcontext_func)();


#define	grab_if_lock()		simple_lock(&if_lock)
#define	drop_if_lock()		simple_unlock(&if_lock)

#define	grab_mbuf_context(a)	{					\
	(a) = (*splimp_vmcontext_func)();				\
	simple_lock(&mbuf_lock);					\
}
#define	drop_mbuf_context(a)	{					\
	ASSERT((a) != -1);						\
	simple_unlock(&mbuf_lock);					\
	(void) splx((a));						\
}
#else	NCPUS == 1
!!!!!!!!!BLOW UP!!!!!!!!!!!!! + + + +
#endif	NCPUS
#else	KADB
#define check_vm_context(a)
#endif	!KADB
#endif _machine_smpdefs_h
