/* @(#) fontdefs.h 1.1@(#) Solbourne id 9/21/93 23:57:45 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */



/* @(#) GLIB file fontdefs.h, VERSION 2.1 87/12/21 09:00:55 */

/******************************************************************************
*                                                                             *
* This document is proprietary and the sole property of SAE Inc. Any          *
* unauthorized use or copies are expressly prohibited.                        *
*                                                                             *
* USA (c) Copyright 1987, SAE Inc.                                            *
*                                                                             *
******************************************************************************/


/******************************************************************************
*
*        module: text & char exported header file
*      filename: fontdefs.h
*    start date: 87/08/04
*    last delta: 87/10/02
* 
*        author: Tony Jackson
* current owner: Tony Jackson
*
* Contains definitions for internal font formats. Needs to be a separate
*   file because it is used by various font generation utilities.
*
******************************************************************************/


    /**********************************************************************
    *
    * This file contains the structure definitions required for handling
    * fonts. In the long term, this will be integrated with the rest of the
    * DIGL system.
    *
    **********************************************************************/
    
#define POLYLINE_FONT	    1
#define POLYGON_FONT	    2
#define RASTER_FONT	    3

#define ASCII_FONT	    1
#define ISO_FONT	    2
#define KANJI_FONT	    3

/**************************************************************************
*
* The following structures are for vector (i.e. polyline & polygon) fonts
* 
**************************************************************************/

typedef struct
    {
    int	    start;
    int	    num_coords;
    float   offset;
    } index_entry;

typedef struct
    {
    float x;
    float y;
    float md;
    } char_coord;

typedef struct
    {
    char name[20];
    int   font_type;
    int	  coding;
    int	  mindefchar;
    int   maxdefchar;
    float minx, maxx;
    float miny, maxy;
    float max_step;
    float defined_height;
    float defined_width;
    int	  index_size;
    int   num_coords;
    } fontinfo;



/************************************************************************
*
* The following structures are for raster fonts
*
************************************************************************/


typedef struct
    {
    char	    name[20];
    short	    font_type;
    short	    coding;
    unsigned short  mindefchar;
    unsigned short  maxdefchar;
    short	    maxx;
    short	    maxy;
    int		    index_size;
    unsigned int    size;
    } ras_info; 

typedef struct
    {
    unsigned int    addr;
    unsigned int    nbytes;
    int		    up, down, left, right;
    short	    offset;
    short	    filler;
    } ras_index;

