/* @(#) eeprom.h 1.1@(#) Solbourne id 9/21/93 23:57:36 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*
 * The EEPROM has one byte in each 8 byte block.  Thus consecutive
 * bytes are at addresses that are incremented by 8.
 * The EEPROM may be written a maximum of 10000 times.
 */
#define	EEPROM_INCR	8		/* space between consecutive bytes */
#define	EEPROM_SHIFT	3		/* EEPROM index to an address */

#define	OBIO_EEPROM_ADDR 0x17002000	/* address of EEPROM in obio space */
/*
 * key tables are at the end of the eeprom
 */
#define	EEPROM_KEYTAB_SIZE	128
#define	EEPROM_STRINGS_END	(EEPROM_SIZE - EEPROM_KEYTAB_SIZE * 2)
#define	EEPROM_KEYTAB_LC_ADDR	(EEPROM_STRINGS_END)
#define	EEPROM_KEYTAB_UC_ADDR	(EEPROM_SIZE - EEPROM_KEYTAB_SIZE)
#define	EEPROM_SIZE	0x400		/* size of EEPROM in bytes */

/* 
 * after writing an eeprom location, read it this many
 * times before the data is actually there.  in the wait loop
 * the overhead is due to the read latency not the instruction 
 * execution speed.
 */
#ifdef Series4
#define EEPROM_WAIT	10000		
#endif Series4
#ifdef Series5 
#define EEPROM_WAIT	22000		
#endif Series5
#if	defined(Series6) || defined(Series7)
#ifdef viking
#define EEPROM_WAIT	5000	
#endif /* viking */
#ifdef cypress
#define EEPROM_WAIT	5000
#endif /* cypress */
#endif Series6 || Series7

/*
 * The hard-wired fields below are the first things in the EEPROM,
 * the remainder is available for user-defined strings.  (Some strings
 * are added by the ROM by default.)  Whenever the EEPROM is changed
 * the value of csum must be adjusted so that the sum of all the EEPROM
 * locations equals EE_VERSION.  This is how the ROM determines if the
 * EEPROM requires initialization.
 *
 * N.B. the EE_VERSION number should be incremented whenever the
 *      fields in the eeprom struct change.  this will cause the
 *      ROM to re-initialize the field automatically.
 */
#if defined(Series4) || defined(Series5)
#define EE_VERSION	0x13	/* eeprom struct version (must be non-zero) */
#endif /* Series4 || Series5 */

#ifdef Series6
#define EE_VERSION	0x14	/* eeprom struct version (must be non-zero) */
#endif Series6

#ifdef Series7
#define EE_VERSION	0x14	/* eeprom struct version (must be non-zero) */
#endif Series7

#ifndef LOCORE
struct ee_keymap {
	unsigned char   keymap[EEPROM_KEYTAB_SIZE];
};
struct eeprom {
	u_char	ee_csum;		/* checksum -- must be first */
	char	ee_model[16];		/* hardware model string */
	int	ee_ttya_mode;		/* ttya modes */
	int	ee_ttyb_mode;		/* ttyb modes */
	u_char	ee_bootmode;		/* default boot mode */
#if	defined(Series6) || defined(Series7)
	u_char	ee_diagmode;		/* power on self test mode */
#endif Series6 || Series7
	u_char	ee_displayres;		/* display resolution in pixels */
	u_char	ee_master;		/* master cpu slot number */
};
#define	EEINDEX(field)	((int)(&((struct eeprom *)0)->field))
extern caddr_t eeprom_base_va;		/* virtual address of EEPROM base */
#endif !LOCORE

#define	EEPROM_AUTO	1		/* auto boot mode */
#define	EEPROM_MANUAL	2		/* manual boot mode */
#define	EEPROM_BURNIN	3		/* burnin boot mode */

#if	defined(Series6) || defined(Series7)
#define	EEPROM_POST_SHORT	1	/* short self-test */
#define	EEPROM_POST_NORM	2	/* normal self-test */
#endif Series6 || Series7
