/* @(#) cpuboard.h 1.5@(#) Solbourne id 3/10/94 21:05:07 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */
#ifndef	_kbus_cpuboard_h
#define	_kbus_cpuboard_h

/*
 * This header file contains information specific to Kbus cpu boards
 */

/*
 * CPUSTAT bit definitions.
 * This register has the SYSFAIL bit set on power up and is 1 byte in size.
 */
#define CPUSTAT_SLAVE	0x01		/* this cpu is a slave */
#define CPUSTAT_GOOD	0x02		/* this cpu passes diagnostics */
#define CPUSTAT_NMI	0x04		/* issue NMI to all other processors */
#define CPUSTAT_SYSFAIL	0x08		/* pull KBUS SYSFAIL signal */

#if	defined(Series4) || defined(Series5)
/*
 * BID, board ID register, bit definitions
 * NOTE: NMI, SYSFAIL, and BJMPR0 are active low
 */
#define BID_SLOT	0x0000000f	/* board's system slot address */
#define BID_DIAG	0x00000010	/* status of diag switch */
#define BID_NMI		0x00000020	/* status of KBUS NMI signal */
#define BID_SYSFAIL	0x00000040	/* status of KBUS sysfail signal */
#define BID_BJMPR0	0x00000080	/* status of burnin jumper 0 if present */

#define BID_MASK	0x0000ffff
#endif	Series4 || Series5

#ifdef Series4
/*
 * The cpu board has some control registers which are addressable
 * thru ID space transactions (IO space 1). The offset to these
 * registers if from the beginning of the idprom.
 */
#define CPUHR		0x4010		/* cpu hard reset register, 8-bit, RW */
#define CPUSTAT		0x4018		/* cpu status, 8-bit, RW */

/*
 * CPUHR bit definitions. 
 * This register is set to 0 at power on and is 1 byte in size.
 */
#define CPUHR_RESET	0x01		/* cpu reset bit */
#define CPUHR_BWTE	0x02		/* bus watcher tag enable */
#endif Series4

#ifdef Series5
/*
 * The cpu board has a control register which is addressable
 * thru ID space transactions (IO space 1). The offset to this
 * register is from the beginning of the idprom.
 */
#define CPUSTAT		0x4018		/* cpu status, 8-bit, RW */
#endif Series5

#ifdef Series6
#define BID_SLOT	0x0000000f	/* board's system slot address */

/*
 * cpu board status/control register
 * This register has the SYSFAIL bit set on power up and is 32 bits in size.
 */
#define CPUSTAT		KID_BCS		/* cpu status, 32-bit, RW */

/*
 * BCS - Board Control and Status Register bit definitions
 */

#define BCS_NMI		0x00000001	/* NMI */
#define BCS_SYSF	0x00000002	/* SYSFAIL */
#define BCS_FIOE	0x00000004	/* Kbus Fast I/O write enable */
#define BCS_CT		0x00000008	/* Cache Test */
#define BCS_CS		0x00000010	/* Cold Start */
#define BCS_PRST	0x00000020	/* Processor RESET */
#define BCS_MCBE	0x00000040	/* Mbus CB register Enable */
#define BCS_KCBE	0x00000080	/* Kbus CB register Enable */
#define BCS_MECE	0x00000100	/* Mbus ECC Enable */
#define BCS_KECE	0x00000200	/* Kbus ECC Enable */
#define BCS_IRE		0x00000400	/* Inactivity Reset Enable */
#define BCS_BWE		0x00000800	/* Boot ROM Write Enable */
#define BCS_KTID_MASK	0x0000F000	/* Kbus Transaction ID */
#define BCS_KTID_SHIFT	12		/* KTID shift */
#define BCS_KBID_MASK	0x000F0000	/* Kbus board id mask */
#define BCS_KBID_SHIFT	16		/* Kbus board id shift */
#define BCS_KNMI	0x00100000	/* Status of Kbus NMI */
#define BCS_KSYSF	0x00200000	/* Status of Kbus SYSFAIL */
#define BCS_DIAG	0x00400000	/* Front panel DIAG switch */
#define BCS_BURN	0x00800000	/* CPU Burnin jumper */
#define BCS_PIO		0x01000000	/* Pending Fast I/O cycle */

/*
 * Kbus Probe Transaction Space Addresses
 */

#define KPT_WATCHER	0x00000000	/* Watcher Test Probe */
#define KPT_EAWTENB	0x00000001	/* EAROM Write Enable */
#define KPT_EAWTDIS	0x00000002	/* EAROM Write Disable */
#define KPT_KI		0x00000003	/* KI register */

/*
 * Kbus ID Space Addresses
 *
 * Base address specifies local cpu board access.  Add Kbus
 * slot number address to reference other boards.
 */

#define KID_IDPROM	0x00000000	/* IDPROM base address (every 8th byte) */
#define KID_DGRAM	0x00100000	/* Diagnostic RAM base address */

#define KID_FC		0x00200000	/* Fault Cause Register */
#define FC_REG_MASK	0x00001FFF

#define KID_ADFA	0x00210000	/* Asynchronouse Data Fault Address */
#define ADFA_REG_MASK	0xffffffff

#define KID_KSFA	0x00220000	/* Kbus SECC Fault Address Register */
#define KSFA_REG_MASK	0xffffffff

#define KID_KMFA	0x00230000	/* Kbus MECC Fault Address Register */
#define KMFA_REG_MASK	0xffffffff

#define KID_MSFA	0x00240000	/* Mbus SECC Fault Address Register */
#define MSFA_REG_MASK	0xffffffff

#define KID_MMFA	0x00250000	/* Mbus SECC Fault Address Register */
#define MMFA_REG_MASK	0xffffffff

#define KID_SDFA	0x00260000	/* Synchronous Data Fault Register */
#define SDFA_REG_MASK	0xffffffff

#define KID_KTFA	0x00270000	/* Kbus Timeout Fault Address Reg */
#define KTFA_REG_MASK	0xffffffff

#define KID_KAFA	0x00280000	/* Kbus Async Fault Address Reg */
#define KAFA_REG_MASK	0xffffffff

#define KID_KTS		0x00290000	/* Kbus Timeout SPACE/TTYPE Reg */
#define KTS_REG_MASK	0x01ff01ff

#define KID_MFID	0x002A0000	/* Mbus Fault ID Register */
#define MFID_REG_MASK	0x0000000f

#define KID_KCB		0x00300000	/* Kbus Check Byte Register */
#define KCB_REG_MASK	0x000000ff

#define KID_MCB		0x00310000	/* Mbus Check Byte Register */
#define MCB_REG_MASK	0x000000ff

#define KID_BCS		0x00320000	/* Board Control and Status Reg */
#define BCS_REG_MASK	0x01ffffff

#define KID_LED		0x00330000	/* LED Register */
#define LED_REG_MASK	0x0000ffff

#define KID_KSS		0x00340000	/* Kbus SECC Syndrome Reg */
#define KSS_REG_MASK	0x00003fff

#define KID_KMS		0x00350000	/* Kbus MECC Syndrome Reg */
#define KMS_REG_MASK	0x00003fff

#define KID_AMSS	0x00360000	/* Async Mbus SECC Syndrome Reg */
#define AMSS_REG_MASK	0x00003fff

#define KID_AMMS	0x00370000	/* Async Mbus MECC Syndrome Reg */
#define AMMS_REG_MASK	0x00003fff

#define KID_MMS		0x00380000	/* Mbus MECC Syndrome Reg */
#define MMS_REG_MASK	0x00003fff

#define KID_CTI		0x00390000	/* Cache Test Information Reg */
#define CTI_REG_MASK	0xffbeffbf

#define KID_WTI		0x003A0000	/* Watcher Test Information Reg */
#define WTI_REG_MASK	0xffb8ffb9

#define KID_DIR		0x00400000	/* Device ID Register */
#define DIR_REG_MASK	0x000000ff

#define KID_IXR		0x00410000	/* Int Transmit Register */
#define IXR_REG_MASK	0x0000ffff

#define KID_ITXC	0x00420000	/* Int Transmit Control Register */
#define ITXC_REG_MASK	0x00000003

#define KID_IPR		0x00430000	/* Int Priority Register */
#define IPR_REG_MASK	0x000000ff

#define KID_ACK_IPV	0x00440000	/* Int Pending Register (clr int) */
#define IPV_REG_MASK	0x0000ffff

#define KID_IRXC	0x00450000	/* Int Receiver Control Register */
#define IRXC_REG_MASK	0x00000003

#define KID_KI		0x00460000	/* Kbus Interrupt Register */
#define KI_REG_MASK	0x0000000f

#define KID_IRL		0x00470000	/* Int Request Level Register */
#define IRL_REG_MASK	0x0000000f
	
#define KID_NOACK_IPV	0x004c0000	/* Int Pending Register (hold int) */

#define KID_MSC		0x00500000	/* Micro-second Count Register */
#define MSC_REG_MASK	0xffffffff

#define KID_CREF	0x00510000	/* Cache Reference Count Register */
#define CREF_REG_MASK	0xffffffff

#define KID_CHIT	0x00520000	/* Cache Hit Count Register */
#define CHIT_REG_MASK	0xffffffff

/*
 * FC, fault cause register, bit definitions
 */
#define FCR_IR		0x00000001	/* Inactivity reset occurred */
#define FCR_KM		0x00000002	/* Kbus MECC fault */
#define FCR_KT		0x00000004	/* Kbus timeout fault */
#define FCR_MM		0x00000008	/* Mbus MECC fault */
#define FCR_SMT		0x00000010	/* Sync Mbus timeout fault */
#define FCR_S3C		0x00000020	/* Sync L3 Cache fault */
#define FCR_MTI		0x00000040	/* Mbus Tag Inconsistency fault */
#define FCR_FT		0x00000080	/* Fast IO write timeout */
#define FCR_KFT		0x00000100	/* Kbus Flush Timeout fault */

#define FCR_A3C		0x00000200	/* Async L3 Cache fault */
#define FCR_A3M		0x00000400	/* Async L3 Cache Multi-bit ECC fault */
#define FCR_AMT		0x00000800	/* Async Mbus timeout fault */
#define FCR_KTI		0x00001000	/* Kbus Tag Inconsistency fault */
#define FCR_CLR_MASK	FC_REG_MASK	/* clear other bits */

#define FCR_BITS	"\20\15Kbus_tag_inconsistenry\14Async_mbus_timeout\13Async_l3_multibit_ECC\12Async_l3_cache\11Kbus_flush_timeout\10Kbus_fastIO_timeout\7Mbus_tag_inconsistency\6Sync_l3_cache\5Sync_mbus_timeout\4Mbus_multibit_ECC\3Kbus_timeout\2Kbus_multibit_ECC\1Inactivity_reset"
#define FCR_ERR_BITS	(FCR_KTI|FCR_AMT|FCR_A3M|FCR_A3C|FCR_KFT|FCR_FT|FCR_MTI|FCR_S3C|FCR_SMT|FCR_MM|FCR_KT|FCR_KM)
#define	FCR_ECC_ERR	(FCR_KM|FCR_MM|FCR_A3M)
#define	FCR_TIMEOUT	(FCR_KT|FCR_SMT|FCR_FT|FCR_KFT|FCR_AMT)
#define	FCR_OTHER_ERR	(FCR_S3C|FCR_MTI|FCR_A3C|FCR_KTI)

#define	viking_errata_16

#endif	Series6

#ifdef	Series7	/* **************************************************** */

#define BID_SLOT	0x0000000f	/* board's system slot address */

/*
 * cpu board status/control register
 * This register has the SYSFAIL bit set on power up and is 32 bits in size.
 */
#define CPUSTAT		KID_BCS		/* cpu status, 32-bit, RW */

/*
 * BCS - Board Control and Status Register bit definitions
 */

#define BCS_NMI		0x00000001	/* NMI */
#define BCS_SYSF	0x00000002	/* SYSFAIL */
#define BCS_FIOE	0x00000004	/* Kbus Fast I/O write enable */
#define BCS_CT		0x00000008	/* Cache Test */
#define BCS_PRST	0x00000020	/* Processor RESET */
#define BCS_MCBE	0x00000040	/* Mbus CB register Enable */
#define BCS_KCBE	0x00000080	/* Kbus CB register Enable */
#define BCS_IRE		0x00000400	/* Inactivity Reset Enable */
#define BCS_BWE		0x00000800	/* Boot ROM Write Enable */
#define BCS_KTID_MASK	0x0000F000	/* Kbus Transaction ID */
#define BCS_KTID_SHIFT	12		/* KTID shift */
#define BCS_KBID_MASK	0x000F0000	/* Kbus board id mask */
#define BCS_KBID_SHIFT	16		/* Kbus board id shift */
#define BCS_KNMI	0x00100000	/* Status of Kbus NMI */
#define BCS_PIO		0x01000000	/* Pending Fast I/O cycle */

/*
 * BCS2 - Second Board Control and Status Register bit definitions
 */

#define BCS2_MIH_MASK	0x00000007	/* MIH Timing Mask */
#define BCS2_VC		0x00000008	/* Virtual Cache bit */
#define BCS2_VMSK_MASK	0x00000FF0	/* Virtual Address Mask */
#define BCS2_VMSK_SHIFT	4		/* Virtual Address Shift */
#define BCS2_KSE	0x00001000	/* Kbus Snoop Enable */
#define BCS2_WTPE	0x00002000	/* Watcher Tag Parity Check Enable */
#define BCS2_CTPE	0x00004000	/* Cache Tag Parity Check Enable */
#define BCS2_ECE	0x00008000	/* ECC Check and Correct Enable */
#define BCS2_PAEN_MASK	0x00030000	/* Processor Arbitration Enable mask */
#define BCS2_PAEN_SHIFT 16		/* Processor Arbitration Enable shift */
#define BCS2_AIEN_MASK	0x000C0000	/* Asynchronous Fault Interrupt Enable mask */
#define BCS2_AIEN_SHIFT 18		/* Asynchronous Fault Interrupt Enable shift */
#define BCS2_RVM	0x00100000	/* Request on Virtual tag Miss */
#define BCS2_MR		0x00200000	/* Memory Reflection */
#define BCS2_RCM	0x00400000	/* Retry on Cache Miss */
#define BCS2_CNF	0x00800000	/* Cache No Fault */
#define BCS2_ORE	0x01000000	/* Outstanding kbus RIO enable */
#define BCS2_MTE	0x02000000	/* Module Tag Enable */

/*
 * BCS3 - Third Board Control and Status Register bit definitions
 */

#define BCS3_KSYSF	0x00000001	/* Status of Kbus SYSFAIL */
#define BCS3_DIAG	0x00000002	/* Front panel DIAG switch */
#define BCS3_BURN	0x00000004	/* CPU Burnin jumper */
#define BCS3_CS		0x00000008	/* Cold Start */

/*
 * Kbus Probe Transaction Space Addresses
 */

#define KPT_WATCHER	0x00000000	/* Watcher Test Probe */
#define KPT_EAWTENB	0x00000001	/* EAROM Write Enable */
#define KPT_EAWTDIS	0x00000002	/* EAROM Write Disable */
#define KPT_KI		0x00000003	/* KI register */

/*
 * Kbus ID Space Addresses
 *
 * Base address specifies local cpu board access.  Add Kbus
 * slot number address to reference other boards.
 */

#define KID_IDPROM	0x00000000	/* IDPROM base address (every 8th byte) */
#define KID_DGRAM	0x00100000	/* Diagnostic RAM base address */

#define KID_FC		0x00200000	/* Fault Cause Register */
#define KID_ADFA	0x00210000	/* Asynchronouse Data Fault Address */
#define KID_KSFA	0x00220000	/* Kbus SECC Fault Address Register */
#define KID_KMFA	0x00230000	/* Kbus MECC Fault Address Register */
#define KID_MSFA	0x00240000	/* Mbus SECC Fault Address Register */
#define KID_MMFA	0x00250000	/* Mbus MECC Fault Address Register */
#define KID_SDFA	0x00260000	/* Synchronous Data Fault Register */
#define KID_KTFA	0x00270000	/* Kbus Timeout Fault Address Register */
#define KID_KAFA	0x00280000	/* Kbus Async Fault Address Register */
#define KID_KTS		0x00290000	/* Kbus Timeout SPACE/TTYPE Register */
#define KID_MFID	0x002A0000	/* Mbus Fault ID Register */
#define KID_KFTA	0x002B0000	/* Kbus Flush Timeout Fault Address Register */

#define KID_BCS		0x00320000	/* Board Control and Status Register */
#define KID_KSS		0x00340000	/* Kbus SECC Syndrome Register */
#define KID_KMS		0x00350000	/* Kbus MECC Syndrome Register */
#define KID_AMSS	0x00360000	/* Async. Mbus SECC Syndrome Register */
#define KID_AMMS	0x00370000	/* Async. Mbus MECC Syndrome Register */
#define KID_MMS		0x00380000	/* Sync. Mbus MECC Syndrome Register */
#define KID_BCS2	0x003B0000	/* Board Control and Status Register 2 */
#define KID_ECB		0x003C0000	/* ECC Check Byte Register */
#define KID_MIDR	0x003D0000	/* Mbus ID Register */

#define KID_DIR		0x00400000	/* Device ID Register */
#define KID_IXR		0x00410000	/* Interrupt Transmit Register */
#define KID_ITXC	0x00420000	/* Interrupt Transmit Control Register */
#define KID_IPR		0x00430000	/* Interrupt Priority Register */
#define KID_IPVCLR	0x00440000	/* Interrupt Pending Register (clr int) */
#define KID_IRXC	0x00450000	/* Interrupt Receiver Control Register */
#define KID_KI		0x00460000	/* Kbus Interrupt Register */
#define KID_IRL		0x00470000	/* Interrupt Request Level  */
#define KID_MTIL	0x00480000	/* Micro-second Timer Interrupt Level Register */
#define KID_EDIL	0x00490000	/* External Device Interrupt Level Register */
#define KID_IPVHLD	0x004c0000	/* Interrupt Pending Register (hold int) */

#define KID_MSC		0x00500000	/* Micro-second Count Register */
#define KID_CREF	0x00510000	/* Cache Reference Count Register */
#define KID_CHIT	0x00520000	/* Cache Hit Count Register */
#define KID_CFSH	0x00530000	/* Cache Flush Counter Register */
#define KID_MTIM	0x00540000	/* Micro-second Timer Register */
#define KID_CND		0x00550000	/* Counter n Data Register */
#define KID_CNC		0x00560000	/* Counter n Control Register */
#define KID_CNQT	0x00570000	/* Counter n Qualifying TTYPE Register */
#define KID_CNQSZ	0x00580000	/* Counter n Qualifying SIZE Register */
#define KID_CNQSP	0x00590000	/* Counter n Qualifying Space Register */
#define KID_CNQTID	0x005A0000	/* Counter n Qualifying Transaction Identifier Register */
#define KID_CNQDID	0x005B0000	/* Counter n Qualifying Data Identifier Register */
#define KID_CNGSS	0x005C0000	/* Counter Global Snapshot Register */
#define KID_CNGEC	0x005D0000	/* Counter Global Enable Count Register */

#define KID_WTDR	0x00800000	/* Watcher Tag Data Register */
#define KID_WTIR	0x00810000	/* Watcher Tag Initialize Register */
#define KID_EWER	0x00820000	/* EAROM Write Enable Register */
#define KID_EWDR	0x00830000	/* EAROM Write Disable Register */
#define KID_KIPR	0x00840000	/* KI Probe Register (I = Request Interrupt Level) */
#define KID_WTAR	0x00850000	/* Watcher Tag Address Register */
#define KID_CFITR	0x00860000	/* Cache Flush and Invalidate Trigger Register */
#define KID_CFTR	0x00870000	/* Cache Flush Trigger Register */
#define KID_CFAR	0x00880000	/* Cache Flush Adress Register */
#define KID_CLDR	0x00890000	/* CPU Semaphore Lock Data Register */ 
#define KID_CLCR	0x008A0000	/* CPU Semaphore Lock Clear Register */
#define KID_CLSR	0x008B0000	/* CPU Semaphore Lock Set Register */
#define KID_CLLR	0x008C0000	/* CPU Semaphore Lock Register */
#define KID_CLUR	0x008D0000	/* CPU Semaphore Unlock Register */
#define KID_WFBT	0x008E0000	/* Watcher Flush Buffer Tag Register */

#define KID_BCS3	0x00910000	/* Board Control and Status Register 3 */
#define KID_LED 	0x00920000	/* LED Register */

#define KID_CTDR 	0x00A00000	/* Cache Tag Data Register */
#define KID_CTIR	0x00A10000	/* Cache Tag Initaialize Register */
#define KID_CTAR	0x00A20000	/* Cache Tag Address Register */
#define KID_CFBT	0x00A30000	/* Cache Flush Buffer Tag Register */

#define KID_BFTR	0x00B00000	/* Block Fill Trigger Register */
#define KID_BCTR	0x00B10000	/* Block Copy Trigger Register */
#define KID_BCSR	0x00B20000	/* Block Copy Status Register */
#define KID_COTR	0x00B30000	/* Cache Ownership Read Trigger Register */
#define KID_BCSA0	0x00B40000	/* Block Copy Source Address Register 0 */
#define KID_BCSA1	0x00B50000	/* Block Copy Source Address Register 1 */
#define KID_BCDA0	0x00B60000	/* Block Copy Destination Address Register 0 */
#define KID_BCDA1	0x00B70000	/* Block Copy Destination Address Register 1 */
#define KID_BCCR	0x00B80000	/* Block Copy Counter Register */
#define KID_BFDR	0x00B90000	/* Block Fill Data Register */
#define KID_COAR	0x00BA0000	/* Cache Ownership Read Address Register */
#define KID_AFCR	0x00BB0000	/* ASIC Fault Cause Register */
#define KID_AFAR	0x00BC0000	/* ASIC Fault Address Register */

#define WTAG_TFTR_TGR	KID_TFTR | TFTR_WTAG	/* Watcher Tag TFTR trigger */
#define CTAG_TFTR_TGR	KID_TFTR | TFTR_CTAG	/* Cache Tag TFTR trigger */
#define OWNERSHIP_READ	KID_TFTR | TFTR_OWNREAD	/* ownership read */

/*
 * FC, fault cause register, bit definitions
 */
#define FCR_IR		0x00000001	/* Inactivity reset occurred */
#define FCR_KM		0x00000002	/* Kbus Multi-bit ECC fault */
#define FCR_KT		0x00000004	/* Kbus timeout fault */
#define FCR_MM		0x00000008	/* Cache Multi-bit ECC fault */
#define FCR_SMT		0x00000010	/* Sync. Mbus timeout fault */
#define FCR_S3C		0x00000020	/* Sync. Cache fault */
#define FCR_MTI		0x00000040	/* Mbus Tag Inconsistency fault */
#define FCR_KAT		0x00000080	/* Kbus Asynchronous timeout */
#define FCR_KFT		0x00000100	/* Kbus Flush Timeout fault */

#define FCR_A3C		0x00000200	/* Async Cache fault */
#define FCR_A3M		0x00000400	/* Async Cache Multi-bit ECC fault */
#define FCR_AMT		0x00000800	/* Async Mbus timeout fault */
#define FCR_KTI		0x00001000	/* Kbus Tag Inconsistency fault */
#define FCR_CTP		0x00002000	/* Cache Tag Parity Fault */
#define FCR_WTP		0x00004000	/* Watcher Tag Parity Fault */
#define FCR_IRID	0x00008000	/* Inactivity Reset ID Field */
#define FCR_BITS	"\20\15Kbus_Tag\14Async_Mbus_TO\13Async_L3_MECC\12Async_L3_Cache\11Kbus_Flush_TO\10Kbus_FastIO_TO\7Mbus_Tag\6Sync_L3_Cache\5Sync_Mbus_TO\4Mbus_MECC\3Kbus_TO\2Kbus_MECC\1Inactivity_Reset"
#define FCR_CLR_MASK	0x0000FFFF	/* clear other bits */

#define FCR_ERR_BITS	(FCR_KTI|FCR_AMT|FCR_A3M|FCR_A3C|FCR_KFT|FCR_FT|FCR_MTI|FCR_S3C|FCR_SMT|FCR_MM|FCR_KT|FCR_KM)
#define	FCR_ECC_ERR	(FCR_KM|FCR_MM|FCR_A3M)
#define	FCR_TIMEOUT	(FCR_KT|FCR_SMT|FCR_FT|FCR_KFT|FCR_AMT)
#define	FCR_OTHER_ERR	(FCR_S3C|FCR_MTI|FCR_A3C|FCR_KTI)

#endif Series7
#endif	_kbus_cpuboard_h
