#ifndef lint
static char *Solbourne_id =
"@(#) if_prgconf.c 1.1@(#) Solbourne id 9/22/93 00:12:12\n";
#endif
/*
 * Copyright 1991 Solbourne Computer, Inc.
 * All rights reserved.
 */
#include "pg.h"
#if	NPG > 0

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/reboot.h>
#include <sys/uio.h>
#include <sys/mbuf.h>
#include <sys/buf.h>
#include <sys/map.h>
#include <sys/socket.h>
#include <sys/errno.h>
#include <sys/time.h>
#include <sys/kernel.h>
#include <sys/ioctl.h>

#include <net/if.h>
#include <net/if_arp.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <netinet/if_fddi.h>

#include <dev/mbvar.h>
#include <dev/ioasic.h>
#include <machine/sysboard.h>
#include <machine/mmu.h>
#include <machine/prom.h>
#include <machine/smpdefs.h>
#include <mfg/autoconf.h>

#include <if/if_prgreg.h>
#include <if/if_prgreg_fddi.h>
#include <if/if_prgvar.h>

int			prg_nprg = NPG;
int			prg_verbose = 1;
int			prg_verbose_mib = 0;
int			prg_ignore_cbfail = 0;
int			prg_xdma_align_conservative = 0;
int			prg_xdma_align = 0x1;
int			prg_xdma_copyloaned = 0;	/* faster free */
int			prg_xdma_copynocl = 1;
int			prg_xdma_alwayscopy = 0;
int			prg_panic_error = 1;
int			prg_panic_message = 0;
int			prg_max_drain_resp = 100;

struct mb_device	*prginfo[NPG];
struct prg_softc	prg_softc[NPG];
struct prg_dstat	prg_dstat[NPG];
slock 			prg_lock[NPG];
slock 			prg_b_lock[NPG];

/* TODO  ADD DATA STRUCTURES FOR INITIALIZATION OF FDDI SET MIB's */

/* parameters for boards supported by driver */
struct prg_conf	prg_conf[] = {
    {"V4211/2211", "FDDI-DAS", PC_TYPE_FDDI, 0
		|PC_FLAGS_BLOCK_R	/**/
		|PC_FLAGS_BLOCK_X	/**/
		|PC_FLAGS_XMIT_MBUF	/**/
		,				/* pc_flags */
	4,					/* pc_align_board */
	32,					/* pc_align_driver */
	22,					/* pc_min_tu */
	4096+256,				/* pc_max_tu */
	4512,					/* pc_buf_sz (multiple of 32) */
	32,					/* pc_nrecv */
	32 - 4,					/* pc_nrecv_loan (leave 4) */
	4,					/* pc_rx_throttle */
	16,					/* pc_nxmit (no dvma) */
	48,					/* pc_nxmit_dvma */
    	8,					/* pc_nxmit_frags */
	512,					/* pc_minlen_rdma_loan */
	45,					/* pc_max_xbackback */
	32,					/* pc_max_xdrain */
	1,					/* pc_resp_intr_timer - */
						/*   in 100's usec, 200usec */
						/*   resolution; 0 -> now  */
	20,					/* pc_xresp_intr_timer - */
						/*   in 100's usec, 200usec */
						/*   resolution; 0 -> now  */
	1,					/* pc_h2b_channels */
	2,					/* pc_b2h_channels: */
						/* STD_B2H_CH, and XMT_B2H_CH */
	8,					/* pc_segs_per_channel */
	2048,					/* pc_seg_size */
    },
    {"V5211", "FDDI-DAS", PC_TYPE_FDDI, 0
		|PC_FLAGS_BLOCK_R	/**/
		|PC_FLAGS_BLOCK_X	/**/
		|PC_FLAGS_XMIT_MBUF	/**/
		|PC_FLAGS_FLASH		/**/
		,				/* pc_flags */
	4,					/* pc_align_board */
	32,					/* pc_align_driver */
	22,					/* pc_min_tu */
	4096+256,				/* pc_max_tu */
	4512,					/* pc_buf_sz (multiple of 32) */
	32,					/* pc_nrecv */
	32 - 4,					/* pc_nrecv_loan (leave 4) */
	4,					/* pc_rx_throttle */
	16,					/* pc_nxmit (no dvma) */
	48,					/* pc_nxmit_dvma */
    	8,					/* pc_nxmit_frags */
	512,					/* pc_minlen_rdma_loan */
	45,					/* pc_max_xbackback */
	32,					/* pc_max_xdrain */
	1,					/* pc_resp_intr_timer - */
						/*   in 100's usec, 200usec */
						/*   resolution; 0 -> now  */
	20,					/* pc_xresp_intr_timer - */
						/*   in 100's usec, 200usec */
						/*   resolution; 0 -> now  */
	1,					/* pc_h2b_channels */
	2,					/* pc_b2h_channels: */
						/* STD_B2H_CH, and XMT_B2H_CH */
	8,					/* pc_segs_per_channel */
	2048,					/* pc_seg_size */
    },
    /* TODO: ETHERNET, TOKEN RING */
    {0,}
};
char	*prg_pc_type_ascii[] = PC_TYPE_ASCII;

/*
 * determine the transfer options (address modifier) to used based on
 * address/len/direction
 */
/*ARGSUSED*/
prg_xopts(ps, addr, len, memory_read)
struct prg_softc *ps;
caddr_t		addr;
{
    if (memory_read) {
	if ((ps->ps_pc->pc_flags & PC_FLAGS_BLOCK_X) == 0)
	    return (TOPTS_32BIT |
		(VME_AM_A24|VME_AM_SUPERVISORY|VME_AM_DATA_ACCESS));
	if ((((int)addr)&0x3) == 0)
	    return (TOPTS_32BIT |
		(VME_AM_A24|VME_AM_SUPERVISORY|VME_AM_BLOCK_TRANSFER));
	return (TOPTS_32BIT |
		(VME_AM_A24|VME_AM_SUPERVISORY|VME_AM_DATA_ACCESS));
    } else {
	if ((ps->ps_pc->pc_flags & PC_FLAGS_BLOCK_R) == 0)
	    return (TOPTS_32BIT |
		(VME_AM_A24|VME_AM_SUPERVISORY|VME_AM_DATA_ACCESS));
	/* we know that revieve dma buffers are aligned in length */
	return (TOPTS_32BIT |
		(VME_AM_A24|VME_AM_SUPERVISORY|VME_AM_BLOCK_TRANSFER));
    }
}

#endif
