/* @(#) systm.h 1.2@(#) Solbourne id 11/29/93 19:08:09 */
/*
 * Copyright 1990 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*	@(#)systm.h 2.22 89/08/16 SMI; from UCB 4.35 83/05/22	*/

/*
 * Random set of variables
 * used by more than one
 * routine.
 */

#ifndef _sys_systm_h
#define _sys_systm_h

#include <sys/types.h>
#include <sys/kmem_alloc.h>

extern	char version[];		/* system version */

/*
 * Nblkdev is the number of entries
 * (rows) in the block switch.
 * Used in bounds checking on major
 * device numbers.
 */
int	nblkdev;

/*
 * Number of character switch entries.
 */
int	nchrdev;

char	runin;			/* scheduling flag */
char	runout;			/* scheduling flag */

#if	NCPUS == 1
int	runrun;			/* scheduling flag */
char	curpri;			/* more scheduling */
#endif	NCPUS > 1

int	maxmem;			/* actual max memory per process */
int	physmem;		/* physical memory (to be) used by system */
int	physmax;		/* highest numbered physical page present */

extern	int intstack[];		/* stack for interrupts */
dev_t	rootdev;		/* device of the root */
struct	vnode *rootvp;		/* vnode of root filesystem */
struct	vnode  *dumpvp;		/* vnode to dump on */
long	dumplo;			/* offset into dumpvp */

u_int	max();
u_int	min();

#ifdef	solbourne
char 	*strcpy();
char 	*strncpy();
char 	*strncat();
char 	*strrchr();
char 	*strchr();
#define	softcall(func, arg)	softcall_parallel(func, arg, 0)
#define	sleep(chan, pri)	sleep_and_unlock(chan, pri, (slock_t)NULL)
#define	wakeup(chan)		proc_wakeup(chan, 0, 0)
u_int	vtop();
#endif	solbourne

struct	vnode *bdevvp();
struct	vnode *specvp();

/*
 * Structure of the system-entry table
 */
extern	struct sysent {
	short	sy_narg;	/* total number of arguments */
#ifdef	solbourne
	short	sy_parallel;	/* if true, can execute in parallel */
#define	SYSC_PARALLEL	1	/* system call can execute in parallel */
#define	SYSC_SERIAL	0	/* system call must execute serially */
#endif	solbourne
	int	(*sy_call)();	/* handler */
} sysent[];

#if	NCPUS > 1
int	noproc[];		/* no one is running on this cpu just now */
#else
int	noproc;			/* no one is running just now */
#endif	NCPUS > 1
char	*panicstr;
int	wantin;
int	boothowto;		/* reboot flags, from console subsystem */
int	selwait;

extern	char vmmap[];		/* poor name! */

/* casts to keep lint happy */
#define	insque(q,p)	_insque((caddr_t)q,(caddr_t)p)
#define	remque(q)	_remque((caddr_t)q)

/*
 * TRUE if the pageout daemon. This process can't sleep to get memory
 * else deadlock will result.
 */
#define	NOMEMWAIT() (u.u_procp == &proc[2])

#endif /*!_sys_systm_h*/
