/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)tftp.h	5.1 (Berkeley) 5/30/85
 */

/*
 * Trivial File Transfer Protocol (IEN-133)
 */
#define	SEGSIZE		512		/* data segment size */

/*
 * Packet types.
 */
#define	TFTP_RRQ	01		/* read request */
#define	TFTP_WRQ	02		/* write request */
#define	TFTP_DATA	03		/* data packet */
#define	TFTP_ACK	04		/* acknowledgement */
#define	TFTP_ERROR	05		/* error code */

/*
 * format of a tftp packet
 */
struct	tftppkt {
	short		th_opcode;	/* packet type */
	short		th_misc;
	char		th_data[SEGSIZE]; /* data or error string */
};

#define	th_block	th_misc
#define	th_code		th_misc
#define	th_stuff	th_misc
#define	th_msg		th_data

/*
 * Error codes.
 */
#define	TFTP_EUNDEF	0		/* not defined */
#define	TFTP_ENOTFOUND	1		/* file not found */
#define	TFTP_EACCESS	2		/* access violation */
#define	TFTP_ENOSPACE	3		/* disk full or allocation exceeded */
#define	TFTP_EBADOP	4		/* illegal TFTP operation */
#define	TFTP_EBADID	5		/* unknown transfer ID */
#define	TFTP_EEXISTS	6		/* file already exists */
#define	TFTP_ENOUSER	7		/* no such user */
#define	TFTP_ERR_MESSAGES  {			\
	"not defined",				\
	"file not found",			\
	"access violation",			\
	"disk full or allocation exceeded",	\
	"illegal TFTP operation",		\
	"unknown transfer ID",			\
	"file already exists",			\
	"no such user", 			\
	NULL}

/*
 * tftp network port numbers
 */
#define TFTPPORT_SERVER	69		/* tftp server port on other machine */
#define TFTPPORT_SA	1025		/* port on my machine */

/*
 * data in octet mode
 */
#define TFTP_MODE	"octet"

/*
 * timeout and retry information timeout 
 */
#define TFTP_RETRIES	3

/*
 * tftp network connection information
 */
#define FNSIZE		256

struct tftp_info {
	char		ti_filename[FNSIZE];	/* file name */
	int		ti_timeout;		/* timeout pending */
	int		ti_count;		/* number of bytes transfered */
	short		ti_block;		/* tftp block number */
	short		ti_eof;			/* eof encountered */
};
