/*	@(#)stand.h	1.4	*/

/*
 * Header file for standalone package
 */

#ifndef ASSEMBLER
#include <sys/types.h>
#include <kap/dklabel.h>
#endif

#ifdef ROM
#define	getenv	rom_getenv
#endif

/*
 * misc defines
 */
#ifndef min
#define min(a,b)	((a) < (b) ? (a) : (b))
#endif min
#ifndef	nel
#define	nel(a)		(sizeof(a)/sizeof(*(a)))
#endif	nel
#ifndef	roundup
#define	roundup(x, y)   ((((x)+((y)-1))/(y))*(y))
#endif	roundup
#ifndef	within
#define within(a, b, x)	((x) >= (a) && (x) <= (b))
#endif	within
#ifndef NULL
#define NULL		0
#endif 
#define NULLSTR		(char *)-1 
#ifndef EOF
#define EOF		(-1)
#endif
#define INDIR		3		/* number of levels of indirection */
#define	NBPSCTR		512		/* Bytes per disk sector. */
#define SCTRSHFT	9		/* Shift for NBPSCTR. */
#define	MAXADDR		0xffffffff	/* largest address possible */
#define MAXSEGS		2
#ifdef SIMULATOR
#define MAXMEM		0x100000
#endif
#define MINMEM		0

/*
 * misc exception related constants
 */
#define	EVEC_MIN	0		/* minimum allowed vector entry */
#define EVEC_MAX	255		/* maximum allowed vector entry */
#define EVEC_MULTIPLE	16		/* entries multiple of this num bytes */

/*
 * name assumed for RTC device
 */
#define	CLOCKDEV	"tm(0,0,0)"

/*
 * defines pertaining to environment information
 */
#define	MAXENV		32	/* maximum number of environment variables */
#define MAXENVSTR	128	/* max length of environ string "name=value" */

#define STDIN	0
#define STDOUT	1
#define STDERR	STDOUT

/*
 * I/O block flags
 */
#define F_READ		0x0001	/* open for reading */
#define F_WRITE		0x0002	/* open for writing */
#define F_ALLOC		0x0004	/* slot allocated by open */
#define F_FILE		0x0008	/* file specified */
#define F_LABEL		0x0010	/* label read */
#define F_NBLOCK	0x0020	/* non-blocking io */
#define F_GETINPUT	0x0040	/* device supports async poll */
#define F_POLLACTIVE	0x0080	/* async poll active */
#define	F_INPUTAVAIL	0x0100
#define	F_NOFILE	0x0200
#define F_REMOTE	0x0400
#define F_RDEBUG	0x0800	/* device is being used for remote debugging */

/*
 * Request codes -- must be the same as above
 */
#define	READ		F_READ
#define	WRITE		F_WRITE	

#ifndef ASSEMBLER

/*
 * command table entry structure
 */
struct cmd_entry {
unsigned char   cmd_abbrv;      /* # chars in shortest allowable abbreviation */         
	 char   *cmd_name;      /* command name string */
	 int    (*cmd_map)();   /* function pointer */
	 char   *cmd_usage;     /* command usage message string */
};

/*
 * device switch table -- initialized in conf.c
 */
struct devsw {
	char	*dv_name;		/* device name */
	char	*dv_desc;		/* device description */
	int	dv_devtype;		/* device type, see below */
	int	(*dv_init)();		/* device initialization routine */
	int	(*dv_strategy)();	/* device strategy routine */
	int	(*dv_open)();		/* device open routine */
	int	(*dv_close)();		/* device close routine */
	int	(*dv_ioctl)();		/* device ioctl routine */
	struct fssw *dv_fssw;		/* pointer to file system switch */
};
extern struct devsw _devsw[];
#endif

/*
 * different device types
 */
#define DEVTYPE_CHAR		0x0001	/* character device */
#define DEVTYPE_BLOCK		0x0002	/* block device */
#define DEVTYPE_RAW		0x0004	/* raw device */
#define DEVTYPE_TTY		0x0008	/* tty device */
#define DEVTYPE_ALIGN		0x4000	/* align address/lenght for transfers */
#define DEVTYPE_MENU		0x8000	/* print device in menu */
#define	DEVTYPE_PROTOCOL	0x1000	/* protocol device, use hw switch */
#define	DEVTYPE_PROTO_MSK	0x1F00	/* protocol mask */
#define	DEVTYPE_SCSI		0x1100	/* scsi protocol device */
#define	DEVTYPE_NET		0x1200	/* network protocol device */

#ifndef ASSEMBLER
/*
 * hardware switchs
 */
union hwsw {
    struct scsisw {			/* SCSI host adaptor switch */
	char	*ss_name;		/* host adaptor name */
	char	*ss_desc;		/* host adaptor description */
	int	(*ss_init)();		/* initialize host adaptor data */
	int	(*ss_cinit)();		/* initialize host adaptor */
	int	(*ss_cdone)();		/* uninitialize host adaptor */
	int	(*ss_docmd)();		/* execute command */
	int	(*ss_perror)();		/* print host adaptor err msg */
	int	ss_maxcnt;		/* largest size dma to try */
	int	ss_retry;		/* number of software retries */
    }		hw_scsi;
    struct netsw {			/* network switch */
	char	*ns_name;		/* controller name */
	char	*ns_desc;		/* controller description */
	int	(*ns_init)();		/* initialize data structures */
	int	(*ns_cinit)();		/* initialize controller */
	int	(*ns_cdone)();		/* uninitialize controller */
	int	(*ns_rcv)();		/* recieve */
	int	(*ns_perror)();		/* print controller err msg */
    }		hw_net;
};
extern struct scsisw	_scsisw[];
extern struct netsw	_netsw[];
#endif

#ifndef ASSEMBLER
/*
 * file system switch table - initialized in conf.c
 */
struct fssw {
	char	*fs_name;		/* file system name */
	int	(*fs_init)();		/* file system init routine */
	int	(*fs_open)();		/* file system open routine */
	int	(*fs_close)();		/* file system close routine */
	int	(*fs_read)();		/* file system read routine */
	int	(*fs_write)();		/* file system write routine */
	int	(*fs_ioctl)();		/* file system ioctl routine */
};
extern struct fssw *_fssw[];
#endif

/*
 * I/O block: includes an inode,
 * cells for the use of seek, etc,
 * and a buffer.
 *
 * Note: i_fsbuf and i_devbuf should be cast to pointers to the
 * appropriate structure type in their respective file system
 * or device driver routine. 
 *
 * Also: i_ac is really of type struct arpcom *, but was not
 * defined that way here so routines that don't need it don't
 * have include problems
 */
#define BLKSIZ		1024
#define FSBUFSIZE	8192
#define DEVBUFSIZE	512
#define NFILES		6

#ifndef ASSEMBLER
struct iob {
	int		i_flgs;		/* see F_ above */
	struct devsw	*i_dp;		/* pointer into device/proto switch */
	union hwsw	*i_hw;		/* pointer into hardware switch */
	struct fssw	*i_fs;		/* file system switch */
	int		i_ctlr;		/* controller number */
	int		i_unit;		/* pseudo device unit */
	int		i_devid;	/* device specific id, i.e. part num */
	char		*i_fn;		/* file name */
	int		i_ioaddr;	/* device io address */
	int		i_cc;		/* character count of transfer */
	off_t		i_offset;	/* seek offset in file */
	int		i_nbsec;	/* number of bytes per sector */
	daddr_t		i_bn;		/* 1st block # of next read */
	int		i_error;	/* error # return */
	char		*i_ma;		/* memory address of i/o buffer */
	char		*i_buf;		/* i/o buffer */
	char		*i_fsbuf;	/* fs info. e.g. super block */
	char		*i_devbuf;	/* dev info, e.g. inode */
	char		*i_ac;		/* Ethernet/ARP information */
	struct dk_label	i_label;	/* disk label */
};

extern struct iob _iobuf[NFILES];
extern char	ibufs[NFILES][FSBUFSIZE];
extern char	ifsbufs[NFILES][FSBUFSIZE];
extern char	idevbufs[NFILES][DEVBUFSIZE];
extern int	printf_silent;

/* struct used by stand-alone readdir */
struct dirstuff {
	int loc;
	struct iob *io;
};

/*
 * circular character buffers used by tty drivers
 */
struct char_buf {
	short	cb_flags;		/* misc flag information */
	short	cb_nlcount;		/* number of newlines in buffer */
	int	cb_tabcnt;		/* used for expanding tabs on output */
	int	cb_count;		/* buffer character count */
	int	cb_refcnt;		/* reference count */
	char	*cb_read;		/* read pointer */
	char	*cb_write;		/* write pointer */
	char	cb_buf[BLKSIZ];		/* circular character buffer */
};

#define CB_EMPTY(cb)	((cb)->cb_count == 0)
#define CB_FULL(cb)	((cb)->cb_count == (BLKSIZ-1))
#endif

/*
 * character buffer flags 
 */
#define CB_RAW		0x0001		/* no io processing */
#define CB_STOPPED	0x0002		/* stop output */
#define CB_XTABS	0x0004		/* expand tabs */
#define CB_CRMOD	0x0008		/* map \r to \r\n on output */
#define	CB_BUSY		0x0010		/* output busy */

/*
 * default special output characters
 */
#define CBS		'\b'
#define CHT		'\t'
#define CNULL		'\0'
#define CNL		'\n'
#define CCRTN		'\r'
#define CSP		' '
#define BELL		0x7
#define TABLEN		8

/*
 * standalone library ioctls
 */

/*
 * file ioctls
 */
#define FIOC		('F'<<8)
#define FIOCGETINPUT	(FIOC|1)	/* get pending input */
#define FIOCNBLOCK	(FIOC|2)	/* do not block waiting for input */

/*
 * tty ioctls
 */
#define TIOC		('T'<<8)
#define TIOCCRMOD	(TIOC|1)	/* map \r to \r\n on output */
#define TIOCXTABS	(TIOC|2)	/* expand tabs */
#define TIOCRAW		(TIOC|3)	/* no io processing */
#define TIOCLOGO	(TIOC|4)	/* put out logo */

/*
 * network ioctls
 */
#define NIOC		('N'<<8)

/*
 * RTC ioctls
 */
#define	RIOC		('R'<<8)
#define	RIOCGGMT	(RIOC|1)	/* get GMT from RTC clock */
#define	RIOCSGMT	(RIOC|2)	/* set GMT into RTC clock */

