/* $Header$ */

/* Define Serial Line Protocol Packets */

#define SOH_COUNT	3
#define PKT_MAX		224	/* maximum data length */

struct slp_packet {
	unsigned char pre[SOH_COUNT];	/* 3 SOH's of preamble */
	unsigned char type;	/* char indicating pkt type */
	unsigned char seq;	/* packet sequence number */
	unsigned char csum;	/* 8 bit check sum, csum assumed 0 when doing csum */
	unsigned short len;	/* data length */
	unsigned char data[PKT_MAX];  /* the variable length data */
};

#define SLP_SIZE	sizeof(struct slp_packet)	/* size of struct slp_packet */
#define	SLP_HDRSIZ	(SOH_COUNT+5)

/* packet types */
#define REQ_TYPE	'\002'	/* request for server */
#define	POLL_TYPE	'\005'	/* poll for server originated requests */
#define ACK_TYPE	'\006'	/* acknowledge from server */

#define MAX_RETRIES	15
#define DLY_TIME	15
#define	SLP_PKTTO	20	/* seconds to wait for packet read time out */

#define SOH		'\001'

/* error returns */
#define	SLP_READERR	-1	/* read I/O error */
#define	SLP_READTO	-2	/* read packet timed out error */
#define	SLP_CKSUM	-3	/* read packet checksum error */
#define	SLP_WRITEERR	-4	/* write I/O error */
#define SLP_TOOBIG	-5	/* write packet too large */
