/*
 * Command block sent from the upper level driver to the lower level for 
 * command initiation.  On completion or termination of the command the 
 * lower level driver fills in completion status, and sense information.
 */
struct	scsi_cb {
	char		*cb_addr;		/* data start address */
	u_int		cb_len;			/* amount of data */
	union scsi_cdb	cb_cdb;			/* command block */
	u_int		cb_flags;		/* command flags */
#define			CB_FLAGS_IE	0x0001	/*   enable interrupts */
#define			CB_FLAGS_NSYNC	0x0002	/*   negotiate synchronous */
#define			CB_FLAGS_DISC	0x0004	/*   allow dissconnect */
#define			CB_FLAGS_RSENSE	0x0008	/*   request sense on check */
#define			CB_FLAGS_SILENT	0x0010	/*   no messages */

	int		cb_err;			/* host adaptor specific err */
#define			CB_ERR_OK	0	/*   no host adaptor err */
	union scsi_scb	cb_scb;			/* scsi completion status */
	union scsi_sns	cb_sns;			/* if CB_FLAGS_RSENSE */
};

#define	TARGET(io)	((io)->i_unit & 0x07)
#define	LUN(io)		(((io)->i_unit >> 4) & 0x07)

#define	SET_CB(cb, addr, len, flags)	{				\
	(cb)->cb_addr = (char *)(addr);					\
	(cb)->cb_len = len;						\
	(cb)->cb_flags = flags;		}
	
