/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)mbuf.h	7.3 (Berkeley) 9/11/86
 */

/* Constants related to memory allocator. */
#define	MMINOFF		0
#define	MMAXOFF		100
#define	MLEN		(ETHERMTU+MMAXOFF+32)

/* Allocate some mbufs per socket + xmit + recv + arp */
#define MAXMBUFS	2		/* max mbufs q'd per socket */
#define NUMMBUFS	(NUMSOCKETS * MAXMBUFS + 3)

/* mbuf head to typed data */
#define	mtod(x,t)	((t)(&(x)->m_dat[(x)->m_off]))

/* memory buffer for network code */
struct mbuf {
	short		m_len;		/* amount of data in this mbuf */
	short		m_off;		/* offset of data from m_dat */
	struct sockaddr	m_srcaddr;
	char		m_dat[MLEN];	/* data storage */
	struct mbuf	*m_act;		/* link in higher-level mbuf list */
};

/* flags to m_get */
#define	M_DONTWAIT	0
#define	M_WAIT		0

extern struct mbuf *m_get(), *so_remove();
