/* @(#) sysboard.h 1.1@(#) Solbourne id 9/21/93 23:59:30 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*
 * This header file contains information specific to the system board
 */

#ifndef	sysboard_h
#define	sysboard_h

/*
 * The vme address map can map 16M of vme space into the 4G system space
 * on a page basis. The base of the map is VME_MAP_BASE. The map entry
 * for each VME page is the first 4 bytes of that page. For example,
 * the map entry for 0x83000000 is the first four bytes at 0x83000000.
 * Map entries look like ptes, with bits 1 through 12 unused.
 */
#define VME_MAP_BASE	0x83000000
#define VME_PAGESIZE	8192
#define VME_PAGEOFFSET	(VME_PAGESIZE-1)
#define VME_MAP_SPAN	VME_PAGESIZE
#define VME_MAP_SIZE	2048
#define VME_MAP_SPACE	(VME_MAP_SIZE * VME_MAP_SPAN)
#define VME_MAP_PFN	0xffffe000
#define VME_MAP_V	0x1

#ifndef	LOCORE
/*
 * a VME map pte
 */
struct vme_pte {
	unsigned int	pg_pfnum:19;	/* page frame number */
	unsigned int	pg_unused:11;	/* unused bits */
	unsigned int	pg_peek:1;	/* pte also in cpu mmu */
	unsigned int	pg_v:1;		/* valid bit */
};
#endif	LOCORE
/*
 * flags for valid/invalid VME map entries
 */
#define	VME_INVALID	0
#define	VME_VALID	1

/*
 * A16 vme masters can only be allocated certain entries in 
 * the vme map since they only put out 16 bits of address
 */
#define VME_MAP_A16_MIN		2040
#define VME_MAP_A16_MAX		2047
#define VME_MAP_A16_NENTRIES	8

/*
 * Various I/O space related constants
 */
#define	VME16_BASE_USR	0x84FF0000	/* short supervisor access */
#define	VME16_BASE	0x85FF0000	/* short supervisor access */
#define	VME16_SIZE	(1<<16)
#define	VME16_MASK	(VME16_SIZE-1)

#define	VME24_BASE_USR	0x86000000	/* standard supervisor access */
#define	VME24_BASE	0x87000000	/* standard supervisor access */
#define	VME24_SIZE	(1<<24)
#define	VME24_MASK	(VME24_SIZE-1)

#define	VME32_BASE_USR	0x80000000	/* extended supervisor access */
#define	VME32_BASE	0x81000000	/* extended supervisor access */
#define	VME32_SIZE	(1<<24)
#define	VME32_MASK	(VME32_SIZE-1)

/*
 * the status of each entry in the mh_vmemap, in the mb_hd structure, is 
 * indicated by the following constants
 */
#define VMEMAP_INUSE	1
#define VMEMAP_FREE	0

/*
 * To acknowledge a vme interrupt and get the vme vector, 
 * read the location VME_IACK_BASE + (2 * vme_ipl). This location is
 * read as a short with the lower byte containing the vme vector
 */
#define VME_IACK_BASE	0x82000000
#define VME_NUMIPL	7
#define VME_MINIPL	1
#define VME_MAXIPL	7

/*
 * The system board is capable of interrupting a processor by either
 * directed and or undirected interrupts. The system interrupt register
 * specifies whether directed or undirected interrupts are to be used.
 * This register is read/written as one byte.
 */
#define SBIR		0x17030000	/* system board interrupt register */
#define SBIR_DI		0x00000040	/* 1==directed intr, 0==undirected */
#define SBIR_INFO	0x0000003f	/* for undir intr, information */
#define SBIR_DDID	0x0000003f	/* for dir intr, dest dev id */

#define SBIDIS		0x17030000	/* read to disable system brd intrs */
#define SBIEN		0x17031000	/* read to enable system brd intrs */

/*
 * The ASIC has an interrupt register which indicates the cause of an
 * interrupt on vector BASE+3(or 131) of the hardware related interrupt 
 * vectors. Note that this page is also the page containing the SCSI
 * and Ethernet device specific registers for that system board.
 */
#define	ASIC_IR		0x90000000	/* location of register */
#define ASIC_IR_VME	0x0001		/* vme panic interrupt */
#define ASIC_IR_SCSI	0x0002		/* scsi page overflow */

#define	IOASIC_ADDR	0x90000000	/* location of asic control registers */
#define	WD33C93A_ADDR	0x90000800	/* location of WD33C93A registers */
#define	WD33C93A_OFFSET	0x00000800
#define	LANCE_ADDR	0x90001000	/* location of LANCE registers */
#define	LANCE_OFFSET	0x00001000

#define	IO_RESET_VMEINT	0x17140000	/* write to reset, read for vmeintr */
#define	IO_RESET_ASIC_ADDR	0x10	/* will unreset automaticaly */
#define	IO_RESET_SCSI_ADDR	0x20	/* remove by reading mh_unreset_va */
#define	IO_RESET_VME_ADDR	0x40	/* remove by reading mh_unreset_va */
#define	IO_RESET_LANCE_ADDR	0x80	/* pseudo: turn off ioasic lance */
#define IO_RESET_ALL		0xF0	/* reset asic, vme, and scsi, lance */
#define	IO_VMEINT_LEVEL_SHFT	4	/* vmelevel to address shift for read */
#define	IO_VMEINT_PEND_BIT	0x80000000	/* vme interrupt pending bit */
#define	IO_VMEINT_PFETCH_DONE	0x40000000	/* scsi prefetch done bit */

#define	SYS_RESET	0x17000001	/* write byte to reset system */
#define	IO_UNRESET	0x17000000	/* read byte to unreset */
#endif	sysboard_h
