/* @(#) sic.h 1.1@(#) Solbourne id 9/21/93 23:59:14 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

#ifndef _SIC_
#define _SIC_

/*
 * Kbus CPU serial interrupt controller's registers
 *	DIR	device id register
 *	IPR	interrupt priority register
 *	IRC	interrupt receiver control register	
 *	IXR	interrupt transmit register
 *	IXC	interrupt transmitter control register
 *	IPV	interrupt pending vector register
 */
#define NUM_IPL		256 		/* num interrupt priority levels */

#define DIR_MASK	0x003f		/* current device id */
#define IPR_MASK	0x00ff		/* current interrupt priority level */
#define IPR_CLR_MASK	0xffff0000	/* clear bits always read as 1's */
#define IRXC_E		0x0001		/* receiver enable bit */
#define IRXC_P		0x0002		/* interrupt pending bit */
#define IRXC_CLR_MASK	0xfffffffc	/* clear bits always read as 1's */
#define IRC_E		0x0001		/* receiver enable bit */
#define IRC_P		0x0002		/* interrupt pending bit */
#define IRC_CLR_MASK	0xfffffffc	/* clear bits always read as 1's */

#define IPV_IVL		0xff00		/* pending interrupt vector level */
#define IPV_DIR		0x0040		/* directed interrupt if set */
#define IXR_BRDCST	0x0080		/* broadcast interrupt if set */
/* NOTE: broadcast interrupts only on Series5 and above */
#define IPV_INFO	0x003f		/* misc info if undirected interrupt */
#define IPV_DDID	0x003f		/* dest dev id if directed interrupt */
#define IPV_CLR_MASK	0xffff0000	/* clear bits always read as 1's */

#define IXR_IVL		0xff00		/* interrupt vector level */
#define IXR_DIR		0x0040		/* directed interrupt if set */
#define IXR_INFO	0x003f		/* misc info if undirected interrupt */
#define IXR_DDID	0x003f		/* dest dev id if directed interrupt */
#define IXR_CLR_MASK	0xffff0000	/* clear bits always read as 1's */
#define ITXC_X		0x0001		/* transmitter enable bit */
#define ITXC_G		0x0002		/* interrupt ack'd bit */
#define ITXC_CLR_MASK	0xfffffffc	/* clear bits always read as 1's */
#define IXC_X		0x0001		/* transmitter enable bit */
#define IXC_G		0x0002		/* interrupt ack'd bit */
#define IXC_CLR_MASK	0xfffffffc	/* clear bits always read as 1's */

#define IVL_SHIFT	8

/*
 * base of system board (I/O board) interrupt range
 */
#define	IOINTBASE	0x80		/* system/IO board interrupt base */
#define IOINTMAX	0x8f		/* highest system board intr level */
/*
 * base of kernel interrupt tables
 */
#define INTBASE		0x80		/* kernel tables biased by this */

/*
 * used to software generate level 3, 2, and 1 interrupts
 */
#define	IR_SOFT_INT3	0x08	/* cause software level 3 interrupt */
#define	IR_SOFT_INT2	0x04	/* cause software level 2 interrupt */
#define	IR_SOFT_INT1	0x02	/* cause software level 1 interrupt */

/*
 * interrupt levels set in the IPR for their corresponding spl routines
 * traditional kernel spl levels 0-7 are mapped to 0-255 levels in sic
 *
 * Since SPL_HIGH traditionally implies blocking clock and device interrupt
 * it is not the highest. This allows tlb-shoots to get acknowledged quicker.
 * A new spl level called SPL_BLOCK is defined. This is same as splsched but
 * is created to clarify the purpose.
 */

#define SPL_0		0		/* all interrupts allowed */
#define SPL_SOFTCLOCK	128		/* software clock interrupts */
#define SPL_NET		SPL_SOFTCLOCK	/* software network interrupts */
#define	SPL_1		130		/* VME level 1 */
#define SPL_2		132		/* VME level 2 */
#define SPL_FB		133		/* frame buffer interrupts */
#define SPL_IMP		135		/* network device interupts */
#define	SPL_3		SPL_IMP		/* VME level 3 (block IMP) */
#define SPL_BIO		136		/* disk/tape device interrupts */
#define	SPL_4		SPL_BIO		/* VME level 4 */
#define SPL_TTY		139		/* tty device interrupts */
#define	SPL_ZS		SPL_TTY
#define	SPL_5		SPL_TTY		/* VME level 5 (block TTY) */
#define SPL_VME		140		/* all vme interrupts */
#define SPL_HARD_CLOCK	141		/* hardclock interrupt */
#define SPL_CLOCK	142		/* highest scheduling clock interrupt */
#define	SPL_6		SPL_CLOCK	/* VME level 6 (must block CLOCK) */
#define	SPL_RELAY_CLOCK	SPL_CLOCK	/* slave clock tick level */
#define SPL_HIGH	SPL_CLOCK	/* no clock or vme interrupts */
#define	SPL_PROF	143		/* profiling clock level */
#define SPL_VM		145		/* used by vm code for pmap updates */
#define SPL_RELAY_PROF	147		/* profiling relay interrupt */
#define SPL_PROFILING	SPL_RELAY_PROF
#define SPL_SCHED	255		/* used by scheduling code */
#define	SPL_7		SPL_SCHED
#define	SPL_BLOCK	SPL_7           /* used for mach specific code */
#endif _SIC_

