/* @(#) prom.h 1.2@(#) Solbourne id 12/16/93 19:33:04 */
/*
 * Copyright 1991 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*
 * Definitions for ROM entry point vectors:
 *	Each entry consists of eight bytes, a pointer to the
 *	desired location followed by a nop.
 *	The table resides at the beginning of physical memory.
 *	There are also pointers to such things as the ROM
 *	version number and the prom/standalone communication area.
 * The following conventions will be used:
 *	The ROM text and data will be mapped at virtual address
 *	ROM_BASE_VA and the ROM data/bss will be at ROM_DATA_VA.
 *	The ROM will allocate pages for its data/BSS starting at physical
 *	page 1.
 *	When calls are made to the ROM, the arguments will be passed
 *	in the prom/standalone communication area.
 *
 * NOTE: the kernel is a standalone
 */

#define	ROM_BASE_VA	ROM_WINDOW			/* Virtual address of ROM base */
#define	ROM_DATA_VA	(PHYSICAL_WINDOW+MSIM_START_PAGE+0x2000)	/* Virtual address of ROM data/bss */
#if defined(Series4) || defined(Series5)
#define	ROM_STACK_VA	(PHYSICAL_WINDOW+MSIM_START_PAGE+0x2000)	/* Virtual address of ROM data/bss */
#endif /* Series4 || Series5 */
#if	defined(Series6) || defined(Series7)
#define	ROM_STACK_VA	(PHYSICAL_WINDOW+MSIM_START_PAGE+0x8000)	/* Virtual address of ROM data/bss */
#endif /* Series6 || Series7 */
#define	ROM_VECTORS	(PHYSICAL_WINDOW+MSIM_START_PAGE)		/* address to find rom vectors */
#define	ROM_VERSION	(ROM_VECTORS+0)			/* ptr to ROM version string */
#define	ROM_COMMAREA	(ROM_VECTORS+8)			/* ptr to ROM/SA comm area */
#define	ROM_COMMAND	(ROM_VECTORS+16)		/* ROM cmd execute vector */
#define	ROM_SLAVEHALT	(ROM_VECTORS+24)		/* slave halt entry address */
#define	ROM_MSGBUFP	(ROM_VECTORS+32)		/* ptr to printf msgbuf */
#define	ROM_DGRAM	(ROM_VECTORS+40)		/* DGRAM format revision  */
#define	ROM_EEVERSION	(ROM_VECTORS+48)		/* EEPROM format revision  */
#define	ROM_REVISION	(ROM_VECTORS+56)		/* ROM revision level */
#define	ROM_EMDUMP	(ROM_VECTORS+64)		/* Ptr to Kernel core dump routine */
#define	ROM_VECTORS_END	(ROM_VECTORS+72)		/* end of vectors */

#define	ROM_MAXPARAM	8		/* max no. of params for ROM routine */
#define	ROM_INTERNATIONAL	1	/* rev level supporting loadable kbds */
#define	ROM_REV_LEVEL	1		/* ROM rev level */

#if !defined(ASSEMBLER) && !defined(LOCORE)
/*
 * Structure of ROM resetflags[] entries
 */
struct resetflag {
	char	*name;
	int	value;
};

/*
 * Structure of the prom/standalone communication area.
 */


struct prom_sa_comm {
	char	*commptr;	/* pointer to command prom should execute */
	int	retval;		/* return value from prom */
	int	firstfree;	/* 1st free mem page after pages used by ROM */
	int	memsize;	/* size of memory in megabytes */
	int	ramdisk;	/* size of ramdisk in megabytes */
	char	*iomap_addr;	/* points to area with misc IO addr info */
				/* really a pointer to a struct iomap */
	int	(*slave_start)(); /* address for slaves to start execution at */
	int	row, col;	/* cursor position on console */
	int	silent;		/* prom command in silient mode ? */

#endif !ASSEMBLER && !LOCORE

/* 
 * first part of dtrap_regs[] array.  These registers are transferred
 * from DGRAM into dtrap_regs[] in the dtrap_dump() routine.
 */
#define DTRAP_PC	0
#define DTRAP_NPC	1
#define DTRAP_TBR	2
#define DTRAP_PSR	3
#define DTRAP_FCR	4

#if defined(Series4) || defined(Series5) || defined(STIMULUS)
#define DTRAP_REG_START	5
#endif

#if	defined(Series6) || defined(Series7)
#define DTRAP_MFSR	5
#define DTRAP_MFAR	6	
#define	DTRAP_CNTX	7
#define DTRAP_CNTXP	8 	
#ifdef viking
#define DTRAP_MCNTL	9 	
#define DTRAP_MXCTL	10
#define DTRAP_MXRST	11
#define DTRAP_MXER0	12
#define DTRAP_MXER1	13
#define DTRAP_MXST0	14
#define DTRAP_MXST1	15
#endif viking
#ifdef cypress
#define DTRAP_SCR	9
#define DTRAP_AFSR	10
#define DTRAP_AFAR	11
#define DTRAP_RR	12
#endif cypress
#define DTRAP_RES3	16	/* reserved for future use */
#define DTRAP_RES4	17	/* reserved for future use */
#define DTRAP_REG_START	(DTRAP_RES4+1)
#endif 	Series6 || Series7

/*
 * registers saved by the reg_save() routine in this order in DGRAM
 */
#define REG_G0		0
#define REG_G1		1
#define REG_G2		2
#define REG_G3		3
#define REG_G4		4
#define REG_G5		5
#define REG_G6		6
#define REG_G7		7
#define REG_O0		8
#define REG_O1		9
#define REG_O2 		10
#define REG_O3 		11
#define REG_O4 		12
#define REG_O5 		13
#define REG_O6 		14
#define REG_O7 		15
#define REG_L0 		16
#define REG_L1 		17
#define REG_L2 		18
#define REG_L3 		19
#define REG_L4 		20
#define REG_L5 		21
#define REG_L6 		22
#define REG_L7 		23
#define REG_I0 		24
#define REG_I1 		25
#define REG_I2 		26
#define REG_I3 		27
#define REG_I4 		28
#define REG_I5 		29
#define REG_I6 		30
#define REG_I7 		31
#define REG_PSR 	32
#define REG_Y 		33
#define REG_WIM		34
#define REG_TBR 	35
#define REG_DIR 	36
#define REG_IPR 	37
#define REG_IXR		38
#define REG_IPV 	39
#define REG_ITXC	40
#define REG_IRXC 	41

#if defined(Series4) || defined(Series5) || defined(STIMULUS)
#define REG_FCR		42
#define REG_FES		43
#define REG_FPAR	44
#define REG_FVAR	45
#define REG_MMCR	46
#define REG_PDBA	47
#define REG_BID		48
#define EB_SIZE		49
#endif /* Series4 || Series5 || STIMULUS */

#if	defined(Series6) || defined(Series7)
#define REG_FCR		42
#define REG_BCS		43
#define REG_MFID	44
#define REG_AMMS	45
#define REG_ADFA	46
#define REG_KSS		47
#define REG_KSFA	48
#define REG_KMS		49
#define REG_KMFA	50
#define REG_AMSS	51
#define REG_MSFA	52
#define REG_MMS		53
#define REG_MMFA	54
#define REG_SDFA	55
#define REG_KTS		56
#define REG_KTFA	57
#define REG_KAFA	58
#define REG_MCNTL	59
#define REG_CNTXP	60
#define REG_CNTX	61
#define REG_MFSR	62
#define REG_MFAR	63
#define REG_MXER0	64
#define REG_MXER1	65
#define REG_MXST0	66
#define REG_MXST1	67
#define REG_MXRST	68
#define EB_SIZE		69
#define S6_EB_SIZE	EB_SIZE
#endif /* Series6 || Series7 */

/*
 * dtrap_dump() routine puts the above registers in the dtrap_regs[] 
 * array in this order
 */ 
#define DTRAP_REG_G0	(DTRAP_REG_START+REG_G0)
#define DTRAP_REG_G1	(DTRAP_REG_START+REG_G1)
#define DTRAP_REG_G2	(DTRAP_REG_START+REG_G2)
#define DTRAP_REG_G3	(DTRAP_REG_START+REG_G3)
#define DTRAP_REG_G4	(DTRAP_REG_START+REG_G4)
#define DTRAP_REG_G5	(DTRAP_REG_START+REG_G5)
#define DTRAP_REG_G6	(DTRAP_REG_START+REG_G6)
#define DTRAP_REG_G7	(DTRAP_REG_START+REG_G7)
#define DTRAP_REG_O0	(DTRAP_REG_START+REG_O0)
#define DTRAP_REG_O1	(DTRAP_REG_START+REG_O1)
#define DTRAP_REG_O2	(DTRAP_REG_START+REG_O2)
#define DTRAP_REG_O3	(DTRAP_REG_START+REG_O3)
#define DTRAP_REG_O4	(DTRAP_REG_START+REG_O4)
#define DTRAP_REG_O5	(DTRAP_REG_START+REG_O5)
#define DTRAP_REG_O6	(DTRAP_REG_START+REG_O6)
#define DTRAP_REG_O7	(DTRAP_REG_START+REG_O7)
#define DTRAP_REG_l0	(DTRAP_REG_START+REG_L0)
#define DTRAP_REG_l1	(DTRAP_REG_START+REG_L1)
#define DTRAP_REG_l2	(DTRAP_REG_START+REG_L2)
#define DTRAP_REG_l3	(DTRAP_REG_START+REG_L3)
#define DTRAP_REG_l4	(DTRAP_REG_START+REG_L4)
#define DTRAP_REG_l5	(DTRAP_REG_START+REG_L5)
#define DTRAP_REG_l6	(DTRAP_REG_START+REG_L6)
#define DTRAP_REG_l7	(DTRAP_REG_START+REG_L7)
#define DTRAP_REG_i0	(DTRAP_REG_START+REG_I0)
#define DTRAP_REG_i1	(DTRAP_REG_START+REG_I1)
#define DTRAP_REG_i2	(DTRAP_REG_START+REG_I2)
#define DTRAP_REG_i3	(DTRAP_REG_START+REG_I3)
#define DTRAP_REG_i4	(DTRAP_REG_START+REG_I4)
#define DTRAP_REG_i5	(DTRAP_REG_START+REG_I5)
#define DTRAP_REG_i6	(DTRAP_REG_START+REG_I6)
#define DTRAP_REG_i7	(DTRAP_REG_START+REG_I7)
#define DTRAP_REG_PSR	(DTRAP_REG_START+REG_PSR)
#define DTRAP_REG_Y	(DTRAP_REG_START+REG_Y)
#define DTRAP_REG_WIM	(DTRAP_REG_START+REG_WIM)
#define DTRAP_REG_TBR	(DTRAP_REG_START+REG_TBR)
#define DTRAP_REG_DIR	(DTRAP_REG_START+REG_DIR)
#define DTRAP_REG_IPR	(DTRAP_REG_START+REG_IPR)
#define DTRAP_REG_IXR	(DTRAP_REG_START+REG_IXR)
#define DTRAP_REG_IPV	(DTRAP_REG_START+REG_IPV)
#define DTRAP_REG_ITXC	(DTRAP_REG_START+REG_ITXC)
#define DTRAP_REG_IRXC	(DTRAP_REG_START+REG_IRXC)

#if defined(Series4) || defined(Series5) || defined(STIMULUS)
#define DTRAP_REG_FCR	(DTRAP_REG_START+REG_FCR)
#define DTRAP_REG_FES	(DTRAP_REG_START+REG_FES)
#define DTRAP_REG_FPAR	(DTRAP_REG_START+REG_FPAR)
#define DTRAP_REG_FVAR	(DTRAP_REG_START+REG_FVAR)
#define DTRAP_REG_MMCR	(DTRAP_REG_START+REG_MMCR)
#define DTRAP_REG_PDBA	(DTRAP_REG_START+REG_PDBA)
#define DTRAP_REG_BID	(DTRAP_REG_START+REG_BID)
#define NUM_DTRAP_REGS	(DTRAP_REG_BID+1)
#endif /* Series4 || Series5 || STIMULUS */

#if	defined(Series6) || defined(Series7)
#define DTRAP_REG_FCR	(DTRAP_REG_START+REG_FCR)
#define DTRAP_REG_BCS	(DTRAP_REG_START+REG_BCS)
#define DTRAP_REG_MFID	(DTRAP_REG_START+REG_MFID)
#define DTRAP_REG_AMMS	(DTRAP_REG_START+REG_AMMS)
#define DTRAP_REG_ADFA	(DTRAP_REG_START+REG_ADFA)
#define DTRAP_REG_KSS	(DTRAP_REG_START+REG_KSS)
#define DTRAP_REG_KSFA	(DTRAP_REG_START+REG_KSFA)
#define DTRAP_REG_KMS	(DTRAP_REG_START+REG_KMS)
#define DTRAP_REG_KMFA	(DTRAP_REG_START+REG_KMFA)
#define DTRAP_REG_AMSS	(DTRAP_REG_START+REG_AMSS)
#define DTRAP_REG_MSFA	(DTRAP_REG_START+REG_MSFA)
#define DTRAP_REG_MMS	(DTRAP_REG_START+REG_MMS)
#define DTRAP_REG_MMFA	(DTRAP_REG_START+REG_MMFA)
#define DTRAP_REG_SDFA	(DTRAP_REG_START+REG_SDFA)
#define DTRAP_REG_KTS	(DTRAP_REG_START+REG_KTS)
#define DTRAP_REG_KTFA	(DTRAP_REG_START+REG_KTFA)
#define DTRAP_REG_KAFA	(DTRAP_REG_START+REG_KAFA)
#define DTRAP_REG_MCNTL	(DTRAP_REG_START+REG_MCNTL)
#define DTRAP_REG_CNTXP	(DTRAP_REG_START+REG_CNTXP)
#define DTRAP_REG_CNTX	(DTRAP_REG_START+REG_CNTX)
#define DTRAP_REG_MFSR	(DTRAP_REG_START+REG_MFSR)
#define DTRAP_REG_MFAR	(DTRAP_REG_START+REG_MFAR)
#define DTRAP_REG_MXER0	(DTRAP_REG_START+REG_MXER0)
#define DTRAP_REG_MXER1	(DTRAP_REG_START+REG_MXER1)
#define DTRAP_REG_MXST0	(DTRAP_REG_START+REG_MXST0)
#define DTRAP_REG_MXST1	(DTRAP_REG_START+REG_MXST1)
#define DTRAP_REG_MXRST	(DTRAP_REG_START+REG_MXRST)
#define NUM_DTRAP_REGS	(DTRAP_REG_MXRST+1)
#endif /* Series6 || Series7 */

#if !defined(ASSEMBLER) && !defined(LOCORE)
#if defined(Series4) || defined(Series5) || defined(STIMULUS)
	int	dtrap_regs[NUM_DTRAP_REGS];
	int	dtrap_finished;	/* slave done filling in dtrap information */
	int	dtrap_valid;	/* slave had valid double trap information */
#endif


#if	defined(Series6) || defined(Series7)
/* 
 * for Series6/Series7, put the semaphores before the register array so that 
 * adding to the array does not re-position the semaphores
 */
	int	dtrap_finished;	/* slave done filling in dtrap information */
	int	dtrap_valid;	/* slave had valid double trap information */
	int	dtrap_regs[NUM_DTRAP_REGS];
#endif	Series6 || Series7
};

/*
 * saved state for prom/standalone communication
 */
struct prom_sa_state {
	/*
	 * rom state
	 */
	int	rom_g1;		/* rom global regs */
	int	rom_g2;
	int	rom_g3;
	int	rom_g4;
	int	rom_g5;
	int	rom_g6;
	int	rom_g7;
	int	rom_tbr;	/* rom TBR */
	int	rom_sp;		/* rom SP */
	int	rom_ra;		/* rom return address, used by callprog() */
	/*
	 * standalone program state
	 */
	int	sa_g1;		/* sa global regs */
	int	sa_g2;
	int	sa_g3;
	int	sa_g4;
	int	sa_g5;
	int	sa_g6;
	int	sa_g7;
	int	sa_tbr;		/* sa TBR */
	int	sa_sp;		/* sa SP */
	int	sa_ra;		/* sa return address */
#if defined(Series4) || defined(Series5)
	int	sa_mmcr;	/* sa MMCR */
#endif	/* Series4 || Series5 */
	int	sa_psr;		/* sa PSR for PIL field */
#if	defined(Series6) || defined(Series7)
	int	sa_mcntl;	/* sa MMU control register */
	int	sa_context;	/* sa MMU context register */
#endif	/* Series6 || Series7 */
};
#endif !ASSEMBLER && !LOCORE

/*
 * rom reset flags
 */
#define NUM_RESET_FLAGS	7	/* number of entries */

#define	ROM_COLD	0x01	/* requests a hardware reset */
#define	ROM_WARM	0x02	/* requests a prom state reinitialization */
#define	ROM_HALT	0x04	/* requests the roms to halt the machine */
#define	ROM_AUTOBOOT	0x08	/* requests the roms to auto boot */
#define ROM_INTR	0x10	/* same as ROM_WARM but forces no auto boot */
#define ROM_CONT	0x20	/* continue rom command proc w/ no reset */
#define ROM_FLAGEND	-1	/* end of reset flag array */

/*
 * rom reset strings
 */
#define	ROM_COLD_S	"cold"
#define	ROM_WARM_S	"warm"
#define	ROM_HALT_S	"halt"
#define	ROM_AUTOBOOT_S	"autoboot"
#define	ROM_INTR_S	"intr"
#define	ROM_CONT_S	"cont"
#define ROM_FLAGEND_S	""

/*
 * some known names in the EEPROM
 */
#define	TTYA_MODE	"TTYA_MODE"
#define	TTYB_MODE	"TTYB_MODE"
#define	BOOTMODE	"BOOTMODE"
#if	defined(Series6) || defined(Series7)
#define	DIAGMODE	"DIAGMODE"
#endif Series6 || Series7
#define HOSTID		"HOSTID"
#define	ENETADDR	"ENETADDR"
#define	MODEL		"MODEL"
#define SERIAL		"SERIAL"
#define	HOSTNAME	"HOSTNAME"
#define	CONSOLE		"CONSOLE"
#define DEFAULTBOOT	"DEFAULTBOOT"
#define	DIAGBOOT	"DIAGBOOT"
#define	DEFAULTROOT	"DEFAULTROOT"
#define	DEFAULTSWAP	"DEFAULTSWAP"
#define	DEFAULTDUMP	"DEFAULTDUMP"
#define	TZ		"TZ"
#define	DISPLAYRES	"DISPLAYRES"
#define	KBDTYPE		"KBDTYPE"
#define	MASTER		"MASTER"
#define	REMOTEDEV	"REMOTEDEV"
#define	DIAGSERVER	"DIAGSERVER"
#define	BANNER		"BANNER"
#define	COPYRIGHT	"COPYRIGHT"
#define	LOGO		"LOGO"
#define	KBD_LAYOUT	"KBD_LAYOUT"

/*
 * some prom default values
 */
#define	DEFAULTCONSOLE	"zs()"

#if !defined(ASSEMBLER) && !defined(LOCORE)
extern struct prom_sa_comm *rom_commarea();
#endif !ASSEMBLER && !LOCORE
