/* @(#) kbus.h 1.1@(#) Solbourne id 9/21/93 23:58:03 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*
 * Misc defines related to the Kbus interface
 */

/*
 * physical address which require an RIO cycle are divided 
 * into the following fields
 */
#define KBUS_SPACE_MASK		0xf0000000
#define KBUS_SLOT_MASK		0x0f000000
#define KBUS_ADDR_MASK		0x00ffffff
#define KBUS_SPACE_SHIFT	28
#define KBUS_SLOT_SHIFT		24
#define KBUS_ADDR_SHIFT		0

/*
 * possible values for the space bits in a physical IO address
 */
#define SPACE_NSPACES			0x10
#define SPACE_BOOTROM			0x00
#define SPACE_ID			0x01
#define	SPACE_IOREQACK			0x08
#define	SPACE_IOREQACK_FIRST_FREE	0x0A
#define	SPACE_IOREQACK_LAST		0x0F

/*
 * given the portions of an physical IO address, construct one
 * NOTE: slot argument is only used for SPACE_ID and  Series5E this macro
 * will only provide limited addressing per space...
 */
#define MK_IOADDR(space, slot, addr)				\
	(((space) == SPACE_ID) ?				\
	((((space) << KBUS_SPACE_SHIFT) & KBUS_SPACE_MASK) |	\
	 (((slot)  << KBUS_SLOT_SHIFT)  & KBUS_SLOT_MASK)  |	\
	 (((addr)  << KBUS_ADDR_SHIFT)  & KBUS_ADDR_MASK)) :	\
	((((space) << KBUS_SPACE_SHIFT) & KBUS_SPACE_MASK) |	\
	 (((addr)  << KBUS_ADDR_SHIFT)  & (KBUS_SLOT_MASK|KBUS_ADDR_MASK))))
#if	defined(Series6) || defined(Series7)
#define DGRAM(slot, addr) ( 					\
	*(unsigned int *) (					\
	(((SPACE_ID) << KBUS_SPACE_SHIFT) & KBUS_SPACE_MASK) | 	\
	(((slot)  << KBUS_SLOT_SHIFT)  & KBUS_SLOT_MASK) |	\
	(((addr)  << KBUS_ADDR_SHIFT)  & KBUS_ADDR_MASK) 	\
	)							\
)
#define dgram
#endif /* Series6 || Series7 */

#define KBUS_MIN_SLOT		1
#define KBUS_MAX_SLOT		15
#define KBUS_NUM_SLOTS		12
#define KBUS_NUM_SLOT		12
#define KBUS_SYS_SLOT		7	/* IO board slot */
#define KBUS_ALT_SLOT           15
#define KBUS_RACK_SLOT		8

/*
 * cache block information
 */
#define NBPCB		32		/* number of bytes per cache block */
#define CBOFFSET	31		/* mask of addressing bits in a cache block */
#define CBSHIFT		5		/* log2(NBPCB) */

/*
 * conversion between bytes and cache blocks
 */
#define	cbtob(x)	((x) << CBSHIFT)
#define	btocb(x)	(((unsigned)(x)) >> CBSHIFT)
#define	btocbr(x)	(((unsigned)(x) + CBOFFSET) >> CBSHIFT)

/*
 * Kbus ttypes
 */
#define	KBUS_TTYPE_ASCII	{"", "CACHE:IOB", "CACHE:WRITE_INV", "CACHE:READ_INV",	\
	"", "", "", "CACHE:READ", "RIO:BYTE_WRITE", "RIO:BYTE_READ", "RIO:2BYTE_WRITE",	\
	"RIO:2BYTE_READ", "RIO:4BYTE_WRITE", "RIO:4BYTE_READ", "RIO:8BYTE_WRITE",	\
	"RIO:8BYTE_READ", "", "RIO:BYTE_RMW", "", "", "", "", "", "", "REFRESH",	\
	"", "", "", "", "", "", "PROBE"}

