/* @(#) if_prgreg_fddi.h 1.2@(#) Solbourne id 1/11/94 19:43:56 */
/*
 * Copyright 1991 Solbourne Computer, Inc.
 * All rights reserved.
 */
#ifndef if_if_prgreg_fddi_h
#define	if_if_prgreg_fddi_h
/*
 * This file contains definitions for Interphase fddi specific RC command set
 */

/* recieve buf list element */
struct rc_rcvble {
    u_int     rcvble_paddr;	/* physical address of the receive buffer */
#define		RCVBLE_SENTINEL	0xffffffff
    u_int     rcvble_rtag;	/* tag provided with CMD_FINB_RX */
};

/* FDDI-specific structures and commands. */
#define	RC_TYPE_FDDI		1

/*-----------------requests: RC Fddi command ReQuest Blocks-----------------*/
struct rc_frqb_tx {		/* CMD_FRQB_TX */
    u_int	tx_len;			/* length of command */
    u_int	tx_cmd;			/* Request command code */
#define		  CMD_FRQB_TX		0x0101
    u_int	tx_rchid;		/* channel id for command response */
    u_int	tx_rtag;		/* driver tag for command response */
    u_int	tx_class;
#define		  TX_CLASS_NORESP	0x0
#define		  TX_CLASS_RESP		0x1
#define		  TX_CLASS_SYNC		0x0
#define		  TX_CLASS_ASYNC	0x2
    u_int	tx_xopts;
    u_int	tx_frame_len;
    u_int	tx_frag_cnt;
    struct rc_tx_frag {
	u_int	frag_paddr;
	u_int	frag_len;
    }		tx_frag[1];
};
struct rc_frqb_txi {		/* CMD_FRQB_TXI */
    u_int	txi_len;		/* length of command */
    u_int	txi_cmd;		/* Request command code */
#define		  CMD_FRQB_TXI		0x0102
    u_int	txi_rchid;		/* channel id for command response */
    u_int	txi_rtag;		/* driver tag for command response */
    u_short	txi_dest_addr[3];
    u_short	txi_ethertype;
    u_int	txi_reserved;
    u_int	txi_class;
    u_int	txi_xopts;
    u_int	txi_frame_len;
    u_int	txi_frag_cnt;
    struct rc_tx_frag txi_frag[1];
};
struct rc_frqb_getmac {		/* CMD_FRQB_GETMAC */
    u_int	getmac_len;		/* length of command */
    u_int	getmac_cmd;		/* Request command code */
#define		  CMD_FRQB_GETMAC	0x0104
    u_int	getmac_rchid;		/* channel id for command response */
    u_int	getmac_rtag;		/* driver tag for command response */
};
struct rc_frqb_getmib {		/* CMD_FRQB_GETMIB */
    u_int	getmib_len;		/* length of command */
    u_int	getmib_cmd;		/* Request command code */
#define		  CMD_FRQB_GETMIB	0x0108
    u_int	getmib_rchid;		/* channel id for command response */
    u_int	getmib_rtag;		/* driver tag for command response */
    u_int	getmib_at_name;		/* attribute name */
    u_int	getmib_at_len;		/* attribute length */
    u_int	getmib_at_index;	/* attribute index */
};
struct rc_frqb_cam {		/* CMD_FRQB_SETCAM, CMD_FRQB_CLRCAM */
    u_int	cam_len;		/* length of command */
    u_int	cam_cmd;		/* Request command code */
#define		  CMD_FRQB_SETCAM	0x010A
#define		  CMD_FRQB_CLRCAM	0x010B
    u_int	cam_rchid;		/* channel id for command response */
    u_int	cam_rtag;		/* driver tag for command response */
    u_short	cam_addr[3];
    u_short	cam_reserved;
};
struct rc_frqb_gethwp {		/* CMD_FRQB_GETHWP */
    u_int	gethwp_len;		/* length of command */
    u_int	gethwp_cmd;		/* Request command code */
#define		  CMD_FRQB_GETHWP	0x010F
/*  u_int	gethwp_rchid;		/* channel id for command response */
    u_int	gethwp_rtag;		/* driver tag for command response */
    u_int	gethwp_pcount;		/* number of parameters requested */
    u_short	gethwp_ptype;		/* code for parameter requested */
    u_short	gethwp_reserved;
};

/*----------------requests: RC Fddi command DIrective Blocks----------------*/
struct rc_fdib_setrx {		/* CMD_FDIB_SETRX */
    u_int	setrx_len;		/* length of command */
    u_int	setrx_cmd;		/* Request command code */
#define		  CMD_FDIB_SETRX	0x0103
    u_int	setrx_rl_xopts;		/* xfer options for rc_rcvble */
    u_int	setrx_rl_paddr;		/* paddr(struct rc_rcvble *) */
    u_int	setrx_rl_len;		/* # bytes in rc_rcvble list */
    u_int	setrx_rb_throttle;	/* # packets moved before response */
    u_int	setrx_rb_xopts;		/* xfer options for each buffer */
    u_int	setrx_rb_len;		/* length of each buffer */
};
struct rc_fdib_setmac {		/* CMD_FDIB_SETMAC */
    u_int	setmac_len;		/* length of command */
    u_int	setmac_cmd;		/* Request command code */
#define		  CMD_FDIB_SETMAC	0x0105
    u_short	setmac_addr[3];
    u_short	setmac_type;
};
struct rc_fdib_ring {		/* CMD_FDIB_RING */
    u_int	ring_len;		/* length of command */
    u_int	ring_cmd;		/* Request command code */
#define		  CMD_FDIB_RING		0x0106
    u_int	ring_state;
#define		  RING_STATE_CONNECT	1
#define		  RING_STATE_DISCONNECT	2
};
struct rc_fdib_mant {		/* CMD_FDIB_MANT */
    u_int	mant_len;		/* length of command */
    u_int	mant_cmd;		/* Request command code */
#define		  CMD_FDIB_MANT		0x0107
    u_int	mant_ctl;
#define		  MANT_CTL_PCM_ON	1
#define		  MANT_CTL_PCM_OFF	2
    u_int	mant_pcmstate;
#define		  MANT_PCMSTATE_Noise_Line_State                0x02
#define		  MANT_PCMSTATE_Master_Line_State               0x04
#define		  MANT_PCMSTATE_Idle_Line_State                 0x08
#define		  MANT_PCMSTATE_Super_Idle_Line_State           0x08
#define		  MANT_PCMSTATE_Halt_Line_State                 0x10
#define		  MANT_PCMSTATE_Quiet_Line_State                0x20
#define		  MANT_PCMSTATE_Active_Line_State               0x40
#define		  MANT_PCMSTATE_Transmit_PHY_Data_Request       0x100
};
struct rc_fdib_setmib {		/* CMD_FDIB_SETMIB */
    u_int	setmib_len;		/* length of command */
    u_int	setmib_cmd;		/* Request command code */
#define		  CMD_FDIB_SETMIB	0x0109
    u_int	setmib_at_name;		/* attribute name */
    u_int	setmib_at_len;		/* attribute length */
    u_int	setmib_at_index;	/* attribute index */
    u_int	setmib_at_attr[32];	/* variable len mib attribute */
};
struct rc_fdib_flshcam {	/* CMD_FDIB_FSHCAM */
    u_int	flshcam_len;		/* length of command */
    u_int	flshcam_cmd;		/* Request command code */
#define		  CMD_FDIB_FSHCAM	0x10C
};
struct rc_fdib_smtrc {		/* CMD_FDIB_SMTRC */
    u_int	smtrc_len;		/* length of command */
    u_int	smtrc_cmd;		/* Request command code */
#define		  CMD_FDIB_SMTRC	0x010D
    u_int	smtrc_ctl;
#define		  SMTRC_CTL_FRAME_ON	1
#define		  SMTRC_CTL_FRAME_OFF	2
#define		  SMTRC_CTL_EVENT_ON	3
#define		  SMTRC_CTL_EVENT_OFF	4
};
struct rc_frqb_sethwp {		/* CMD_FRQB_SETHWP */
    u_int	sethwp_len;		/* length of command */
    u_int	sethwp_cmd;		/* Request command code */
#define		  CMD_FRQB_SETHWP	0x010E
    u_int	sethwp_rtag;		/* BOGUS! there is no response... */
    u_int	sethwp_pcount;		/* number of parameters being set */
    u_short	sethwp_ptype;		/* code for parameter to set */
#define		  HWP_PTYPE_CAM_CMD_REG	0x0001	/* CAM CoMmanD REGister */
#define		  HWP_PTYPE_FE_CMD_REG	0x0002	/* Front End CoMmanD REGister */
#define		  HWP_PTYPE_FMC_MODE	0x0003	/* ForMaC MODE */
#define		  HWP_PTYPE_FRC_F_MODE	0x0004	/* ForMaC Flush MODE */
#define		  HWP_PTYPE_FCS_CTL	0x0005	/* FrameCheckSequence Control */
#define		  HWP_PTYPE_OBR_CTL	0x0006	/* Optical Bypass Reley Ctl */
    u_short	sethwp_pvalue;		/* value for parameter */
#define		    CAM_CMD_REG_DST	0x0020
#define		    CAM_CMD_REG_SRC	0x0010
#define		    CAM_CMD_REG_MULTI	0x0080
#define		    FRC_F_MODE_NORMAL	0x0000	/* normal mode */
#define		    FRC_F_MODE_PROMISC	0x0002	/* promiscuous mode */
#define		    FCS_CTL_ENABLED	0x0000
#define		    FCS_CTL_DISABLED	0x0001
#define		    OBR_CTL_BYPASS	0x0000
#define		    OBR_CTL_THRU	0x0001
};

/*----------------responses: RC Fddi command ReSponse Blocks----------------*/
struct rc_frsb_tx {		/* CMD_FRSB_TX */
    u_int	tx_len;			/* length of response */
    u_int	tx_cmd;			/* response command code */
#define		  CMD_FRSB_TX		0x0181
    u_int	tx_rtag;		/* driver tag specified in request */
    u_int	tx_stat;
#define		  TX_STAT_NORMAL	0
#define		  TX_STAT_RING_UP	1
#define		  TX_STAT_RING_DOWN	2
#define		  TX_STAT_VMEBUSERR	3
#define		  TX_STAT_ASCII_N	4
#define		  TX_STAT_ASCII	{"NORMAL", "RING_UP", "RING_DOWN", "VMEBUSERR"}
};
struct rc_frsb_getmac {		/* CMD_FRSB_GETMAC */
    u_int	getmac_len;		/* length of response */
    u_int	getmac_cmd;		/* response command code */
#define		  CMD_FRSB_GETMAC	0x0184
    u_int	getmac_rtag;		/* driver tag specified in request */
    u_short	getmac_can[3];		/* internet format */
    u_short	getmac_noncan[3];	/* bit transmition format */
};
struct rc_frsb_cam {		/* CMD_FRSB_CAM */
    u_int	cam_len;		/* length of response */
    u_int	cam_cmd;		/* response command code */
#define		  CMD_FRSB_CAM		0x0187
    u_int	cam_rtag;		/* driver tag specified in request */
    u_int	cam_status;
#define		  CAM_STATUS_SUCCESS		0
#define		  CAM_STATUS_FULL		1
#define		  CAM_STATUS_ADDR_PRESENT	2
#define		  CAM_STATUS_ADDR_NOT_PRESENT	3
};
struct rc_frsb_getmib {		/* CMD_FRSB_GETMIB */
    u_int	getmib_len;		/* length of response */
    u_int	getmib_cmd;		/* response command code */
#define		  CMD_FRSB_GETMIB	0x0188
    u_int	getmib_response_id;	/* ** BOGUS ***WHAT IS THIS FOR??? */
    u_int	getmib_rtag;		/* driver tag specified in request */
    u_int	getmib_at_name;		/* attribute name */
    u_int	getmib_at_len;		/* attribute length */
    u_int	getmib_at_index;	/* attribute index */
    u_int	getmib_at_attr[1];	/* variable len mib attribute */
};

/*--------------indications: RC Fddi command INdication Blocks--------------*/
struct rc_finb_rx {		/* CMD_FINB_RX */
    u_int	rx_len;			/* length of response */
    u_int	rx_ind;			/* response command code */
#define		  CMD_FINB_RX		0x0182
    u_short	rx_status;
    u_short	rx_frame_status;
    u_short	rx_frame_len;
    u_short	rx_nfrag;
    struct rc_rx_frag {
	u_int	frag_rtag;
	u_int	frag_len;
    }		rx_frag[1];
};
struct rc_finb_rxi {		/* CMD_FINB_RXI */
    u_int	rxi_len;		/* length of response */
    u_int	rxi_ind;		/* response command code */
#define		  CMD_FINB_RXI		0x0183-NOT_YET_IMPLEMENTED
    u_short	rxi_status;
    u_short	rxi_frame_status;
    u_short	rxi_source_addr[3];
    u_short	rxi_ethertype;
    u_short	rxi_frame_len;
    u_short	rxi_nfrag;
    struct rc_rx_frag rxi_frag[1];
};
struct rc_finb_getring {		/* CMD_FRSB_GETRING */
    u_int	getring_len;		/* length of response */
    u_int	getring_cmd;		/* response command code */
#define		  CMD_FRSB_GETRING	0x0185
    u_int	getring_state;
};
struct rc_finb_smtevent {		/* CMD_FINB_SMTEVENT */
    u_int	smtevent_len;		/* length of response */
    u_int	smtevent_cmd;		/* response command code */
#define		  CMD_FINB_SMTEVENT	0x0189
    u_int	smtevent_type;		/* SMT defined message type */
    u_char	smtevent_msg[1];	/* ... variable length */
};

/* start of MIB information */

/*
*	E, A, and C indicator bit positions.
*	The frame interface routines must provide the E, A, and C
*	indicator values with all frames received. The indicator
*	values will be passed to the frame services process as a
*	bit string. These defined values determine the bit positions
*	of each indicator.
*/
#define	E_Bit_Position	0x80
#define	A_Bit_Position	0x40
#define	C_Bit_Position	0x20

/*********************************************************************
		CSP Defined Values
*********************************************************************/

/*
*	   Station Types
*/
#define SMSAS_TYPE	  1
#define SMDAS_TYPE	  2
#define DMDAS_TYPE	  3

/*
*	FDDI Addresses
*/
typedef	u_char	MACAddr48[6];
typedef	u_char	MACAddr16[2];
typedef	struct MACAddr48_n_Type {
	MACAddr48	bogus;
	MACAddr48	addr;
}	MACAddr48_n;

/**********************************************************************
*
*	The following typedefs provide data types and structures
*	for use throughout the MIB. These types align short data
*	values to 32-bit boundaries. This allows the MIB routines
*	to provide attributes properly aligned for frame transmission.
*	Thus, the frame processing routines do not need to know about
*	individual data sizes when building frame parameters.
*
**********************************************************************/
/*
*	8-bit attribute values.
*/
typedef	struct SMT8BitStruct {
	u_char		pad[3];
	u_char		data;
} TLV8BitType;

/*
*	16-bit attribute values.
*/
typedef	struct SMT16BitStruct {
	u_char		pad[2];
	u_short		data;
} TLV16BitType;

/*
*	32-bit attribute values.
*	This type allows access to 32-bit attribute using member data
*	as with the 16- and 8-bit attributes.
*/
typedef	struct SMT32BitStruct {
	u_int		data;
} TLV32BitType;

/*
*	Address/ID attribute values.
*	This type allows access to two-byte data field followed by
*	a 6-byte address.
*/
typedef struct SMTIdStruct {
	u_char		data[2];
	MACAddr48	addr;
} TLVIdType;


/**********************************************************************
*
*	Typedefs for special attributes. These attributes are either
*	larger than 32 bits or consists of aggregate members.
*
**********************************************************************/

typedef	struct SMTStationIdStruct {
	u_char		user[2];		/* user defined octets */
	MACAddr48	IEEEAddress;		/* IEEE-assigned address */
} SMTStationIdType;

typedef	struct SMTManufacturerDataStruct {
	u_char		OUI[3];			/* implementor's OUI */
	u_char		data[29];		/* implementor's data */
} SMTManufacturerDataType;

typedef	u_char	SMTUserDataType[32];		/* implementor's data */

typedef	struct	SMTTimeStampStruct {
	u_int		hi_word;			/* upper 32 bits */
	u_int		lo_word;			/* lower 32 bits */
} SMTTimeStamp;

typedef	struct	SMTSetCountStruct {
	u_int		count;			/* last counter value */
	SMTTimeStamp	setTimeStamp;		/* last time of set */
} SetCountType;

typedef	struct	PathConfigStruct {
	u_short		ResourceType;		/* 2=MAC, 4=PORT */
	u_short		ResourceIndex;
} PathConfigType;

typedef	struct	TLVHdrStruct {
	u_short	paramType;
	u_short	paramLen;
} TLVHdrType;

typedef	struct	TLVParamStruct {
	u_short		paramType;		/* Type and length are */
	u_short		paramLen;		/* common to all params */
	union {
		struct {			/* Some attrs require index */
			TLV16BitType	paramIndex;
			union {
				TLV8BitType	p8;
				TLV16BitType	p16;
				TLV32BitType	p32;
				TLVIdType	pId;
				u_char		pOther[12];
			} pval;
		} otherAttr;
		union {
			TLV8BitType	smt8;	/* SMT attrs need no index */
			TLV16BitType	smt16;
			TLV32BitType	smt32;
			TLVIdType	smtId;
			u_char		smtOther[32];
		} smtAttr;
	} paramValue;
} TLVParamType;

typedef	struct 	TLVSetCountStruct {
	u_short		paramType;
	u_short		paramLen;
	SetCountType	paramValue;
} TLVSetCountType;

/*
*	The list of supported SMT versions.  The supported versions
*	must be a contigous range.  The structure below gives the
*	starting version supported and the ending version supported.
*/
typedef struct SMTVersList {
	u_short	Start;			/* Initial version supported */
	u_short	End;			/* Last version supported */
} SMTVersList;

/*********************************************************************
	CMT & RMT States
*********************************************************************/

/*
*	The following defined values are used to determine the current
*	states for each state machine. The values and names used follow
*	the FDDI SMT documentation.
*/

/*
*	CFM States
*/
#define	CF_ISOLATED	0
#define	CF_WRAP_S	1
#define	CF_WRAP_A	2
#define	CF_WRAP_B	3
#define	CF_WRAP_AB	4
#define	CF_THRU		5
#define	CF_STATE_NASCII	6
#define	CF_STATE_ASCII	\
	{"Isolated", "WrapS", "WrapA", "WrapB", "WrapAB", "Thru" }

/*
*	CCE States
*/
#define	CE_ISOLATED	0
#define	CE_INSERT_P	1
#define	CE_INSERT_S	2
#define	CE_INSERT_X	3
#define	CE_LOCAL	4

/*
*	PCM States
*/
#define	PC_OFF		0
#define	PC_BREAK	1
#define	PC_TRACE	2
#define	PC_CONNECT	3
#define	PC_NEXT		4
#define	PC_SIGNAL	5
#define	PC_JOIN		6
#define	PC_VERIFY	7
#define	PC_ACTIVE	8
#define	PC_MAINT	9

/*
*	RMT States
*/
#define	RM_ISOLATED	0
#define	RM_NON_OP	1
#define	RM_RING_OP	2
#define	RM_DETECT	3
#define	RM_NON_OP_DUP	4
#define	RM_RING_OP_DUP	5
#define	RM_DIRECTED	6
#define	RM_TRACE	7

/*
*	RMT Substates used in XDI SMT implementation.
*/
#define	RM_JAM_A_WAIT_TJAM	41
#define	RM_JAM_B_WAIT_TDBJ	42
#define	RM_JAM_B_WAIT_TJAM	43

/*
*	LEM States used in XDI SMT implementation.
*/
#define	LE_OFF		0
#define	LE_MONITOR	1
#define	LE_LCT		2


/*********************************************************************
	SMT Definitions
*********************************************************************/

/*
*	Configuration Capabilities/Policies
*/
#define	Config_None		0x0
#define	Config_Hold_Available	0x0001
#define	Config_CF_Wrap_AB	0x0002

/*
*	Connection Policies
*/
#define	Policy_rejectA_A	0x0001
#define	Policy_rejectA_B	0x0002
#define	Policy_rejectA_S	0x0004
#define	Policy_rejectA_M	0x0008
#define	Policy_rejectB_A	0x0010
#define	Policy_rejectB_B	0x0020
#define	Policy_rejectB_S	0x0040
#define	Policy_rejectB_M	0x0080
#define	Policy_rejectS_A	0x0100
#define	Policy_rejectS_B	0x0200
#define	Policy_rejectS_S	0x0400
#define	Policy_rejectS_M	0x0800
#define	Policy_rejectM_A	0x1000
#define	Policy_rejectM_B	0x2000
#define	Policy_rejectM_S	0x4000
#define	Policy_rejectM_M	0x8000
/* Additional policy types used by XLNT Manager */
#define	Policy_limited		(~(Policy_rejectA_B | Policy_rejectB_A\
					| Policy_rejectS_M | Policy_rejectM_S))
#define	Policy_expanded		(Policy_rejectM_M)
#define	Policy_acceptAll	0x0
#define	Policy_rejectAll	0xFFFF

/*
*	Hold State
*/
#define	HS_Not_Holding	0
#define	HS_Holding_Prm	1			/* holding on primary */
#define	HS_Holding_Sec	2			/* holding on secondary */

/*
*	T_Notify Limits
*/
#define	T_Notify_Min		2
#define	T_Notify_Max		30

/*
*	Station Actions
*/
#define	StationAction_Connect		0
#define	StationAction_Disconnect	1
#define	StationAction_Path_Test		2
#define	StationAction_Self_Test		3


/*********************************************************************
	MAC Definitions
*********************************************************************/

/*
*	Frame Status Capabilities
*/
#define	FSC_None	0
#define	FSC_Type0	0x0001
#define	FSC_Type1	0x0002
#define	FSC_Type2	0x0004
#define	FSC_Type0_Pgm	0x0100
#define	FSC_Type1_Pgm	0x0200
#define	FSC_Type2_Pgm	0x0400

/*
*	Bridge Function
*/
#define	Bridge_None	0
#define	Bridge_Type0	0x01
#define	Bridge_Type1	0x02

/*
*	Master-Slave Loop Status
*/
#define	MSLoop_Unknown		0
#define	MSLoop_Suspected	1
#define	MSLoop_None		2

/*
*	Duplicate Address Test
*/
#define	DA_Test_None		0
#define	DA_Test_Pass		1
#define	DA_Test_Fail		2

/*
*	Neighbor Change Event Conditions
*/
#define	EVENT_UNA_CHANGED	0x01
#define	EVENT_DNA_CHANGED	0x02

/*
*	MAC Actions
*/
#define	MACAction_EnableLLCService	0
#define	MACAction_DisableLLCService	1
#define	MACAction_ConnectMAC		2
#define	MACAction_DisconnectMAC		3


/*********************************************************************
	PATH Definitions
*********************************************************************/

/*
*	Paths Available/Current Path
*/
#define	PA_UNKNOWN	0x00
#define	PA_PRIMARY	0x01
#define	PA_SECONDARY	0x02
#define	PA_LOCAL	0x04
#define	PA_ISOLATED	0x08

/*
*	PATH Order
*/
#define	Path_Order_Unsupported	0
#define	Path_Order_Ascending	1
#define	Path_Order_Descending	2

/*
*	PATH Class Type
*/
#define	Path_Type_Local		0
#define	Path_Type_nonLocal	1

/*
*	PATH Trace Status
*/
#define	Trace_NoCurrent		0
#define	Trace_Initiated		1
#define	Trace_Propagated	2
#define	Trace_Terminated	3

/*
*	Path Status
*/
#define	Path_Status_Wrapped	0
#define	Path_Status_Thru	1


/*********************************************************************
	PORT Definitions
*********************************************************************/

/*
*	PC_Type & PC_Neighbor Values
*/
#define	PC_Type_A	0
#define	PC_Type_B	1
#define	PC_Type_S	2
#define	PC_Type_M	3
#define	PC_Type_Unknown	4
#define	PC_Type_None	PC_Type_Unknown

/*
*	Connection State Values
*/
#define	Connect_Disabled	0	/* PC0:OFF */
#define	Connect_Connecting	1	/* !PC8:ACTIVE & !PC0:OFF !PC2:TRACE
						& PC_Withhold = None */
#define	Connect_Standby		2	/* PC_Withhold != None */
#define	Connect_Active		3	/* PC8:ACTIVE */

/*
*	PORT Connection Policies.
*/
#define	PC_MAC_None		0
#define	PC_MAC_LCT		0x01
#define	PC_MAC_Loop		0x02
#define	PC_MAC_Placement	0x04

/*
*	PC_Withhold Values
*/
#define	PC_WH_None		0	/* no withholding */
#define	PC_WH_M_to_M		1	/* PHY M to PHY M */
#define	PC_WH_Other		2	/* Other incompatible PHY types */

/*
*	Maintenance Line States
*/
#define	Maint_QLS	0
#define	Maint_ILS	1
#define	Maint_MLS	2
#define	Maint_HLS	3
#define	Maint_PDR	4

/*
*	Limits on LER ranges
*/
#define	LER_MIN	4
#define	LER_MAX	15

/*
*	PORT FOTX Class
*/
#define	FOTX_Multimode		0
#define	FOTX_Single_Mode1	1
#define	FOTX_Single_Mode2	2
#define	FOTX_SONET		3

/*
*	PORT Actions
*/
#define	PORTAction_Maint	0
#define	PORTAction_Enable	1
#define	PORTAction_Disable	2
#define	PORTAction_Start	3
#define	PORTAction_Stop		4


/*********************************************************************
	ATTACHMENT Definitions
*********************************************************************/

/*
*	ATTACHMENT Classes
*/
#define	Attachment_Class_Single		0
#define	Attachment_Class_Dual		1
#define	Attachment_Class_Concentrator	2


/*********************************************************************
	CMT Definitions
*********************************************************************/

/*
*	Path_Test Values
*/
#define	PT_None		0
#define	PT_Testing	1
#define	PT_Passed	2
#define	PT_Failed	3
#define	PT_Pending	4
#define	PT_Exiting	5

/*
*	PC_Mode Values
*/
#define	PC_Mode_Peer	0
#define	PC_Mode_Tree	1
#define	PC_Mode_None	2

/*
*	Line States
*/
#define	PDRLS		0x100
#define	ALS		0x40
#define	QLS		0x20
#define	HLS		0x10
#define	ILS		0x08
#define	SILS		0x08
#define	MLS		0x04
#define	NLS		0x02

/*
*	RMT Duplicate Address Policies
*/
#define	RMT_DUP_CHANGE	1		/* perform change actions */
#define	RMT_DUP_JAM_A	2		/* perform jam actions */
#define	RMT_DUP_JAM_B	3		/* perform jam actions */
#define	RMT_DUP_LEAVE	4		/* leave ring */

/*
*	Reason Denied Codes
*/
#define	RC_FRAME_CLASS		((u_int) 0x01)
#define	RC_FRAME_VERSION	((u_int) 0x02)
#define	RC_SUCCESS		((u_int) 0x03)
#define	RC_BAD_SET_COUNT	((u_int) 0x04)
#define	RC_READ_ONLY		((u_int) 0x05)
#define	RC_NO_PARAM		((u_int) 0x06)
#define	RC_NO_MORE		((u_int) 0x07)
#define	RC_OUT_OF_RANGE		((u_int) 0x08)
#define	RC_NOT_AUTHORIZED	((u_int) 0x09)
#define	RC_LENGTH_ERROR		((u_int) 0x0A)
#define	RC_FRAME_TOO_LONG	((u_int) 0x0B)
#define	RC_ILLEGAL_PARAMETER	((u_int) 0x0C)

/* XLNT Manager value */
#define	RC_ERROR_UNKNOWN	((u_int) 0xFE)
#define	RC_BUFFER_ERROR		((u_int) 0xFF)

/*
*	Node Class of Station Descriptor Parameter
*	The type of station we are can be one of two things, either a
*	station or a concentrator.  The values for these are defined
*	below.
*/
#define SMT_Type_Station	0
#define SMT_Type_Concentrator	1

/*
*	Topology Bit Assignments of Station State Parameter
*	The station's current topology is indicated by which bit is set.
*/
#define	Topology_Thru		0x00
#define	Topology_Wrapped	0x01
#define	Topology_Unrooted	0x02
#define	Topology_Twisted_AA	0x04
#define	Topology_Twisted_BB	0x08
#define	Topology_Rooted_Station	0x10
#define	Topology_SRF		0x20

/*
*	Duplicate Address Bit Assignments of Station State Parameter
*	MAC's current duplicate address status for the
*	Station State parameter.
*/
#define	DuplAddr_My_Duplicate		0x01
#define	DuplAddr_My_UNA_Duplicate	0x02

/*
*	Maximum Interval Between SRFs (in seconds).
*/
#define	MAX_SRF_INTERVAL	32

/*
*	Frame Status Values
*	Defined in smtdefs.h.
*/
#define	E_Indicator	E_Bit_Position
#define	A_Indicator	A_Bit_Position
#define	C_Indicator	C_Bit_Position

/*
*	Attach PORT Indexes
*/
#define	PHY_A	0
#define	PHY_B	1
#define	PHY_S	0

/*
*	Station MAC Indexes
*/
#define	PRIMARY_MAC	0
#define	SECONDARY_MAC	1
#define	LOCAL_MAC	2
#define	MAC_P		PRIMARY_MAC
#define	MAC_S		SECONDARY_MAC
#define	MAC_L		LOCAL_MAC

/* These values are left for compatibility with older software */
#define	MAC_1	0
#define	MAC_2	1

/*
*	PATH Indexes
*/
#define	PATH_P	0
#define	PATH_S	1
#define	PATH_L	2

/*
*	MIB Attach PORT Indexes
*/
#define	MIB_PHY_A	1
#define	MIB_PHY_B	2
#define	MIB_PHY_S	1

/*
*	MIB MAC Indexes
*/
#define	MIB_MAC_P	1
#define	MIB_MAC_S	2
#define	MIB_MAC_L	3

/*
*	Entity Types
*
*	These are arbitrary assignments until the SMT committee sets
*	the proper values.
*/
#define	PHY_TYPE	0
#define	PORT_TYPE	PHY_TYPE
#define	MAC_TYPE	1

/*
*	Object ID constants.
*/
#define	fddiSMT			0x1000
#define	fddiMAC			0x2000
#define	fddiPATHClass		0x3000
#define	fddiPATHClassPATH	0x3200
#define	fddiPORT		0x4000
#define	fddiATTACH		0x6000

/*
*	ID Masks.
*/
#define	MIB_OBJECT_MASK		0xF000
#define	MIB_SUBOBJECT_MASK	0x0F00
#define	MIB_ID_MASK		0x00FF

/*
*	SMT Attribute Constants
*/
#define			fddiSMTStationIdGrp		(fddiSMT | 10)
typedef struct SMTStationIdGrpStruct {
#define			fddiSMTStationId		(fddiSMT | 11)
	SMTStationIdType	StationId;	/* the SMT station id */
#define			fddiSMTOpVersionId		(fddiSMT | 13)
	u_short			OpVersionId;	/* version of SMT */
#define			fddiSMTHiVersionId		(fddiSMT | 14)
	u_short			HiVersionId;	/* highest version supported */
#define			fddiSMTLoVersionId		(fddiSMT | 15)
	u_short			LoVersionId;	/* lowest version supproted */
#define			fddiSMTManufacturerData		(fddiSMT | 16)
	SMTManufacturerDataType	ManufacturerData;/* manufacturer's data */
#define			fddiSMTUserData			(fddiSMT | 17)
	SMTUserDataType		UserData;	/* user data */
} SMTStationIdGrpType;

#define			fddiSMTStationConfigGrp		(fddiSMT | 20)
typedef struct SMTStationConfigGrpStruct {
#define			fddiSMTMAC_Ct			(fddiSMT | 21)
	u_char		MAC_Ct;			/* number of MACs */
#define			fddiSMTNonMaster_Ct		(fddiSMT | 22)
	u_char		NonMaster_Ct;		/* number of attachments */
#define			fddiSMTMaster_Ct		(fddiSMT | 23)
	u_char		Master_Ct;		/* number of masters */
#define			fddiSMTPathsAvailable		(fddiSMT | 24)
	u_char		PathsAvailable;		/* available paths in stn */
#define			fddiSMTConfigCapabilities	(fddiSMT | 25)
	u_short		ConfigCapabilities;	/* configuration options */
#define			fddiSMTConfigPolicy		(fddiSMT | 26)
	u_short		ConfigPolicy;		/* configuration selected */
#define			fddiSMTConnectionPolicy		(fddiSMT | 27)
	u_short		ConnectionPolicy;	/* connections allowed */
#define			fddiSMTReportLimit		(fddiSMT | 28)
	u_int		ReportLimit;		/* SRF limit */
#define			fddiSMTT_Notify			(fddiSMT | 29)
	u_short		T_Notify;		/* NIF NN interval */
#define			fddiSMTStatusReporting		(fddiSMT | 30)
	u_char		StatusReporting;	/* SRF flag */
} SMTStationConfigGrpType;

#define			fddiSMTStatusGrp		(fddiSMT | 40)
typedef	struct SMTStatusGrpStruct {
#define			fddiSMTECMState			(fddiSMT | 41)
	u_char		ECMState;		/* current ECM state */
#define					EC_OUT		0
#define					EC_IN		1
#define					EC_TRACE	2
#define					EC_LEAVE	3
#define					EC_PATH_TEST	4
#define					EC_INSERT	5
#define					EC_CHECK	6
#define					EC_DEINSERT	7
#define			fddiSMTCF_State			(fddiSMT | 42)
	u_char		CF_State;		/* current config state */
#define			fddiSMTHoldState		(fddiSMT | 43)
	u_short		HoldState;		/* current Hold condition */
#define			fddiSMTRemoteDisconnectFlag	(fddiSMT | 44)
	u_char		RemoteDisconnectFlag;	/* remotely disconnected */
} SMTStatusGrpType;

#define			fddiSMTMIBOperationGrp		(fddiSMT | 50)
typedef	struct SMTMIBOperationGrpStruct {
#define			fddiSMTMsgTimeStamp		(fddiSMT | 51)
	SMTTimeStamp	MsgTimeStamp;		/* station time stamp */
#define			fddiSMTTransitionTimeStamp	(fddiSMT | 52)
	SMTTimeStamp	TransitionTimeStamp;	/* SRF time stamp */
#define			fddiSMTSetCount			(fddiSMT | 53)
	SetCountType	SetCount;		/* PMF support */
#define			fddiSMTLastSetStationId		(fddiSMT | 54)
	SMTStationIdType
			LastSetStationId;	/* last station to set MIB */
} SMTMIBOperationGrpType;

/* XDI added attributes */
typedef	struct XDISMTGrpStruct {
#define	xdiSMTBothWrapCapability	(fddiSMT | 201)
	u_char		BothWrapCapability;
#define	xdiSMTBothWrapPolicy		(fddiSMT | 202)
	u_char		BothWrapPolicy;
/* BOGUS.... */
#define	xdiSMTStationType		(fddiSMT | 203)
#define	xdiSMTPathLatencyRing1		(fddiSMT | 204)
#define	xdiSMTPathLatencyRing2		(fddiSMT | 205)
#define	xdiSMTTopology			(fddiSMT | 206)
#define	xdiSMTOutIndex1			(fddiSMT | 207)
#define	xdiSMTOutIndex2			(fddiSMT | 208)
#define	xdiSMTSB_Flag			(fddiSMT | 209)
	u_char		Topology;
	u_short		OutIndex1;
	u_short		OutIndex2;
	u_short		Port_Ct;
	u_char		SB_Flag;
} XDISMTGrpType;

/*
*	MAC Attribute Constants
*/
#define			fddiMACCapabilitiesGrp		(fddiMAC | 10)/*RO*/
typedef	struct MACCapabilitiesGrpStruct {
#define			fddiMACFrameStatusCapabilities	(fddiMAC | 11)/*RO*/
	u_short		FrameStatusCapabilities;/* AC indicator capabilities */
#define			fddiMACBridgeFunction		(fddiMAC | 12)/*RO*/
	u_short		BridgeFunction;		/* bridging type */
#define			fddiMACT_MaxGreatestLowerBound	(fddiMAC | 13)/*RO*/
	u_int		T_MaxGreatestLowerBound;/* lowest T_Max */
#define			fddiMACTVXGreatestLowerBound	(fddiMAC | 14)/*RO*/
	u_int		TVXGreatestLowerBound;	/* lowext TVX */
} MACCapabilitiesGrpType;

#define			fddiMACConfigGrp		(fddiMAC | 20)/*RO*/
typedef	struct MACConfigGrpStruct {
#define			fddiMACPathsAvailable		(fddiMAC | 22)/*RO*/
	u_char		PathsAvailable;		/* usable MAC paths */
#define			fddiMACCurrentPath		(fddiMAC | 23)/*RO*/
	u_short		CurrentPath;		/* path for MAC */
#define			fddiMACUpstreamNbr		(fddiMAC | 24)/*RO*/
	MACAddr48	UpstreamNbr;		/* MAC's upstream neighbor */
#define			fddiMACDownstreamNbr		(fddiMAC | 25)/*RO*/
	MACAddr48	DownstreamNbr;		/* MAC's dwnstrm neighbor */
#define			fddiMACOldUpstreamNbr		(fddiMAC | 26)/*RO*/
	MACAddr48	OldUpstreamNbr;		/* MAC's previous nbr */
#define			fddiMACOldDownstreamNbr		(fddiMAC | 27)/*RO*/
	MACAddr48	OldDownstreamNbr;	/* MAC's pervious nbr */
#define			fddiMACRootConcentratorMAC	(fddiMAC | 28)/*RO*/
	u_char		RootConcentratorMAC;	/* flag if root */
#define			fddiMACDup_Addr_Test		(fddiMAC | 29)/*RO*/
	u_short		Dup_Addr_Test;		/* dup addr test status */
#define			fddiMACPathsRequested		(fddiMAC | 32)
	u_char		PathsRequested;		/* preferred path for MAC */
#define			fddiMACDownstreamPORTType	(fddiMAC | 33)/*RO*/
	u_short		DownstreamPORTType;	/* PC-Type of dwnstrm prt */
} MACConfigGrpType;

#define			fddiMACAddressGrp		(fddiMAC | 40)/*RO*/
typedef	struct MACAddressGrpStruct {
#define			fddiMACSMTAddress		(fddiMAC | 41)
	MACAddr48	SMTAddress;		/* MAC's 48-bit address */
#define			fddiMACLongAliases		(fddiMAC | 42)
	u_char		*LongAliases;		/* list of long aliases */
#define			fddiMACShortAliases		(fddiMAC | 43)
	u_char		*ShortAliases;		/* list of short aliases */
#define			fddiMACLongGrpAddrs		(fddiMAC | 44)
	u_char		*LongGrpAddrs;		/* list of long group addrs */
#define			fddiMACShortGrpAddrs		(fddiMAC | 45)
	u_char		*ShortGrpAddrs;		/* list of short group addrs */
} MACAddressGrpType;

#define			fddiMACOperationGrp		(fddiMAC | 50)/*RO*/
typedef	struct MACOperationGrpStruct {
#define			fddiMACT_Req			(fddiMAC | 51)
	u_int		T_Req;
#define			fddiMACT_Neg			(fddiMAC | 52)/*RO*/
	u_int		T_Neg;
#define			fddiMACT_Max			(fddiMAC | 53)/*RO*/
	u_int		T_Max;
#define			fddiMACTvxValue			(fddiMAC | 54)/*RO*/
	u_int		TvxValue;
#define			fddiMACT_Min			(fddiMAC | 55)
	u_int		T_Min;
#define			fddiMACT_Pri0			(fddiMAC | 56)/*RO*/
	u_int		T_Pri0;
#define			fddiMACT_Pri1			(fddiMAC | 57)/*RO*/
	u_int		T_Pri1;
#define			fddiMACT_Pri2			(fddiMAC | 58)/*RO*/
	u_int		T_Pri2;
#define			fddiMACT_Pri3			(fddiMAC | 59)/*RO*/
	u_int		T_Pri3;
#define			fddiMACT_Pri4			(fddiMAC | 60)/*RO*/
	u_int		T_Pri4;
#define			fddiMACT_Pri5			(fddiMAC | 61)/*RO*/
	u_int		T_Pri5;
#define			fddiMACT_Pri6			(fddiMAC | 62)/*RO*/
	u_int		T_Pri6;
#define			fddiMACFrameStatus		(fddiMAC | 63)
	u_short		FrameStatus;		/* MAC's current status */
} MACOperationGrpType;

#define			fddiMACCountersGrp		(fddiMAC | 70)/*RO*/
typedef	struct MACCountersGrpStruct {
#define			fddiMACFrame_Ct			(fddiMAC | 71)/*RO*/
	u_int		Frame_Ct;
#define			fddiMACCopied_Ct		(fddiMAC | 72)/*RO*/
	u_int		Copied_Ct;
#define			fddiMACTransmit_Ct		(fddiMAC | 73)/*RO*/
	u_int		Transmit_Ct;
#define			fddiMACToken_Ct			(fddiMAC | 74)/*RO*/
	u_int		Token_Ct;
} MACCountersGrpType;

#define			fddiMACErrorCtrsGrp		(fddiMAC | 80)/*RO*/
typedef	struct MACErrorCtrsGrpStruct {
#define			fddiMACError_Ct			(fddiMAC | 81)/*RO*/
	u_int		Error_Ct;
#define			fddiMACLost_Ct			(fddiMAC | 82)/*RO*/
	u_int		Lost_Ct;
#define			fddiMACTvxExpired_Ct		(fddiMAC | 83)/*RO*/
	u_int		TvxExpired_Ct;
#define			fddiMACNotCopied_Ct		(fddiMAC | 84)/*RO*/
	u_int		NotCopied_Ct;
#define			fddiMACLate_Ct			(fddiMAC | 85)/*RO*/
	u_short		Late_Ct;
#define			fddiMACRingOp_Ct		(fddiMAC | 86)/*RO*/
	u_int		RingOp_Ct;
} MACErrorCtrsGrpType;

#define			fddiMACFrameErrorConditionGrp	(fddiMAC | 90)/*RO*/
typedef	struct MACFrameErrorConditionGrpStruct {
#define			fddiMACBaseFrame_Ct		(fddiMAC | 91)/*RO*/
	u_int		BaseFrame_Ct;
#define			fddiMACBaseError_Ct		(fddiMAC | 92)/*RO*/
	u_int		BaseError_Ct;
#define			fddiMACBaseLost_Ct		(fddiMAC | 93)/*RO*/
	u_int		BaseLost_Ct;
#define			fddiMACBaseTimeFrameError	(fddiMAC | 94)/*RO*/
	SMTTimeStamp	BaseTimeFrameError;
#define			fddiMACFrameErrorThreshold	(fddiMAC | 95)
	u_short		FrameErrorThreshold;
#define			fddiMACFrameErrorRatio		(fddiMAC | 96)/*RO*/
	u_short		FrameErrorRatio;
} MACFrameErrorConditionGrpType;

#define			fddiMACNotCopiedConditionGrp	(fddiMAC | 100)/*RO*/
typedef	struct MACNotCopiedConditionGrpStruct {
#define			fddiMACBaseNotCopied_Ct		(fddiMAC | 101)/*RO*/
	u_int		BaseNotCopied_Ct;
#define			fddiMACBaseTimeNotCopied	(fddiMAC | 102)/*RO*/
	SMTTimeStamp	BaseTimeNotCopied;
#define			fddiMACNotCopiedThreshold	(fddiMAC | 103)
	u_short		NotCopiedThreshold;
#define			fddiMACBaseCopied_Ct		(fddiMAC | 104)/*RO*/
	u_int		BaseCopied_Ct;
#define			fddiMACNotCopiedRatio		(fddiMAC | 105)/*RO*/
	u_short		NotCopiedRatio;
} MACNotCopiedConditionGrpType;

#define			fddiMACStatusGrp		(fddiMAC | 110)/*RO*/
typedef	struct MACStatusGrpStruct {
#define			fddiMACRMTState			(fddiMAC | 111)/*RO*/
	u_char		RMTState;		/* current RMT state */
#define			fddiMACDa_Flag			(fddiMAC | 112)/*RO*/
	u_char		Da_Flag;		/* dup addr flag */
#define			fddiMACUnaDa_Flag		(fddiMAC | 113)/*RO*/
	u_char		UnaDa_Flag;		/* dup addr from UNA */
#define			fddiMACFrameErrorCondition	(fddiMAC | 114)/*RO*/
	u_char		FrameErrorCondition;	/* current condition */
#define			fddiMACNotCopiedCondition	(fddiMAC | 115)/*RO*/
	u_char		NotCopiedCondition;	/* current condition */
#define			fddiMACLLCServiceAvailable	(fddiMAC | 116)/*RO*/
	u_char		LLCServiceAvailable;	/* LLC service enabled */
} MACStatusGrpType;

#define			fddiMACRootMACStatusGrp		(fddiMAC | 120)/*RO*/
typedef	struct MACRootMACStatusGrpStruct {
#define			fddiMACMasterSlaveLoopStatus	(fddiMAC | 121)/*RO*/
	u_char		MasterSlaveLoopStatus;	/* loop detection stat */
#define			fddiMACRootMACDownstreamPORTType (fddiMAC | 122)/*RO*/
	u_char		RootMACDownStreamPORTType;
#define			fddiMACRootMACCurrentPath	(fddiMAC | 123)/*RO*/
	u_short		RootMACCurrentPath;	/* path for root MAC */
} MACRootMACStatusGrpType;

/* XDI added attributes */
typedef	struct XDIMACGrpStruct {
#define	xdiMACRMTDupPolicy1		(fddiMAC | 201)
	u_char		RMTDupPolicy1;
#define	xdiMACRMTDupPolicy2		(fddiMAC | 202)
	u_char		RMTDupPolicy2;
/* BOGUS???? */
#define	xdiMACResourceIndex		(fddiMAC | 203)/*RO*/
#define	xdiMACConnectedIndex		(fddiMAC | 204)/*RO*/
#define	xdiMACDataAddress		(fddiMAC | 205)
#define	xdiMACOperational		(fddiMAC | 207)
	u_char		NeighborChange;
	MACAddr48	DataAddress;
	u_char		Operational;
} XDIMACGrpType;

/*
*	Path Class Attributes
*/
#define			fddiPATHConfigGrp		(fddiPATHClass | 10)
typedef	struct ClassConfigGrpStruct {
#define			fddiPATHClassTrace_MaxExpiration (fddiPATHClass | 12)
	u_int		Trace_MaxExpiration;	/* value of Trace_Max */
#define			fddiPATHClassTVXLowerBound	(fddiPATHClass | 13)
	u_int		TVXLowerBound;		/* lower bound of TVX */
#define			fddiPATHClassT_MaxLowerBound	(fddiPATHClass | 14)
	u_int		T_MaxLowerBound;	/* lower bound of T_Max */
} ClassConfigGrpType;

/*
*	Path Class Path Attributes
*/
#define			fddiPATHClassPATHConfigGrp	(fddiPATHClassPATH | 10)/*RO*/
typedef	struct ClassPATHConfigGrpStruct {
#define			fddiPATHClassPATHClassType	(fddiPATHClassPATH | 11)/*RO*/
	u_short		Type;			/* which path */
#define			fddiPATHClassPATHPORTOrder	(fddiPATHClassPATH | 12)/*RO*/
	u_short		PORTOrder;		/* ascending/descending */
#define			fddiPATHClassPATHRingLatency	(fddiPATHClassPATH | 13)
	u_int		RingLatency;		/* latency on this path */
#define			fddiPATHClassPATHTraceStatus	(fddiPATHClassPATH | 14)/*RO*/
	u_short		TraceStatus;		/* current trace status */
#define			fddiPATHClassPATHSba		(fddiPATHClassPATH | 15)
	u_int		Sba;			/* SBA for path */
#define			fddiPATHClassPATHSbaOverhead	(fddiPATHClassPATH | 16)
	u_short		SbaOverhead;		/* overhead for path */
#define			fddiPATHClassPATHStatus		(fddiPATHClassPATH | 17)/*RO*/
	u_short		Status;			/* wrapped/through */
#define			fddiPATHClassPATHConfiguration	(fddiPATHClassPATH | 18)/*RO*/
	PathConfigType	Configuration;		/* path configuration */
#define			fddiPATHClassPATHT_Rmode	(fddiPATHClassPATH | 19)
	u_int		T_Rmode;		/* restricted dialog limit */
} ClassPATHConfigGrpType;

/*
*	Port Attributes
*/
#define			fddiPORTConfigGrp		(fddiPORT | 10)/*RO*/
typedef	struct PORTConfigGrpStruct {
#define			fddiPORTPC_Type			(fddiPORT | 12)/*RO*/
	u_char		PC_Type;		/* type of PORT */
#define			fddiPORTPC_Neighbor		(fddiPORT | 13)/*RO*/
	u_char		PC_Neighbor;		/* type of neighbor PORT */
#define			fddiPORTConnectionPolicies	(fddiPORT | 14)
	u_char		ConnectionPolicies;	/* requested policies */
#define			fddiPORTRemoteMACIndicated	(fddiPORT | 15)/*RO*/
	u_char		RemoteMACIndicated;	/* 1 if True, 0 False */
#define			fddiPORTCE_State		(fddiPORT | 16)/*RO*/
	u_char		CE_State;		/* config element state */
#define			fddiPORTPathsRequested		(fddiPORT | 17)
	u_char		PathsRequested;		/* requested path for S/M */
#define			fddiPORTMACPlacement		(fddiPORT | 18)/*RO*/
	u_short		MACPlacement;		/* MAC index of upstream MAC */
#define			fddiPORTAvailablePaths		(fddiPORT | 19)/*RO*/
	u_char		AvailablePaths;		/* paths usable for S/M */
#define			fddiPORTMACLoop_Time		(fddiPORT | 21)
	u_int		MACLoop_Time;		/* value of T_Next(9) */
#define			fddiPORTFotxClass		(fddiPORT | 22)/*RO*/
	u_char		FotxClass;		/* optic xmitter class */
} PORTConfigGrpType;

#define			fddiPORTOperationGrp		(fddiPORT | 30)/*RO*/
typedef	struct PORTOperationGrpStruct {
#define			fddiPORTMaintLineState		(fddiPORT | 31)
	u_char		MaintLineState;		/* current maint LS */
#define			fddiPORTTB_Max			(fddiPORT | 32)
	u_int		TB_Max;			/* value of TB_Max */
#define			fddiPORTBS_Flag			(fddiPORT | 33)/*RO*/
	u_char		BS_Flag;		/* 1 True, 0 False */
} PORTOperationGrpType;

#define			fddiPORTErrorCtrsGrp		(fddiPORT | 40)/*RO*/
typedef	struct PORTErrorCtrsGrpStruct {
#define			fddiPORTEBError_Ct		(fddiPORT | 41)/*RO*/
	u_int		EBErr_Ct;		/* EB overflow count */
#define			fddiPORTLCTFail_Ct		(fddiPORT | 42)/*RO*/
	u_int		LCTFail_Ct;		/* # fails for LCT */
} PORTErrorCtrsGrpType;

#define			fddiPORTLerGrp			(fddiPORT | 50)/*RO*/
typedef	struct PORTLerGrpStruct {
#define			fddiPORTLer_Estimate		(fddiPORT | 51)/*RO*/
	u_char		Ler_Estimate;		/* exponent of estimate */
#define			fddiPORTLem_Reject_Ct		(fddiPORT | 52)/*RO*/
	u_int		Lem_Reject_Ct;		/* # times link rejected */
#define			fddiPORTLem_Ct			(fddiPORT | 53)/*RO*/
	u_int		Lem_Ct;			/* # errors detected */
#define			fddiPORTBaseLer_Estimate	(fddiPORT | 54)/*RO*/
	u_char		BaseLer_Estimate;
#define			fddiPORTBaseLem_Reject_Ct	(fddiPORT | 55)/*RO*/
	u_int		BaseLem_Reject_Ct;
#define			fddiPORTBaseLem_Ct		(fddiPORT | 56)/*RO*/
	u_int		BaseLem_Ct;
#define			fddiPORTBaseLer_TimeStamp	(fddiPORT | 57)/*RO*/
	SMTTimeStamp	BaseLer_TimeStamp;
#define			fddiPORTLer_Cutoff		(fddiPORT | 58)
	u_char		Ler_Cutoff;		/* level for cutoff */
#define			fddiPORTLer_Alarm		(fddiPORT | 59)
	u_char		Ler_Alarm;		/* level for alarm */
} PORTLerGrpType;


#define			fddiPORTStatusGrp		(fddiPORT | 60)/*RO*/
typedef	struct PORTStatusGrpStruct {
#define			fddiPORTConnectState		(fddiPORT | 61)/*RO*/
	u_short		ConnectState;		/* current connect state */
#define			fddiPORTPCMState		(fddiPORT | 62)/*RO*/
	u_char		PCMState;		/* state of PCM */
#define			fddiPORTPC_Withhold		(fddiPORT | 63)/*RO*/
	u_char		PC_Withhold;		/* withhold reason */
#define			fddiPORTLerCondition		(fddiPORT | 64)/*RO*/
	u_char		LerCondition;		/* current condition state */
} PORTStatusGrpType;


/* XDI added attributes */
typedef	struct XDIPORTGrpStruct {
/* BOGUS???? */
#define	xdiPORTResourceIndex				(fddiPORT | 201) /*RO*/
#define	xdiPORTConnectedIndex				(fddiPORT | 202) /*RO*/
#define	xdiPORTOperational				(fddiPORT | 203)
	u_char		Operational;
	u_int		BaseEBError_Ct;
} XDIPORTGrpType;

/*
*	Attachment Attributes
*/
#define			fddiATTACHConfigGrp		(fddiATTACH | 10)/*RO*/
typedef	struct ATTACHConfigGrpStruct {
#define			fddiATTACHClass			(fddiATTACH | 11)/*RO*/
	u_short		Class;			/* dual, single, conc. */
#define			fddiATTACHOpticalBypassPresent	(fddiATTACH | 12) /*RO*/
	u_char		OpticalBypassPresent;	/* 1 True, 0 False */
#define			fddiATTACHI_MaxExpiration	(fddiATTACH | 13)/*RO*/
	u_int		I_MaxExpiration;	/* I_Max value */
#define			fddiATTACHInsertedStatus	(fddiATTACH | 14)/*RO*/
	u_char		InsertedStatus;		/* 1 True, 0 False */
#define			fddiATTACHInsertPolicy		(fddiATTACH | 15)
	u_char		InsertPolicy;		/* 1 insert, 0 don't insert */
} ATTACHMENTConfigGrpType;


/*
 *	MIB Actions Frames
 */
#define			fddiSMTStationAction		(fddiSMT | 60)
#define			fddiMACAction			(fddiMAC | 130)
#define			fddiPORTAction			(fddiPORT | 70)


/*
 *	MIB Events and Conditions Frames
 */
/* Configuration Change Event */
typedef struct EvtCfgChgStruct {
#define			fddiSMTConfigurationChgEvent	(fddiSMT | 70)
	TLVHdrType	eventHdr;	/* event header */
	TLVHdrType	CF_StateHdr;	/* CF_State header */
	TLV8BitType	CF_State;	/* CF_State value */
#ifdef OPTIONAL_PARAMETER
	TLVHdrType	PathListHdr;	/* Path list header */
	TLV16BitType	pathIndex;	/* index for path */
					/* maximum size path list */
	u_char		PathList[(MAX_MAC_COUNT + MAX_PORT_COUNT) * 4];
#endif
}
EvtCfgChgType;

/* Duplicate Address Condition */
typedef struct CondDAStruct {
#define			fddiMACDuplicateAddressCondition	(fddiMAC | 140)
	TLVHdrType	condHdr;	/* condition header */
	u_short		Condition;	/* condition status */
	u_short		MACIndex;	/* index (MIB value) */
	MACAddr48	DuplicateAddr;	/* this duplicate */
	MACAddr48	UNADuplicateAddr;	/* UNA duplicate */
} CondDAType;

/* Frame Error Condition */
typedef struct CondFrErrStruct {
#define			fddiMACFrameErrorConditionEvent	(fddiMAC | 141)
	TLVHdrType	condHdr;	/* condition header */
	u_short		Condition_State;
	u_short		MACIndex;	/* index (MIB value) */
	u_int		Frame_Ct;
	u_int		Error_Ct;
	u_int		Lost_Ct;
	u_int		BaseFrame_Ct;
	u_int		BaseError_Ct;
	u_int		BaseLost_Ct;
	SMTTimeStamp	BaseTimeStamp;
	u_char		pad[2];
	u_short		FrameErrorRatio;
} CondFrErrType;

/* Not Copied Condition */
typedef struct CondNotCopiedStruct {
#define			fddiMACNotCopiedConditionEvent	(fddiMAC | 142)
	TLVHdrType	condHdr;	/* condition header */
	u_short		Condition_State;
	u_short		MACIndex;	/* index (MIB value) */
	u_int		NotCopied_Ct;
	u_int		Copied_Ct;
	u_int		BaseNotCopied_Ct;
	SMTTimeStamp	BaseTimeStamp;
	u_int		BaseCopied_Ct;
	u_char		pad[2];
	u_short		NotCopiedRatio;
} CondNotCopiedType;

/* MAC Neighbor Change Event */
typedef struct EvtNbrChgStruct {
#define			fddiMACNeighborChangeEvent		(fddiMAC | 143)
	TLVHdrType	eventHdr;
	u_short		Condition;
	u_short		MACIndex;
	MACAddr48	Old_UNA;
	MACAddr48	New_UNA;
	MACAddr48	Old_DNA;
	MACAddr48	New_DNA;
} EvtNbrChgType;

/* Trace Status Event */
typedef struct EvtTrStatType {
#define			fddiPATHTraceStatusEvent	(fddiPATHClassPATH | 30)
	TLVHdrType	eventHdr;
	u_char		pad;
	u_char		TraceStarted;
	u_char		TraceTerminated;
	u_char		TracePropagated;
} EvtTrStatType;

/* Ler Condition */
typedef struct CondLerStruct {
#define			fddiPORTLerConditionEvent	(fddiPORT | 80)
	TLVHdrType	condHdr;
	u_short		ConditionState;
	u_short		PORTIndex;
	u_char		pad1;
	u_char		Ler_Cutoff;
	u_char		Ler_Alarm;
	u_char		Ler_Estimate;
	u_int		Lem_Reject_Ct;
	u_int		Lem_Ct;
	u_char		pad2[3];
	u_char		BaseLer_Estimate;
	u_int		BaseLem_Reject_Ct;
	u_int		BaseLem_Ct;
	SMTTimeStamp	BaseLer_TimeStamp;
} CondLerType;

/* Undesired Connection Attempt Event */
#define			fddiPORTUndesiredConnectionAttempt	(fddiPORT | 81)
typedef struct EvtConnectStruct {
	TLVHdrType	eventHdr;
	u_char		pad[2];
	u_short		PORTIndex;
	u_char		PC_Type;
	u_char		connectState;
	u_char		PC_Neighbor;
	u_char		connectionAccepted;
} EvtConnectType;

/* EB Error Condition */
typedef struct CondEBErrStruct {
#define			fddiPORTEBErrorConditionEvent	(fddiPORT | 82)
	TLVHdrType	condHdr;
	u_short		ConditionState;
	u_short		PORTIndex;
	u_int		EbError_Ct;
} CondEBErrType;


/* end of MIB information */
#endif	if_if_prgreg_fddi_h
