/* @(#) if_npreg.h 1.1@(#) Solbourne id 9/22/93 00:12:02 */
/*
 * 	Copyright (c) 1991 by Network Peripherals Inc.
 * 			All rights reserved.
 */
struct np_registers {
	u_char		spare00;
	u_char	np_cden;			/* addr = 01 */
#define		  NP_CDEN_NORMAL	0x00	/* reset bit clear */
#define		  NP_CDEN_INTSEL0	0x01	/* interrupt selection bit 0 */
#define		  NP_CDEN_INTSEL1	0x02	/* interrupt selection bit 1 */
#define		  NP_CDEN_INTSEL2	0x04	/* interrupt selection bit 2 */
#define		  NP_CDEN_BLOCK		0x08	/* Enables Block Mode DMA */
#define		  NP_CDEN_RESET		0x80	/* reset bit SET */
	u_char		spare02_08[0x09-0x01-1];/* 7 */
	u_char	np_int_vector;			/* addr = 09 */
	u_char		spare0A_10[0x11-0x09-1];/* 7 */
	u_char	np_intmsk;			/* addr = 11 */
	u_char		spare12_18[0x19-0x11-1];/* 7 */
	u_char	np_intsts;			/* addr = 19 */
#define		  NP_INTSTS_ALL_CLEAR	0x00	/* clear all int */
#define		  NP_INTSTS_R_F_UNDER	0x01	/* receive fifo underflow */
#define		  NP_INTSTS_T_F_OVER	0x02	/* transmit fifo overflow */
#define		  NP_INTSTS_R_F_FRAME	0x04	/* rcv fifo has frame */
#define		  NP_INTSTS_T_F_FULL	0x08	/* transmit fifo is full */
#define		  NP_INTSTS_HPC_SREQ	0x10	/* HPC - Srvice request */
#define		  NP_INTSTS_T_F_DMA	0x20	/* DMA for tramsmit done */
#define		  NP_INTSTS_R_F_DMA	0x40	/* DMA for receive done */
#define		  NP_INTSTS_X_INT	0x80	/* OR of all other bits */
	u_char		spare1A_20[0x21-0x19-1];/* 7 */
	u_char	np_fifoctl;			/* addr = 21 */
#define		  NP_FIFOCTL_NORMAL	0x00	/* normal - all bits 0 */
#define		  NP_FIFOCTL_RXRST	0x01	/* reset RX */
#define		  NP_FIFOCTL_TXRST	0x02	/* reset TX */
#define		  NP_FIFOCTL_TRXRST	0x03	/* reset RX and TX */
#define		  NP_FIFOCTL_TXFRAME	0x04	/* transmit frame */
#define		  NP_FIFOCTL_TXDONE	0x00	/* transmit done */
#define		  NP_FIFOCTL_TXABORT	0x06	/* transmit abort */
#define		  NP_FIFOCTL_PROMISC	0x18	/* promisc mode */
#define		  NP_FIFOCTL_TXARM	0x20	/* DMA tx arm */
#define		  NP_FIFOCTL_RXARM	0x40	/* DMA rx arm */
	u_char		spare22_28[0x29-0x21-1];		/* 7 */
	u_char	np_fifosts;			/* addr = 29 */
#define		  NP_FIFOSTS_RERR	0x01	/* receiver error */
#define		  NP_FIFOSTS_TERR	0x02	/* transmit error */
#define		  NP_FIFOSTS_REMPTY	0x04	/* receiver empty */
#define		  NP_FIFOSTS_TFULL	0x08	/* transmiter full */
#define		  NP_FIFOSTS_TXDONE	0x20	/* DMA tx done */
#define		  NP_FIFOSTS_RXDONE	0x40	/* DMA rx done */
	u_char		spare2A_2F[0x30-0x29-1];		/* 6 */
	u_int	np_fifodata;			/* addr = 30 */
	u_char		spare35_38[0x39-0x34-1];/* 4 */
	union {
		u_short	upic;
		u_short	mbcmd;
	}	np_hpc; 			/* addr = 38 */
#define		  NP_HPC_NOT_WREADY	0x01
#define		  NP_HPC_NOT_RREADY	0x02
	u_char		spare3A_3B[0x3C-0x39-1];/* 2 */
	u_short	np_mbdata;			/* addr = 3C */
	u_char		spare3E_3F[0x3F-0x3C-1];/* 2 */
	u_char	np_prom[32];			/* addr = 40 */
						/* prom data on odd
						 * bytes in array  */
	u_short	np_tx_data_lo;			/* addr = 60 */
	u_short	np_tx_data_hi;			/* addr = 62 */
	u_short		spare64;		/* addr = 64 */
	u_short		spare66;		/* addr = 66 */
	u_short	np_rx_data_lo;			/* addr = 68 */
	u_short	np_rx_data_hi;			/* addr = 6A */
	u_short		spare6c;		/* addr = 6C */
	u_short		spare6e;		/* addr = 6E */
	u_short	np_tx_count;			/* addr = 70 */
	u_short		spare72;		/* addr = 72 */
	u_short		spare74;		/* addr = 74 */
	u_short		spare76;		/* addr = 76 */
	u_short	np_rx_count;			/* addr = 78 */
	u_short		spare7A;		/* addr = 7A */
	u_short		spare7C;		/* addr = 7C */
	u_short		spare7E;		/* addr = 7E */
};

#define BYTE_SWAP(x) (((((x)&0xff00)>>8)&0x00ff) | ((((x)&0x00ff)<<8)&0xff00))

/*
 * Types for ehternet demuxing
 */
#define ETHERTYPE_PUP	0x0200		/* PUP protocol */
#define ETHERTYPE_IP	0x0800		/* IP protocol */
#define ETHERTYPE_ARP	0x0806		/* Addr. resolution protocol */
#define ETHERTYPE_RARP	0x8035		/* Reverse ARP */

typedef struct {
	u_short control;
	u_short packet_count;
	u_short pad;
	u_short fc;
	union {
		u_short w[3];
		u_char b[6];
	} da;
	union {
		u_short w[3];
		u_char b[6];
	} sa;
	union {
		u_short w[3];
		u_char b[6];
	} snap;
	u_short etype;
} Npi_llc_header;


typedef struct {
	u_char ethernet[6]; /* read from PROM */
	u_char fddi[6]; /* corrected bit ordering */
} Npi_IEEE_Address;

#define BUF_MAX_FDDI_PACKET 6000 /* only used for buffer space allocation */

typedef struct
{
	short	r_rdidx;
	short	r_wrtidx;
	short	r_size;
	short	r_pad;
	u_int	r_slot[1];
} RING;

typedef struct
{
	short	r_rdidx;
	short	r_wrtidx;
	short	r_size;
	short	r_pad;
	u_int	r_slot[16];
} RING16;

struct np_softc {
    struct arpcom	ns_ac;
#define			ns_if		ns_ac.ac_if
#define			ns_enaddr	ns_ac.ac_enaddr	/* internet bit order */
    Npi_IEEE_Address	ns_addr;
    Npi_llc_header	ns_llc_template;
    int			ns_started_already;
    int			ns_llc_available_state;
    int			ns_card_exists;
    int			ns_smt_open;
    int			ns_tx_dma_done;
    char		*ns_tx_buf_dvma;
    char		*ns_tx_buf_kern;
    int			ns_tx_buf_index;
    union {
	u_char	b[BUF_MAX_FDDI_PACKET];
	u_short	w[BUF_MAX_FDDI_PACKET/2];
	u_int	l[BUF_MAX_FDDI_PACKET/4];
    } ns_send_buffer;
    int			ns_ints_received;
    struct ifqueue	ns_smt_inq;
    struct ifqueue	ns_send_outq;
    int			ns_smt_sleep_channel;
    int			ns_MAC_is_available;
    int			ns_hi_32_time_stamp;
    RING16		ns_tx_free;
    RING16		ns_rx_free;
    RING16		ns_dma_tx_req;
    RING16		ns_rx_free_dangle;
    u_int		ns_dma_rx_req;
    u_int		ns_rx_wait_resource;
    u_int		ns_inited;
    struct smt		*ns_smtp;
    u_int		ns_flags;
    u_int		ns_rx_buf;
    u_int		ns_bogus_ct;
};

#define SPLLEVEL spl3()
#define NP_FDDIMTU (4096+256)

/* The following are definition from RFC1188 */
#define UI		3			/* unumbered information */
#define SNAP_SAP	170
#define GLOBAL_SAP	255
#define NULL_SAP	0
#define XID		175
#define XID_PF		191		/* XID with Poll/Final */
#define TEST		227
#define TEST_PF		243		/* TEST with Poll/Final */

#define LLC_UI		((SNAP_SAP << 24)|(SNAP_SAP << 16)|(UI << 8)|0)

/*
 * struct for 802.2 LLC & SNAP checking, I move one byte from snap into
 * llc to get an integer structure, since the 1st byte of SNAP should be
 * 0 anyway.
 */
typedef struct {
    u_int llc;
    union {
	   u_int snap;
	   struct {
		   u_short pad;
		   u_short ether_type;
	   } ether_type;
    } snap;

} LLC_SNAP;

/* struct same as above, but used for doing response to XID & TEST */
typedef struct {
	u_char	dsap,
		ssap,
		control,
		org[3];
	u_short	ether;
} LLC_SNAP1;

#define LLC	snap.llc
#define SNAP	snap.snap
#define ether 	snap.ether_type.ether_type

typedef struct	{
	u_short	a[3];
} Integer48;

typedef struct {
	u_int		ctl_len;
	u_int		fc;
	Integer48	da;
	Integer48	sa;
	LLC_SNAP	llc_snap;
} fddi_llc_header;


typedef struct {
	u_int		length;
	struct mbuf	*m;
	u_char		*data;
	u_char		*dvma;
	u_char		ctl,
			unit,
			flag,
			pad;
} dma_req;

#define dma_req_t 	dma_req *

#define NUM_REQ	16
#define NUM_RX		12
#define NUM_TX		NUM_REQ - NUM_RX

#define NPI_BUFFER_SIZE		4500

#define ASYNC_HIGHEST	0x57


/*
 * 	Copyright (c) 1991 by Network Peripherals Inc.
 * 			All rights reserved.
 */
/*
 * Common .h between smt driver and smt daemon/stat programs
 */

/* NOTE BASED ON STANDARD DOCUMENT X3T9.5/84-49 IE SMT6.1 */

/*
 * Ioctl controls
 */
#include <sys/ioccom.h>
typedef struct {
	u_char address[6];
} network_address_type_def;
#define SMT_IOCTL_R_MYFDDIADDR _IOR(w,1,network_address_type_def)
#define SMT_IOCTL_R_MYENETADDR _IOR(w,2,network_address_type_def)
#define SMT_IOCTL_P_Basic_HPC _IO(w,4)
#define SMT_IOCTL_R_HPC _IOWR(w,5,long)
#define SMT_IOCTL_W_HPC _IOW(w,6,long)
#define SMT_IOCTL_R_SMT_TIMESTAMP _IORN(w,7,2*sizeof(long))
#define SET_LLC_NOT_AVAIL _IO(w,13)
#define SET_LLC_AVAIL _IO(w,12)

/*
 * ***********************************************************
 * ********************* HPC DEFINITIONS *********************
 * ***********************************************************
 */

/*
 * HPC data size definition bits
 */
#define HPC_SIZE_MASK 0x1800
#define HPC_NO_DATA   0x0000
#define HPC_SIZE_LONG 0x0800
#define HPC_SIZE_WORD 0x1000
#define HPC_SIZE_BYTE 0x1800


/* HPC  Dependant defines Mailbox commands */
/* Operations (other than heart bypass which is defined in med.h) */
#define HPC_SIGNAL 	0x0000
#define HPC_WRITE		0x2000
#define HPC_OR			0x4000
#define HPC_AND		0x6000
#define HPC_READ		0x8000
#define HPC_XCHG		0xA000
#define HPC_TEST_AND_SET 0xC000
#define HPC_TEST_AND_CLR 0xE000

/* Memory map of HPC controlled data space */
#define HPC_SMT_REGS 0x0200

#define HPC_MAC1_REGS 0x0280
#define HPC_MAC2_REGS 0x02C0
#define HPC_RMT1_REGS HPC_MAC1_REGS
#define HPC_RMT2_REGS HPC_MAC2_REGS

#define HPC_PORT1_REGS 0x0300
#define HPC_PORT2_REGS 0x0340
#define HPC_PORT3_REGS 0x0380
#define HPC_PORT4_REGS 0x03C0
#define HPC_CMT1_REGS HPC_PORT1_REGS
#define HPC_CMT2_REGS HPC_PORT2_REGS
#define HPC_CMT3_REGS HPC_PORT3_REGS
#define HPC_CMT4_REGS HPC_PORT4_REGS

#define HPC_PLAYER1_REGS 0x0500
#define HPC_PLAYER2_REGS 0x0540
#define HPC_PLAYER3_REGS 0x0580
#define HPC_PLAYER4_REGS 0x05C0

#define HPC_BMAC1_REGS 0x0600
#define HPC_BMAC2_REGS 0x0700

/* composits and bit definitions */
#define HPC_SIGNAL_EC_CONNECT ((u_short)(0x0003 | HPC_SMT_REGS))
#define HPC_SIGNAL_EC_DISCONNECT ((u_short)(0x0002 | HPC_SMT_REGS))
#define HPC_SIGNAL_EC_PTPASS ((u_short)(0x0006 | HPC_SMT_REGS))
#define HPC_BMAC1_ADDR_REG (0x0040 | HPC_BMAC1_REGS | HPC_WRITE | HPC_SIZE_BYTE)

/* New way (8/28) send 0x000f to mbx command reg */
#define CLEAR_HPC_INT_COND 0x000f

/* Interrupt summary */
#define HPC_INT_SUMMARY (0x0A | HPC_SMT_REGS | HPC_SIZE_BYTE)
#define HPC_INT_SUMMARY_MASK (0x0B | HPC_SMT_REGS | HPC_SIZE_BYTE)
#define HPC_INT_SUMMARY_TMR_EVENT BIT_0
#define HPC_INT_SUMMARY_SMT_EVENT BIT_1
#define HPC_INT_SUMMARY_RMT_EVENT BIT_2
#define HPC_INT_SUMMARY_PORT1_EVENT BIT_4
#define HPC_INT_SUMMARY_PORT2_EVENT BIT_5
#define HPC_SMT_EVENT_SUMMARY 	(0x0c | HPC_SMT_REGS | HPC_SIZE_WORD)
#define HPC_SMT_EVENT_MASK 		(0x0e | HPC_SMT_REGS | HPC_SIZE_WORD)
#define HPC_RMT_EVENT_SUMMARY 	(0x04 | HPC_RMT1_REGS | HPC_SIZE_WORD)
#define HPC_RMT_EVENT_MASK 		(0x06 | HPC_RMT1_REGS | HPC_SIZE_WORD)
#define HPC_PORT1_EVENT_SUMMARY 	(0x34 | HPC_PORT1_REGS | HPC_SIZE_WORD)
#define HPC_PORT1_EVENT_MASK 		(0x36 | HPC_PORT1_REGS | HPC_SIZE_WORD)
#define HPC_PORT2_EVENT_SUMMARY 	(0x34 | HPC_PORT2_REGS | HPC_SIZE_WORD)
#define HPC_PORT2_EVENT_MASK 		(0x36 | HPC_PORT2_REGS | HPC_SIZE_WORD)
#define HPC_TMR_EVENT_SUMMARY 	(0x16 | HPC_SMT_REGS | HPC_SIZE_BYTE)
#define HPC_TMR_EVENT_MASK 		(0x17 | HPC_SMT_REGS | HPC_SIZE_BYTE)
/* Used int bits */
#define SMT_INT_TSTAMP BIT_7
#define RMT_INT_CHGMAV BIT_1
#define RMT_INT_DETECT BIT_3
#define SMT_INT_PATHTEST BIT_8
#define PORT_INT_LER_CUTOFF BIT_15
#define PORT_INT_PCM_ACTIVE BIT_9

/* Registers inside MAC */
#define HPC_MAC1_ADDR_RD (HPC_READ | HPC_SIZE_LONG | HPC_MAC1_REGS )
#define HPC_LATE_COUNT	0x0E
#define HPC_TO_COUNT 0x10
#define HPC_TX_COUNT 0x14
#define HPC_NC_COUNT 0x18
#define HPC__C_COUNT 0x1c
#define HPC_RX_COUNT 0x28
#define HPC_LO_COUNT 0x20
#define HPC_ER_COUNT 0x24

#define HPC_SMT_TIME_STAMP_READ (0x10|HPC_SIZE_LONG|HPC_SMT_REGS|HPC_READ)
/*
 * HARDWARE dependant STUFF
 */
#define SMT_FRAME_FIFO_CONTROL (BYTE_SWAP(0x0208))
#define FRAME_COPIED 0x80 /* bit 23 of 32 read from FIFO */
#define A_INDICATOR 0x40 /* bit 22 of 32 read from FIFO */

/*
 * smt header template
 */
typedef struct {
	u_short control;
	u_short packet_count;
	u_short pad0;
	u_short FC;
	union {
		u_short w[3];
		u_char b[6];
	} DA;
	union {
		u_short w[3];
		u_char b[6];
	} SA;
	u_char Frame_Class;
	u_char Frame_Type;
	u_short Version_ID;
	u_int Transaction_ID;
	struct {
		u_char yy[2];
		u_char xx[6];
	} Station_ID;
	u_short Pad;
	u_short InfoField_Length;
} Npi_smt_header;

/*
 * SMT standard definitions
 */

#define SMT_MIN_PACKET_LENGTH sizeof(Npi_smt_header)

/*
 * Frame Classes & types
 * page 273 of 5.1
 */
#define SMT_FRAME_CLASS_NIF 0x01
#define SMT_FRAME_CLASS_C_SIF 0x02
#define SMT_FRAME_CLASS_O_SIF 0x03
#define SMT_FRAME_CLASS_ECF 0x04
#define SMT_FRAME_CLASS_RAF 0x05
#define SMT_FRAME_CLASS_RDF 0x06
#define SMT_FRAME_CLASS_SRF 0x07
#define SMT_FRAME_CLASS_G_PMF 0x08
#define SMT_FRAME_CLASS_C_PMF 0x09
#define SMT_FRAME_CLASS_A_PMF 0x0A
#define SMT_FRAME_CLASS_R_PMF 0x0B
#define SMT_FRAME_CLASS_ESF 0xFF
#define SMT_FRAME_TYPE_ANNOUNCE 0x01
#define SMT_FRAME_TYPE_REQUEST 0x02
#define SMT_FRAME_TYPE_RESPONSE 0x03

/* SMT stuff needed in drivers */
#define FRAME_CLASS_NIF SMT_FRAME_CLASS_NIF
#define FRAME_TYPE_NIF_REQUEST SMT_FRAME_TYPE_REQUEST
#define FRAME_TYPE_NIF_RESPONSE SMT_FRAME_TYPE_RESPONSE
#define FRAME_TYPE_NIF_ANNOUNCE SMT_FRAME_TYPE_ANNOUNCE
#define SMT_VERSION_ID_51 1
#define SMT_VERSION_ID_61 1
#define FC_NSA 0x4F
#define FC_SMT_info 0x41
#define SMT52_NIF_LEN_old 0x3D
#define NIF_INFO_LEN_old 0x1C
#define NIF_INFO_LEN 0x28
#define SMT52_NIF_LEN (0x3D+36-0x1C+4)

/*
 * Bit number to hex
 */
#define BIT_15 0x8000
#define BIT_14 0x4000
#define BIT_13 0x2000
#define BIT_12 0x1000
#define BIT_11 0x0800
#define BIT_10 0x0400
#define BIT_9 0x0200
#define BIT_8 0x0100
#define BIT_7 0x0080
#define BIT_6 0x0040
#define BIT_5 0x0020
#define BIT_4 0x0010
#define BIT_3 0x0008
#define BIT_2 0x0004
#define BIT_1 0x0002
#define BIT_0 0x0001

typedef struct smt {
	Integer48 una;
	Integer48 dna;
} SMT_DEV;


typedef struct {
	int	command;		/* command or index of registers */
	int	sub_command;
	int	param1;
	int	param2;
	int	param3;
	char	*where;		/* where the input or output string is */
	int	length;		/* length of the string */
} SMTCB;

#define SMT_GET	_IOWR(w, 14, SMTCB)
#define SMT_SET	_IOWR(w, 15, SMTCB)
#define SMT_ACT	_IOWR(w, 16, SMTCB)


/* sub command number for SMT_GET*/
#define GET_COUNTER_GROUP	0x1
#define GET_PORT_GROUP		0x2
#define GET_NEIGHBOR_ADDR	0x3

/* sub command number for SMT_SET */
#define SET_UNA				0x1
#define SET_DNA				0x2

typedef struct {
	u_int		late_ct;
	u_int		token_ct;
	u_int		xmit_ct;
	u_int		notcopy_ct;
	u_int		copy_ct;
	u_int		lost_ct;
	u_int		err_ct;
	u_int		frame_ct;
	u_int		ring_ct;
	u_int		tvx_ct;
	u_int		latency_ct;
	u_int		bogus_ct;
} COUNTER_GROUP;

typedef struct {
	u_char 	pcm_state;		/* 0x00 */
	u_char	pcm_idx;			/* 0x01 */
	u_short	pcm_policy;		/* 0x10 */
	u_short	r_val;			/* 0x12 */
	u_short	t_val;			/* 0x14 */
	u_char	psc_status;		/* 0x16 */
	u_char	lct_fail;		/* 0x17 */
	u_short	cem_policy;		/* 0x18 */
	u_char	cem_state;		/* 0x1A */
	u_char	lem_reject_ct;	/* 0x1C */
	u_char	ler_average;	/* 0x1D */
	u_char	ler_alarm;		/* 0x1E */
	u_char	ler_cutoff;		/* 0x1F */
	u_char	lem_ct;			/* 0x20 */
	u_char	ebe_ct;			/* 0x24 */
	u_char	ecm_state;		/* 0x30 */
} PORT_GROUP;

#undef PRINTFS
