/* @(#) if_fxvar.h 1.1@(#) Solbourne id 9/22/93 00:11:33 */
/*
 * Copyright 1990 Solbourne Computer, Inc.
 * All rights reserved.
 */
/*
 * 	Copyright (c) 1990 by Communication Machinery Corporation
 * 			All rights reserved.
 *
 * 	This software contains proprietary and confidential information
 * 	of Communication Machinery Corporation and its suppliers.  Use,
 * 	disclosure, or reproduction is prohibited without the prior express
 * 	written consent of Communication Machinery Corporation.
 */
#ifndef	_if_if_fxvar_h
#define	_if_if_fxvar_h

#include <if/mbuf_machdep.h>

/* control specific configuration information */
struct fx_conf {
    char	*fc_bname;			/* board name */
    char	*fc_pname;			/* customer product name */
    int		fc_type;
#define		  FC_TYPE_ETHER		1
#define		  FC_TYPE_FDDI		2
#define		  FC_TYPE_ASCII		{ "UNKNOWN", "ETHER", "FDDI", }
    int		fc_flags;
#define		  FC_FLAGS_LOAD		0x0001	/* must download firmware */
#define		  FC_FLAGS_HAS_NOVDMA	0x0002	/* no dma control in bcb */
#define		  FC_FLAGS_BLOCK_R	0x0004	/* block mode rcv works */
#define		  FC_FLAGS_BLOCK_X	0x0008	/* block mode xmit works */
#define		  FC_FLAGS_INTR_BOARD	0x0010	/* board supports host intr */
#define		  FC_FLAGS_OINTR_BOARD	0x0020	/* optimize intrs to board */
    int		fc_size;
    int		fc_fx_mode;		/* initial iface mode */
    int		fc_align_board;		/* board dma alignment requirements */
    int		fc_align_carve_bcb;	/* board alignment for carved bcb's */
    int		fc_align_driver;	/* driver alignment desire 1->byte */
    int		fc_min_tu;		/* min size packet */
    int		fc_max_tu;		/* max size packet */
    int		fc_buf_sz;		/* size of buffer for packet */
    int		fc_nrecv;		/* number of recieve buffers */
    int		fc_nxmit;		/* number of transmit buffers */
    int		fc_nxmit_dvma;		/* number of transmit buffers */
    int		fc_nxmit_frags;		/* number of frags per transmit buf */
    int		fc_minlen_rdma_loan;	/* min len for rcv dma to loan mbuf */
    int		fc_minlen_xdma;		/* if HAS_NOVDMA, min len xmit dma */
    int		fc_max_xbackback;	/* max # of back-to-back xmits */
    int		fc_xstrip_imm;		/* #pkts for immediate strip */
    int		fc_xstrip_to;		/* fraction of second till strip */
    int		fc_conv_bcb_max;	/* max # bcbs to convert to bcbs */
    int		fc_conv_busd_max;	/* max # bcbs to convert to busds */
    int		fc_fxctl_size;		/* size of fxctl */
};

/*
 * Network software status per interface.
 */
struct fx_softc {
    struct arpcom       fs_ac;		/* common ethernet structures */
#define			fs_if		fs_ac.ac_if
#define			fs_enaddr	fs_ac.ac_enaddr	/* internet bit order */
    struct fddi_addr	fs_wireaddr;	/* network bit order */
    short		fs_unit;	/* unit number of board */
    u_short		fs_flags;
#define			  FS_FLAGS_RUNNING	0x0001
#define			  FS_FLAGS_CONNECTED	0x0002
#define			  FS_FLAGS_STRIP_PEND	0x0004
    struct fx_conf	*fs_fc;		/* configuration information */
    struct fx_dstat	*fs_dstat;	/* driver statistics */
    FXDEVICE		*fs_fx;		/* low ram on fx board */
    u_char		*fs_fxctl_int;	/* int control window on fx board */
    u_char		*fs_fxctl_rst;	/* reset control window on fx board */
    u_int		fs_vector;	/* interrupt vector */

    caddr_t		fs_recv;	/* pointer to base of recv buffer */
    int			fs_recv_tlen;	/* length of allocated recv buffer */
    caddr_t		fs_recv_align;	/* aligned pointer to recv buffer */
    u_int		fs_recv_cookie;	/* bus cookie for base of recv buf */

    caddr_t		fs_xmit;	/* pointer to base of xmit buffers */
    int			fs_xmit_tlen;	/* length of allocated xmit buffers */
    caddr_t		fs_xmit_align;	/* aligned pointer to 1st xmit buf */
    u_int		fs_xmit_span;	/* # bytes from one xmit buf to next */
    struct mbuf		*fs_xmit_freebuf;/* list of free transmit buffers */

    caddr_t		fs_xmit_dvma;	/* DVMA address of xmit buf base */
    struct map		*fs_xmit_dvma_map;/* priviate xmit DVMA resource map */
    u_int		fs_xmit_dvma_cookie;/* bus cookie for base of xmit buf */
    u_int		fs_xmit_dvma_npf;/* number of pages for DVMA */
    int			*fs_xmit_dvma_pgref;/* page reference count */

    RING256             fs_free;	/* free transmit BCB's */
    BCB			*fs_free_bcb;	/* free dma BCB's */
    int			fs_conv_bcb;	/* # bcbs to converted to bcbs */
    BUSD		*fs_free_busd;	/* free dma BUSD's */
    int			fs_conv_busd;	/* # bcbs to converted to busds */
};

/* driver statistics: seperate from softc so it is easy to find */
struct fx_dstat {
    int		fx_dstat_intr;			/* number of interrupts */
    int		fx_dstat_npkt;			/* number of packets */
#define		  FX_STAT_NPKT_BINS	16
    int		fx_dstat_npkt_intr[FX_STAT_NPKT_BINS]; /* histogram pkt/intr*/
    int		fx_dstat_rdma;			/* number of rcv-dma's */
    int		fx_dstat_r;			/* number of rcv's */
    int		fx_dstat_xdma;			/* number of xmit-dma's */
    int		fx_dstat_x;			/* number of xmit's */
    int		fx_dstat_smt;			/* number of smt's */
    int		fx_dstat_xstrip;		/* number of xstrips's */
    int		fx_dstat_sumxlen;		/* number of bytes xmited */
    int		fx_dstat_sumrlen;		/* number of bytes rcved */
    int		fx_dstat_xalo;			/* dma xmit allocations */
    int		fx_dstat_xrel;			/* dma xmit releases */
    int		fx_dstat_xdma_unal;		/* dma xmit unaligned: xbuf */
    int		fx_dstat_xdma_toofrag;		/* dma xmit fraged: xbuf */
    int		fx_dstat_xdma_mbuf;		/* dma xmit ok: mbuf */
    int		fx_dstat_xbufs_issued;		/* number of xbufs used */
    int		fx_dstat_xbufs_returned;	/* number of xbufs returned */
    int		fx_dstat_xnobuf;		/* failed to find xbufs */
    int		fx_dstat_xmit_out_ring;		/* xmit out of rings */
    int		fx_dstat_xmit_out_busd;		/* xmit out of busd's */
    int		fx_dstat_xmit_out_dvma;		/* xmit out of dvma mappings */
#define		  FX_STAT_LEN_BINS	13
    int		fx_dstat_xlen[FX_STAT_LEN_BINS]; /* histogram pkt xmit len */
    int		fx_dstat_rlen[FX_STAT_LEN_BINS]; /* histogram pkt rcv len */
    struct	mbuf_machdep_stats	fx_dstat_mstats;
};

#endif	_if_if_fxvar_h
