/* @(#) if_eivar.h 1.1@(#) Solbourne id 9/22/93 00:11:02 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*	@(#)if_eivar.h 1.1 88/03/29 SMI	*/

/*
 * Copyright (c) 1987 by Sun Microsystems, Inc.
 */

#ifndef	_if_if_eivar_h
#define	_if_if_eivar_h

/*
 * Definitions for data structures that the
 * AMD 7990 LANCE driver uses internally.
 *
 * This file exists primarily to allow network monitoring
 * programs easy access to the definition of ei_softc.
 */
#define	EI_LOANED

/*
 * Transmit and receive buffer layout.
 *	The chip sees only the fields from lb_ehdr onwards; the
 *	preceding fields are for the driver's benefit. The e_to_lb
 *	macro defined below converts the address of the start of a lb_ehdr 
 *	field to the address of the start of the containing ei_buf structure.
 *	NOTE: The "es_rpad" padding is used to make sure that the packet 
 *	is properly aligned.  In general short alignment for revieve packets
 *	is preferable since this causes int aligment of that data portion of
 *	the packet.  However, int alignment is REQUIRED for sun's sbus 
 *	ethernet cards to work in an S4000.
 *
 *	The buffer size is chosen to give room for the maximum ether
 *	transmission unit, an overrun consisting of the entire fifo
 *	contents, and slop that experience indicates is necessary.
 *	(The exact amount of slop required is still unknown.)
 */
#ifdef S4000
struct ei_buf {
	/* Fields used only by driver: */
	struct ei_buf	*lb_next;		/* Link to next buffer */
	struct ei_softc	*lb_es;			/* Link back to sw status */
	u_short		lb_loaned;		/* buffer is loaned out */
	char		lb_preblock_pad[32];	/* make sure buffer is 
						 * in seperate cache block */
	/* Fields seen by LANCE chip: */
#define	EI_MAXBUF	(sizeof (struct ether_header) + MAXBUF + 2)
	/* NOTE: ethernet header starts at lb_buffer[es->es_[rx]pad] */
	/* NOTE: currently at short alignment boundry... */
	u_char		lb_buffer[EI_MAXBUF];	/* Packet's header and data */
	char		lb_block_pad[32];	/* padding to block for 
						 * the last write to memory 
						 */
};
#else /* !S4000 */
#define	ROUNDUP(a, n)	(((a) + ((n) - 1)) & ~((n) - 1))
#define	EI_MAXBUF ROUNDUP((2 + sizeof (struct ether_header) + MAXBUF), 32)
struct ei_buf {
	u_char		lb_buffer[EI_MAXBUF];	/* Packet's header and data */
	struct ei_buf	*lb_next;		/* Link to next buffer */
	struct ei_softc	*lb_es;			/* Link back to sw status */
	u_short		lb_loaned;		/* buffer is loaned out */
	u_short		lb_lmd_ladr;		/* lance buf addr */
	char		lb_block_pad[20];	/* padding to cache line  */
};
#endif /* !S4000 */


/*
 * Given a pointer to the ethernet frame,
 * return a pointer to the containing le_buf.
 * N.B.: This assumes that the compiler inserts no padding
 * between the fields of the le_buf structure.  (If it did, we'd be
 * in trouble on other grounds as well.)
 */
#ifdef S4000
#define e_to_lb(es, e) \
	(struct ei_buf *)((caddr_t)(e) - \
	(int)(&((struct ei_buf *)0)->lb_buffer[0]) - es->es_rpad)
#else /* !S4000 */
#define e_to_lb(es, e) \
	(struct ei_buf *)((caddr_t)(e) - \
	(int)(&((struct ei_buf *)0)->lb_buffer[0]) - 2)
#endif /* !S4000 */


/*
 * Ethernet software status per interface.
 *
 * Each interface is referenced by a network interface structure,
 * es_if, which the routing code uses to locate the interface.
 * This structure contains the output queue for the interface, its address, ...
 * "es" indicates Ethernet Software status.
 *
 * The buffer-related declarations allow for more than one packet to
 * be transmitted at a time, although the driver (and other declarations)
 * currently allows for only one at a time.
 */
struct	ei_softc {
	struct	arpcom es_ac;		/* common ethernet structures */
#define	es_if		es_ac.ac_if	/* network-visible interface */
#define	es_enaddr	es_ac.ac_enaddr	/* hardware ethernet address */
#define	es_mcaddr	es_ac.ac_mcaddr	/* multicast address vector */
#define	es_nmcaddr	es_ac.ac_nmcaddr/* count of multicast addrs */
					
	struct	ei_init_block *es_ib;	/* Initialization block */

#ifdef S4000
	int		es_lance_cookie;/* address returned from mballoc */
	int		es_lance_va;	/* address given to mballoc */
	struct icu_ether_xlate *es_asic_va;
	u_short		es_rpad;	/* alignment required on recieve */
	u_short		es_xpad;	/* alignment required on transmit */
	u_short		es_aconbcon;	/* true if csr3 needs ACON & BCON */
	u_short		es_rmw;		/* true if need bit 23 for md's */
	unsigned int	es_mask;	/* mask for lance addresses */
#else
	int		es_pad_1;
	int		es_pad_2;
	struct 	ioasic_reg *es_ioasic_va;/* virtaul address of ioasic reg. */
	u_short		es_rpad;	/* alignment required on recieve */
	u_short		es_xpad;	/* alignment required on transmit */
	int		es_pad_3;
	int		es_pad_4;
#endif S4000
	u_short		*es_ei_rdp;	/* Register Data Port */
	u_short		*es_ei_rap;	/* Register Address Port */
#define es_ei_csr es_ei_rdp

	/* LANCE message descriptor info */
	struct	ei_md *es_rdrp;		/* Receive Descriptor Ring Ptr */
	struct	ei_md *es_rdrend;	/* Receive Descriptor Ring End */
	int	es_nrmdp2;		/* log(2) Num. Rcv. Msg. Descs. */
	int	es_nrmds;		/* Num. Rcv. Msg. Descs. */
	struct	ei_md *es_tdrp;		/* Transmit Descriptor Ring Ptr */
	struct	ei_md *es_tdrend;	/* Receive Descriptor Ring End */
	int	es_ntmdp2;		/* log(2) Num. Tran. Msg. Descs. */
	int	es_ntmds;		/* Num. Xmit. Msg. Descs. */
	struct	ei_md *es_his_rmd;	/* Next descriptor in ring */
	struct	ei_md *es_cur_tmd;	/* Tmd for start of current packet */
	struct	ei_md *es_nxt_tmd;	/* Tmd for start of next packet */

	/* Buffer info */
	int	es_nrbufs;		/* Number of Receive Buffers */
	struct	ei_buf *es_rbufs;	/* Receive Buffers */
	struct	ei_buf *es_rbuf_free;	/* Head of free list */
	int	es_ntbufs;		/* Number of Transmit Buffers */
	struct	ei_buf *es_tbufs;	/* Transmit Buffers */
	struct	ei_buf *es_tbuf_free;	/* Head of free list */
	struct	mbuf **es_tmbufc;	/* mbuf chain heads for xmit packets */
	struct	ei_buf **es_tei_buf;	/* transmit buffer for xmit packets */

	u_int	es_flags;		/* State info: see below */

	/* Error counters */
	int	es_extrabyte;		/* Rev C,D LANCE extra byte problem */
	int	es_fram;		/* Receive Framing Errors (dribble) */
	int	es_crc;			/* Receive CRC Errors */
	int	es_oflo;		/* Receive overruns */
	int	es_uflo;		/* Transmit underruns */
	int	es_retries;		/* Transmit packets w/at least one retry (collision) */
	int	es_missed;		/* Number of missed packets */
	int	es_babble;		/* Number of babbles */
	int	es_merr;		/* Number of memory errors */
	int	es_rxoff;		/* Number of rxoff errors */
	int	es_txoff;		/* Number of txoff errors */
	int	es_noheartbeat;		/* Number of nonexistent heartbeats */
	int	es_tBUFF;		/* BUFF bit in tmd occurrences */
	int	es_tlcol;		/* Transmit late collisions */
	int	es_trtry;		/* Transmit retry errors (failed after 16 retries) */
	int	es_tnocar;		/* No carrier errors */
	int	es_dogreset;		/* Number of ledog() chip resets */
	int	es_reset;		/* freeze chip resets */

	/* Performance statistics counters */
	int	es_started;		/* Times through lestart with > 0
					   packets ready to go out */
	int	es_no_tmds;		/* Number of output packets dropped
					   due to unavailability of tmd's */
	int	es_tsync;		/* Times we lost xmit sync with chip */
	int	es_defer;		/* Deferred transmission counter */
	int	es_outcpy;		/* Output copy operations */
	int	es_incpy;		/* Input copy operations */

	/* hang state detectioon */
	int	es_intr;		/* # interrupts since dog */
	int	es_intr_lastdog;	/* # interrupts during last dog */
	int	es_hang_state;		/* state of hang, 2 -> hung */
	int	es_hung;		/* # of times we entered hung state */

	int	es_bigp;		/* # of big packets recieved */
	int	es_init;		/* # of times chip was inited */
	int	es_had_rcv;		/* we have had a recieve since inited */
	int	es_got_rcv;		/* # of rcvs packets since last dog */
	int	es_hung_rcv;		/* # of times we entered hung rcv */
};

/*
 * Bit definitions for es_flags field:
 */
#define EI_TBUSY	0x01	/* Single static xmit buffer in use */
#define EI_TOPENDING	0x02	/* Transmit timeout pending */
#define	EI_NEEDTMD	0x04	/* Output waiting for tmd to free up */
#define	EI_SERVICING	0x08	/* a cpu is currently servicing this unit */
#define	EI_WAITING	0x10	/* a cpu is waiting on this unit */

#ifdef	KERNEL
/*
 * Variables imported from ei_conf.c
 */
extern int	ei_units;
extern struct ei_softc	ei_softc[];
extern struct mb_device *eiinfo[];
extern int	ei_watchdog;
extern char	ei_lance_pages[];
extern int	ei_enable;
extern int	eidebug;
extern int	eiretransmit;
extern int	ei_loan_len;
extern int	ei_back_to_back;
extern int	ei_ntmdp2, ei_nrmdp2;
extern int	ei_ntbufs, ei_nrbufs;
struct mbuf 	*ei_tmbufc[];
struct ei_buf	*ei_tei_buf[];
#endif	KERNEL

#ifdef	EI_TRACE
#define TRACE_NUM 		1024
#define	TRACE_BACK_DEPTH	6
#define TRACE_INIT 		0x0001
#define TRACE_FREE 		0x0002
#define TRACE_LOAN 		0x0004
#define TRACE_HANG 		0x0008
#define TRACE_IHANG 		0x0010
#define TRACE_MISS 		0x0020
#define TRACE_REHANGA 		0x0040
#define TRACE_REHANGB 		0x0080
#define TRACE_INTR 		0x0100	/* intr start */
#define TRACE_INTRR 		0x0200	/* intr release */
#define TRACE_INTRS 		0x0400	/* intr serviced */
#define TRACE_INTRC 		0x0800	/* intr csr */
#define TRACE_INTRE 		0x1000	/* intr end */
#define TRACE_DOG 		0x2000	/* eidog */
#define TRACE_TXSTART 		0x4000	/* eistart */
#define TRACE_TXNSTART 		0x8000	/* eistart notmds */
int	ei_trace = 0		/* 0x3FFF */;	/* should be disabled */
#ifdef	KERNEL
slock	ei_trace_lock;
#endif	KERNEL
struct ei_trace {
	struct timeval	t_timestamp;
	short		t_event;
	char		t_cpu;
	char		t_ifn;
	int		t_d0;
	int		t_d1;
	int		t_bt[TRACE_BACK_DEPTH];
} ei_trace_buf[TRACE_NUM], *ei_trace_cur;
#endif	EI_TRACE

#endif /*!_sunif_if_levar_h*/
