/* @(#) prom.h 1.1@(#) Solbourne id 9/22/93 00:01:49 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

#define	ROM_BASE_VA	0x00000000	/* Virtual address of ROM base */
#define VIRT_BASE	0xfd000000	/* Virtual address of Memory base */
#define ROM_DATA_VA (VIRT_BASE + 0x2000) /* Virtual addr of ROM bss */
#define	ROM_STACK_VA (VIRT_BASE+ 0x50000) /* Virtual addr of ROM stack base */
#define	ROM_COMM_VA (VIRT_BASE + 0x0)	/* Virtual addr of prom_sa_comm */
#define ROM_PTW_INDEX	0		/* ptw number used to map roms */

#if !defined(ASSEMBLER) && !defined(LOCORE)
/*
 * Structure of ROM resetflags[] entries
 */
struct resetflag {
	char	*name;
	int	value;
};

#define ROM_COMM_VERSION	4 /* version number of struct */
/*
 * Structure of the prom/standalone communication area.
 */
struct prom_sa_comm {
	int	version;	/* version of this struct */
	/* NOTE: rom_call should be the second item in this structure
	 * and never change if possible.  This way if the structure changes
	 * the kernel can still use rom call backs to print and notify the
	 * user of the problem.
	 */
	int	(*rom_call)();	/* routine called to execute rom commands */
	char	rom_vers[128];	/* rom version string, copied out of roms */
	int	(*forth_call)();/* routine called to execute forth commands */
	int	ramdisk;	/* size of ram disk in Mbytes */
	int	firstfree;	/* lowest page in memory unused by the rom */
	int	memsize;	/* size of memory (clicks) */
	int	real_memsize;	/* size of memory (Mbytes) */
	int	client_prot;	/* client programs shouldn't touch memory
				 * starting at this address */
	int	client_pages;	/* for this number of pages */
	struct msgbuf *msgbufp;	/* pointer to kernel's msgbuf area */
	int	usrtrapoffset;	/* offset to usrtraps from sash's tbr. */
				/* This is required for KAPBUG_S433 */
	int	root_node;	/* root pointer for device tree */
	int	valid_regs;	/* true if reg area is valid */
	int	regs[100];	/* register save area */
	int	rom_revision;	/* revision of ROMs */
};
#endif !ASSEMBLER && !LOCORE

#define	ROM_INTERNATIONAL	1	/* rev level supporting loadable kbds */
#define	ROM_REV_LEVEL		1	/* current rom revision level */

/*
 * dtrap_check() in the rom is relying on the fact that all %g[1-7] regs are
 * bunched together. Likewise with the %i[0-7] and %l[0-7] regs.  If this
 * changes, dtrap_check() must also change.
 */
#define COMM_REGS_RA	(0 * 4)
#define COMM_REGS_SP	(1 * 4)
#define COMM_REGS_TBR	(2 * 4)
#define COMM_REGS_G1	(3 * 4)
#define COMM_REGS_G2	(4 * 4)
#define COMM_REGS_G3	(5 * 4)
#define COMM_REGS_G4	(6 * 4)
#define COMM_REGS_G5	(7 * 4)
#define COMM_REGS_G6	(8 * 4)
#define COMM_REGS_G7	(9 * 4)
#define COMM_REGS_L0	(10 * 4)
#define COMM_REGS_L1	(11 * 4)
#define COMM_REGS_L2	(12 * 4)
#define COMM_REGS_L3	(13 * 4)
#define COMM_REGS_L4	(14 * 4)
#define COMM_REGS_L5	(15 * 4)
#define COMM_REGS_L6	(16 * 4)
#define COMM_REGS_L7	(17 * 4)
#define COMM_REGS_FVAR	(18 * 4)
#define COMM_REGS_FPAR	(19 * 4)
#define COMM_REGS_PC	(20 * 4)
#define COMM_REGS_NPC	(21 * 4)
#define COMM_REGS_PSR	(22 * 4)
#define COMM_REGS_I0	(23 * 4)
#define COMM_REGS_I1	(24 * 4)
#define COMM_REGS_I2	(25 * 4)
#define COMM_REGS_I3	(26 * 4)
#define COMM_REGS_I4	(27 * 4)
#define COMM_REGS_I5	(28 * 4)
#define COMM_REGS_I6	(29 * 4)
#define COMM_REGS_I7	(30 * 4)
#define COMM_REGS_O0	(31 * 4)
#define COMM_REGS_O1	(32 * 4)
#define COMM_REGS_O2	(33 * 4)
#define COMM_REGS_O3	(34 * 4)
#define COMM_REGS_O4	(35 * 4)
#define COMM_REGS_O5	(36 * 4)
#define COMM_REGS_O6	(37 * 4)
#define COMM_REGS_O7	(38 * 4)

/*
 * rom reset flags
 */
#define NUM_RESET_FLAGS	7	/* number of entries */

#define	ROM_COLD	0x01	/* requests a hardware reset */
#define	ROM_WARM	0x02	/* requests a prom state reinitialization */
#define	ROM_HALT	0x04	/* requests the roms to halt the machine */
#define	ROM_AUTOBOOT	0x08	/* requests the roms to auto boot */
#define ROM_INTR	0x10	/* same as ROM_WARM but forces no auto boot */
#define ROM_CONT	0x20	/* continue rom command proc w/ no reset */
#define ROM_FLAGEND	-1	/* end of reset flag array */

/*
 * rom reset strings
 */
#define	ROM_COLD_S	"cold"
#define	ROM_WARM_S	"warm"
#define	ROM_HALT_S	"halt"
#define	ROM_AUTOBOOT_S	"autoboot"
#define ROM_INTR_S	"intr"
#define	ROM_CONT_S	"cont"
#define ROM_FLAGEND_S	""

/*
 * some known names in the EEPROM
 */
#define	TTYA_MODE	"TTYA_MODE"
#define	TTYB_MODE	"TTYB_MODE"
#define	BOOTMODE	"BOOTMODE"
#define HOSTID		"HOSTID"
#define	ENETADDR	"ENETADDR"
#define	MODEL		"MODEL"
#define SERIAL		"SERIAL"
#define	HOSTNAME	"HOSTNAME"
#define	CONSOLE		"CONSOLE"
#define DEFAULTBOOT	"DEFAULTBOOT"
#define	DIAGBOOT	"DIAGBOOT"
#define	DEFAULTROOT	"DEFAULTROOT"
#define	DEFAULTSWAP	"DEFAULTSWAP"
#define	DEFAULTDUMP	"DEFAULTDUMP"
#define	TZ		"TZ"
#define	DISPLAYRES	"DISPLAYRES"
#define	KBDTYPE		"KBDTYPE"
#define	MASTER		"MASTER"
#define	REMOTEDEV	"REMOTEDEV"
#define	DIAGSERVER	"DIAGSERVER"
#define	DIAGMODE	"DIAGMODE"
#define	RAMTEST_MB	"RAMTEST_#MB"
#define SUNMON		"SUNMON-COMPAT?"
#define INPUTDEVICE	"INPUT-DEVICE"
#define OUTPUTDEVICE	"OUTPUT-DEVICE"
#define OEM_BANNER_Q	"OEM-BANNER?"
#define OEM_BANNER	"OEM-BANNER"
#define OEM_LOGO_Q	"OEM-LOGO?"
#define OEM_LOGO	"OEM-LOGO"
#define OEM_COPYRIGHT	"OEM-COPYRIGHT"
#define MFG		"MFG"
#define KBD_LAYOUT	"KBD_LAYOUT"

/*
 * some prom default values
 */
#define	DEFAULTCONSOLE	"zs()"

#if !defined(ASSEMBLER) && !defined(LOCORE)
extern struct prom_sa_comm *rom_commarea();
#endif !ASSEMBLER && !LOCORE

/*
 * Manufacturing history defines
 */
#define	TEST_RUN	0x01
#define DG_RUN		0x02
#define DG_PASSED	0x04
#define SYSD_RUN	0x08
#define SYSD_PASSED	0x10
#define STAT_LOCKED	0x80

#define TEST_OFFSET	0
#define PRECHECK	1
#define BURN_IN		2
#define POSTCHECK	3
#define AGING		4
#define SHIPPING	5
#define TEST_BANK	6
#define TEST_SLOT	7

#define MAX_STATIONS	5
