/* @(#) iCU.h 1.1@(#) Solbourne id 9/22/93 00:00:54 */
/*
 * structure definitions for the iCU.  this struct, mapped by
 * autoconf is available for general use.  the actual register
 * addresses and bit defines (for assembly language use) are in
 * cpuboard.h.
 */

struct icuio {
	/* scsi address register */
	unsigned	scsi_addr;	/* current scsi address (32-bits) */

	/* scsi control register */
	u_char		scsi_control;
#define SCSI_READ	0x00
#define SCSI_WRITE	0x01
#define	S_FLUSH_PENDING	0x02
#define	S_DMA_FAIL	0x04
#define	S_SCSI_REQ	0x08
#define	S_DIS_PREFETCH	0x10
#define	S_DIS_BURST	0x20
#define S_BITS "\20\6BST\5PREF\4S_REQ\3DMAFAIL\2F_PEND\1WRITE"

	u_char		pad0[3];

	/* scsi data registers */
#define SCSI_BUF_SIZE	4
#define SCSI_BUF_MSK	(SCSI_BUF_SIZE * sizeof(unsigned) - 1)
	unsigned	scsi_data[SCSI_BUF_SIZE];

	/* ethernet address mapping register */
	unsigned	enet_maddr:15,	/* upper 15 bits of ethernet addr */
			enet_baddr:17;	/* current enet buffer address reg */

	/* ethernet control register */
	unsigned	:28,
			ether_req:1,	/* enet requesting dma xfer */
			e_dma_fail:1,	/* enet dma failed */
			flush_ether:1,	/* set to flush enet block buffer */
			:1;

	/* WD33C93A registers */
        unsigned	wd_ia:8,	/* write - indirect address */
			:24,
			wd_rval:8,	/* reg indexed by indirect address */
			:24;

	/* ethernet data registers (lower half of them) */
#define ENET_BUF_SIZE	4
#define ENET_BUF_MSK	(ENET_BUF_SIZE * sizeof(unsigned) - 1)
	unsigned	enet_data_low[ENET_BUF_SIZE/2];

	/* Am7990 data port */
	unsigned	ei_rdp:16,
			:16;

	/* ethernet data registers (higher half of them) */
	unsigned	enet_data_high[ENET_BUF_SIZE/2];

	/* Am7990 address port */
	unsigned	ei_rap:16,
			:16;
};

struct icu {
	/* interrupt status register */
	unsigned	retry_tim:1,	/* retry timeout on sbus rio xfer */
			eth_rio_serr:1,	/* sbus error during enet rio xfer */
			sb2_rio_serr:1,	/* sbus error during slot 2 rio xfer */
			sb1_rio_serr:1,	/* sbus error during slot 1 rio xfer */
			sb0_rio_serr:1,	/* sbus error during slot 0 rio xfer */
			fault:1,	/* dma addr caused kapbus timeout */
			win_mis:1,	/* dma addr didn't match trans win */
			trannvld:1,	/* dma addr translation not valid */
			memd_mis:1,	/* dma addr space not memory's space */
			count_ovr:1,	/* single bit ecc counter overflowed */
			secc_cnt:4,	/* single bit ecc counter */
			icuirq_en:1,	/* enable int on scsi dma error */
			dma_nmi_en:1,	/* enable int on mecc or sbus error */
			rio_nmi_en:1,	/* enable int on sbus late error */
			sc_dma_serr:1,	/* scsi dma sbus error occurred */
			sc_dma_mecc:1,	/* scsi dma multi-bit ecc occurred */
			sc_dma_secc:1,	/* scsi dma single-bit ecc occurred */
			eth_dma_serr:1,	/* enet dma sbus error occurred */
			eth_dma_mecc:1,	/* enet dma multi-bit ecc occurred */
			eth_dma_secc:1,	/* enet dma single-bit ecc occurred */
			sb2_dma_serr:1,	/* slot 2 dma sbus error occurred */
			sb2_dma_mecc:1,	/* slot 2 dma multi-bit ecc occurred */
			sb2_dma_secc:1,	/* slot 2 dma single-bit ecc occurred */
			sb1_dma_serr:1,	/* slot 1 dma sbus error occurred */
			sb1_dma_mecc:1,	/* slot 1 dma multi-bit ecc occurred */
			sb1_dma_secc:1,	/* slot 1 dma single-bit ecc occurred */
			sb0_dma_serr:1,	/* slot 0 dma sbus error occurred */
			sb0_dma_mecc:1,	/* slot 0 dma multi-bit ecc occurred */
			sb0_dma_secc:1;	/* slot 0 dma single-bit ecc occurred */

	/* i/o decode register */
	unsigned	:7,
			sbus_rio_32m:1,	/* 32 Mbyte sbus rio decode */
			memdec:4,	/* memory decode bits */
			icudec:4,	/* icu decode bits */
			eth_scsi:4,	/* enet/scsi decode bits */
			sslot2:4,	/* sbus slot 2 decode bits */
			sslot1:4,	/* sbus slot 1 decode bits */
			sslot0:4;	/* sbus slot 0 decode bits */

	/* translation index register */
	unsigned	:8,
			index:11,	/* translation ram index */
			:13;

	/* translation enable register */
	unsigned	:25,
			io_disable:1,	/* only allow access to main memory */
			escsi:1,	/* enable translations for scsi */
			elan:1,		/* enable translations for enet */
			eslot2:1,	/* enable translations for slot 2 */
			eslot1:1,	/* enable translations for slot 1 */
			eslot0:1,	/* enable translations for slot 0 */
			:1;

	/* translation window register */
	unsigned	window:8,	/* msb for dvma address range */
			:23,
			compare_dis:1;	/* disable trans window compare */

	/* translation ram register */
	unsigned	pfnum:19,	/* physical page frame number */
			:12,
			tranvld:1;	/* entry valid */

	/* configuration register */
	unsigned	:21,
			icache_dis:1,	/* disable icache detect */
			from_wr_en:1,	/* enable writes to flash roms */
			slow_dma_rd:1,	/* add wait states to dma cycles */
			slow_dma_wr:1,	/* add wait states to dma cycles */
			fac2:1,		/* shorten XKAS low time */
			sbus_clk:1,	/* 0==20MHz, 1==25MHz */
			:1,
			mem_banks:1,	/* 0==3-4 mem banks, 1==1-2 mem banks */
			eccen:1,	/* enable ecc checking */
			rcod:2;		/* revision code */
};

/* virtual address allocated in locore, mapped in autoconf */
extern struct icuio icuio;
extern struct icu icu;

/* XXX not sure if this old stuff is still needed... */

struct icu_scsi_dma {
    long	scsi_addr;			/* These bits contain 
						   the SCSI block address. */
    long	scsi_rw;			/* Bit 1 when set indicates
						   a read from memory to SCSI.
						   Default is 0 */
    long	scsi_data[SCSI_BUF_SIZE];
};
typedef struct icu_scsi_dma icu_scsi_dma_t;

struct icu_ether_xlate {
    int		ether_addr:15,			/* Upper 15 bits of ether
						   mapped addres */
    		ether_reserved:17;
    int		ether_flush_reserved:31,
    		ether_flush:1;			/* When 1 flushes current
						   ether block to memory */
};
typedef struct icu_ether_xlate icu_ether_xlate_t;

/* 
 * The scsi control register has active bits for direction,
 * burst control, and prefetch control.  It also has hardware debug bits.
 */

#define iCU_FLUSH_PEND          0x02
#define iCU_DMA_FAIL            0x04
#define iCU_SCSI_REQ            0x08
#define iCU_DISABLE_PREFETCH    0x10
#define iCU_DISABLE_BURST       0x20
