/* @(#) rwlock.h 1.1@(#) Solbourne id 9/21/93 23:50:38 */
/*
 * The processes in this version of reader-writer lock will sleep on the 
 * sleep queue.
 */

#ifndef  _sys_rwlock_h
#define  _sys_rwlock_h
#ifndef LOCORE

#ifdef KERNEL

#include <sys/queue.h>

#ifdef LKSTAT 
#include <sys/lkstat.h>
#endif LKSTAT
#include <sys/osmp_lock.h>



typedef struct reader_writer_lock
  {
     slock     lock;      /* lock to protect this structure */
     int sleep_pri;         /* priority at which this lock will sleep */
     
     char *rw_name;		/* name for the lock */
     
     unsigned int  reader_count:16, /* Number of accepted readers */
                   want_upgrade:1,  /* Read-to-write upgrade waiting */
                   want_write:1,    /* Writer is waiting or locked for write */
                   waiting:1,       /* Someone is sleeping on the lock */
                   can_sleep:1,     /* if lock not available can sleep. */
                   valid:1;         /* set when initialized          */
     
     int    rw_pid;                 /* pid of the proc..debugging */     
     int    rw_lorder;              /* lock order for debugging */
     struct reader_writer_lock *next_rw,  /* for a list of of locks */
                               *hnext_rw;
#ifdef LKSTAT
     lkstat_t           rw_statp;     /* pointer to lock statistics */
#endif LKSTAT
    } rw_lock;

typedef  rw_lock   *rw_lock_t;

#define  CAN_SLEEP                0x1
#define  NO_SLEEP                 0x2

#define p_rwlist     pp->p_rw_lcklist /* handy define for inserting locks */


/* 
 *  Global list of all the locks held 
 */

slock  rw_hlck;                    /* lock to protect the hashq */
struct q_node rw_hashq[HASH_NO];


#ifdef LKSTAT
#define UPDATE_MISSES(lp)   { \
  if (lock_stat_collect) \
	  atomic_lk((&(lp)->rw_statp->intlk),(lp)->rw_statp->lk_misses++);\
		      }

#define UPDATE_HITS(lp) { \
  if (lock_stat_collect) \
	  atomic_lk((&(lp)->rw_statp->intlk),(lp)->rw_statp->lk_hits++);\
		      }
#define UPDATE_SPINS_ON_RESTORE { \
  if (lock_stat_collect) \
	  atomic_lk((&(lp)->rw_statp->intlk),(lp)->rw_statp->lk_spins_on_restore++);\
		      }
#else 
#define  UPDATE_MISSES(lp) 
#define  UPDATE_HITS(lp)
#define  UPDATE_SPINS_ON_RESTORE(lp)
#endif LKSTAT

extern void    rw_lock_init();
extern void    rw_read_lock();
extern void    rw_write_lock();
extern void    rw_unlock();

#define  rw_read_unlock(lp)   rw_unlock(lp);
#define  rw_write_unlock(lp)   rw_unlock(lp);

extern void    rw_read_unlock();
extern void    rw_write_unlock();
extern int    rw_read_to_write_upgrade();
extern void    rw_write_to_read_upgrade();


extern int     rw_try_read_lock();
extern int     rw_try_write_lock();
extern int     rw_try_read_to_write_upgrade();
#else !KERNEL
typedef int  rw_lock_t;
#endif KERNEL
#endif LOCORE
#endif _rwlock_h

