/* @(#) tyboard.h 1.1@(#) Solbourne id 9/21/93 23:59:47 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*
 * This header file contains information specific to the TyBoard
 */

/*
 * ID space registers:
 */
#define TB_IDPROM_OFFSET	0	/* IDPROM offset */
#define	TB_UNRESET_OFFSET	0	/* read byte to unreset */

/*
 * The TyBoard is capable of operating in two VMEbus addressing modes.
 * The first "limited" mode is for use with Series4&5; the "full" addressing
 * mode is for Series5E.  The space of the VMEbus port and the ioba number
 * for the board is also defined in the mode register.
 */
#define TB_MODE_OFFSET		0x10000	/* Mode Register offset */
#define	TB_MODE_KSPACE_MASK	0x0f	/* kbus space for vme port */
#define	TB_MODE_BIT_MASK	0x10	/* addressing mode for vme port */
#define	TB_MODE_BIT_LIMITED	0x00	/* limited addressing mode */
#define	TB_MODE_BIT_FULL	0x10	/* full addressing mode */
#define TB_MODE_IOBUS_MASK	0xe0	/* mask for IO Bus Adaptor number */
#define TB_MODE_IOBUS_SHIFT	5	/* shift count for right justify */
#define MODE_BAN		TB_MODE_IOBUS_MASK
#define MODE_BAN_SHIFT		TB_MODE_IOBUS_SHIFT

/*
 * The TyBoard is capable of interrupting a processor by either
 * directed and or undirected interrupts. The interrupt register
 * specifies whether directed or undirected interrupts are to be used.
 * This register is read/written as one byte.
 */
#define TB_IDIS_OFFSET	0x30000		/* read to disable intrs */
#define TB_IENB_OFFSET	0x31000		/* read to enable intrs */
#define TBIDIS		TB_IDIS_OFFSET	/* for compatibility */
#define TBIEN		TB_IENB_OFFSET 	/* for compatibility */
#define	TBIR		TB_IDIS_OFFSET	/* write to program intrs */
#define TBIR_DI		0x00000040	/* 1==directed intr, 0==undirected */
#define TBIR_INFO	0x0000003f	/* for undir intr, information */
#define TBIR_DDID	0x0000003f	/* for dir intr, dest dev id */

/*
 * The reset functions the same as the SYSTEM BOARD
 */
#define	TB_RESET_VMEINT_OFFSET	0x140000/* write to reset, read for vmeintr */
#define	TB_RESET_ASIC_ADDR	IO_RESET_ASIC_ADDR	/* same as io board */
#define	TB_RESET_SCSI_ADDR	IO_RESET_SCSI_ADDR	/* same as io board */
#define	TB_RESET_VME_ADDR	IO_RESET_VME_ADDR	/* same as io board */
#define	TB_RESET_LANCE_ADDR	IO_RESET_LANCE_ADDR	/* same as io board */
#define TB_RESET_ALL		IO_RESET_ALL		/* same as io board */
#define	TB_VMEINT_LEVEL_SHFT	IO_VMEINT_LEVEL_SHFT	/* same as io board */
#define	TB_VMEINT_PEND_BIT	IO_VMEINT_PEND_BIT	/* same as io board */
#define	TB_VMEINT_PFETCH_DONE	IO_VMEINT_PFETCH_DONE	/* same as io board */

/* 
 * Limited mode addressing
 */
#define	TB_LVME32_OFFSET_USR	0x00000000
#define	TB_LVME32_SIZE_USR	0x08000000
#define	TB_LVME32_MASK_USR	(TB_LVME32_SIZE_USR-1)
#define	TB_LVME32_OFFSET	0x08000000
#define	TB_LVME32_SIZE		0x04000000
#define	TB_LVME32_MASK		(TB_LVME32_SIZE-1)
#define	TB_LVME24_OFFSET_USR	0x0C000000
#define	TB_LVME24_OFFSET	0x0D000000
#define	TB_LVME24_SIZE		0x01000000
#define	TB_LVME24_MASK		(TB_LVME24_SIZE-1)
#define	TB_LVME16_OFFSET_USR	0x0E000000
#define	TB_LVME16_OFFSET	0x0F000000
#define	TB_LVME16_SIZE		0x00010000
#define	TB_LVME16_MASK		(TB_LVME16_SIZE-1)

#define	TB_LIOASIC_OFFSET	0x0FFFFF00	/* see dev/ioasic.h */
#define	TB_LSCSI_WD_OFFSET	0x0FFFFF40	/* see dev/wdreg.h */
#define	TB_LENET_LANCE_OFFSET	0x0FFFFF70	/* see if/if_eireg.h */

/*
 * To acknowledge a vme interrupt and get the vme vector, 
 * read the location VME_IACK_BASE + (2 * vme_ipl). This location is
 * read as a short with the lower byte containing the vme vector
 * This works the same as the SYSTEM BOARD.
 */
#define TB_LVME_IACK_OFFSET	0x0FFFFF80

/* more definitions below... */
#define TB_LVME_MAP_OFFSET	0x0FFFFFC0

/* 
 * Full mode addressing
 */
#define	TB_FVME32_OFFSET	0x00000000
#define	TB_FVME32_SIZE		0xFF000000
#define	TB_FVME24_OFFSET	0xFF000000
#define	TB_FVME24_SIZE		0x0FFF0000
#define	TB_FVME16_OFFSET	0xFFFF0000
#define	TB_FVME16_SIZE		0x0000FF00

#define	TB_FIOASIC_OFFSET	0xFFFFFF00	/* see dev/ioasic.h */
#define	TB_FSCSI_WD_OFFSET	0xFFFFFF40	/* see dev/wdreg.h */
#define	TB_FENET_LANCE_OFFSET	0xFFFFFF70	/* see if/if_eireg.h */
#define TB_FVME_IACK_OFFSET	0xFFFFFF80
#define TB_FVME_MAP_OFFSET	0xFFFFFFC0

/*
 * The Ty Board vme address map can map 16M of vme space into the 4G system 
 * space on a page basis. The base of the map is TB_{LF}VME_MAP_OFFSET from 
 * the assigned Ty Board space. Access to a map entry for each VME page offset
 * is accomplished by writing the address into TB_{LF}VME_MAP_OFFSET and the
 * reading/writing the value from TB_{LF}VME_MAP_OFFSET + TB_{LF}VME_MAP_VALUE.
 */
#define	TB_VME_MAP_VALUE	0x10
#define TB_VME_MAP_SIZE		2048
#define TB_VME_MAP_SPACE	0x14
#define TB_VME_MAP_ENTRY_PFN	0xffffe000
#define TB_VME_MAP_ENTRY_V	0x1
