/* @(#) param.h 1.1@(#) Solbourne id 9/21/93 23:58:48 */
/*
 * Copyright 1990 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*	@(#)param.h 1.3 90/12/05 SMI	*/

/*
 * Copyright (c) 1989 by Sun Microsystems, Inc.
 *
 * This file is intended to contain the basic
 * specific details of a given architecture.
 */

#ifndef _kbus_param_h
#define _kbus_param_h
/*
 * Machine dependent constants for kbus systems.
 */
#define	MAXNCPUS	9	/* maximum number of CPUS supported */

#if !defined(MULTIPROCESSOR) && !defined(UNIPROCESSOR)
/*
 * If neither MULTIPROCESSOR nor UNIPROCESSOR is specified,
 * default to MULTIPROCESSOR. This should do the right thing
 * for users including this file as <sys/param.h>. Care
 * should be taken that the layout of system information does
 * not change between UNI and MULTIprocessor kernels.
 */
#define	MULTIPROCESSOR
#endif

#ifdef MULTIPROCESSOR
#define NCPU MAXNCPUS
#else
#define NCPU 1
#endif

/*
 * Define the VAC symbol if we could run on a machine
 * which has a Virtual Address Cache (e.g. SUN4_260)
 *
 * Series7 supports Mbus modules which may have a VAC
 */
#if defined(SUN4_260) || defined(SUN4_470) || defined(SUN4_330) || (defined(Series7) && !defined(viking))
#define VAC
#else
#undef VAC
#endif SUN4_260 || SUN4_470 || SUN4_330 || Series7


/*
 * Define the FPU symbol if we could run on a machine with an external
 * FPU (i.e. not integrated with the normal machine state like the vax).
 */
#define FPU

/*
 * Define the MMU_3LEVEL symbol if we could run on a machine with
 * a three level mmu.   We also assume these machines have region
 * and user cache flush operations.
 */
#ifdef SUN4_470
#define MMU_3LEVEL
#else
#undef MMU_3LEVEL
#endif SUN4_470

/*
 * Define IOC if we could run on machines that have an I/O cache.
 */
#ifdef SUN4_470
#define IOC
#else
#undef IOC
#endif SUN4_470

/*
 * Define BCOPY_BUF if we could run on machines that have a bcopy buffer.
 */
#if	defined(SUN4_470) || defined(Series6) || (defined(Series7) && defined(viking))
#define BCOPY_BUF
#else
#undef BCOPY_BUF
#endif SUN4_470 || Series6 || (Series7 && viking)

/*
 * Define VA_HOLE for machines that have a hole in the virtual address space.
 */
#if defined(SUN4_260) || defined(SUN4_110) || defined(SUN4_330)
#define VA_HOLE
#else
#undef VA_HOLE
#endif SUN4_260 || SUN4_110 || SUN4_330

/*
 * MMU_PAGES* describes the physical page size used by the mapping hardware.
 * PAGES* describes the logical page size used by the system.
 *
 * Default to Series4/Series5 values if not given Series6 or Series7
 */


#if	defined(Series6) || defined(Series7)

#define	MMU_PAGESIZE	0x1000		/* 4096 bytes */
#define	MMU_PAGESHIFT	12		/* log2(MMU_PAGESIZE) */
#define	MMU_PAGEOFFSET	(MMU_PAGESIZE-1)/* Mask of address bits in page */
#define	MMU_PAGEMASK	(~MMU_PAGEOFFSET)

#define	PAGESIZE	0x2000		/* All of the above, for logical */
#define	PAGESHIFT	13
#define	PAGEOFFSET	(PAGESIZE - 1)
#define	PAGEMASK	(~PAGEOFFSET)

/* Guarantee "refmmu" is defined */
#ifndef refmmu
#define	refmmu
#endif

#endif Series6 || Series7

#if defined(Series4) || defined(Series5)

#define	MMU_PAGESIZE	0x2000		/* 8192 bytes */
#define	MMU_PAGESHIFT	13		/* log2(MMU_PAGESIZE) */
#define	MMU_PAGEOFFSET	(MMU_PAGESIZE-1)/* Mask of address bits in page */
#define	MMU_PAGEMASK	(~MMU_PAGEOFFSET)

#define	PAGESIZE	0x2000		/* All of the above, for logical */
#define	PAGESHIFT	13
#define	PAGEOFFSET	(PAGESIZE - 1)
#define	PAGEMASK	(~PAGEOFFSET)

#endif /* Series4 or Series5 */

/*
 * DATA_ALIGN is used to define the alignment of the Unix data segment.
 */
#define	DATA_ALIGN	0x2000

/*
 * Some random macros for units conversion.
 */

/*
 * MMU pages to bytes, and back (with and without rounding)
 */
#define	mmu_ptob(x)	((x) << MMU_PAGESHIFT)
#define	mmu_btop(x)	(((unsigned)(x)) >> MMU_PAGESHIFT)
#define	mmu_btopr(x)	((((unsigned)(x) + MMU_PAGEOFFSET) >> MMU_PAGESHIFT))

/*
 * pages to bytes, and back (with and without rounding)
 */
#define	ptob(x)		((x) << PAGESHIFT)
#define	btop(x)		(((unsigned)(x)) >> PAGESHIFT)
#define	btopr(x)	((((unsigned)(x) + PAGEOFFSET) >> PAGESHIFT))

/*
 * 2 versions of pages to disk blocks
 */
#define	mmu_ptod(x)	((x) << (MMU_PAGESHIFT - DEV_BSHIFT))
#define	ptod(x)		((x) << (PAGESHIFT - DEV_BSHIFT))

/*
 * Delay units are in microseconds.
 */
#define	DELAY(n)	usec_delay(n)
#define	CDELAY(c, n)	\
{ \
	register int N = n; \
	while (--N > 0) { \
		if (c) \
			break; \
		usec_delay(1); \
	} \
}


/* 
 * pages of u-area, NOT including red zone 
 * u-area is split into the struct user and the kernel stack, the struct
 * user is at most 4096 bytes, thus leaving the rest of the UPAGES for
 * the kernel stack
 */
#if	defined(Series4) || defined(Series5)
#define	UPAGES		3	
#endif	Series4 || Series5
#ifdef	refmmu
#define	UPAGES		4	
#endif	refmmu
#define UPAGES_U	1
#define UPAGES_KS	(UPAGES-UPAGES_U)

/* 
 * size of the kernel stack 
 * only 1.5 pages, for sun4 compatibility
 */
#define	KERNSTACK	(0x3000)

#if UPAGES == 1
ERROR - UPAGES must be at least 2
#endif UPAGES == 1

/* 
 * u-area virtual address 
 *
 * also specify index within seg_u array for different portions of u-area
 */
#ifdef Series4
#define	KSADDR			(0xfd800000 + (4*1024*1024))

/*
 * on Series4, the * u-area stuff begins at 0x100 (we avoid using address zero).
 */
#define	UADDR			(0x100) 
#define UPAGES_U_INDEX		0
#define UPAGES_KS_INDEX		UPAGES_U
#endif Series4

#if	defined(Series5) || defined(Series6) || defined(Series7)
#define	KSADDR			(0-(MMU_PAGESIZE*UPAGES))
/*
 * on Series5, the kernel stack is really in the two pages virtually
 * below the u-area.  the u-area stuff begins at 0-4096.
 */
#define	UADDR			(0-4096) 
#define UPAGES_U_INDEX		0
#define UPAGES_KS_INDEX		UPAGES_U
#endif Series5 || Series6 || Series7

#if !defined(ASSEMBLER) && !defined(LOCORE)
/*
 * this structure contains the information libkvm needs for accessing
 * various kernel information thus removing the need for libkvm to be
 * recompiled for different machines
 */
struct kernel_info {
	unsigned	u_addr;		/* address of struct user */
	unsigned	ks_addr;	/* address of kernel stack */
	short		u_pages;	/* number of struct user pages */
	short		ks_pages;	/* number of kernel stack pages */
	short		u_index;	/* seg_u index of struct user ptes */
	short		ks_index;	/* seg_u index of kernel stack ptes */
	short		total_upages;	/* total number of uarea pages */
	unsigned	usrstack;	/* address of top of user stack */
	unsigned	sysbase;	/* start of kernel allocated memory */
	unsigned	kernelbase;	/* start of kernel virtual */
	unsigned	physwin_base;	/* start of kernel physical window */
	unsigned	physwin_limit;	/* end of kernel physical window */
	unsigned	cpu;		/* cpu type */
	unsigned	mmu_clsize;	/* pages per cluster */
	unsigned	mmu_pagesize;	/* page size */
	unsigned	mmu_pageoffset;	/* page offset mask */
	unsigned	mmu_pageshift;	/* page shift value */
	unsigned	mmu_pg_sv_msk;	/* mask for software valid */
	unsigned	mmu_pg_sv;	/* value for software valid */
	unsigned	mmu_pg_v_msk;	/* mask for valid */
	unsigned	mmu_pg_v;	/* value for valid */
	unsigned	kinfo_magic;	/* kinfo struct magic number */
#define			 KINFO_MAGIC	0xABBADABA
};
#endif !ASSEMBLER && !LOCORE

/*
 * KERNELSIZE is the amount of virtual address space the kernel
 * uses in all contexts.
 */
#define	KERNELSIZE	(128*1024*1024)

/*
 * KERNELBASE is the first kernel virtual address 
 */
#define	KERNELBASE	(0-KERNELSIZE)

/*
 * SYSBASE is the virtual address which
 * the kernel allocated memory mapping starts in 
 */
#define	SYSBASE		(KERNELBASE+0x1000000)

/*
 * MBPOOLBYTES gives the amount of virtual space to reserve for mbuf
 * storage.
 */
#define	MBPOOLBYTES	(2*1024*1024)
#define MBPOOLMMUPAGES	(MBPOOLBYTES / MMU_PAGESIZE)

/*
 * BUFBYTES: Maximal size of Disk Buffer Cache
 * BUFBASE - BUFLIMIT: Disk Buffer Cache
 */
#define BUFBYTES	(4*1024*1024)
#define BUFPAGES	(BUFBYTES / MMU_PAGESIZE)
#define BUFLIMIT	SYSLIMIT
#define BUFBASE		(BUFLIMIT - BUFBYTES)

/*
 * HEAPBYTES: Maximal size of Kernel Heap
 * HEAPBASE - HEAPLIMIT: Kernel Heap
 * The HEAPBYTES was changed from 6M - 16M as per 
 * Sun Patch S100516-01 --- nadkarni
 */

#define HEAPBYTES	(20*1024*1024)
#define HEAPPAGES	(HEAPBYTES / MMU_PAGESIZE)
#define HEAPLIMIT	BUFBASE
#define HEAPBASE	(HEAPLIMIT - HEAPBYTES)

/*
 * Msgbuf size.
 */
# define MSG_BSIZE_OLD	((7 * 1024) - sizeof (struct msgbuf_hd))
# define MSG_BSIZE       ((32 * 1024) - sizeof (struct msgbuf_hd))

/*
 * XXX - Macros for compatibility
 */
/* Clicks (MMU PAGES) to disk blocks */
#define	ctod(x)		ptod(x)

/* Clicks (MMU PAGES) to bytes, and back (with rounding) */
#define	ctob(x)		ptob(x)
#define	btoc(x)		btopr(x)

/*
 * XXX - Old names for some backwards compatibility
 */
#define	NBPG		PAGESIZE
#define	PGOFSET		PAGEOFFSET
#define	PGSHIFT		PAGESHIFT

#define	CLSIZE		(PAGESIZE/MMU_PAGESIZE)
#define	CLSIZELOG2	0
#define	CLBYTES		PAGESIZE
#define	CLOFSET		PAGEOFFSET
#define	CLSHIFT		PAGESHIFT
#define	clrnd(i)	(i)

#endif /*!_kbus_param_h*/
