/* @(#) mmu.h 1.4@(#) Solbourne id 3/18/94 09:36:32 */
/*
 * Copyright 1991 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*	@(#)mmu.h 1.2 89/08/03 SMI	*/

/*
 * Copyright (c) 1985 by Sun Microsystems, Inc.
 */

#ifndef _kbus_mmu_h
#define _kbus_mmu_h

/* 
 * Kbus memory management units.
 * All Kbus implementations use 32 bits of address.
 */

#if	defined(Series4) || defined(Series5)
/* 
 * Hardware context and segment information
 * Mnemonic decoding:
 *	PTE - Page Table Entry 
 *	PT  - A page table or group of PTEs (aka "segment")
 *	PDE - Page Directory Entry
 * 	PDT - Page Directory Table or group of PDEs 
 */
#define	NPTEPERPT	1024		/* number of ptes per page table */
#define	NPTEPERPTSHIFT	10		/* log2(NPTEPERPT) */
#define NPDEPERPDT	512		/* number of pdes per page dir table */
#define NPDEPERPDTSHIFT	9		/* log2(NPDEPERPDT) */
#define	MMU_SEGSIZE	(NPTEPERPT * PAGESIZE)
#define MMU_SEGOFFSET	(MMU_SEGSIZE - 1)
#define	MMU_SEGSHIFT	(PAGESHIFT + NPTEPERPTSHIFT)
#define	MMU_SEGMASK	(~MMU_SEGOFFSET)

/*
 * defines for performing software table walk based on a virtual address
 */
#define PDT_INDEX_SIZE	9		/* num bits of pdt index in va */
#define PT_INDEX_SIZE	10		/* num bits of pt index in va */
#define PDT_INDEX_SHIFT	23		/* shift for pde index */
#define PT_INDEX_SHIFT	13		/* shift for pt index */
#define PDT_INDEX_MASK	0xff800000	/* mask for pdt index */
#define PT_INDEX_MASK	0x007fe000	/* mask for pdt index */
#define	FAULT_VA_ALIGN	0x3		/* mask to align virtual address */
#define PDE_SIZE_SHIFT	3		/* log2(sizeof(struct pde)) */
#define PTE_SIZE_SHIFT	2		/* log2(sizeof(struct pte)) */
#define	PTE_OFFSET_MASK	0xffc
#define PT_OFFSET_SHIFT	(PT_INDEX_SHIFT-PTE_SIZE_SHIFT)
#define PT_INDEX_SHIFT_MASK	0xffc	/* mast for pt index after shift */

/*
 * macros for getting from a virtual address to the proper entry
 * in either page directory table or page table
 */
#define PDT_INDEX(addr) \
	(((unsigned)addr & PDT_INDEX_MASK) >> PDT_INDEX_SHIFT)
#define PDT_OFFSET(addr)	(PDT_INDEX(addr) << PDE_SIZE_SHIFT)

#define PT_INDEX(addr)	\
	(((unsigned)addr & PT_INDEX_MASK) >> PT_INDEX_SHIFT)
#define PT_OFFSET(addr)		(PT_INDEX(addr) << PTE_SIZE_SHIFT)

#endif	/* Series4 || Series5 */

#ifdef	refmmu

/* 
 * Hardware context and segment information
 * Mnemonic decoding:
 *	PTE - Page Table Entry 
 *	PT  - A page table or group of PTEs (aka "segment")
 * 	PTP - Page Table Pointer
 */
#define	NPTPPERCTXTBL	16384	/* number of ptps per context table */
#define	NPTPPERL1PT	256	/* number of ptps per Level 1 page table */
#define	NPTPPERL2PT	64	/* number of ptps per Level 2 page table */
#define	NPTEPERL3PT	64	/* number of ptes per Level 3 page table */

/*
 * defines for performing software table walk based on a virtual address
 */
#define L1_INDEX_SIZE	8		/* num bits of Level 1 index in va */
#define L2_INDEX_SIZE	6		/* num bits of Level 2 index in va */
#define L3_INDEX_SIZE	6		/* num bits of Level 3 index in va */
#define L1_INDEX_SHIFT	24		/* shift for Level 1 index */
#define L2_INDEX_SHIFT	18		/* shift for Level 2 index */
#define L3_INDEX_SHIFT	12		/* shift for Level 3 index */
#define L1_INDEX_MASK	0xff000000	/* mask for Level 1 index */
#define L2_INDEX_MASK	0x00fc0000	/* mask for Level 2 index */
#define L3_INDEX_MASK	0x0003f000	/* mask for Level 3 index */
#define	FAULT_VA_ALIGN	0x3		/* mask to align virtual address */
#define PTP_SIZE_SHIFT	2		/* log2(sizeof(struct ptp)) */
#define PTE_SIZE_SHIFT	2		/* log2(sizeof(struct pte)) */
#define PTP_SHIFT	8		/* physical address to ptp */
#define PTP_OFF_SHIFT	4		/* ptp field offset in word */
#define PTP_SPACE_SHIFT	4		/* ptp to physical addr */
#define PFN_SPACE_SHIFT	4		/* pfn to physical addr */

/*
 * address space covered by each page table level
 */
#define	L2_SEGSIZE	0x1000000
#define	L2_SEGOFFSET	(L2_SEGSIZE - 1)
#define	L2_SEGMASK	(~(L2_SEGSIZE - 1))
#define	L3_SEGSIZE	0x0040000
#define	L3_SEGOFFSET	(L3_SEGSIZE - 1)
#define	L3_SEGMASK	(~(L3_SEGSIZE - 1))

/*
 * macros for getting from a virtual address to the proper entry
 * in any level page table
 */
#define L1_INDEX(addr) \
	(((unsigned)addr & L1_INDEX_MASK) >> L1_INDEX_SHIFT)
#define L1_OFFSET(addr)	(L1_INDEX(addr) << PTP_SIZE_SHIFT)

#define L2_INDEX(addr) \
	(((unsigned)addr & L2_INDEX_MASK) >> L2_INDEX_SHIFT)
#define L2_OFFSET(addr)	(L2_INDEX(addr) << PTP_SIZE_SHIFT)

#define L3_INDEX(addr) \
	(((unsigned)addr & L3_INDEX_MASK) >> L3_INDEX_SHIFT)
#define L3_OFFSET(addr)	(L3_INDEX(addr) << PTE_SIZE_SHIFT)

#endif	refmmu

#ifndef LOCORE
/*
 * Variables set at boot time to reflect cpu type.
 */
extern u_int segmask;		/* mask for segment number */
extern addr_t hole_start;	/* addr of start of MMU "hole" */
extern addr_t hole_end;		/* addr of end of MMU "hole" */

/*
 * Macro to determine whether an address is within the range of the MMU.
 *
 * Sun4 machine has a hole in the virtual address space, Kbus does not
 * thus all 32 bit addresses are good
 */
#define good_addr(a)	(1)
#endif !LOCORE

#ifdef Series4
/*
 * Two hard-wired translation windows exists which may be accessed
 * regardless of whether the MMU is enabled or not. Both of these
 * windows are 16Mbytes. The hard-wired translation window beginning
 * at 0xfe000000 accesses IO space 0, or bootrom space. The hard-wired
 * translation window beginning at 0xff000000 accesses physical memory
 * starting at 0. Thus 0xff000000 is direct mapped onto the first
 * 16Mbytes of physical memory.
 */
#define	F16M_PHYS_WIN	0xff000000	/* "first 16Meg" physical memory window */
#define	KERN_PHYS_WIN	0xff000000	/* kernel's physical memory window */
#define	PHYS_WIN_MASK	0xff000000	/* mask to determine memory window */
#define	PHYSICAL_WINDOW	KERN_PHYS_WIN	/* alias */
#define	PHYS_WIN_SIZE	0x01000000	/* physical window size in bytes */
#define	IO_ZERO_WIN	0xfe000000	/* hardwired I/O space zero window */
#define	IO_WIN_SIZE	0x01000000	/* I/O window size in bytes */
#define	ROM_WINDOW	0xfe000000	/* Boot ROM text window */
#define	ROM_WIN_SIZE	0x01000000	/* Boot ROM window size in bytes */



/*
 * Address space identifier (formerly function codes) values.
 */
#define	ASI_UP		0x8	/* user program */
#define	ASI_SP		0x9	/* supervisor program */
#define	ASI_UD		0xA	/* user data */
#define	ASI_SD		0xB	/* supervisor data */
#define ASI_INTR	0x10	/* interrupt registers */
#define ASI_PHYS_CPU	0x18	/* physical cpu registers */
#define ASI_VIRT_CPU	0x14	/* virtual cpu registers */
#define ASI_AUTO_CPU	0x15	/* auto read of tlbmiss registers */
#define ASI_TLB_VALI	0x1c	/* validate instruction tlb entry, by write */
#define ASI_TLB_VALD	0x1e	/* validate data tlb entry, by write */
#define ASI_TLB_INVI	0x1c	/* invalidate instruction tlb entry, by read */
#define ASI_TLB_INVD	0x1e	/* invalidate data tlb entry, by read */
#define ASI_CPU_BRD	0x30	/* cpu board registers */	
#define ASI_DIAG_RAM	0x38	/* diagnostic RAM */

#define ASI_ITLB	0x1c	/* instruction TLB space */
#define ASI_DTLB	0x1e	/* data TLB space */
#define ASI_UITIR	0x20	/* User Instruction TIR space */
#define ASI_SITIR	0x21	/* Supervisor Instruction TIR space */
#define ASI_UDTIR	0x22	/* User Data TIR space */
#define ASI_SDTIR	0x23	/* Supervisor Data TIR space */

/*
 * ASI offsets of various registers within their appropriate address space
 */
/*
 * interrupt registers
 */
#define ASI_OFF_DIR	0x00	/* device id register, 8-bit, RW */
#define ASI_OFF_IXR	0x04	/* interrupt transmit reg, 16-bit, RW */
#define ASI_OFF_ITXC	0x08	/* interrupt transmit control reg, 2-bit, RW */
#define ASI_OFF_IPR	0x0C	/* interrupt priority register, 8-bit, RW */
#define ASI_OFF_IPV	0x10	/* interrupt pending vector reg, 16-bit, RW */
#define ASI_OFF_IRXC	0x14	/* interrupt receiver control reg, 2-bit, RW */

#define ASI_OFF_NOACK_IPV	0x32	/* interrupt pending vector reg */
#define ASI_OFF_ACK_IPV		0x12	/* interrupt pending vector reg */

/*
 * physical cpu registers 
 */
#define ASI_OFF_FPAR	0x00	/* fault physical address reg, 32-bit, RO */
#define ASI_OFF_FES	0x04	/* fault ECC syndrome register, 8-bit, RO */
#define ASI_OFF_KCB	0x08	/* tests ECC check bits reg, 9-bit, WO */

/*
 * virtual cpu registers
 */
#define ASI_OFF_MMCR	0x00	/* memory mgmt control register, 32-bit, RW */
#define ASI_OFF_FCR	0x04	/* fault cause register, 32-bit, RW */
#define ASI_OFF_FVAR	0x08	/* fault virtual address reg, 32-bit, RO */
#define ASI_OFF_PDEP	0x0C	/* page directory base reg, 32-bit, RW */

/*
 * the lower bits of the PDEP may hold special information
 */
#define PDEP_CLEAN	0x02	/* process requires clean windows */

/*
 * cpu board registers
 */
#define ASI_OFF_BID	0x00	/* board id register, 16-bit, RO */
#define ASI_OFF_LED	0x04	/* LED register, 16-bit, WO */

/*
 * MMCR, memory management control register, bit definitions
 *
 * NOTE: MMCR_IA, MMCR_PIN, and MMCR_VIN read undefined - be careful
 * when reading MMCR, modifying some bits, and writing it back
 */
#define MMCR_ME		0x00000001	/* mmu enable */
#define MMCR_IA		0x00000010	/* invalidate all tlb entries */
#define MMCR_VIN	0x00000020	/* invalidate the virtual cache tags */
#define MMCR_PIN	0x00000040	/* invalidate the physical cache tags */
#define MMCR_EE		0x00000080	/* ecc enable */
/* the next set of bits are for diagnostics only */
#define MMCR_VDCI	0x00000100	/* virtual data cache inhibit */
#define MMCR_PDCI	0x00000200	/* physical data cache inhibit */
#define MMCR_TPV0	0x00000400	/* test physical valid bit 0 */
#define MMCR_TPV1	0x00000800	/* test physical valid bit 1 */
#define MMCR_TPO0	0x00001000	/* test physical own bit 0 */
#define MMCR_TPO1	0x00002000	/* test physical own bit 1 */

#define MMCR_CLR_MASK	0xffffc07e	/* mask for clearing MMCR */
					/* bits which always read as 1's */

#ifndef LOCORE
/*
 * macro for checking if mmu is enabled
 */
#define MMU_ENABLED	(mmu_rd_mmcr() & MMCR_ME)
#endif !LOCORE

/*
 * FCR, fault cause register, bit definitions
 */
#define FCR_TOFIO	0x00000001	/* timeout to IO space exception */
#define FCR_TOFM	0x00000002	/* timeout to memory exception */
#define FCR_ECCM	0x00000004	/* multiple bit ECC exception */
#define FCR_DTRAP	0x00000008	/* double trap exception */
#define FCR_POF		0x00000010	/* page out exception */
#define FCR_WPF		0x00000020	/* write protection exception */
#define FCR_UPF		0x00000040	/* user protection exception */
#define FCR_TMISS	0x00000080	/* tlb miss exception */
#define	FCR_MASK	0x000000ff	/* valid fcr bits */

#define FCR_CLR_MASK	0xffffff00	/* clear bits read as 1's */

#define FCR_PFAULT	(FCR_TOFIO|FCR_TOFM|FCR_ECCM)
#define FCR_VFAULT	(FCR_POF|FCR_WPF|FCR_UPF|FCR_TMISS)

#define phys_fault(x)	((x) & FCR_PFAULT)
#define virt_fault(x)	((x) & FCR_VFAULT)

#define FCR_BITS	"\20\10Tlb_miss_ex\7User_protection_ex\6Write_protect_ex\5Page_out_ex\4Double_trap\3Multibit_ECC\2Memory_timeout\1FastIO_timeout"
#endif Series4

#ifdef Series5
/*
 * Two translation windows exists which may be accessed
 * regardless of whether the MMU is enabled or not. Both of these
 * windows translate 16Mbytes of instruction and 16Mbytes of data.
 * The translation window beginning at 0xfe000000 accesses IO space 0,
 * or bootrom space. The translation window beginning at 0xff000000 
 * accesses physical memory. Both windows translate using physical 
 * addresses loaded in the fe/ff half of the GTLB.
 */
#define	F16M_PHYS_WIN	0xff000000	/* "first 16Meg" physical memory window */
#define	KERN_PHYS_WIN	0xff000000	/* kernel's physical memory window */
#define	PHYS_WIN_MASK	0xff000000	/* mask to determine memory window */
#define	PHYSICAL_WINDOW	KERN_PHYS_WIN	/* alias */
#define	PHYS_WIN_SIZE	0x01000000	/* physical window size in bytes */
#define	IO_ZERO_WIN	0xfe000000	/* hardwired I/O space zero window */
#define	IO_WIN_SIZE	0x01000000	/* I/O window size in bytes */
#define	ROM_WINDOW	0xfe000000	/* Boot ROM text window */
#define	ROM_WIN_SIZE	0x01000000	/* Boot ROM window size in bytes */
/*
 * Address space identifier (formerly function codes) values.
 */
#define	ASI_UP		0x08	/* user program */
#define	ASI_SP		0x09	/* supervisor program */
#define	ASI_UD		0x0a	/* user data */
#define	ASI_SD		0x0b	/* supervisor data */

/*
 * A scheme is followed where every register on the CPU board resides
 * in its own Address space at address 0.  This improves the speed
 * of routines that access these registers as they don't have to
 * generate addresses for them.
 */
/*
 * TLB Space
 */
#define ASI_FGTLB_VALI	0xa8	/* write FTLB & instruction GTLB entry, WO */
#define ASI_GTLB_VALI	0xa8	/* write FTLB & instruction GTLB entry, WO */
#define ASI_FGTLB_VALD	0xaa	/* write FTLB & data GTLB entry, WO */
#define ASI_GTLB_VALD	0xaa	/* write FTLB & data GTLB entry, WO */
#define	ASI_GTLB_RDI	0xb1	/* read instruction GTLB entry, RO */
#define	ASI_GTLB_RDD	0xb3	/* read data GTLB entry, RO */
#define ASI_GTLB_INV	0x85	/* invalidate GTLB, WO */
#define ASI_FTLB_INV	0x86	/* invalidate FTLB, WO */
#define ASI_FGTLB_INV	0x87	/* invalidate FTLB & GTLB, WO */
/* some alternate names... 	*/
#define ASI_RI_GTLB	0xb1	/* read instruction GTLB entry, RO */
#define ASI_RD_GTLB	0xb3	/* read data GTLB entry, RO */
#define ASI_WI_GTLB	0xa8	/* write FTLB & instruction GTLB entry, WO */
#define ASI_WI_FTLB	0xa8	/* write FTLB & instruction GTLB entry, WO */
#define ASI_WI_FGTLB	0xa8	/* write FTLB & instruction GTLB entry, WO */
#define ASI_WD_GTLB	0xaa	/* write FTLB & data GTLB entry, WO */
#define ASI_WD_FTLB	0xaa	/* write FTLB & data GTLB entry, WO */
#define ASI_WD_FGTLB	0xaa	/* write FTLB & data GTLB entry, WO */

/*
 * Virtual CPU Registers
 */
#define ASI_MMCR	0x80	/* memory mgmt control register, 32-bit, RW */
#define ASI_FCR 	0x81	/* fault cause register, 32-bit, RW */
#define ASI_FVAR	0x82	/* fault virtual address reg, 32-bit, RO */
#define ASI_PDBA	0x83	/* page directory base reg, 32-bit, RW */

/*
 * the lower bits of the PDBA may hold special information
 */
#define PDBA_CLEAN	0x02	/* process requires clean windows */

/*
 * Interrupt Registers
 */
#define ASI_DIR		0xc8	/* device id register, 8-bit, RW */
#define ASI_IXR		0xc9	/* interrupt transmit reg, 32-bit, RW */
#define ASI_ITXC	0xca	/* interrupt transmit control reg, 32-bit, RW */
#define ASI_IPR		0xcb	/* interrupt priority register, 32-bit, RW */
#define ASI_ACK_IPV	0xcc	/* ack intrupt pending vector reg, 32-bit RW */
#define ASI_IRXC	0xcd	/* intrupt receiver control reg, 32-bit, RW */
#define ASI_NOACK_IPV	0xec	/* noack intrupt pending vector, 32-bit, RO */

/*
 * Physical CPU Registers 
 */
#define ASI_FPAR	0xd0	/* fault physical address reg, 32-bit, RO */
#define ASI_FTOR	0xd3	/* fault time out reg, 32-bit, RO */
#define ASI_FES		0xd1	/* fault ECC syndrome register, 16-bit, RO */
#define ASI_FTSR	0xd4	/* fault time out space reg, 16-bit, RO */

#define FTSR_TO_SPACE(ftsr)	((unsigned)ftsr & 0xf)
#define FTSR_TO_TTYPE(ftsr)	(((unsigned)ftsr & 0xf0) >> 4)

/*
 * Diagnostic RAM
 */
#define ASI_DIAG_RAM	0xe0	/* diagnostic RAM */

/*
 * CPU Board Registers
 */
#define ASI_BID		0xc0	/* board id register, 16-bit, RO */
#define ASI_LED		0xc1	/* LED register, 16-bit, WO */

/*
 * MMCR, memory management control register, bit definitions
 */
#define MMCR_ME		0x00000001	/* mmu enable */
#define MMCR_CS		0x00000002	/* cold start */
#define MMCR_FIO	0x00000004	/* fast I/O enable */
#define MMCR_PIO	0x00000008	/* fast I/O pending */
#define MMCR_WDEN	0x00000010	/* watchdog enable */
#define MMCR_WTAGCLR	0x00000020	/* clear bus watcher tags */
#define MMCR_KCB	0x00000040	/* use KCB as check bit source */
#define MMCR_EE		0x00000080	/* ecc enable */

#ifndef LOCORE
/*
 * macro for checking if mmu is enabled
 */
#define MMU_ENABLED	(mmu_rd_mmcr() & MMCR_ME)
#endif !LOCORE

/*
 * FCR, fault cause register, bit definitions
 */
#define FCR_TOF		0x00000001	/* timeout to IO or memory exception */
#define FCR_WDOG	0x00000002	/* watchdog reset occurred */
#define FCR_ECCM	0x00000004	/* multiple bit ECC exception */
#define FCR_DTRAP	0x00000008	/* double trap exception */
#define FCR_POF		0x00000010	/* page out exception */
#define FCR_WPF		0x00000020	/* write protection exception */
#define FCR_UPF		0x00000040	/* user protection exception */
#define FCR_TMISS	0x00000080	/* tlb miss exception */
#define	FCR_TOFIO	0x00000100	/* I/O timeout, only set by software */
#define	FCR_MASK	0x000000ff	/* valid fcr bits */
#define	FCR_SOFT_MASK	0x00000100	/* valid fcr bits */

#define FCR_CLR_MASK	0xffffff00	/* clear bits read as 1's */

#define FCR_PFAULT	(FCR_TOF|FCR_ECCM|FCR_TOFIO)
#define FCR_VFAULT	(FCR_POF|FCR_WPF|FCR_UPF|FCR_TMISS)

#define phys_fault(x)	((x) & FCR_PFAULT)
#define virt_fault(x)	((x) & FCR_VFAULT)

#define FCR_BITS	"\20\10Tlb_miss_ex\7User_protection_ex\6Write_protect_ex\5Page_out_ex\4Double_trap\3Multibit_ECC\2WatchDog_Reset\1Memory_timeout"
#endif Series5

#if	defined(Series6) || defined(Series7)
/*
 * The boot ROM and standalone programs have one MMU context set 
 * up to simulate the 0xFF and 0xFE translations from previous
 * CPU's.  The 16 Mbyte region beginning at 0xfe000000 accesses Boot 
 * space.  The 16 Mbyte region beginning at 0xff000000 accesses 
 * physical memory starting at address 0x0.
 */

#define	F16M_PHYS_WIN	0xfd000000	/* "first 16Meg" memory window */
#define	F16M_ALT_WIN	0xfc000000	/* "alternate first 16Meg" memory window */
#define	KERN_PHYS_WIN	0xff000000	/* kernel's physical memory window */
#define	PHYS_WIN_MASK	0xff000000	/* mask to determine memory window */
#define	PHYSICAL_WINDOW	KERN_PHYS_WIN	/* alias */
#define	PHYS_WIN_SIZE	0x01000000	/* physical window size in bytes */
#define	ROM_WINDOW	0xfe000000	/* Boot ROM text window */
#define	ROM_WIN_SIZE	0x01000000	/* Boot ROM window size in bytes */
#define ROM_WIN_PA	0xf0000000	/* Boot ROM physical address */
					/* in boot space */

/*
 * When simulating using MSIM, any reference to memory in
 * the host cpu ROM data/bss or MSIM data/bss areas
 * must be protected.  Memory references which
 * normally would begin using the first page
 * of physical memory must be adjusted by
 * the number of pages reserved for the host
 * ROM and MSIM.
 */
#ifdef	MSIM
#define	MSIM_START_PAGE	0x001c0000	/* last MSIM bss space must be below this address */
#endif	MSIM

/*
 * the standalone context table is resident just below the
 * stack of the standalone program. Series6/Series7 standalones and
 * the kernel are loaded at 0xff0a0000. Allowing for a 64Kbyte 
 * stack, the context table starts at 0xff080000 and ends at
 * 0xff070000 (64K byte total).
 *
 * The two standalone L1 page tables will be positioned 2Kbytes
 * below the context table.  This should still give the ROM
 * enough room for its data area. 
 *
 * When using the MSIM simulator, the above addresses
 * are adjusted by MSIM_START_PAGE.  The kernel or
 * standalone programs are loaded at 0xff240000, and
 * the context table starts at 0xff220000.
 */
#define SA_STACK_SIZE	0x00010000	/* size of Standalone Stack area */
#ifdef viking_erratum_6
/*
 * for viking erratum 6, we must use a larger context table and
 * page tables.
 *
 * context table must be 128K bytes so that bit 14 of the context
 * register can remain set (viking erratum 12)
 *
 */
#define CTX_TBL_SIZE 0x00020000	
#define	CTX_TBL_ENTRIES	(CTX_TBL_SIZE >> 2)
#define L1_TBL_VA	(PHYSICAL_WINDOW|0x006afc00)
#define L2_TBL_VA	(PHYSICAL_WINDOW|0x006b0000
#define CTX_TBL_VA	(PHYSICAL_WINDOW|0x006c0000
#define L3_TBL_VA	(PHYSICAL_WINDOW|0x00200000
#else
#define CTX_TBL_SIZE	0x00010000	/* size of Context table (64Kbytes) */
#define	CTX_TBL_ENTRIES	(CTX_TBL_SIZE >> 2)
#define CTX_TBL_VA	((KERN_PHYS_WIN|0x000A0000)-SA_STACK_SIZE-CTX_TBL_SIZE+MSIM_START_PAGE) /* start of Context table */
#endif

#define PT_L1_SIZE			0x00000400	/* size of Level 1 page tables */
#define PT_L2_SIZE			0x00000100	/* size of Level 2 page tables */
#define PT_L3_SIZE			0x00000100	/* size of Level 3 page tables */

#ifndef notdef
/* NORMAL defines */
#define CACHEABLE_SPACE			0xB0000000	/* Kbus cacheable space */ 
#define ALT_CACHEABLE_SPACE		0x90000000	/* alternate cacheable space */ 
#define BOOT_ROM_SPACE			0xF0000000	/* Boot ROM space */
#define PTP_CACHEABLE_SPACE_SHARE	0x0b000000 	/* Kbus cacheable space */ 
#define PFN_ROM_SPACE			0x00ff0000	/* Kbus cacheable ROM space */ 
#define PFN_CACHEABLE_SPACE_SHARE	0x00b00000 	/* Kbus cacheable space */ 
#define PFN_CACHEABLE_SPACE_OWN		0x00b00000 	/* Kbus cacheable space */ 
#define PFN_SPACE_MASK			0x00f00000
#else
/* DEBUG */
#define CACHEABLE_SPACE			0x90000000	/* Kbus cacheable space */ 
#define ALT_CACHEABLE_SPACE		0xB0000000	/* alternate cacheable space */ 
#define BOOT_ROM_SPACE			0xF0000000	/* Boot ROM space */
#define PTP_CACHEABLE_SPACE_SHARE	0x09000000 	/* Kbus cacheable space */ 
#define PFN_ROM_SPACE			0x00ff0000	/* Kbus cacheable ROM space */ 
#define PFN_CACHEABLE_SPACE_SHARE	0x00900000 	/* Kbus cacheable space */ 
#define PFN_CACHEABLE_SPACE_OWN		0x00900000 	/* Kbus cacheable space */ 
#define PFN_SPACE_MASK			0x00f00000
/* DEBUG */
#endif notdef

#define TLB_UPAGE_INDEX	0	/* tlb index for locked in upage pte */

/*
 * Mbus modules do not drive the ASI off the chip
 * Access must be through MMU bypass ASI 0x20-0x2f.
 */

#define ASI_MEM		0x20	/* Kbus I/O Space 15 (0xF) */
#define	ASI_KBUS_IO14	0x21	/* Kbus RIO Space 14 (0xE) */
#define ASI_KBUS_IO13	0x22	/* Kbus RIO Space 13 (0xD) */
#define ASI_KBUS_IO12	0x23	/* Kbus RIO Space 12 (0xC) */
#define ASI_KBUS_IO11	0x24	/* Kbus RIO Space 11 (0xB) */
#define ASI_KBUS_IO10	0x25	/* Kbus RIO Space 10 (0xA) */
#define ASI_KBUS_IOASIC	0x26	/* Kbus RIO Space 9 (IO ASIC registers) */
#define ASI_KBUS_IOVME	0x27	/* Kbus RIO Space 8 (VMEbus Space) */
#define ASI_KBUS_IO7	0x28	/* Kbus RIO Space 7 */
#define ASI_KBUS_IO6	0x29	/* Kbus RIO Space 6 */
#define ASI_KBUS_IO5	0x2A	/* Kbus RIO Space 5 (MXCC/bootrom from kbus) */
#define ASI_KBUS_CACHE	0x2B	/* Kbus Cacheable space (memory) */
#define ASI_KBUS_PROBE	0x2C	/* Kbus Probe Transaction Space */
#define ASI_MBUS_PROBE	0x2D	/* Mbus Cache Probe Transaction Space */
#define ASI_KBUS_ID	0x2E	/* Kbus RIO Space 1 (ID Space) */
#define ASI_MBUS_BOOT	0x2F	/* Mbus Configuration/Boot Space */

#define ASI_KBUS_OWN	0x29	/* Cacheable space (take ownership) */
#define ASI_KBUS_NOWN	0x2B	/* Cacheable space (don't take ownership) */

#endif Series6 || Series7

#ifdef viking
/*
 * ASI and register definitions for TMS390Z50 (Viking)
 *
 *  In the definitions below, 
 *       LD = Load Alternate
 *	 ST = Store Alternate
 */
#define ASI_CS		0x02	/* Control Space, LD/ST all sizes */
/*
 * MXCC registers (read through ASI_CS).
 */
#define MXCC_CD		0x01000000	/* (dword) L2 Cache Data */
#define MXCC_CT		0x01800000	/* (dword) L2 Cache Tags */
#define MXCC_SDATA	0x01C00000	/* (64 bytes) Stream Data Reg */
#define MXCC_SSRC	0x01C00100	/* (dword) Stream Source Reg */
#define MXCC_SDST	0x01C00200	/* (dword) Stream Dest Reg */
#define MXCC_RMC	0x01C00300	/* (dword) Ref/Miss Count Reg */
#define MXCC_IP		0x01C00400	/* (hword) Int Pending Reg */
#define MXCC_IM		0x01C00500	/* (hword) Int Mask Reg */
#define MXCC_IPC	0x01C00600	/* (hword) Int Pending Clr Reg */
#define MXCC_IG		0x01C00700	/* (word) Int Generation Reg */
#define MXCC_BIST	0x01C00800	/* (word) BIST Reg */
#define MXCC_CNTRL	0x01C00A00	/* (word) Control Reg */
#define MXCC_STATUS	0x01C00B00	/* (dword) Status Reg */
#define MXCC_RESET	0x01C00C00	/* (word) Reset Reg */
#define MXCC_ERROR	0x01C00E00	/* (dword) Error Reg */
#define MXCC_PORT	0x01C00F00	/* (word) Mbus Port Reg */

/*
 * MXCC_PORT reg bits:
 */
#define MXPORT_MID	0x0F000000	/* MID mask */	
#define MID_SHIFT	24		
#define MXPORT_MREV	0x000000F0	/* MREV mask */	
#define MXPORT_MVEND	0x0000000F	/* MVEND mask */	
#define MREV_SHIFT	4		
/*
 * MXCC_CNTRL reg bits:
 */
#define MXCNTRL_HC	0x00000001	/* Half Cache */
#define MXCNTRL_CS	0x00000002	/* Cache Size */
#define MXCNTRL_CE	0x00000004	/* Cache Enable */
#define MXCNTRL_PE	0x00000008	/* Parity Enable */
#define MXCNTRL_MC	0x00000010	/* Multi Cmd */
#define MXCNTRL_PF	0x00000020	/* Prefetch Enable */
#define MXCNTRL_WI	0x00000040	/* Write Invalidate */
#define MXCNTRL_BWC	0x00000180	/* Bus Watcher Count */
#define MXCNTRL_RC	0x00000200	/* Read Ref Count */

/*
 * MXCC_STATUS reg - 64 bits:
 *
 * 	lower 32 bits... 
 */
#define MXSTATUS_PP	0x00000001	/* Prefetch Pending */
#define MXSTATUS_RP	0x00000002	/* Read Pending */
#define MXSTATUS_WP	0x00000004	/* Write Pending */
#define MXSTATUS_BC	0x00000008	/* Boot Communication */
#define MXSTATUS_SPC	0x000000f0	/* Store Pending Count (mask) */
#define MXSTATUS_NCSPC	0x00000f00	/* NC Store Pending Count (mask) */
#define MXSTATUS_NCSPAL	0xfffff000	/* NC Store Pending Address (mask) */
#define	MXSTATUS_L_BITS		\
"\20\4Boot\3Write_pending\2Read_pending\1Prefetch_pending"
/*
 * 	upper 32 bits... 
 */
#define MXSTATUS_NCSPAU	0x0000000f	/* NC Store Pending Address (mask) */
#define MXSTATUS_NCSID	0x00000030	/* NC store bus watcher ID (mask) */
#define MXSTATUS_SM	0x00000040	/* Synchronous mode */
#define MXSTATUS_SXP	0x00000080	/* Store Exception Pending */
#define	MXSTATUS_U_BITS		\
"\20\10Store_ex_pend\7Sync_mode"

/*
 * MXCC_RESET reg - 32 bits:
 */
#define MXRESET_SI	0x00000002	/* Software Internal Reset */	
#define MXRESET_WD	0x00000004	/* Watch Dog Reset */

/*
 * MXCC_ERROR reg - 64 bits:
 *	lower 32 bits...
 */
#define MXERROR_PAL	0xffffffff	/* Physical Address (lower mask) */
/*
 *	upper 32 bits...
 */
#define MXERROR_PAU	0x0000000f	/* Physical Address (upper mask) */
#define MXERROR_S	0x00000040	/* Supervisor bit */
#define MXERROR_ERR	0x00007f80	/* Error Code (mask) */
#define MXERROR_CCOP	0x01ff8000	/* MXCC Operation Code (mask) */
#define MXERROR_EV	0x02000000	/* Error Valid */
#define MXERROR_AE	0x04000000	/* Asynchronous Error */
#define MXERROR_CP	0x08000000	/* Vbus Parity Error/MXCC master */
#define MXERROR_VP	0x10000000	/* Vbus Parity Error/Viking master */
#define MXERROR_CC	0x20000000	/* Cache Consistency Error */
#define MXERROR_XP	0x40000000	/* Xbus Parity error */
#define MXERROR_ME	0x80000000	/* Multiple Errors */
#define	MXERROR_U_BITS	\
"\20\32Error_valid\33Async_error\34Vbus_parity_MXCC\35Vbus_parity_vik\36Cache_consistency_error\37Xbus_parity\40Multiple_errors"

/*
 * MXCC_SDST reg - 64 bits:
 *	upper 32 bits...
 */
#define	MXSDST_C	0x10		/* cacheable bit */
#define	MXSDST_RDY	0x80000000	/* operation done bit */

#define	ASI_FLPR	0x03	/* Reference MMU flush/probe */
#define ASI_MPROBE	ASI_FLPR/* MMU Probe, LD word */	
#define ASI_MFLUSH	ASI_FLPR/* MMU Flush, ST word */	
#define	FLUSH_PAGE	0x000	/* flush page from tlb */
#define	FLUSH_SEG	0x100	/* flush segment from tlb */
#define	FLUSH_REG	0x200	/* flush region from tlb */
#define	FLUSH_CTX	0x300	/* flush context from tlb */
#define	FLUSH_ALL	0x400	/* flush entire tlb */
#define	ASI_MOD		0x4	/* Modlule control/status register */
#define	ASI_MMU		ASI_MOD	/* SPARC Reference MMU control regs */
/*
 * Viking Reference MMU registers, LD/ST word 
 */
#define	MMU_MCNTL	0x00000000	/* MMU Control Register */
/*
 * MMU Control register bit definitions
 */
#define MCNTL_EN	0x00000001	/* MMU enable */
#define MCNTL_NF	0x00000002	/* No Fault */
#define MCNTL_PSO	0x00000080	/* Partial Store Ordering */
#define MCNTL_DE	0x00000100	/* Data Cache Enable */
#define MCNTL_IE	0x00000200	/* Inst Cache Enable */
#define MCNTL_SB	0x00000400	/* Store Buffer Enable */
#define MCNTL_MB	0x00000800	/* Mbus mode */
#define MCNTL_PE	0x00001000	/* Parity Enable */
#define MCNTL_BT	0x00002000	/* Boot Mode */
#define MCNTL_SE	0x00004000	/* Snoop Enable */
#define MCNTL_AC	0x00008000	/* Alternate Cacheable */
#define MCNTL_TC	0x00010000	/* Table Walk Cacheable */
#define MCNTL_PF	0x00040000	/* Data Prefetcher Enable */
#define MCNTL_VER	0x0f000000	/* Version Mask */
#define MCNTL_IMP	0xf0000000	/* Implementation Mask */

#define MMU_CTP		0x00000100	/* MMU Context Table Ptr Register */
#define MMU_CONTEXT	0x00000200	/* MMU Context Register */
#define MMU_FSR		0x00000300	/* MMU Fault Status Register */
#define MMU_FAR		0x00000400	/* MMU Fault Address Register */
#define	MMU_RWFSR	0x00001300	/* MMU read/write Fault Status Register */
#define MMU_RWFAR	0x00001400	/* MMU read/write Fault Address Register */
#define MMU_SFSR	0x00001500	/* MMU Shadow Fault Status Register */

/*
 * MMU fault status register bit definitions
 */
#define	FSR_OW		0x00000001	/* Overwrite */
#define FSR_FAV		0x00000002	/* Fault Address Valid */
#define	FSR_FT		0x0000001C	/* Fault Type mask */
#define	FSR_FT_SHFT	2
#define FSR_FT_NONE	0x00000000	/* no fault */
#define FSR_FT_INVAL	0x00000004	/* Invalid Address error */
#define FSR_FT_PROT	0x00000008	/* Protection error */
#define FSR_FT_PRIV	0x0000000C	/* Privilege violation */
#define FSR_FT_TRANS	0x00000010	/* Translation error */
#define FSR_FT_BUS	0x00000014	/* Access Bus error */
#define FSR_FT_INT	0x00000018	/* Internal error */
#define FSR_FT_RES	0x0000001C	/* Reserved error */
#define	FSR_FT_ASCII	{"No_fault","Invalid_address","Protection_error",\
			"Privilege_violation","Translation_error", \
			"Access_bus_error","Internal_error","Reserved_error"}
#define FSR_AT		0x000000E0	/* Access Type mask */
#define	FSR_AT_SHFT	5
#define FSR_AT_UDATL	0x00000000	/* User data space load */
#define FSR_AT_SDATL	0x00000020	/* Supervisor data space load */
#define FSR_AT_UINSTL	0x00000040	/* User instruction space load */
#define FSR_AT_SINSTL	0x00000060	/* Supervisor instruction space load */
#define	FSR_AT_STORE	0x00000080	/* access was a store */
#define FSR_AT_UDATS	0x00000080	/* User data space store */
#define FSR_AT_SDATS	0x000000a0	/* Supervisor data space store */
#define FSR_AT_UINSTS	0x000000c0	/* User instruction space store */
#define FSR_AT_SINSTS	0x000000e0	/* Supervisor instruction space store */
#define	FSR_AT_ASCII	{"User_data_load","Supervisor_data_load",\
			"User_instruction_load","Supervisor_instruction_load",\
			"User_data_store","Supervisor_data_store",\
			"User_instruction_store","Supervisor_instruction_store"}
#define FSR_L		0x00000300	/* Page Table entry Level mask */
#define FSR_L_SHFT	8
#define FSR_L_RT	0x00000000	/* level = root pointer (level 0) */
#define FSR_L_L1	0x00000100	/* level = level 1 */
#define FSR_L_L2	0x00000200	/* level = level 2 */
#define FSR_L_L3	0x00000300	/* level = level 3 */
#define FSR_BE		0x00000400	/* Bus Error */
#define FSR_TO		0x00000800	/* Time Out */
#define FSR_UC		0x00001000	/* Uncorrectable error */
#define FSR_UD		0x00002000	/* Undefined error */
#define FSR_P		0x00004000	/* Parity error */
#define FSR_SB		0x00008000	/* Store Buffer error */
#define FSR_CS		0x00010000	/* Control Space error */
#define FSR_EM		0x00020000	/* Error Mode Reset Taken */
#define FSR_ECCM	0x00040000	/* ECCM flag set by Software */
#define	FSR_BITS		\
"\20\23Multibit_ECC_SW\22Error_mode_reset\21Control_space_error\20Store_buffer_error\17Vbus_parity_error\16Undefined_error\15Uncorrectable_error\14Timeout\13Bus_error\2Fault_address_valid\1Overwrite"

#define ASI_MTLB	0x06	/* Ref MMU TLB diagnostics, LD/ST word */
#define	SEL_VADDR	0x000	/* write TLB virtual address field */
#define	SEL_CTX		0x100	/* write TLB PTE field */
#define	SEL_PTE		0x200	/* write TLB PTE field */
#define	SEL_LOCK	0x300	/* write TLB lock bit */
#define ASI_UINST	0x08	/* User Instruction, LD/ST all sizes */
#define ASI_SINST	0x09	/* Supv Instruction, LD/ST all sizes */
#define ASI_UDATA	0x0A	/* User Data, LD/ST all sizes */
#define ASI_SDATA	0x0B	/* Supv Data, LD/ST all sizes */
#define ASI_ICTAGS	0x0C	/* ICACHE Tags, LD/ST double word */
#define ASI_ICDATA	0x0D	/* ICACHE Data, LD/ST double word */
#define ASI_DCTAGS	0x0E	/* DCACHE Tags, LD/ST double word */
#define ASI_DCDATA	0x0F	/* DCACHE Data, LD/ST double word */
#define ASI_MBYP	0x20	/* MMU bypass, LD/ST all sizes */

#define ASI_SBTAGS	0x30	/* Store Buffer Tags, LD/ST double word */
#define ASI_SBDATA	0x31	/* Store Buffer Data, LD/ST double word */
#define ASI_SBCTL	0x32	/* Store Buffer Control, LD/ST word */
#define SB_DPTR_MASK	0x38	/* Store Buffer Drain Pointer Mask */
#define SB_DPTR_CLR	0xffffffc7	/* Store Buffer Drain Pointer Clear */
#define SB_VAL_CLR	0xfffffeff	/* Store Buffer Valid Bit Clear  */

#define ASI_ICCLR	0x36	/* ICACHE flash Clear, ST word */
#define ASI_DCCLR	0x37	/* DCACHE flash Clear, ST word */
#define CCLR_LOCK	0x80000000 /* selects Lock bits for flash clear */

#define ASI_MDIAG	0x38	/* MMU breakpoint diags, LD/ST double word */
#define MDIAG_BKV	0x000	/* Breakpoint Value (Addr) register */
#define MDIAG_BKM	0x100	/* Breakpoint Mask register */
#define MDIAG_BKC	0x200	/* Breakpoint Control register */
#define CSPACE	0x40	/* 1=code space breakpoint, 0=data space */
#define PAMD	0x20	/* 1=physical addr, 0=virtual addr */
#define CBFEN	0x10	/* 1=enable inst_address_exception */
                        /* 0=take interrupt on code breakpoint */
#define CBKEN	0x08	/* 1=enable code breakpoint */
 			/* 0=no code breakpoint can occur */
#define DBFEN	0x04	/* 1=enable data_address_exception */
                        /* 0=take interrupt on data breakpoint*/
#define DBREN	0x02	/* 1=break on data read */
			/* 0=don't break on data read */
#define DBWEN	0x01	/* 1=break on data write */
			/* 0=don't break on data write */
#define MDIAG_BKS	0x300	/* Breakpoint Status register */
#define CBKIS	0x08	/* 1=interrupt generated on code breakpoint */
#define CBKFS	0x04	/* 1=inst_access_exception generated on breakpoint */
#define DBKIS	0x02	/* 1=interrupt generated on data breakpoint */
#define DBKFS	0x01	/* 1=data_access_exception generated on breakpoint */
#define BKS_BITS	\
"\20\4Code_breakpoint_interrupt\3Code_breakpoint_exception\2Data_breakpoint_interrupt\1Data_breakpoint_exception"

#define ASI_BIST	0x39	/* BIST diagnostics, LD/ST word */
#define BIST_XSHORT	0x000	/* ST - execute short BIST */
#define BIST_XLONG	0x100	/* ST - execute long BIST */
#define BIST_SIGNATURE	0x000	/* LD - read 31-bit signature */
#define BIST_STATUS	0x100	/* LD - read 2-bit status */
#define BIST_SHORT 	1	/* short BIST run */
#define BIST_LONG 	2	/* long BIST run */

#define ASI_MTMP1	0x40	/* Emulation Temp1, LD/ST word */
#define ASI_MTMP2	0x41	/* Emulation Temp2, LD/ST word */
#define ASI_MDIN	0x44	/* Emulation Data Input, LD/ST word */
#define ASI_MDOUT	0x46	/* Emulation Data Ouput, LD/ST word */
#define ASI_MPC  	0x47	/* Emulation PC, LD/ST word */
#define ASI_MNPC 	0x48	/* Emulation NPC, LD/ST word */
#define ASI_BCTRV	0x49	/* Counter Breakpoint Values, LD/ST word */
#define ASI_BCTRC	0x4a	/* Counter Breakpoint Control, LD/ST word */
#define ASI_BCTRS	0x4b	/* Counter Breakpoint Status, LD/ST word */
#define	ASI_BACTION	0x4c	/* Action Register */
#define MIX		0x1000	/* MIX enable bit */
#define ACTION_MIX	MIX	/* MIX enable bit */
#define IPL_MASK	0x0f00	/* IPL mask */
#define STEN_CBK	0x0080	/* Enable strobe on code breakpt */
#define STEN_ZIC	0x0040	/* Enable strobe on zero inst count*/
#define STEN_DBK	0x0020	/* Enable strobe on data breakpt */
#define STEN_ZCC	0x0010	/* Enable strobe on zero cycle count*/
#define IEN_CBK		0x0008	/* Generate int on code breakpt */
#define IEN_ZIC		0x0004	/* Generate int on zero inst count*/
#define IEN_DBK		0x0002	/* Generate int on data breakpt */
#define IEN_ZCC		0x0001	/* Generate int on zero cycle count*/

/*
 * bits in the TLB rendition of a PTE
 */
#define TLB_ENTRY_SHIFT	12

#define	TLBPTE_4GB	0x00	/* TLB pte protects 4 Gbytes */
#define	TLBPTE_16M	0x01	/* TLB pte protects 16 Mbytes */
#define	TLBPTE_256K	0x02	/* TLB pte protects 256 Kbytes */
#define	TLBPTE_4K	0x03	/* TLB pte protects 4 Kbytes */
#define TLBPTE_TYPE_MASK	(TLBPTE_4GB|TLBPTE_16M|TLBPTE_256K|TLBPTE_4K)

#define TLBPTE_ACC_RW	0x04	/* TLB pte access is read/write */
#define TLBPTE_ACC_RE	0x08	/* TLB pte access is read/exe */
#define TLBPTE_ACC_RWE	0x0C	/* TLB pte access is read/write/exe */
#define TLBPTE_ACC_SUP	0x10	/* TLB pte access is supvervisor only */
#define TLBPTE_PROT_MASK	(TLBPTE_ACC_SUP|TLBPTE_ACC_RWE|TLBPTE_ACC_RE|TLBPTE_ACC_RW)
#define	TLBPTE_VALID	0x20	/* TLB pte is valid */
#define	TLBPTE_V	0x20	/* TLB pte is valid */
#define TLBPTE_M	0x40	/* TLB pte modified */
#define TLBPTE_C	0x80	/* TLB pte has cacheable attribute */

/* Cache sizes */
#define	L2_CACHE_SIZE	0x100000	/* 1 Mbyte */
#define L2_BLOCK_SIZE	0x20		/* Cache Block Size */

/*
 * Assembly macro to flush write buffers
 */
#define	FLUSH_WRITEBUFFERS(reg) \
	iflush	%g0

#endif /* viking */

#ifdef cypress
/*
 * ASI and register definitions for CY7C605 (Cypress)
 * and for CY7C620/625 (Cypress hyperSPARC)
 */

#ifndef	cypress625
#define ASI_CTL		0x02	/* control space */
#endif	/* !cypress625 */
#define ASI_MPROBE	0x03	/* MMU Probe, LD word */	
#define ASI_MFLUSH	0x03	/* MMU Flush, ST word */	
#define	FLUSH_PAGE	0x000	/* flush page from tlb */
#define	FLUSH_SEG	0x100	/* flush segment from tlb */
#define	FLUSH_REG	0x200	/* flush region from tlb */
#define	FLUSH_CTX	0x300	/* flush context from tlb */
#define	FLUSH_ALL	0x400	/* flush entire tlb */
#define	ASI_MMU		0x04	/* Reference MMU control regs */
#define ASI_MITLB	0x05	/* MMU diagnostics ITLB */
#define ASI_MTLB	0x06	/* MMU diagnostics I/D TLB */
#define ASI_IOTLB	0x07	/* MMU diagnostics IO TLB */
#define ASI_UINST	0x08	/* User Instruction */
#define ASI_SINST	0x09	/* Supv Instruction */
#define ASI_UDATA	0x0A	/* User Data */
#define ASI_SDATA	0x0B	/* Supv Data */
#define ASI_ICTAGS	0x0C	/* ICACHE Tags */
#define ASI_ICDATA	0x0D	/* ICACHE Data */
#define ASI_CTAG	0x0E	/* Cache Tag combined (Inst/Data) */
#define ASI_CDATA	0x0F	/* Cache Data combinded (Inst/Data) */
#define ASI_CFPG	0x10	/* Flush Combined cache line (page) */
#define ASI_CFSEG	0x11	/* Flush Combined cache line (segment) */
#define ASI_CFREG	0x12	/* Flush Combined cache line (region) */
#define ASI_CFCNTX	0x13	/* Flush Combined cache line (context) */
#define ASI_CFUSER	0x14	/* Flush Combined cache line (user) */
#define ASI_BCOPY	0x17	/* Block Copy */

#ifdef	cypress625
#define ASI_IBLPG	0x18	/* Flush Instruction Buffer Cache Line (page) */
#define ASI_IBLSEG	0x19	/* Flush Instruction Buffer Cache Line (segment) */
#define ASI_IBLREG	0x1A	/* Flush Instruction Buffer Cache Line (region) */
#define ASI_IBLCNTX	0x1B	/* Flush Instruction Buffer Cache Line (context) */
#define ASI_IBLUSER	0x1C	/* Flush Instruction Buffer Cache Line (user) */
#define ASI_MBYP	0x20	/* MMU bypass */
#define ASI_FIBUF	0x31	/* Flush Entire Instruction Buffer */
#else	/* cypress625 */
#define ASI_DCFPG	0x18	/* Flush Data cache line (page) */
#define ASI_DCFSEG	0x19	/* Flush Data cache line (segment) */
#define ASI_DCFREG	0x1a	/* Flush Data cache line (region) */
#define ASI_DCFCNTX	0x1b	/* Flush Data cache line (context) */
#define ASI_DCFUSER	0x1c	/* Flush Data cache line (user) */
#define ASI_MBYP	0x20	/* MMU bypass */
#define ASI_MPTAG	0x30	/* MPTAG cache tag entries */
#endif	/* cypress625 */

/*
 * Cypress Reference MMU registers, LD/ST word
 */
#define	MMU_SCR		0x00000000	/* System Control (SCR) */
#define MMU_CTP		0x00000100	/* MMU Context Table Ptr Register */
#define MMU_CONTEXT	0x00000200	/* MMU Context Register */
#define MMU_FSR		0x00000300	/* MMU Fault Status Register */
#define MMU_FAR		0x00000400	/* MMU Fault Address Register */
#define	MMU_AFSR	0x00000500	/* Async Fault Status Register */
#define MMU_AFAR	0x00000600	/* Async Fault Address Register */
#define MMU_RR		0x00000700	/* Reset Register */
#define MMU_RPR		0x00001000	/* Root Pointer Register */
#define MMU_IPTP	0x00001100	/* Instruction Access PTP */
#define MMU_DPTP	0x00001200	/* Data Access PTP */
#define MMU_ITR		0x00001300	/* Index Tag Register */
#define MMU_TRCR	0x00001400	/* Tlb Replacement Control Reg */

#ifdef	cypress625
#define MMU_IPTP1	0x00001500	/* Instruction Access PTP1 */
#define MMU_DPTP1	0x00001600	/* Data Access PTP1 */
#define MMU_ITR1	0x00001700	/* Index Tag Register1 */
#endif	/* cypress625 */

/*
 * MMU System Control Register bit definitions
 */
#define SCR_ME		0x00000001	/* MMU enable */
#define SCR_NF		0x00000002	/* No Fault */
#define SCR_CE		0x00000100	/* Cache Enable */
#define SCR_CM		0x00000400	/* Cache Mode (1 == copy back) */
#define SCR_MR		0x00000800	/* Memory Reflection */
#ifdef cypress625
#define SCR_CS		0x00001000	/* Cache Size (0=128K 1=256K) */
#endif	/* cypress625 */
#define SCR_C		0x00002000	/* Cacheable */
#define SCR_BM		0x00004000	/* Boot Mode */
#define SCR_MID		0x00078000	/* MID mask */
#define MID_SHIFT	15
#ifdef	cypress625
#define SCR_WBE		0x00080000	/* Write Buffer Enable */
#define SCR_SE		0x00100000	/* Snoop Enable */
#define SCR_CWR		0x00200000	/* Cache Wrap Enable */
#else
#define SCR_MV		0x00080000	/* Multi-chip Valid */
#define SCR_MCM		0x00300000	/* Multichip Mask */
#define SCR_MCA		0x00C00000	/* Multichip Address */
#endif	/* cypress625 */
#define SCR_VER		0x0f000000	/* Version Mask */
#define SCR_IMP		0xf0000000	/* Implementation Mask */

/*
 * Context Table Pointer Register (CTPR) bit definitions
 * Bits [31..10] of CTPR appear on bits [35..14] of Mbus, i.e. when
 * CTP is taken from CTPR to Mbus, we shift left (<<) 4 bits, 
 * thus we shift right (>>) 4 bits when we store CTP to CTPR.
 * However, this also means the physical address of context table
 * has to be alligned to 1 >> 14.
 */
#define MMU_CTP_SHIFT		4
#define MMU_CTP_ALIGN		(1 << 14)


/*
 * Sync fault status register definitions
 */
#define	FSR_OW		0x00000001	/* Overwrite */
#define FSR_FAV		0x00000002	/* Fault Address Valid */
#define	FSR_FT		0x0000001C	/* Fault Type mask */
#define	FSR_FT_SHFT	2
#define FSR_FT_NONE	0x00000000	/* no fault */
#define FSR_FT_INVAL	0x00000004	/* Invalid Address error */
#define FSR_FT_PROT	0x00000008	/* Protection error */
#define FSR_FT_PRIV	0x0000000C	/* Privilege violation */
#define FSR_FT_TRANS	0x00000010	/* Translation error */
#define FSR_FT_BUS	0x00000014	/* Access Bus error */
#define FSR_FT_INT	0x00000018	/* Internal error */
#define FSR_FT_RES	0x0000001C	/* Reserved error */
#define	FSR_FT_ASCII	{"No_fault","Invalid_address","Protection_error",\
			"Privilege_violation","Translation_error", \
			"Access_bus_error","Internal_error","Reserved_error"}
#define FSR_AT		0x000000E0	/* Access Type mask */
#define	FSR_AT_SHFT	5
#define FSR_AT_UDATL	0x00000000	/* User data space load */
#define FSR_AT_SDATL	0x00000020	/* Supervisor data space load */
#define FSR_AT_UINSTL	0x00000040	/* User instruction space load */
#define FSR_AT_SINSTL	0x00000060	/* Supervisor instruction space load */
#define	FSR_AT_STORE	0x00000080	/* access was a store */
#define FSR_AT_UDATS	0x00000080	/* User data space store */
#define FSR_AT_SDATS	0x000000a0	/* Supervisor data space store */
#define FSR_AT_UINSTS	0x000000c0	/* User instruction space store */
#define FSR_AT_SINSTS	0x000000e0	/* Supervisor instruction space store */
#define	FSR_AT_ASCII	{"User_data_load","Supervisor_data_load",\
			"User_instruction_load","Supervisor_instruction_load",\
			"User_data_store","Supervisor_data_store",\
			"User_instruction_store","Supervisor_instruction_store"}
#define FSR_L		0x00000300	/* Page Table entry Level */
#define FSR_L_SHFT	8
#define FSR_BE		0x00000400	/* Bus Error */
#define FSR_TO		0x00000800	/* Time Out */
#define FSR_UC		0x00001000	/* Uncorrectable Error */
#define FSR_SE		0x00002000	/* System Error */
#define FSR_ECCM	0x00040000	/* ECCM flag set by Software */
#define	FSR_BITS		\
"\20\23ECCM\16System_error\15Uncorrectable_error\14Timeout\13Bus_error\2Fault_address_valid\1Overwrite"

/*
 * Async fault status register bit definitions
 */
#define AFSR_AFO	0x00000001	/* Async Fault Occurred */
#define AFSR_AFA	0x000000F0	/* Async Fault Address */
#define AFSR_BE		0x00000400	/* Bus Error */
#define AFSR_TO		0x00000800	/* Bus Error */
#define AFSR_UC		0x00001000	/* Uncorrectable Error */
#define AFSR_SE		0x00002000	/* System Error */
#define	AFSR_BITS		\
"\20\16System_error\15Uncorrectable_error\14Timeout\13Bus_error\1Async_fault_occured"

/*
 * Reset Register bit definitions
 */
#define	RR_SER		0x00000001	/* Software External Reset */
#define	RR_SIR		0x00000002	/* Software Internal Reset */
#define	RR_WDR		0x00000004	/* Watch Dog Reset */

/*
 * Tlb Replacement Control Register bit definitions
 */
#define	RC_SHIFT	8		/* RC field shift */

/*
 * bits in the TLB rendition of a PTE
 */
#define TLB_ENTRY_SHIFT	12

#define	TLBPTE_VALID	0x01	/* TLB pte is valid */
#define	TLBPTE_V	0x01	/* TLB pte is valid */
#define	TLBPTE_4K	0x00	/* TLB pte protects 4 Kbytes */
#define	TLBPTE_256K	0x02	/* TLB pte protects 256 Kbytes */
#define	TLBPTE_16M	0x04	/* TLB pte protects 16 Mbytes */
#define	TLBPTE_4GB	0x06	/* TLB pte protects 4 Gbytes */
#define TLBPTE_TYPE_MASK	(TLBPTE_4GB|TLBPTE_16M|TLBPTE_256K|TLBPTE_4K)
#define TLBPTE_ACC_RW	0x08	/* TLB pte access is read/write */
#define TLBPTE_ACC_RE	0x10	/* TLB pte access is read/exe */
#define TLBPTE_ACC_RWE	0x18	/* TLB pte access is read/write/exe */
#define TLBPTE_ACC_SUP	0x20	/* TLB pte access is supvervisor only */
#define TLBPTE_PROT_MASK	(TLBPTE_ACC_SUP|TLBPTE_ACC_RWE|TLBPTE_ACC_RE|TLBPTE_ACC_RW)
#define TLBPTE_M	0x40	/* TLB pte modified */
#define TLBPTE_C	0x80	/* TLB pte has cacheable attribute */

/* Cache sizes */
#ifdef	cypress625
#ifdef	USE_SMALL_CACHE
#define L2_CACHE_SIZE	0x20000		/* 128 Kbyte */
#define	L2_BLOCK_SIZE	0x20		/* Single Cache Block Size */
#else
#define L2_CACHE_SIZE	0x40000		/* 256 Kbyte */
#define	L2_BLOCK_SIZE	0x40		/* Paired Cache Block Size */
#endif USE_SMALL_CACHE

/*
 * Assembly macro to flush write buffers
 *
 * A cache read miss forces a delay until all write buffers have been
 * written back.  We force a miss by reading one address and then
 * reading an alias for that address.
 */
#define	FLUSH_WRITEBUFFERS(reg) \
	sethi	%hi(PHYSICAL_WINDOW),reg;		\
	ld	[reg],%g0;				\
	sethi	%hi(PHYSICAL_WINDOW+L2_CACHE_SIZE),reg;	\
	ld	[reg],%g0
#else
#define	L2_CACHE_SIZE	0x10000		/* 64 Kbyte */
#define	L2_BLOCK_SIZE	0x20		/* Cache Block Size */
#define FLUSH_WRITEBUFFERS(reg)		/* Nothing to do, there are none */
#endif	/* cypress625 */
#endif /* cypress */

#ifdef refmmu

#define	MMU_ENABLED	1		/* ref MMU always enabled */

#define	FSR_TOFIO	0x80000		/* fsr fast io timeout pseudo error */

#ifdef viking
#define FSR_PFAULT	(FSR_SB|FSR_UD|FSR_UC|FSR_BE|FSR_TO|FSR_P|FSR_TOFIO)
#endif viking
#ifdef cypress
#define FSR_PFAULT	(FSR_UC|FSR_BE|FSR_TO|FSR_TOFIO)
#endif	/* cypress */

#define phys_fault(x)	((x) & FSR_PFAULT)

#endif /* refmmu */

/* Guarantee MSIM_START_PAGE has been defined */
#ifndef	MSIM_START_PAGE
#define	MSIM_START_PAGE	0
#endif

/* 
 * Guarantee PHYSICAL_WINDOW has been defined for Kbus stimulus
 * board software
 */
#ifndef	PHYSICAL_WINDOW
#define	PHYSICAL_WINDOW	0xff000000
#endif

/*
 * The usable DVMA space size. Limited by amount of SYSMAP we can use.
 * DVMABASE is dynamic, DVMA is aligned to a DVMA_ALIGN boundary in SYSMAP.
 */
#define	DVMASIZE	(8*(1024*1024))		/* 8 Mb */
#define	DVMASIZE_MAX	(16*(1024*1024))	/* 16 Mb */

#if defined(KERNEL) && !defined(LOCORE)
/*
 * Low level mmu-specific functions 
 */
/*
 * Cache specific routines - ifdef'ed out if there is no chance
 * of running on a machine with a virtual address cache.
 */
#ifdef VAC
void	vac_init();
void	vac_flushall();
void	vac_usrflush();
void	vac_ctxflush();
void	vac_segflush(/* base */);
void	vac_pageflush(/* base */);
void	vac_flush(/* base, len */);
#else VAC
#define	vac_init()
#define	vac_flushall()
#define	vac_usrflush()
#define	vac_ctxflush()
#define	vac_segflush(base)
#define	vac_pageflush(base)
#define	vac_flush(base, len)
#endif VAC

void mmu_getkpte(/* addr_t, struct pte *  */);
void mmu_getpte(/* addr_t, struct pte * */);
void mmu_setpte(/* addr_t, struct pte * */);
#ifdef Series4
void mmu_assetpte(/* struct as *, addr_t, struct pte * */);
#endif Series4
void mmu_asgetpte(/* struct as *, addr_t, struct pte * */);
#endif defined(KERNEL) && !defined(LOCORE)

#ifndef LOCORE
#ifdef VAC
extern void vac_flushall(/* */);
#endif
#endif	!LOCORE
#endif _kbus_mmu_h
