/* @(#) from.h 1.2@(#) Solbourne id 1/11/94 19:24:56 */
/*
 * $RCSfile: from.h,v $
 *
 * Copyright (c) 1991 by
 *	Solbourne Computer, Inc.
 *	Matsushita Electric Industrial Co,. Ltd.
 * All rights reserved.
 *
 */

#ifndef lint
#ifdef rcs
static char rcsid[] = "$Id: from.h,v 1.3 1994/01/05 19:36:52 its Exp $" ;
#endif rcs
#endif lint

/*
 * The Series6 CPU has 4 128Kbyte flash ROMs in parallel
 * to form 128K, 32-bit words (512Kbytes)
 */
#define BROM_NDEVS	4
#define BROM_SIZE	(512*1024)
#define BROM_BASE	0
#define HIGH_BROM_ADDR 	BROM_SIZE-BROM_NDEVS
#define S6_ROM0_SIZE	0x3000	/* size of Series6 rom0 module */
#define BWORD_MASK	0xffffffff

/*
 * 8-bit Flash FROM commands
 */
#define FROM_READ_MEM		0x00
#define FROM_ERASE		0x20
#define FROM_ERASE_VERIFY	0xa0
#define FROM_PROGRAM 		0x40
#define FROM_PROGRAM_VERIFY	0xC0
#define FROM_RESET		0xFF

/* 
 * macro to make a 4-byte wide FROM command 
 */
#define BFROM_CMD(x)	((x<<24)|(x<<16)|(x<<8)|x)

/* 
 * Boot FROM commands are all 4-bytes wide 
 */
#define BFROM_READ_MEM		BFROM_CMD(FROM_READ_MEM)
#define BFROM_ERASE		BFROM_CMD(FROM_ERASE)
#define BFROM_ERASE_VERIFY	BFROM_CMD(FROM_ERASE_VERIFY)
#define BFROM_PROGRAM 		BFROM_CMD(FROM_PROGRAM)
#define BFROM_PROGRAM_VERIFY	BFROM_CMD(FROM_PROGRAM_VERIFY)
#define BFROM_RESET 		BFROM_CMD(FROM_RESET)

/*
 * The Series6 CPU has 1 128Kbyte flash ROM for the Xilinx
 * parts
 *
 * The 8 data bits for the Xilinx flash ROM are distributed 
 * across the 32-bit RDAT bus as follows:
 *
 * D0  ->   RDAT<29>
 * D1  ->   RDAT<24>
 * D2  ->   RDAT<18>
 * D3  ->   RDAT<12>
 * D4  ->   RDAT<10>
 * D5  ->   RDAT<4>
 * D6  ->   RDAT<2>
 * D7  ->   RDAT<0>
 *
 */

/* 
 * macro to form the appropriate byte value from the specified
 * 32-bit RDAT value.  
 */
#define PACK(word) \
	(((word&0x20000000)>>(29-0)) | \
	((word&0x01000000)>>(24-1)) | \
	((word&0x00040000)>>(18-2)) | \
	((word&0x00001000)>>(12-3)) | \
	((word&0x00000400)>>(10-4)) | \
	((word&0x00000010)<<(5-4)) | \
	((word&0x00000004)<<(6-2)) | \
	((word&0x00000001)<<(7-0)))
/* 
 * macro to form the appropriate 32-bit RDAT value from the specified
 * byte.  
 */
#define UNPACK(byte) \
	(((byte&0x1)<<(29-0)) | \
	((byte&0x2)<<(24-1)) | \
	((byte&0x4)<<(18-2)) | \
	((byte&0x8)<<(12-3)) | \
	((byte&0x10)<<(10-4)) | \
	((byte&0x20)>>(5-4)) | \
	((byte&0x40)>>(6-2)) | \
	((byte&0x80)>>(7-0)))

#define XWORD_MASK	0x21041415

/* 
 * Xilinx FROM commands 
 */
#define XFROM_READ_MEM		UNPACK(FROM_READ_MEM)
#define XFROM_ERASE		UNPACK(FROM_ERASE)
#define XFROM_ERASE_VERIFY	UNPACK(FROM_ERASE_VERIFY)
#define XFROM_PROGRAM 		UNPACK(FROM_PROGRAM)
#define XFROM_PROGRAM_VERIFY	UNPACK(FROM_PROGRAM_VERIFY)
#define XFROM_RESET 		UNPACK(FROM_RESET)

/*
 * The Xilinx FROM starts at IDSPACE address 1N600000 and is accessed
 * at every 16th byte address.  When CRADD<3> is zero, the lower half 
 * of the XFROM is addressed when CRADD<3> is set, the upper half of 
 * the XFROM is addressed.
 */

#define CRADD3	0x8

/* starting ID space address */
#define XFROM_BASE_ADDR (0x10600000)	

/* address is incremented by 16 hex */
#define XFROM_ADDR_INC	0x10

/* need to set CRADD<3> when address reaches this value */
#define XFROM_HIGH_HALF (0x10700000)

/* size is 128Kbytes */ 
#define XROM_SIZE	0x00020000

/* each half is 64K bytes */
#define XFROM_HALF_SIZE	0x00010000	

/* ending loop address */
#define XFROM_ADDR_END (XFROM_BASE_ADDR + (XFROM_HALF_SIZE*XFROM_ADDR_INC) + CRADD3)

/* rev information is placed at this address by the fpgarev tool */
#define XFROM_REV_ADDR        0x0000fff0

#define NUM_CHECKSUMS 8			/* number of boot FROM checksum bytes  */

#define S6_RTXT_LOADADDR 0xfe003000	/* where S6 ROMs are relocated   */
#define EXT_BOOT_SPACE 	 0x5		/* Boot ROMs are accessed throug */
					/* KSPACE 0x5.  Virtual space 5  */
					/* must map to Mbus space 0xA    */
#define MAXSLOTS 16
#define BROM 0
#define XROM 1
