/* @(#) cpu.h 1.1@(#) Solbourne id 9/21/93 23:57:14 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */
/*	@(#)cpu.h 1.7 89/02/24 SMI	*/

/*
 * Copyright (c) 1986 by Sun Microsystems, Inc.
 */

#ifndef _sun4_cpu_h
#define _sun4_cpu_h

#define CPU_TYPE		0xf0	/* mask for machine type */
#define CPU_TYPE_SHIFT		4
#define CPU_TYPE_SERIES4	0x00	/* Series4 */
#define CPU_TYPE_SERIES5	0x10	/* Series5 */
#define CPU_TYPE_SERIES5E	0x20	/* Series5E */
#define CPU_TYPE_SERIES6	0x30	/* Series6 */
#define CPU_TYPE_SERIES7	0x40	/* Series7 */
#define CPU_TYPE_KAP_M2		0xf0	/* kap m2 based */
#define	CPU_TYPE_ASCII		\
	{"Series4", "Series5", "Series5E", "Series6", "Series7", "?5?" , "?6?", "?7?",\
	"?8?", "?9?", "?10?", "?11?", "?12?", "?13?" , "?14?", "KAP_M2"}

#define CPU_MODEL		0x0f	/* mask for machine model */
#define CPU_MODEL_SHIFT		0
#define CPU_MODEL_500		0x01	/* model 500 */
#define CPU_MODEL_600		0x02	/* model 600 */
#define CPU_MODEL_900		0x03	/* model 900 */
#define CPU_MODEL_4000		0x04	/* model 4000 */
#define CPU_MODEL_4100		0x05	/* model 4100 - L2 Cache */
#define CPU_MODEL_700		0x06	/* model 700 */
#define CPU_MODEL_800		0x07	/* model 800 */

#define	CPU_MODEL_ASCII		\
	{"500", "600", "900", "4000", "4100", "700" , "800", "?8?",	\
	"?9?", "?10?", "?11?", "?12?", "?13?", "?14?" , "?15?"}

#define CPU_SERIES4_500		(CPU_TYPE_SERIES4 | CPU_MODEL_500)
#define CPU_SERIES4_600		(CPU_TYPE_SERIES4 | CPU_MODEL_600)

#define CPU_SERIES5_500		(CPU_TYPE_SERIES5 | CPU_MODEL_500)
#define CPU_SERIES5_600		(CPU_TYPE_SERIES5 | CPU_MODEL_600)
#define CPU_SERIES5_900		(CPU_TYPE_SERIES5 | CPU_MODEL_900)

#define CPU_SERIES5E_500	(CPU_TYPE_SERIES5E | CPU_MODEL_500)
#define CPU_SERIES5E_600	(CPU_TYPE_SERIES5E | CPU_MODEL_600)
#define CPU_SERIES5E_900	(CPU_TYPE_SERIES5E | CPU_MODEL_900)

#define CPU_SERIES6_500		(CPU_TYPE_SERIES6 | CPU_MODEL_500)
#define CPU_SERIES6_600		(CPU_TYPE_SERIES6 | CPU_MODEL_600)
#define CPU_SERIES6_900		(CPU_TYPE_SERIES6 | CPU_MODEL_900)

#define CPU_SERIES7_500		(CPU_TYPE_SERIES7 | CPU_MODEL_500)
#define CPU_SERIES7_600		(CPU_TYPE_SERIES7 | CPU_MODEL_600)
#define CPU_SERIES7_900		(CPU_TYPE_SERIES7 | CPU_MODEL_900)

#define CPU_S4000		(CPU_TYPE_KAP_M2 | CPU_MODEL_4000)

#if defined(KERNEL) && !defined(LOCORE)
extern int cpu;				/* machine type we are running on */
extern int dvmasize;			/* usable dvma size in pages */

#ifdef VAC
extern int vac;				/* there is a virtual address cache */
#else
#define vac 0
#endif VAC

#ifdef IOC
extern int ioc;				/* there is an I/O cache */
#else
#define ioc 0
#endif IOC

#ifdef BCOPY_BUF
extern int bcopy_buf;			/* there is a bcopy buffer */
#else
#define bcopy_buf 0
#endif BCOPY_BUF

#endif KERNEL && !LOCORE

#endif /*!_sun4_cpu_h*/
