#ifndef lint
static char *Solbourne_id =
"@(#) if_fxconf.c 1.1@(#) Solbourne id 9/22/93 00:11:21\n";
#endif
/*
 * Copyright 1990 Solbourne Computer, Inc.
 * All rights reserved.
 */
/*
 * 	Copyright (c) 1990 by Communication Machinery Corporation
 * 			All rights reserved.
 *
 * 	This software contains proprietary and confidential information
 * 	of Communication Machinery Corporation and its suppliers.  Use,
 * 	disclosure, or reproduction is prohibited without the prior express
 * 	written consent of Communication Machinery Corporation.
 */

/*
 * Machine specific configuration information for Network Interfaces
 * for CMC FX Series Controllers
 */
#include "fx.h"
#if	NFX > 0

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/reboot.h>
#include <sys/mbuf.h>
#include <sys/buf.h>
#include <sys/map.h>
#include <sys/socket.h>
#include <sys/errno.h>

#include <sys/time.h>
#include <sys/kernel.h>
#include <sys/ioctl.h>

#include <net/if.h>
#include <net/if_arp.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <netinet/if_fddi.h>

#include <kapdev/mbvar.h>
#include <kapdev/ioasic.h>
#include <machine/sysboard.h>
#include <machine/mmu.h>
#include <machine/prom.h>

#include <kapif/if_fxreg.h>
#include <kapif/if_fxvar.h>

int			fx_nfx = NFX;
int			fx_verbose = 1;
int			fx_strip_leave = 1;
int			fx_strip_intr = 1;
int			fx_found_opt = 0;
int			fx_start_int = 1;
int			fx_xdma_copynocl = 1;
int			fx_xdma_alwayscopy = 0;

struct mb_device	*fxinfo[NFX];
struct fx_softc		fx_softc[NFX];
struct fx_dstat		fx_dstat[NFX];


/* parameters for boards supported by driver */
struct fx_conf	fx_conf[] = {
    {"CMC-1150", "FX FDDI-DAS", FC_TYPE_FDDI, 0		/* 6U */
		|FC_FLAGS_LOAD
/*		|FC_FLAGS_HAS_NOVDMA	/**/
		|FC_FLAGS_BLOCK_R	/**/
		|FC_FLAGS_BLOCK_X	/**/
		|FC_FLAGS_INTR_BOARD	/**/
/*		|FC_FLAGS_OINTR_BOARD	/**/
		,				/* fx_flags */
	1024 K, 0				/* fc_size */
		|FX_MODE_RCV_DMA	/**/
		|FX_MODE_XMT_DMA	/**/
		|FX_MODE_NOTERM		/**/
		|FX_MODE_UDO_TRAILERS	/**/
		,				/* fc_fx_mode */
	4,					/* fc_align_board */
	1,					/* fc_align_carve_bcb */
	32,					/* fc_align_driver */
	22,					/* fc_min_tu */
	4096+256,				/* fc_max_tu */
	4512,					/* fc_buf_sz (multiple of 32) */
	32,					/* fc_nrecv */
	16,					/* fc_nxmit (no dvma rsvd) */
	48,					/* fc_nxmit_dvma */
	8,					/* fc_nxmit_frags (18 MAX) */
	512,					/* fc_minlen_rdma_loan */
	20,					/* fc_minlen_xdma */
	45,					/* fc_max_xbackback */
	7,					/* fc_xstrip_imm */
	10,					/* fc_xstrip_to */
	2,					/* fc_conv_bcb_max */
	3,					/* fc_conv_busd_max */
	1 K,					/* fc_fxctl_size */
    },
    {"CMC-115?", "FX FDDI-SAS", FC_TYPE_FDDI, 0		/* 6U */
		|FC_FLAGS_LOAD
/*		|FC_FLAGS_HAS_NOVDMA	/**/
		|FC_FLAGS_BLOCK_R	/**/
		|FC_FLAGS_BLOCK_X	/**/
		|FC_FLAGS_INTR_BOARD	/**/
/*		|FC_FLAGS_OINTR_BOARD	/**/
		,				/* fx_flags */
	1024 K, 0				/* fc_size */
		|FX_MODE_RCV_DMA	/**/
		|FX_MODE_XMT_DMA	/**/
		|FX_MODE_NOTERM		/**/
		|FX_MODE_UDO_TRAILERS	/**/
		,				/* fc_fx_mode */
	4,					/* fc_align_board */
	1,					/* fc_align_carve_bcb */
	32,					/* fc_align_driver */
	22,					/* fc_min_tu */
	4096+256,				/* fc_max_tu */
	4512,					/* fc_buf_sz (multiple of 32) */
	32,					/* fc_nrecv */
	16,					/* fc_nxmit (no dvma rsvd) */
	32,					/* fc_nxmit_dvma */
	8,					/* fc_nxmit_frags (18 MAX) */
	512,					/* fc_minlen_rdma_loan */
	60,					/* fc_minlen_xdma */
	45,					/* fc_max_xbackback */
	7,					/* fc_xstrip_imm */
	10,					/* fc_xstrip_to */
	2,					/* fc_conv_bcb_max */
	3,					/* fc_conv_busd_max */
	1 K,					/* fc_fxctl_size */
    },
    {"CMC-1050", "FX FDDI-DAS", FC_TYPE_FDDI, 0		/* 9U */
		|FC_FLAGS_LOAD
/*		|FC_FLAGS_HAS_NOVDMA	/**/
/*		|FC_FLAGS_BLOCK_R	/**/
/*		|FC_FLAGS_BLOCK_X	/**/
		|FC_FLAGS_INTR_BOARD	/**/
/*		|FC_FLAGS_OINTR_BOARD	/**/
		,				/* fx_flags */
	512 K, 0				/* fc_size */
		|FX_MODE_RCV_DMA	/**/
		|FX_MODE_XMT_DMA	/**/
		|FX_MODE_NOTERM		/**/
		|FX_MODE_UDO_TRAILERS	/**/
		,				/* fc_fx_mode */
	4,					/* fc_align_board */
	1,					/* fc_align_carve_bcb */
	32,					/* fc_align_driver */
	22,					/* fc_min_tu */
	4096+256,				/* fc_max_tu */
	4512,					/* fc_buf_sz (multiple of 32) */
	32,					/* fc_nrecv */
	16,					/* fc_nxmit (no dvma rsvd) */
	32,					/* fc_nxmit_dvma */
	8,					/* fc_nxmit_frags (18 MAX) */
	512,					/* fc_minlen_rdma_loan */
	60,					/* fc_minlen_xdma */
	45,					/* fc_max_xbackback */
	7,					/* fc_xstrip_imm */
	10,					/* fc_xstrip_to */
	2,					/* fc_conv_bcb_max */
	3,					/* fc_conv_busd_max */
	2 K,					/* fc_fxctl_size */
    },
    {"CMC-105?", "FX FDDI-SAS", FC_TYPE_FDDI, 0		/* 9U */
		|FC_FLAGS_LOAD
/*		|FC_FLAGS_HAS_NOVDMA	/**/
/*		|FC_FLAGS_BLOCK_R	/**/
/*		|FC_FLAGS_BLOCK_X	/**/
		|FC_FLAGS_INTR_BOARD	/**/
/*		|FC_FLAGS_OINTR_BOARD	/**/
		,				/* fx_flags */
	512 K, 0				/* fc_size */
		|FX_MODE_RCV_DMA	/**/
		|FX_MODE_XMT_DMA	/**/
		|FX_MODE_NOTERM		/**/
		|FX_MODE_UDO_TRAILERS	/**/
		,				/* fc_fx_mode */
	4,					/* fc_align_board */
	1,					/* fc_align_carve_bcb */
	32,					/* fc_align_driver */
	22,					/* fc_min_tu */
	4096+256,				/* fc_max_tu */
	4512,					/* fc_buf_sz (multiple of 32) */
	32,					/* fc_nrecv */
	16,					/* fc_nxmit (no dvma rsvd) */
	32,					/* fc_nxmit_dvma */
	8,					/* fc_nxmit_frags (? MAX) */
	512,					/* fc_minlen_rdma_loan */
	60,					/* fc_minlen_xdma */
	45,					/* fc_max_xbackback */
	7,					/* fc_xstrip_imm */
	10,					/* fc_xstrip_to */
	2,					/* fc_conv_bcb_max */
	3,					/* fc_conv_busd_max */
	2 K,					/* fc_fxctl_size */
    },
    {"CMC-130", "FX ETHERNET", FC_TYPE_ETHER, 0
		|FC_FLAGS_BLOCK_R
		|FC_FLAGS_BLOCK_X
		,				/* fx_flags */
	256 K, 0				/* fc_size */
		|FX_MODE_RCV_DMA
		|FX_MODE_XMT_DMA
		|FX_MODE_NOTERM		/**/
		|FX_MODE_UDO_TRAILERS
		,				/* fc_fx_mode */
	1,					/* fc_align_board */
	1 K,					/* fc_align_carve_bcb */
	32,					/* fc_align_driver */
	60,					/* fc_min_tu */
	1500,					/* fc_max_tu */
	1536,					/* fc_buf_sz (multiple of 32) */
	32,					/* fc_nrecv */
	16,					/* fc_nxmit */
	16,					/* fc_nxmit_dvma */
	8,					/* fc_nxmit_frags */
	512,					/* fc_minlen_rdma_loan */
	60,					/* fc_minlen_xdma */
	10,					/* fc_max_xbackback */
	7,					/* fc_xstrip_imm */
	10,					/* fc_xstrip_to */
	3,					/* fc_conv_bcb_max */
	4,					/* fc_conv_busd_max */
	2 K,					/* fc_fxctl_size */
    },
    {0,}
};
char	*fx_fc_type_ascii[] = FC_TYPE_ASCII;

/* determine the address modifier to used based on address/len/direction */
fx_addrmod(fs, addr, len, transmit)
struct fx_softc *fs;
caddr_t		addr;
{
    if (transmit) {
	if ((fs->fs_fc->fc_flags & FC_FLAGS_BLOCK_X) == 0)
	    return (0x3D);
	if (((((int)addr)&0x3) == 0) && ((len&0x3) == 0))
	    return (0x3F);
	return (0x3D);
    } else {
	if ((fs->fs_fc->fc_flags & FC_FLAGS_BLOCK_R) == 0)
	    return (0x3D);
	/* we know that revieve dma buffers are aligned in length */
	return (0x3F);
    }
}

#endif	NFX > 0
